/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolstrip.sections;

import com.google.common.base.Preconditions;
import com.mathworks.desktop.client.Client;
import com.mathworks.desktop.client.ClientCollection;
import com.mathworks.desktop.overlay.Overlay;
import com.mathworks.desktop.overlay.OverlayConstraints;
import com.mathworks.desktop.overlay.OverlayManager;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.desktop.overlay.OverlayType;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.WindowUtils;
import com.mathworks.toolstrip.ToolstripSection;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.accessories.IsOnToolstripPredicate;
import com.mathworks.toolstrip.components.ButtonOrientation;
import com.mathworks.toolstrip.components.PopupListener;
import com.mathworks.toolstrip.components.TSCheckBox;
import com.mathworks.toolstrip.components.TSDropDownButton;
import com.mathworks.toolstrip.components.TSList;
import com.mathworks.toolstrip.components.TSPanel;
import com.mathworks.toolstrip.components.TSSplitButton;
import com.mathworks.toolstrip.components.popups.ListActionListener;
import com.mathworks.toolstrip.components.popups.ListItem;
import com.mathworks.toolstrip.components.popups.ListStyle;
import com.mathworks.toolstrip.components.popups.PopupList;
import com.mathworks.toolstrip.plaf.LAFUtil;
import com.mathworks.toolstrip.sections.DefaultToolstripSection;
import com.mathworks.toolstrip.sections.SectionBuilder;
import com.mathworks.util.Disposable;
import com.mathworks.util.Disposer;
import com.mathworks.util.NegationPredicate;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.Predicate;
import info.clearthought.layout.TableLayout;
import info.clearthought.layout.TableLayoutConstraints;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.LineBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jetbrains.annotations.NotNull;

public class ToolstripSections {
    public static final String BUTTON_POPUP_NAME = "popupListName";

    private ToolstripSections() {
    }

    public static SectionBuilder newSectionBuilder() {
        return new MySectionBuilder();
    }

    public static SectionBuilder newSectionBuilder(String string) {
        return new MySectionBuilder().name(string);
    }

    public static SectionBuilder newSectionBuilder(String string, String string2) {
        return new MySectionBuilder().name(string).title(string2);
    }

    public static SectionBuilder newSectionBuilder(String string, String string2, int n) {
        return new MySectionBuilder().name(string).title(string2).priority(n);
    }

    public static TSSplitButton newSplitButton(Action action, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener) {
        return ToolstripSections.newSplitButton(action, listItemArray, listStyle, listActionListener, true);
    }

    public static TSSplitButton newSplitButton(Action action, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener, boolean bl) {
        return ToolstripSections.newSplitButton(action, listItemArray, listStyle, listActionListener, bl, BUTTON_POPUP_NAME);
    }

    public static TSSplitButton newSplitButton(Action action, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener, boolean bl, String string) {
        return (TSSplitButton)ToolstripSections.setPopupOnDropDownButton(new TSSplitButton(action), listItemArray, listStyle, listActionListener, bl, string);
    }

    public static TSDropDownButton newDropDownButton(Action action, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener, boolean bl, String string) {
        return ToolstripSections.setPopupOnDropDownButton(new TSDropDownButton(action), listItemArray, listStyle, listActionListener, bl, string);
    }

    public static TSDropDownButton newDropDownButton(Action action, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener, boolean bl) {
        return ToolstripSections.newDropDownButton(action, listItemArray, listStyle, listActionListener, bl, BUTTON_POPUP_NAME);
    }

    private static TSDropDownButton setPopupOnDropDownButton(TSDropDownButton tSDropDownButton, final ListItem[] listItemArray, final ListStyle listStyle, final ListActionListener listActionListener, boolean bl, final String string) {
        tSDropDownButton.setOrientation(bl ? ButtonOrientation.VERTICAL : ButtonOrientation.HORIZONTAL);
        tSDropDownButton.setPopupListener(new PopupListener(){

            @Override
            public void onPopupEvent(JComponent jComponent, PopupListener.PopupCallback popupCallback) {
                PopupList popupList = ToolstripSections.createList(listItemArray, listActionListener, listStyle);
                popupList.setName(string);
                popupCallback.show(popupList);
            }
        });
        return tSDropDownButton;
    }

    public static PopupList createList(ListItem[] listItemArray, ListActionListener listActionListener, ListStyle listStyle) {
        PopupList popupList = new PopupList(listItemArray);
        popupList.setListStyle(listStyle);
        popupList.addListActionListener(listActionListener);
        return popupList;
    }

    public static Overlay showPopup(JComponent jComponent, JComponent jComponent2) {
        return ToolstripSections.showPopup(jComponent, jComponent2, true, jComponent.isFocusOwner() ? jComponent : null);
    }

    public static Overlay showPopup(final JComponent jComponent, JComponent jComponent2, boolean bl, final Component component) {
        jComponent.putClientProperty("PopupComponent", jComponent2);
        Window window = WindowUtils.getTopmostWindow((Component)jComponent);
        Dimension dimension = jComponent2.getPreferredSize();
        Rectangle rectangle = LAFUtil.convertRectangleToScreen(jComponent.getBounds(), jComponent.getParent());
        Rectangle rectangle2 = rectangle.width > dimension.width ? new Rectangle(rectangle.x + rectangle.width - dimension.width, rectangle.y + rectangle.height, dimension.width, dimension.height) : new Rectangle(rectangle.x, rectangle.y + rectangle.height, dimension.width, dimension.height);
        int n = rectangle2.height;
        Rectangle rectangle3 = WindowUtils.getInsetScreenBounds((GraphicsConfiguration)window.getGraphicsConfiguration());
        rectangle2.y = Math.max(rectangle2.y, rectangle3.y);
        int n2 = Math.min(rectangle2.y + rectangle2.height, rectangle3.y + rectangle3.height - 20);
        rectangle2.height = Math.min(rectangle2.height, Math.max(100, n2 - rectangle2.y));
        rectangle2.y = Math.min(rectangle3.y + rectangle3.height - rectangle2.height, rectangle2.y);
        rectangle2.x = Math.max(rectangle2.x, rectangle3.x);
        rectangle2.x = Math.min(rectangle2.x, rectangle3.x + rectangle3.width - (rectangle2.width + 20));
        final Rectangle rectangle4 = LAFUtil.convertRectangleFromScreen(rectangle2, window);
        Overlay overlay = null;
        if (jComponent2 instanceof JPopupMenu) {
            final JPopupMenu jPopupMenu = (JPopupMenu)jComponent2;
            final Overlay overlay2 = overlay = new Overlay(){

                public Component getComponent() {
                    return jPopupMenu;
                }

                public Rectangle layout(Window window) {
                    return rectangle4;
                }

                public OverlayType getType() {
                    return new OverlayType(0, Overlay.Mode.AUTO, true);
                }

                public void dispose() {
                    jPopupMenu.setVisible(false);
                }
            };
            jPopupMenu.addPopupMenuListener(new PopupMenuListener(){

                @Override
                public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                }

                @Override
                public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                    this.dispose();
                }

                @Override
                public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                    this.dispose();
                }

                private void dispose() {
                    jPopupMenu.removePopupMenuListener(this);
                    MJUtilities.invokeLater((Runnable)new Runnable(){

                        @Override
                        public void run() {
                            Disposer.dispose((Disposable)overlay2);
                        }
                    });
                }
            });
            Rectangle rectangle5 = SwingUtilities.convertRectangle(window, rectangle4, jComponent);
            jPopupMenu.show(jComponent, rectangle5.x, rectangle5.y);
        } else {
            Object object;
            if (rectangle2.height < n) {
                object = new MJScrollPane((Component)jComponent2, 22, 31);
                rectangle4.width += object.getVerticalScrollBar().getPreferredSize().width;
            } else {
                object = new JPanel(new BorderLayout());
                ((JComponent)object).setBorder(new LineBorder(new Color(0x868686), 1));
                ((Container)object).add(jComponent2);
            }
            OverlayConstraints overlayConstraints = OverlayConstraints.popup((Component)jComponent, (Component)object);
            overlayConstraints.setBounds(rectangle4);
            overlayConstraints.setShouldConsumeDismissEvent((Predicate)new NegationPredicate((Predicate)new IsOnToolstripPredicate()));
            final OverlayManager overlayManager = OverlayManagers.get((Component)jComponent);
            if (overlayManager != null) {
                final Overlay overlay3 = overlay = overlayManager.addOverlay((Component)object, overlayConstraints);
                Disposer.register((Disposable)new Disposable(){

                    public void dispose() {
                        jComponent.putClientProperty("PopupComponent", null);
                    }
                }, (Disposable)overlay3);
                ((JComponent)object).getInputMap(1).put(KeyStroke.getKeyStroke("ESCAPE"), "escape");
                ((JComponent)object).getActionMap().put("escape", new AbstractAction("escape"){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        overlayManager.removeOverlay(overlay3);
                        if (component != null) {
                            if (PlatformInfo.isLinux()) {
                                component.requestFocus();
                            } else {
                                component.requestFocusInWindow();
                            }
                        }
                    }
                });
                jComponent2.putClientProperty("temporary-focus-owner", true);
                if (bl) {
                    if (PlatformInfo.isLinux()) {
                        jComponent2.requestFocus();
                    } else {
                        jComponent2.requestFocusInWindow();
                    }
                }
            }
        }
        return overlay;
    }

    public static Overlay showPopup(JComponent jComponent, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener) {
        return ToolstripSections.showPopup(jComponent, ToolstripSections.createList(listItemArray, listActionListener, listStyle));
    }

    public static Overlay showPopup(JComponent jComponent, ListItem[] listItemArray, ListStyle listStyle, ListActionListener listActionListener, boolean bl, Component component) {
        return ToolstripSections.showPopup(jComponent, ToolstripSections.createList(listItemArray, listActionListener, listStyle), bl, component);
    }

    public static ToolstripSection newCheckboxTable(String string, String string2, String[] stringArray, boolean[] blArray, String[] stringArray2) {
        Preconditions.checkArgument((stringArray.length == blArray.length && blArray.length == stringArray2.length ? 1 : 0) != 0, (Object)"Arrays length do not match");
        TSCheckBox[] tSCheckBoxArray = new TSCheckBox[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            TSCheckBox tSCheckBox = new TSCheckBox(stringArray2[i], blArray[i]);
            tSCheckBox.setName(stringArray[i]);
            tSCheckBoxArray[i] = tSCheckBox;
        }
        return ToolstripSections.newCheckboxTable(string, string2, tSCheckBoxArray);
    }

    public static ToolstripSection newCheckboxTable(String string, String string2, TSCheckBox[] tSCheckBoxArray) {
        SectionBuilder sectionBuilder = ToolstripSections.newSectionBuilder(string, string2);
        for (TSCheckBox tSCheckBox : tSCheckBoxArray) {
            sectionBuilder.add((JComponent)((Object)tSCheckBox));
        }
        return sectionBuilder.build();
    }

    public static ToolstripTab newSelector(String string, String string2, final TSList tSList, final ToolstripSection[][] toolstripSectionArray, final ToolstripTab toolstripTab) {
        final DefaultToolstripSection defaultToolstripSection = new DefaultToolstripSection(string, string2){

            @NotNull
            protected JComponent createComponent() {
                TableLayout tableLayout = new TableLayout((double[][])new double[][]{{-2.0}, {-1.0, -2.0, -1.0}});
                TSPanel tSPanel = new TSPanel((LayoutManager)tableLayout);
                tSList.setVisibleRowCount(4);
                tSPanel.add(new JScrollPane((Component)((Object)tSList)), "0,1");
                tSPanel.setOpaque(false);
                return tSPanel;
            }
        };
        toolstripTab.getModel().add((Client)defaultToolstripSection);
        final int[] nArray = new int[]{-1};
        tSList.setSelectionMode(0);
        tSList.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n;
                if (!listSelectionEvent.getValueIsAdjusting() && (n = tSList.getSelectedIndex()) >= 0 && n < toolstripSectionArray.length && n != nArray[0]) {
                    ToolstripSection[] toolstripSectionArray2;
                    ClientCollection<ToolstripSection> clientCollection = toolstripTab.getModel();
                    int n2 = clientCollection.indexOf((Client)defaultToolstripSection);
                    int n3 = clientCollection.size();
                    while (--n3 > n2) {
                        clientCollection.remove(n3);
                    }
                    for (ToolstripSection toolstripSection : toolstripSectionArray2 = toolstripSectionArray[n]) {
                        clientCollection.add((Client)toolstripSection);
                    }
                    nArray[0] = n;
                }
            }
        });
        tSList.setSelectedIndex(0);
        return toolstripTab;
    }

    private static class MySectionBuilder
    implements SectionBuilder {
        private String fName;
        private String fTitle;
        private int fPriority;
        private List<Block> fBlocks = new ArrayList<Block>();
        private static final int HORIZONTAL_BLOCKS_GAP = 4;
        private static final int VERTICAL_COMPONENT_GAP = 1;

        private MySectionBuilder() {
            this.fBlocks.add(new Block());
        }

        @Override
        public SectionBuilder name(String string) {
            Preconditions.checkState((this.fName == null ? 1 : 0) != 0, (Object)"Name has been already specified");
            this.fName = string;
            return this;
        }

        @Override
        public SectionBuilder title(String string) {
            Preconditions.checkState((this.fTitle == null ? 1 : 0) != 0, (Object)"Title has been already specified");
            this.fTitle = string;
            return this;
        }

        @Override
        public SectionBuilder priority(int n) {
            this.fPriority = n;
            return this;
        }

        @Override
        public SectionBuilder separator() {
            if (this.fBlocks.get((int)(this.fBlocks.size() - 1)).fComponents.size() > 0) {
                this.fBlocks.add(new Block());
            }
            return this;
        }

        @Override
        public SectionBuilder add(JComponent jComponent) {
            this.fBlocks.get(this.fBlocks.size() - 1).add(jComponent);
            return this;
        }

        @Override
        public ToolstripSection build() {
            Preconditions.checkNotNull((Object)this.fName, (Object)"Name has to be specified");
            Preconditions.checkNotNull((Object)this.fTitle, (Object)"Title has to be specified");
            Preconditions.checkArgument((this.fBlocks.get((int)0).fComponents.size() > 0 ? 1 : 0) != 0, (Object)"Section should not be empty");
            DefaultToolstripSection defaultToolstripSection = new DefaultToolstripSection(this.fName, this.fTitle){

                @NotNull
                protected JComponent createComponent() {
                    int n = MySectionBuilder.this.fBlocks.size();
                    if (((Block)((MySectionBuilder)MySectionBuilder.this).fBlocks.get((int)(n - 1))).fComponents.size() == 0) {
                        --n;
                    }
                    TableLayout tableLayout = new TableLayout(){

                        public void layoutContainer(Container container) {
                            int n;
                            int n2;
                            int n3;
                            int n4;
                            super.layoutContainer(container);
                            int n5 = 0;
                            int n6 = 0;
                            for (n4 = 0; n4 < container.getComponentCount(); ++n4) {
                                JComponent jComponent = (JComponent)container.getComponent(n4);
                                if (jComponent.getX() + jComponent.getWidth() > n5) {
                                    n5 = jComponent.getX() + jComponent.getWidth();
                                }
                                if (jComponent.getX() >= n6) continue;
                                n6 = jComponent.getX();
                            }
                            int n7 = n5 - n6;
                            n4 = container.getWidth();
                            if (n4 > n7 && (n3 = (n2 = n4 / 2) - (n = n7 / 2)) > 5) {
                                for (int i = 0; i < container.getComponentCount(); ++i) {
                                    JComponent jComponent = (JComponent)container.getComponent(i);
                                    jComponent.setLocation(jComponent.getX() + n3, jComponent.getY());
                                }
                            }
                        }
                    };
                    for (int i = 0; i < n; ++i) {
                        tableLayout.insertColumn(i * 2, -2.0);
                        if (i >= n - 1) continue;
                        tableLayout.insertColumn(i * 2 + 1, 4.0);
                    }
                    tableLayout.insertRow(0, -1.0);
                    TSPanel tSPanel = new TSPanel((LayoutManager)tableLayout);
                    for (int i = 0; i < n; ++i) {
                        Block block = (Block)MySectionBuilder.this.fBlocks.get(i);
                        int n2 = block.fComponents.size();
                        TableLayout tableLayout2 = new TableLayout();
                        tableLayout2.insertColumn(0, -2.0);
                        TSPanel tSPanel2 = new TSPanel((LayoutManager)tableLayout2);
                        for (int j = 0; j < n2; ++j) {
                            JComponent jComponent;
                            Object object;
                            tableLayout2.insertRow(j * 2, -1.0);
                            if (j < n2 - 1) {
                                tableLayout2.insertRow(j * 2 + 1, 1.0);
                            }
                            if ((object = (jComponent = block.fComponents.get(j)).getClientProperty("canManageOpacity")) == null || !((Boolean)object).booleanValue()) {
                                jComponent.setOpaque(false);
                            }
                            int n3 = 0;
                            Integer n4 = (Integer)jComponent.getClientProperty("horizontalAlignment");
                            if (n4 != null) {
                                switch (n4) {
                                    case 4: {
                                        n3 = 3;
                                        break;
                                    }
                                    case 0: {
                                        n3 = 1;
                                    }
                                }
                            }
                            tSPanel2.add(jComponent, new TableLayoutConstraints(0, j * 2, 0, j * 2, n3, 1));
                        }
                        tSPanel.add((Component)((Object)tSPanel2), new TableLayoutConstraints(i * 2, 0, i * 2, 0, 1, 1));
                    }
                    return tSPanel;
                }
            };
            defaultToolstripSection.setAttribute(ToolstripSection.PRIORITY, this.fPriority);
            return defaultToolstripSection;
        }

        private static class Block {
            List<JComponent> fComponents = new ArrayList<JComponent>();

            private Block() {
            }

            void add(JComponent jComponent) {
                this.fComponents.add(jComponent);
            }
        }
    }
}

