/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.constraint;

import java.io.InvalidObjectException;
import java.lang.reflect.Array;
import java.lang.reflect.Modifier;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collection;

class Constraint {
    private Constraint() {
    }

    static Object[] trim(Object[] objectArray, int n) {
        if (n == objectArray.length) {
            return objectArray;
        }
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), n);
        System.arraycopy(objectArray, 0, objectArray2, 0, n);
        return objectArray2;
    }

    static int hash(Object[] objectArray) {
        int n = 0;
        int n2 = objectArray.length;
        while (--n2 >= 0) {
            n += objectArray[n2].hashCode();
        }
        return n;
    }

    static boolean equal(Object[] objectArray, Object[] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray.length != objectArray2.length) {
            return false;
        }
        int n = objectArray.length;
        while (--n >= 0) {
            if (Constraint.contains(objectArray2, objectArray2.length, objectArray[n])) continue;
            return false;
        }
        return true;
    }

    static boolean contains(Object[] objectArray, int n, Object object) {
        while (--n >= 0) {
            if (!object.equals(objectArray[n])) continue;
            return true;
        }
        return false;
    }

    static String toString(Object[] objectArray) {
        String string;
        int n;
        if (objectArray.length == 0) {
            return "{}";
        }
        if (objectArray.length == 1) {
            String string2 = objectArray[0] instanceof Class ? ((Class)objectArray[0]).getName() : objectArray[0].toString();
            return "{" + string2 + "}";
        }
        Object[] objectArray2 = new String[objectArray.length];
        int n2 = objectArray.length * 2;
        if (objectArray[0] instanceof Class) {
            n = objectArray.length;
            while (--n >= 0) {
                string = ((Class)objectArray[n]).getName();
                objectArray2[n] = string;
                n2 += string.length();
            }
        } else {
            n = objectArray.length;
            while (--n >= 0) {
                string = objectArray[n].toString();
                objectArray2[n] = string;
                n2 += string.length();
            }
        }
        Arrays.sort(objectArray2);
        StringBuffer stringBuffer = new StringBuffer(n2);
        stringBuffer.append("{");
        for (int i = 0; i < objectArray2.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append((String)objectArray2[i]);
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    static Principal[] reduce(Collection collection) {
        try {
            return Constraint.reduce0(collection.toArray(new Principal[collection.size()]));
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new IllegalArgumentException("element of collection is not a Principal");
        }
    }

    static Principal[] reduce(Principal[] principalArray) {
        return Constraint.reduce0((Principal[])principalArray.clone());
    }

    private static Principal[] reduce0(Principal[] principalArray) {
        if (principalArray.length == 0) {
            throw new IllegalArgumentException("cannot create constraint with no elements");
        }
        int n = 0;
        for (int i = 0; i < principalArray.length; ++i) {
            Principal principal = principalArray[i];
            if (principal == null) {
                throw new NullPointerException("elements cannot be null");
            }
            if (Constraint.contains(principalArray, n, principal)) continue;
            principalArray[n++] = principal;
        }
        return (Principal[])Constraint.trim(principalArray, n);
    }

    static void verify(Principal[] principalArray) throws InvalidObjectException {
        if (principalArray == null || principalArray.length == 0) {
            throw new InvalidObjectException("cannot create constraint with no elements");
        }
        int n = principalArray.length;
        while (--n >= 0) {
            Principal principal = principalArray[n];
            if (principal == null) {
                throw new InvalidObjectException("elements cannot be null");
            }
            if (!Constraint.contains(principalArray, n, principal)) continue;
            throw new InvalidObjectException("cannot create constraint with duplicate elements");
        }
    }

    static Class[] reduce(Collection collection, boolean bl) {
        try {
            return Constraint.reduce0(collection.toArray(new Class[collection.size()]), bl);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new IllegalArgumentException("element of collection is not a Class");
        }
    }

    static Class[] reduce(Class[] classArray, boolean bl) {
        return Constraint.reduce0((Class[])classArray.clone(), bl);
    }

    private static Class[] reduce0(Class[] classArray, boolean bl) {
        if (classArray.length == 0) {
            throw new IllegalArgumentException("cannot create constraint with no elements");
        }
        int n = 0;
        block0: for (int i = 0; i < classArray.length; ++i) {
            Class clazz = classArray[i];
            Constraint.verify(clazz);
            int n2 = n;
            while (--n2 >= 0) {
                Class clazz2 = classArray[n2];
                if (!bl ? clazz.isAssignableFrom(clazz2) : clazz2.isAssignableFrom(clazz)) continue block0;
                if (!(bl ? clazz.isAssignableFrom(clazz2) : clazz2.isAssignableFrom(clazz))) continue;
                classArray[n2] = classArray[--n];
            }
            classArray[n++] = clazz;
        }
        return (Class[])Constraint.trim(classArray, n);
    }

    static void verify(Class clazz) {
        if (clazz == null) {
            throw new NullPointerException("elements cannot be null");
        }
        if (clazz.isArray() || clazz.isPrimitive() || Modifier.isFinal(clazz.getModifiers()) && !Principal.class.isAssignableFrom(clazz)) {
            throw new IllegalArgumentException("invalid class");
        }
    }

    static void verify(Class[] classArray) throws InvalidObjectException {
        if (classArray == null || classArray.length == 0) {
            throw new InvalidObjectException("cannot create constraint with no elements");
        }
        int n = classArray.length;
        while (--n >= 0) {
            Class clazz = classArray[n];
            if (clazz == null) {
                throw new InvalidObjectException("elements cannot be null");
            }
            if (clazz.isArray() || clazz.isPrimitive() || Modifier.isFinal(clazz.getModifiers()) && !(class$java$security$Principal == null ? Constraint.class$("java.security.Principal") : class$java$security$Principal).isAssignableFrom(clazz)) {
                throw new InvalidObjectException("invalid class");
            }
            int n2 = n;
            while (--n2 >= 0) {
                Class clazz2 = classArray[n2];
                if (!clazz.isAssignableFrom(clazz2) && !clazz2.isAssignableFrom(clazz)) continue;
                throw new InvalidObjectException("cannot create constraint with redundant elements");
            }
        }
    }
}

