/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.client.core;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksClientException;
import com.mathworks.webservices.client.core.MathWorksServiceException;
import com.mathworks.webservices.client.core.MathWorksServiceResponse;
import com.mathworks.webservices.client.core.ProxyAuthenticationRequiredException;
import com.mathworks.webservices.client.core.ServiceNotFoundException;
import com.mathworks.webservices.client.core.ServiceUnavailableException;
import com.mathworks.webservices.client.core.WebServiceClient;
import com.mathworks.webservices.client.core.auth.ProxyServerCredentialsProvider;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.HttpResponse;
import com.mathworks.webservices.client.core.http.MathWorksHttpClient;
import com.mathworks.webservices.client.core.http.ResponseHandler;
import com.mathworks.webservices.client.core.xml.ErrorMessage;
import com.mathworks.webservices.client.core.xml.ErrorResponse;
import com.mathworks.webservices.client.core.xml.JaxbResponseHandler;
import java.io.IOException;
import org.apache.commons.httpclient.Header;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MathWorksWebServiceClient
implements WebServiceClient {
    private final int SERVICE_MOVED_PERMANENTLY = 301;
    private final int SERVICE_NOT_FOUND = 404;
    private final int PROXY_AUTHENTICATION_REQUIRED = 407;
    private final int SERVICE_UNAVAILABLE = 503;
    private String locale;
    private String clientString;
    protected String endpoint;
    protected final MathWorksHttpClient httpClient;
    protected final ResponseHandler responseHandler;

    public MathWorksWebServiceClient(ClientConfiguration config) {
        this.responseHandler = new JaxbResponseHandler();
        this.httpClient = new MathWorksHttpClient(config);
    }

    public MathWorksWebServiceClient(ClientConfiguration config, ResponseHandler responseHandler) {
        this.responseHandler = responseHandler;
        this.httpClient = new MathWorksHttpClient(config);
    }

    public MathWorksWebServiceClient(MathWorksHttpClient httpClient, ResponseHandler responseHandler) {
        this.httpClient = httpClient;
        this.responseHandler = responseHandler;
    }

    public void setEndpoint(String endpoint) throws IllegalArgumentException {
        this.endpoint = endpoint;
    }

    @Override
    public void setLocale(String locale) {
        this.locale = locale;
    }

    @Override
    public void setClientString(String clientString) {
        this.clientString = clientString;
    }

    public <T extends MathWorksServiceResponse> T executeRequest(HttpRequest request) throws MathWorksServiceException, MathWorksClientException {
        this.addClientLevelLocaleAndClientStringIfEmptyOnRequest(request);
        this.validateRequest(request);
        try {
            ErrorResponse error;
            Header locationHeader;
            request.getRequest().setFollowRedirects(false);
            HttpResponse resp = this.httpClient.invoke(request.getRequest());
            int respCode = resp.getStatusCode();
            if (301 == respCode && (locationHeader = request.getRequest().getResponseHeader("location")) != null) {
                String newLocation = locationHeader.getValue();
                if (newLocation != null && !newLocation.equalsIgnoreCase(this.endpoint)) {
                    this.endpoint = newLocation;
                    resp = this.httpClient.invoke(request.getRequest(true));
                } else {
                    throw new ServiceNotFoundException("301 response did not provide a valid location header.");
                }
            }
            if (407 == respCode) {
                throw new ProxyAuthenticationRequiredException(resp.getStatusText());
            }
            if (404 == respCode) {
                throw new ServiceNotFoundException(resp.getStatusText());
            }
            if (503 == respCode) {
                error = (ErrorResponse)this.responseHandler.handleResponse(resp.getResponseBody());
                ServiceUnavailableException ex = (ServiceUnavailableException)this.createServiceException(respCode, error);
                throw ex;
            }
            if (301 != respCode && respCode > 299) {
                error = (ErrorResponse)this.responseHandler.handleResponse(resp.getResponseBody());
                error.setRequestId(resp.getRequestId());
                if ("Server".equalsIgnoreCase(error.getErrorType())) {
                    throw this.createServiceException(respCode, error);
                }
                throw this.createClientException(error);
            }
            MathWorksServiceResponse response = (MathWorksServiceResponse)this.responseHandler.handleResponse(resp.getResponseBody());
            response.setRequestId(resp.getRequestId());
            response.setSignature(resp.getSignature());
            MathWorksServiceResponse mathWorksServiceResponse = response;
            return (T)mathWorksServiceResponse;
        }
        catch (IOException e) {
            throw new MathWorksClientException("unable to connect to host " + e.getMessage(), e);
        }
        finally {
            if (request.getRequest() != null) {
                request.getRequest().releaseConnection();
            }
        }
    }

    <T extends MathWorksServiceException> T createServiceException(int respCode, ErrorResponse response) {
        ErrorMessage message = this.getErrorMessage(response);
        MathWorksServiceException ex = new MathWorksServiceException(message.getMessage());
        ex.setStatusCode(respCode);
        ex.setErrorCode(message.getCode());
        ex.setRequestId(response.getRequestId());
        return (T)ex;
    }

    <T extends MathWorksClientException> T createClientException(ErrorResponse response) {
        ErrorMessage message = this.getErrorMessage(response);
        MathWorksClientException ex = new MathWorksClientException(message.getMessage());
        ex.setErrorCode(message.getCode());
        ex.setRequestId(response.getRequestId());
        return (T)ex;
    }

    ErrorMessage getErrorMessage(ErrorResponse error) {
        try {
            ErrorMessage message = error.getErrors().get(0);
            return message;
        }
        catch (Throwable t) {
            ErrorMessage message = new ErrorMessage();
            message.setCode("");
            message.setMessage("");
            return message;
        }
    }

    void addClientLevelLocaleAndClientStringIfEmptyOnRequest(HttpRequest request) {
        String locale;
        String clientString = request.getClientString();
        if (clientString == null || "".equals(clientString)) {
            request.setClientString(this.clientString);
        }
        if ((locale = request.getLocale()) == null || "".equals(locale)) {
            request.setLocale(this.locale);
        }
    }

    void validateRequest(HttpRequest request) throws MathWorksClientException {
        String endpoint = request.getEndpoint();
        if (endpoint == null || "".equals(endpoint)) {
            throw new MathWorksClientException("You must define an endpoint for the service client.");
        }
        String clientString = request.getClientString();
        if (clientString == null || "".equals(clientString)) {
            throw new MathWorksClientException("You must set the clientString on your request.");
        }
        String locale = request.getLocale();
        if (locale == null || "".equals(locale)) {
            throw new MathWorksClientException("You must set the locale on your request.");
        }
    }

    @Override
    public void clearProxySettings() {
        this.httpClient.clearProxySettings();
    }

    @Override
    public void setProxyConfiguration(String host, int port) {
        this.httpClient.setProxyConfiguration(host, port);
    }

    @Override
    public void setProxyConfiguration(String host, int port, String username, String password) {
        this.httpClient.setProxyConfiguration(host, port, username, password);
    }

    @Override
    public void setProxyConfiguration(String host, int port, ProxyServerCredentialsProvider credentialsProvider) {
        this.httpClient.setProxyConfiguration(host, port, credentialsProvider);
    }
}

