/*
 * Decompiled with CFR 0.152.
 */
package net.jini.jeri.connection;

import com.sun.jini.jeri.internal.mux.MuxServer;
import com.sun.jini.logging.Levels;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.io.UnsupportedConstraintException;
import net.jini.jeri.InboundRequest;
import net.jini.jeri.RequestDispatcher;
import net.jini.jeri.connection.InboundRequestHandle;
import net.jini.jeri.connection.ServerConnection;

public final class ServerConnectionManager {
    private static final Logger logger = Logger.getLogger("net.jini.jeri.connection.ServerConnectionManager");

    private static void logThrow(Logger logger, String string, String string2, Object[] objectArray, Exception exception) {
        LogRecord logRecord = new LogRecord(Levels.HANDLED, string2);
        logRecord.setLoggerName(logger.getName());
        logRecord.setSourceClassName(ServerConnectionManager.class.getName());
        logRecord.setSourceMethodName(string);
        logRecord.setParameters(objectArray);
        logRecord.setThrown(exception);
        logger.log(logRecord);
    }

    public void handleConnection(ServerConnection serverConnection, RequestDispatcher requestDispatcher) {
        if (serverConnection == null || requestDispatcher == null) {
            throw new NullPointerException();
        }
        InboundMux.create(serverConnection, requestDispatcher);
    }

    private static final class InboundMux
    extends MuxServer {
        private final ServerConnection c;

        private InboundMux(ServerConnection serverConnection, RequestDispatcher requestDispatcher) throws IOException {
            super(serverConnection.getOutputStream(), serverConnection.getInputStream(), requestDispatcher);
            this.c = serverConnection;
        }

        private InboundMux(ServerConnection serverConnection, RequestDispatcher requestDispatcher, boolean bl) throws IOException {
            super(serverConnection.getChannel(), requestDispatcher);
            this.c = serverConnection;
        }

        static void create(ServerConnection serverConnection, RequestDispatcher requestDispatcher) {
            Dispatcher dispatcher = new Dispatcher(requestDispatcher, serverConnection);
            try {
                if (serverConnection.getChannel() == null) {
                    new InboundMux(serverConnection, (RequestDispatcher)dispatcher).start();
                } else {
                    new InboundMux(serverConnection, dispatcher, true).start();
                }
            }
            catch (IOException iOException) {
                if (logger.isLoggable(Levels.HANDLED)) {
                    ServerConnectionManager.logThrow(logger, "handleConnection", "{0} throws", new Object[]{serverConnection}, iOException);
                }
                try {
                    serverConnection.close();
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
        }

        protected void handleDown() {
            try {
                this.c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static final class Inbound
    implements InboundRequest {
        private final InboundRequest req;
        private final ServerConnection c;
        private final InboundRequestHandle handle;

        Inbound(InboundRequest inboundRequest, ServerConnection serverConnection, InboundRequestHandle inboundRequestHandle) {
            this.req = inboundRequest;
            this.c = serverConnection;
            this.handle = inboundRequestHandle;
        }

        public void populateContext(Collection collection) {
            this.req.populateContext(collection);
            this.c.populateContext(this.handle, collection);
        }

        public InvocationConstraints checkConstraints(InvocationConstraints invocationConstraints) throws UnsupportedConstraintException {
            return this.c.checkConstraints(this.handle, invocationConstraints);
        }

        public void checkPermissions() {
            this.c.checkPermissions(this.handle);
        }

        public InputStream getRequestInputStream() {
            return this.req.getRequestInputStream();
        }

        public OutputStream getResponseOutputStream() {
            return this.req.getResponseOutputStream();
        }

        public void abort() {
            this.req.abort();
        }
    }

    private static final class Dispatcher
    implements RequestDispatcher {
        private final RequestDispatcher dispatcher;
        private final ServerConnection c;

        Dispatcher(RequestDispatcher requestDispatcher, ServerConnection serverConnection) {
            this.dispatcher = requestDispatcher;
            this.c = serverConnection;
        }

        public void dispatch(InboundRequest inboundRequest) {
            block2: {
                try {
                    Inbound inbound = new Inbound(inboundRequest, this.c, this.c.processRequestData(inboundRequest.getRequestInputStream(), inboundRequest.getResponseOutputStream()));
                    inbound.checkPermissions();
                    this.dispatcher.dispatch(inbound);
                }
                catch (IOException iOException) {
                    if (!logger.isLoggable(Levels.HANDLED)) break block2;
                    ServerConnectionManager.logThrow(logger, "dispatchRequest", "{0} throws", new Object[]{this.c}, iOException);
                }
            }
        }
    }
}

