/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.DialogSupport;
import org.netbeans.editor.KeySequenceInputPanel;
import org.netbeans.editor.MultiKeyBinding;
import org.netbeans.editor.Settings;
import org.netbeans.editor.Utilities;
import org.openide.util.NbBundle;

public class MacroSavePanel
extends JPanel {
    private final ResourceBundle bundle = NbBundle.getBundle(BaseKit.class);
    private Vector bindings = new Vector();
    private Class kitClass;
    public JButton addButton;
    public JLabel bindingLabel;
    public JList bindingList;
    public JPanel bindingPanel;
    public JScrollPane bindingScrollPane;
    public JTextField macroField;
    public JLabel macroLabel;
    public JPanel macroPanel;
    public JTextField nameField;
    public JLabel nameLabel;
    public JButton removeButton;

    public MacroSavePanel(Class clazz) {
        this.kitClass = clazz;
        this.initComponents();
        this.nameLabel.setDisplayedMnemonic(this.bundle.getString("MSP_Name_Mnemonic").charAt(0));
        this.macroLabel.setDisplayedMnemonic(this.bundle.getString("MSP_Macro_Mnemonic").charAt(0));
        this.bindingLabel.setDisplayedMnemonic(this.bundle.getString("MSP_Keys_Mnemonic").charAt(0));
        this.nameField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_MSP_Name"));
        this.macroField.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_MSP_Macro"));
        this.bindingList.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_MSP_Keys"));
        this.getAccessibleContext().setAccessibleName(this.bundle.getString("MDS_title"));
        this.getAccessibleContext().setAccessibleDescription(this.bundle.getString("ACSD_MSP"));
        this.setMaximumSize(new Dimension(400, 200));
    }

    @Override
    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        Dimension dimension2 = this.getMaximumSize();
        if (dimension.width > dimension2.width) {
            dimension.width = dimension2.width;
        }
        if (dimension.height > dimension2.height) {
            dimension.height = dimension2.height;
        }
        return dimension;
    }

    private void initComponents() {
        this.macroPanel = new JPanel();
        this.nameLabel = new JLabel();
        this.macroLabel = new JLabel();
        this.nameField = new JTextField();
        this.macroField = new JTextField();
        this.bindingPanel = new JPanel();
        this.bindingLabel = new JLabel();
        this.bindingScrollPane = new JScrollPane();
        this.bindingList = new JList();
        this.addButton = new JButton();
        this.removeButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.macroPanel.setLayout(new GridBagLayout());
        this.nameLabel.setLabelFor(this.nameField);
        this.nameLabel.setText(this.bundle.getString("MSP_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.macroPanel.add((Component)this.nameLabel, gridBagConstraints);
        this.macroLabel.setLabelFor(this.macroField);
        this.macroLabel.setText(this.bundle.getString("MSP_Macro"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 0, 0, 12);
        this.macroPanel.add((Component)this.macroLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.macroPanel.add((Component)this.nameField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        this.macroPanel.add((Component)this.macroField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.macroPanel, gridBagConstraints);
        this.bindingPanel.setLayout(new GridBagLayout());
        this.bindingLabel.setLabelFor(this.bindingList);
        this.bindingLabel.setText(this.bundle.getString("MSP_Keys"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.bindingPanel.add((Component)this.bindingLabel, gridBagConstraints);
        this.bindingList.setCellRenderer(new KeySequenceCellRenderer());
        this.bindingScrollPane.setViewportView(this.bindingList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 12);
        this.bindingPanel.add((Component)this.bindingScrollPane, gridBagConstraints);
        this.addButton.setMnemonic(this.bundle.getString("MSP_Add_Mnemonic").charAt(0));
        this.addButton.setText(this.bundle.getString("MSP_Add"));
        this.addButton.setToolTipText(this.bundle.getString("MSP_AddToolTip"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroSavePanel.this.addBindingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.bindingPanel.add((Component)this.addButton, gridBagConstraints);
        this.removeButton.setMnemonic(this.bundle.getString("MSP_Remove_Mnemonic").charAt(0));
        this.removeButton.setText(this.bundle.getString("MSP_Remove"));
        this.removeButton.setToolTipText(this.bundle.getString("MSP_RemoveToolTip"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MacroSavePanel.this.removeBindingActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        this.bindingPanel.add((Component)this.removeButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.bindingPanel, gridBagConstraints);
    }

    private void removeBindingActionPerformed(ActionEvent actionEvent) {
        int n = this.bindingList.getSelectedIndex();
        if (n >= 0) {
            this.bindings.remove(n);
            this.bindingList.setListData(this.bindings);
        }
        if (this.bindingList.getModel().getSize() <= 0) {
            this.removeButton.setEnabled(false);
        } else {
            this.bindingList.setSelectedIndex(0);
        }
    }

    private void addBindingActionPerformed(ActionEvent actionEvent) {
        KeyStroke[] keyStrokeArray = new KeySequenceRequester().getKeySequence();
        if (keyStrokeArray != null) {
            this.bindings.add(keyStrokeArray);
            this.bindingList.setListData(this.bindings);
            this.bindingList.setSelectedIndex(0);
            this.removeButton.setEnabled(true);
        }
    }

    @Override
    public String getName() {
        return this.nameField.getText();
    }

    @Override
    public void setName(String string) {
        this.nameField.setText(string);
    }

    public String getBody() {
        return this.macroField.getText();
    }

    public void setBody(String string) {
        this.macroField.setText(string);
    }

    public List getKeySequences() {
        return new ArrayList(this.bindings);
    }

    public void setKeySequences(List list) {
        this.bindings = new Vector(list);
        this.bindingList.setListData(this.bindings);
    }

    public void popupNotify() {
        this.nameField.requestFocus();
    }

    class KeySequenceRequester {
        KeySequenceInputPanel panel;
        Dialog dial;
        JButton[] buttons;
        KeyStroke[] retVal;

        KeySequenceRequester() {
            this.buttons = new JButton[]{new JButton(MacroSavePanel.this.bundle.getString("MSP_ok")), new JButton(MacroSavePanel.this.bundle.getString("MSP_clear")), new JButton(MacroSavePanel.this.bundle.getString("MSP_cancel"))};
            this.retVal = null;
            this.buttons[0].getAccessibleContext().setAccessibleDescription(MacroSavePanel.this.bundle.getString("ACSD_MSP_ok"));
            this.buttons[1].getAccessibleContext().setAccessibleDescription(MacroSavePanel.this.bundle.getString("ACSD_MSP_clear"));
            this.buttons[2].getAccessibleContext().setAccessibleDescription(MacroSavePanel.this.bundle.getString("ACSD_MSP_cancel"));
            this.buttons[1].setMnemonic(MacroSavePanel.this.bundle.getString("MSP_clear_Mnemonic").charAt(0));
            this.buttons[0].setEnabled(false);
            this.panel = new KeySequenceInputPanel();
            this.panel.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if ("keySequence" != propertyChangeEvent.getPropertyName()) {
                        return;
                    }
                    KeyStroke[] keyStrokeArray = KeySequenceRequester.this.panel.getKeySequence();
                    String string = KeySequenceRequester.this.isAlreadyBounded(keyStrokeArray);
                    if (string == null) {
                        string = KeySequenceRequester.this.getCollisionString(keyStrokeArray);
                    }
                    KeySequenceRequester.this.buttons[0].setEnabled(keyStrokeArray.length > 0 && string == null);
                    KeySequenceRequester.this.panel.setInfoText(string == null ? "" : string);
                }
            });
            this.dial = DialogSupport.createDialog(MacroSavePanel.this.bundle.getString("MSP_AddTitle"), this.panel, true, this.buttons, false, -1, 2, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    if (actionEvent.getSource() == KeySequenceRequester.this.buttons[1]) {
                        KeySequenceRequester.this.panel.clear();
                        KeySequenceRequester.this.panel.requestFocus();
                    } else if (actionEvent.getSource() == KeySequenceRequester.this.buttons[0]) {
                        KeySequenceRequester.this.retVal = KeySequenceRequester.this.panel.getKeySequence();
                        KeySequenceRequester.this.dial.dispose();
                    } else if (actionEvent.getSource() == KeySequenceRequester.this.buttons[2]) {
                        KeySequenceRequester.this.retVal = null;
                        KeySequenceRequester.this.dial.dispose();
                    }
                }
            });
        }

        KeyStroke[] getKeySequence() {
            this.dial.pack();
            this.panel.requestFocus();
            this.dial.show();
            return this.retVal;
        }

        String isAlreadyBounded(KeyStroke[] keyStrokeArray) {
            if (keyStrokeArray.length == 0) {
                return null;
            }
            Iterator iterator = MacroSavePanel.this.bindings.iterator();
            while (iterator.hasNext()) {
                if (!this.isOverlapingSequence((KeyStroke[])iterator.next(), keyStrokeArray)) continue;
                return MacroSavePanel.this.bundle.getString("MSP_Collision");
            }
            return null;
        }

        String getCollisionString(KeyStroke[] keyStrokeArray) {
            if (keyStrokeArray.length == 0) {
                return null;
            }
            Settings.KitAndValue[] kitAndValueArray = Settings.getValueHierarchy(MacroSavePanel.this.kitClass, "key-bindings");
            for (int i = 0; i < kitAndValueArray.length; ++i) {
                for (MultiKeyBinding multiKeyBinding : (List)kitAndValueArray[i].value) {
                    KeyStroke[] keyStrokeArray2 = multiKeyBinding.keys;
                    if (keyStrokeArray2 == null && multiKeyBinding.key != null) {
                        keyStrokeArray2 = new KeyStroke[]{multiKeyBinding.key};
                    }
                    if (keyStrokeArray2 == null || !this.isOverlapingSequence(keyStrokeArray2, keyStrokeArray)) continue;
                    Object[] objectArray = new Object[]{Utilities.keySequenceToString(keyStrokeArray2), multiKeyBinding.actionName};
                    return MessageFormat.format(MacroSavePanel.this.bundle.getString("MSP_FMT_Collision"), objectArray);
                }
            }
            return null;
        }

        private boolean isOverlapingSequence(KeyStroke[] keyStrokeArray, KeyStroke[] keyStrokeArray2) {
            int n = Math.min(keyStrokeArray.length, keyStrokeArray2.length);
            if (n == 0) {
                return false;
            }
            while (n-- > 0) {
                if (keyStrokeArray[n].equals(keyStrokeArray2[n])) continue;
                return false;
            }
            return true;
        }
    }

    private static class KeySequenceCellRenderer
    extends JLabel
    implements ListCellRenderer {
        public KeySequenceCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setText(Utilities.keySequenceToString((KeyStroke[])object));
            this.setBackground(bl ? jList.getSelectionBackground() : jList.getBackground());
            this.setForeground(bl ? jList.getSelectionForeground() : jList.getForeground());
            return this;
        }
    }
}

