/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.editor.view.spi;

public class ViewLayoutQueue {
    private static ViewLayoutQueue defaultQueue;
    private static SynchronousQueue synchronousQueue;
    private Runnable[] taskArray = new Runnable[2];
    private int startIndex;
    private int endIndex;
    private Thread worker;

    public static ViewLayoutQueue getDefaultQueue() {
        if (defaultQueue == null) {
            defaultQueue = new ViewLayoutQueue();
        }
        return defaultQueue;
    }

    public static ViewLayoutQueue getSynchronousQueue() {
        if (synchronousQueue == null) {
            synchronousQueue = new SynchronousQueue();
        }
        return synchronousQueue;
    }

    public synchronized Thread getWorkerThread() {
        this.ensureWorkerInited();
        return this.worker;
    }

    private void ensureWorkerInited() {
        if (this.worker == null) {
            this.worker = new LayoutThread();
            this.worker.start();
        }
    }

    public synchronized void addTask(Runnable runnable) {
        if (runnable != null) {
            this.ensureWorkerInited();
            if (this.startIndex == this.endIndex && this.taskArray[this.startIndex] != null) {
                Runnable[] runnableArray = new Runnable[this.taskArray.length << 1];
                int n = this.taskArray.length - this.startIndex;
                System.arraycopy(this.taskArray, this.endIndex, runnableArray, 0, n);
                System.arraycopy(this.taskArray, 0, runnableArray, n, this.startIndex);
                this.startIndex = 0;
                this.endIndex = this.taskArray.length;
                this.taskArray = runnableArray;
            }
            this.taskArray[this.endIndex] = runnable;
            this.endIndex = this.endIndex + 1 & this.taskArray.length - 1;
            this.notify();
        }
    }

    synchronized Runnable waitForTask() {
        while (this.startIndex == this.endIndex && this.taskArray[this.startIndex] == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                return null;
            }
        }
        Runnable runnable = this.taskArray[this.startIndex];
        this.taskArray[this.startIndex] = null;
        int n = this.taskArray.length;
        this.startIndex = this.startIndex + 1 & n - 1;
        if (n >= 128) {
            int n2 = this.endIndex - this.startIndex;
            if (n2 >= 0) {
                if (n2 < n / 8) {
                    Runnable[] runnableArray = new Runnable[n / 4];
                    System.arraycopy(this.taskArray, this.startIndex, runnableArray, 0, n2);
                    this.taskArray = runnableArray;
                    this.startIndex = 0;
                    this.endIndex = n2;
                }
            } else if ((n2 = n + n2) < n / 8) {
                Runnable[] runnableArray = new Runnable[n / 4];
                System.arraycopy(this.taskArray, this.startIndex, runnableArray, 0, n - this.startIndex);
                System.arraycopy(this.taskArray, 0, runnableArray, n - this.startIndex, this.endIndex);
                this.taskArray = runnableArray;
                this.startIndex = 0;
                this.endIndex = n2;
            }
        }
        return runnable;
    }

    private static class SynchronousQueue
    extends ViewLayoutQueue {
        private SynchronousQueue() {
        }

        @Override
        public void addTask(Runnable runnable) {
            runnable.run();
        }
    }

    class LayoutThread
    extends Thread {
        LayoutThread() {
            super("Text-Layout");
            this.setPriority(1);
        }

        @Override
        public void run() {
            Runnable runnable;
            do {
                if ((runnable = ViewLayoutQueue.this.waitForTask()) == null) continue;
                runnable.run();
            } while (runnable != null);
        }
    }
}

