/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Writer;
import javax.swing.text.Document;
import org.netbeans.editor.SettingsDefaults;
import org.netbeans.editor.ext.ExtFormatter;
import org.openide.text.IndentEngine;

public abstract class FormatterIndentEngine
extends IndentEngine {
    public static final String EXPAND_TABS_PROP = "expandTabs";
    public static final String SPACES_PER_TAB_PROP = "spacesPerTab";
    static final long serialVersionUID = -3408217516931076216L;
    private transient ExtFormatter formatter;
    private String[] acceptedMimeTypes;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("expandTabs", Boolean.TYPE), new ObjectStreamField("spacesPerTab", Integer.TYPE)};

    public ExtFormatter getFormatter() {
        if (this.formatter == null) {
            this.formatter = this.createFormatter();
        }
        return this.formatter;
    }

    protected abstract ExtFormatter createFormatter();

    public Object getValue(String string) {
        return this.getFormatter().getSettingValue(string);
    }

    public void setValue(String string, Object object, String string2) {
        Object object2 = this.getValue(string);
        if (object2 == null && object == null || object2 != null && object2.equals(object)) {
            return;
        }
        this.getFormatter().setSettingValue(string, object);
        if (string2 != null) {
            this.firePropertyChange(string2, object2, object);
        }
    }

    public void setValue(String string, Object object) {
        this.setValue(string, object, null);
    }

    public int indentLine(Document document, int n) {
        return this.getFormatter().indentLine(document, n);
    }

    public int indentNewLine(Document document, int n) {
        return this.getFormatter().indentNewLine(document, n);
    }

    public Writer createWriter(Document document, int n, Writer writer) {
        return this.getFormatter().createWriter(document, n, writer);
    }

    protected boolean acceptMimeType(String string) {
        if (this.acceptedMimeTypes != null) {
            for (int i = this.acceptedMimeTypes.length - 1; i >= 0; --i) {
                if (!this.acceptedMimeTypes[i].equals(string)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExpandTabs() {
        return this.getFormatter().expandTabs();
    }

    public void setExpandTabs(boolean bl) {
        boolean bl2 = this.getFormatter().expandTabs();
        this.getFormatter().setExpandTabs(bl);
        if (bl2 != bl) {
            this.setValue("expand-tabs", bl, EXPAND_TABS_PROP);
            this.firePropertyChange(EXPAND_TABS_PROP, bl2 ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public int getSpacesPerTab() {
        return this.getFormatter().getSpacesPerTab();
    }

    public void setSpacesPerTab(int n) {
        if (n <= 0) {
            return;
        }
        int n2 = this.getFormatter().getSpacesPerTab();
        this.getFormatter().setSpacesPerTab(n);
        if (n2 != n) {
            this.setValue("spaces-per-tab", new Integer(n), SPACES_PER_TAB_PROP);
            this.firePropertyChange(SPACES_PER_TAB_PROP, new Integer(n2), new Integer(n));
        }
    }

    public void setAcceptedMimeTypes(String[] stringArray) {
        this.acceptedMimeTypes = stringArray;
    }

    public String[] getAcceptedMimeTypes() {
        return this.acceptedMimeTypes;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        this.setExpandTabs(getField.get(EXPAND_TABS_PROP, SettingsDefaults.defaultExpandTabs));
        this.setSpacesPerTab(getField.get(SPACES_PER_TAB_PROP, SettingsDefaults.defaultSpacesPerTab));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException, ClassNotFoundException {
        ObjectOutputStream.PutField putField = objectOutputStream.putFields();
        putField.put(EXPAND_TABS_PROP, this.isExpandTabs());
        putField.put(SPACES_PER_TAB_PROP, this.getSpacesPerTab());
        objectOutputStream.writeFields();
    }
}

