/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import [Ljava.lang.String;;
import com.sun.jini.config.Config;
import com.sun.jini.start.ActivateWrapper;
import com.sun.jini.start.AggregatePolicyProvider;
import com.sun.jini.start.ClassLoaderUtil;
import com.sun.jini.start.HTTPDStatus;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.start.LoaderSplitPolicyProvider;
import com.sun.jini.start.ServiceDescriptor;
import com.sun.jini.start.ServiceProxyAccessor;
import com.sun.jini.start.ServiceStarter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.rmi.MarshalledObject;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Policy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.export.ProxyAccessor;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.policy.DynamicPolicyProvider;
import net.jini.security.policy.PolicyFileProvider;

public class NonActivatableServiceDescriptor
implements ServiceDescriptor {
    private static final Class[] actTypes = new Class[]{String;.class, LifeCycle.class};
    private final String codebase;
    private final String policy;
    private final String classpath;
    private final String implClassName;
    private final String[] serverConfigArgs;
    private final LifeCycle lifeCycle;
    private static LifeCycle NoOpLifeCycle = new LifeCycle(){

        public boolean unregister(Object object) {
            return false;
        }
    };
    private static AggregatePolicyProvider globalPolicy = null;
    private static Policy initialGlobalPolicy = null;
    private static final Logger logger = ServiceStarter.logger;

    public NonActivatableServiceDescriptor(String string, String string2, String string3, String string4, String[] stringArray, LifeCycle lifeCycle) {
        if (string == null || string2 == null || string3 == null || string4 == null) {
            throw new NullPointerException("Codebase, policy, classpath, and implementation cannot be null");
        }
        this.codebase = string;
        this.policy = string2;
        this.classpath = string3;
        this.implClassName = string4;
        this.serverConfigArgs = stringArray;
        this.lifeCycle = lifeCycle == null ? NoOpLifeCycle : lifeCycle;
    }

    public NonActivatableServiceDescriptor(String string, String string2, String string3, String string4, String[] stringArray) {
        this(string, string2, string3, string4, stringArray, null);
    }

    public final String getCodebase() {
        return this.codebase;
    }

    public final String getPolicy() {
        return this.policy;
    }

    public final String getClasspath() {
        return this.classpath;
    }

    public final String getImplClassName() {
        return this.implClassName;
    }

    public final String[] getServerConfigArgs() {
        return this.serverConfigArgs != null ? (String[])this.serverConfigArgs.clone() : null;
    }

    public final LifeCycle getLifeCycle() {
        return this.lifeCycle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object create(Configuration configuration) throws Exception {
        Object object;
        Object object2;
        ServiceStarter.ensureSecurityManager();
        logger.entering(NonActivatableServiceDescriptor.class.getName(), "create", new Object[]{configuration});
        if (configuration == null) {
            throw new NullPointerException("Configuration argument cannot be null");
        }
        ProxyPreparer proxyPreparer = (ProxyPreparer)Config.getNonNullEntry(configuration, "com.sun.jini.start", "servicePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        HTTPDStatus.httpdWarning(this.getCodebase());
        Object object3 = null;
        Object var4_4 = null;
        ActivateWrapper.ExportClassLoader exportClassLoader = null;
        try {
            exportClassLoader = new ActivateWrapper.ExportClassLoader(ClassLoaderUtil.getClasspathURLs(this.getClasspath()), ClassLoaderUtil.getCodebaseURLs(this.getCodebase()));
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, "classloader.problem", new Object[]{this.getClasspath(), this.getCodebase()});
            throw iOException;
        }
        Object object4 = NonActivatableServiceDescriptor.class;
        synchronized (object4) {
            if (globalPolicy == null) {
                initialGlobalPolicy = Policy.getPolicy();
                globalPolicy = new AggregatePolicyProvider(initialGlobalPolicy);
                Policy.setPolicy(globalPolicy);
                logger.log(Level.FINEST, "Global policy set: {0}", globalPolicy);
            }
            object2 = new DynamicPolicyProvider(new PolicyFileProvider(this.getPolicy()));
            object = new LoaderSplitPolicyProvider(exportClassLoader, (Policy)object2, new DynamicPolicyProvider(initialGlobalPolicy));
            ((LoaderSplitPolicyProvider)object).grant(this.getClass(), null, new Permission[]{new AllPermission()});
            globalPolicy.setPolicy(exportClassLoader, (Policy)object);
        }
        object4 = Thread.currentThread();
        object2 = ((Thread)object4).getContextClassLoader();
        ((Thread)object4).setContextClassLoader(exportClassLoader);
        try {
            object = null;
            object = Class.forName(this.getImplClassName(), false, exportClassLoader);
            logger.finest("Attempting to get implementation constructor");
            Constructor constructor = ((Class)object).getDeclaredConstructor(actTypes);
            logger.log(Level.FINEST, "Obtained implementation constructor: {0}", constructor);
            constructor.setAccessible(true);
            var4_4 = constructor.newInstance(this.getServerConfigArgs(), this.lifeCycle);
            logger.log(Level.FINEST, "Obtained implementation instance: {0}", (Object)var4_4);
            object3 = var4_4 instanceof ServiceProxyAccessor ? ((ServiceProxyAccessor)var4_4).getServiceProxy() : (var4_4 instanceof ProxyAccessor ? ((ProxyAccessor)var4_4).getProxy() : null);
            if (object3 != null) {
                object3 = proxyPreparer.prepareProxy(object3);
            }
            logger.log(Level.FINEST, "Proxy =  {0}", object3);
            ((Thread)object4).setContextClassLoader((ClassLoader)object2);
            object3 = new MarshalledObject<Object>(object3).get();
            Object var11_12 = null;
            ((Thread)object4).setContextClassLoader((ClassLoader)object2);
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            ((Thread)object4).setContextClassLoader((ClassLoader)object2);
            throw throwable;
        }
        object = new Created(var4_4, object3);
        logger.exiting(NonActivatableServiceDescriptor.class.getName(), "create", object);
        return object;
    }

    public String toString() {
        ArrayList<Object> arrayList = new ArrayList<Object>(6);
        arrayList.add(this.codebase);
        arrayList.add(this.policy);
        arrayList.add(this.classpath);
        arrayList.add(this.implClassName);
        arrayList.add(Arrays.asList(this.serverConfigArgs));
        arrayList.add(this.lifeCycle);
        return arrayList.toString();
    }

    public static class Created {
        public final Object proxy;
        public final Object impl;

        public Created(Object object, Object object2) {
            this.proxy = object2;
            this.impl = object;
        }
    }
}

