/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import java.io.File;
import java.io.FilePermission;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;

public final class SharedActivationPolicyPermission
extends Permission
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final boolean DEBUG = false;
    private FilePermission policyPermission;

    public SharedActivationPolicyPermission(String string) {
        super(string);
        this.init(string);
    }

    public SharedActivationPolicyPermission(String string, String string2) {
        super(string);
        this.init(string);
    }

    private void init(String string) {
        String string2 = null;
        try {
            URL uRL = new URL(string);
            string2 = uRL.toExternalForm();
            string2 = string2.replace('/', File.separatorChar);
        }
        catch (MalformedURLException malformedURLException) {
            string2 = string;
        }
        this.policyPermission = new FilePermission(string2, "read");
    }

    public boolean implies(Permission permission) {
        if (permission == null) {
            return false;
        }
        if (!(permission instanceof SharedActivationPolicyPermission)) {
            return false;
        }
        SharedActivationPolicyPermission sharedActivationPolicyPermission = (SharedActivationPolicyPermission)permission;
        boolean bl = this.policyPermission.implies(sharedActivationPolicyPermission.policyPermission);
        return bl;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (!(object instanceof SharedActivationPolicyPermission)) {
            return false;
        }
        SharedActivationPolicyPermission sharedActivationPolicyPermission = (SharedActivationPolicyPermission)object;
        boolean bl = this.policyPermission.equals(sharedActivationPolicyPermission.policyPermission);
        return bl;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    public String getActions() {
        return "";
    }

    public PermissionCollection newPermissionCollection() {
        return new Collection();
    }

    private static class Collection
    extends PermissionCollection {
        private static final long serialVersionUID = 1L;
        private final ArrayList perms = new ArrayList(3);

        private Collection() {
        }

        public synchronized void add(Permission permission) {
            if (this.isReadOnly()) {
                throw new SecurityException("Collection cannot be modified.");
            }
            if (this.perms.indexOf(permission) < 0) {
                this.perms.add(permission);
            }
        }

        public synchronized boolean implies(Permission permission) {
            int n = this.perms.size();
            while (--n >= 0) {
                if (!((Permission)this.perms.get(n)).implies(permission)) continue;
                return true;
            }
            return false;
        }

        public Enumeration elements() {
            return Collections.enumeration(this.perms);
        }
    }
}

