/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.desk;

import com.mathworks.desktop.attr.Attribute;
import com.mathworks.desktop.overlay.OverlayManagers;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.toolstrip.Toolstrip;
import com.mathworks.toolstrip.ToolstripTab;
import com.mathworks.toolstrip.accessories.TSRobot;
import com.mathworks.toolstrip.impl.ToolstripTabContentPanel;
import com.mathworks.widgets.desk.DTClient;
import com.mathworks.widgets.desk.DTDocumentBar;
import com.mathworks.widgets.desk.DTFrame;
import com.mathworks.widgets.desk.DTGroup;
import com.mathworks.widgets.desk.DTInternalFrame;
import com.mathworks.widgets.desk.DTMultipleClientFrame;
import com.mathworks.widgets.desk.DTOccupant;
import com.mathworks.widgets.desk.DTTitleBar;
import com.mathworks.widgets.desk.DTTitleButton;
import com.mathworks.widgets.desk.DTToolstripFactory;
import com.mathworks.widgets.desk.Desktop;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

class DTSelectionManager
implements PropertyChangeListener,
AWTEventListener {
    private Desktop fDesktop;
    private DTClient fSelectedClient;
    private DTClient fSecondarySelection;
    private int fLockCount;
    private int fSelectionCount;
    private boolean fIsEnabled;
    private boolean fPressDismissedMenu;
    private Component fComponentUnderMouse;
    private DTGroup fPreselectedGroup;

    DTSelectionManager(Desktop desktop) {
        this.fDesktop = desktop;
        this.setEnabled(true);
    }

    void setEnabled(boolean bl) {
        if (bl == this.fIsEnabled) {
            return;
        }
        if (bl) {
            long l = 16L;
            if (this.fDesktop.useToolstrip()) {
                l |= 0x20L;
            }
            Toolkit.getDefaultToolkit().addAWTEventListener(this, l);
        } else {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        }
        this.fIsEnabled = bl;
    }

    void add(DTClient dTClient) {
        if (dTClient.getSelectionOrder() > this.fSelectionCount) {
            this.fSelectionCount = dTClient.getSelectionOrder();
        }
        dTClient.addPropertyListener(this);
    }

    void remove(DTClient dTClient) {
        dTClient.removePropertyListener(this);
        if (dTClient == this.fSelectedClient) {
            this.fSelectedClient = null;
        }
        if (dTClient == this.fSecondarySelection) {
            this.fSecondarySelection = null;
        }
    }

    DTClient getSelectedClient() {
        return this.fSelectedClient;
    }

    DTClient getPreviousSelected() {
        DTClient dTClient = null;
        int n = -1;
        for (DTClient dTClient2 : this.fDesktop.getClients()) {
            DTClient dTClient3 = dTClient2;
            if (dTClient3 == this.fSelectedClient || dTClient3.getSelectionOrder() <= n) continue;
            dTClient = dTClient3;
            n = dTClient3.getSelectionOrder();
        }
        return dTClient;
    }

    DTClient getPreviousSelectedInFrame(DTFrame dTFrame) {
        DTClient dTClient = null;
        int n = -1;
        for (DTClient dTClient2 : this.fDesktop.getClients()) {
            DTClient dTClient3 = dTClient2;
            if (dTClient3 == this.fSelectedClient || dTClient3.getSelectionOrder() <= n || dTClient3.getLocation() == null || dTClient3.getLocation().getFrame() != dTFrame) continue;
            dTClient = dTClient3;
            n = dTClient3.getSelectionOrder();
        }
        return dTClient;
    }

    DTClient getMostRecentlySelected() {
        return this.fSelectedClient != null ? this.fSelectedClient : this.getPreviousSelected();
    }

    void selectClient(DTClient dTClient, boolean bl) {
        if (this.fLockCount == 0) {
            dTClient.setSelected(true, bl);
        }
    }

    void clearSelection() {
        if (this.fSelectedClient != null) {
            DTClient dTClient = this.fSelectedClient;
            this.fSelectedClient = null;
            dTClient.setSelected(false);
        }
    }

    void lock() {
        ++this.fLockCount;
    }

    void unlock() {
        if (this.fLockCount > 0) {
            --this.fLockCount;
            if (this.fLockCount == 0 && this.fSelectedClient != null) {
                this.fSelectedClient.requestFocus();
            }
        }
    }

    int getNextSelectionOrder() {
        return ++this.fSelectionCount;
    }

    Component getComponentUnderMouse() {
        return this.fComponentUnderMouse;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        DTClient dTClient = (DTClient)propertyChangeEvent.getSource();
        if (dTClient == null || !"Occupant Selected".equals(propertyChangeEvent.getPropertyName())) {
            return;
        }
        if (((Boolean)propertyChangeEvent.getNewValue()).booleanValue()) {
            dTClient.setSelectionOrder(++this.fSelectionCount);
            if (dTClient != this.fSelectedClient) {
                boolean bl = dTClient.isSingleton() && dTClient.getGroup() != null && dTClient.getLocation() != null && dTClient.getLocation().isDocked();
                DTClient dTClient2 = this.fSelectedClient;
                DTClient dTClient3 = this.fSecondarySelection;
                if (bl) {
                    this.fSecondarySelection = dTClient;
                } else {
                    this.fSelectedClient = dTClient;
                    if (this.fSecondarySelection != null && (dTClient.getGroup() != this.fSecondarySelection.getGroup() || this.fSecondarySelection.getGroup().isSelected())) {
                        this.fSecondarySelection = null;
                    }
                }
                if (dTClient3 != null && dTClient3 != this.fSecondarySelection) {
                    dTClient3.setSelected(false);
                }
                if (dTClient2 != null && dTClient2 != this.fSelectedClient) {
                    dTClient2.setSelected(false);
                }
            }
        } else if (dTClient == this.fSelectedClient) {
            this.fSelectedClient = null;
        } else if (dTClient == this.fSecondarySelection) {
            this.fSecondarySelection = null;
        }
    }

    private boolean shouldRefireMousePressedEvent(AWTEvent aWTEvent) {
        boolean bl;
        MenuElement[] menuElementArray = MenuSelectionManager.defaultManager().getSelectedPath();
        if (menuElementArray == null || menuElementArray.length == 0) {
            return false;
        }
        Object object = aWTEvent.getSource();
        if (object == null) {
            return false;
        }
        boolean bl2 = false;
        if (!(object instanceof JComponent && ((JComponent)object).getClientProperty("doNotCancelPopup") == "HidePopupKey" || !(bl = UIManager.getBoolean("PopupMenu.consumeEventOnClose")) || object instanceof MenuElement)) {
            bl2 = true;
        }
        return bl2;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        DTMultipleClientFrame dTMultipleClientFrame;
        MouseEvent mouseEvent;
        Component component;
        Window window;
        int n = aWTEvent.getID();
        if (n == 501) {
            Object object;
            Object object2;
            MouseEvent mouseEvent2 = (MouseEvent)aWTEvent;
            this.fPressDismissedMenu = false;
            Component component2 = mouseEvent2.getComponent();
            if (component2 instanceof DTTitleBar || DTDocumentBar.wantsToHandle(mouseEvent2)) {
                return;
            }
            if (this.fDesktop.useToolstrip()) {
                DTMultipleClientFrame dTMultipleClientFrame2;
                Window window2;
                object2 = OverlayManagers.get((Component)component2);
                if (object2 != null && object2.isPopupShowing()) {
                    return;
                }
                object = (ToolstripTabContentPanel)SwingUtilities.getAncestorOfClass(ToolstripTabContentPanel.class, component2);
                if (object != null && !((Boolean)object.getTab().getAttribute((Attribute)DTToolstripFactory.IS_GLOBAL_TAB)).booleanValue() && (window2 = SwingUtilities.windowForComponent((Component)object)) instanceof DTMultipleClientFrame && (dTMultipleClientFrame2 = (DTMultipleClientFrame)((Object)window2)).getDesktop() == this.fDesktop) {
                    dTMultipleClientFrame2.reselectToolstripClient(!this.toolstripComponentIsFocusable(component2));
                }
            }
            if ((object2 = (DTInternalFrame)((Object)SwingUtilities.getAncestorOfClass(DTInternalFrame.class, component2))) != null && ((DTInternalFrame)object2).getOccupant().getDesktop() == this.fDesktop) {
                this.fPressDismissedMenu = this.shouldRefireMousePressedEvent(aWTEvent);
                object = ((DTInternalFrame)object2).getOccupant();
                if (!object.isSelected()) {
                    if (component2 instanceof DTTitleButton) {
                        MenuSelectionManager.defaultManager().clearSelectedPath();
                    }
                    boolean bl = !component2.isFocusable() && !component2.isFocusTraversable() || ((DTOccupant)object).getLocation() != null && ((DTOccupant)object).getLocation().isMinimized() && (mouseEvent2.isPopupTrigger() || MJUtilities.isPopupPrecursor((MouseEvent)mouseEvent2));
                    ((DTOccupant)object).setSelected(true, true, bl);
                }
            }
        } else if (n == 502) {
            if (this.fPressDismissedMenu) {
                this.fPressDismissedMenu = false;
                Object object = aWTEvent.getSource();
                assert (object != null);
                if (object instanceof Component) {
                    Component component3 = (Component)object;
                    MouseEvent mouseEvent3 = (MouseEvent)aWTEvent;
                    component3.dispatchEvent(new MouseEvent(component3, 501, mouseEvent3.getWhen(), mouseEvent3.getModifiers(), mouseEvent3.getPoint().x, mouseEvent3.getPoint().y, mouseEvent3.getClickCount(), mouseEvent3.isPopupTrigger()));
                }
            }
        } else if (n == 504) {
            this.fComponentUnderMouse = (Component)aWTEvent.getSource();
        } else if (n == 505) {
            if (this.fComponentUnderMouse == aWTEvent.getSource()) {
                this.fComponentUnderMouse = null;
            }
        } else if (n == 503 && (window = SwingUtilities.windowForComponent(component = (mouseEvent = (MouseEvent)aWTEvent).getComponent())) instanceof DTMultipleClientFrame && (dTMultipleClientFrame = (DTMultipleClientFrame)((Object)window)).getDesktop() == this.fDesktop && dTMultipleClientFrame.isMainFrame()) {
            ToolstripTab toolstripTab;
            DTGroup dTGroup;
            String string;
            DTOccupant dTOccupant = null;
            Toolstrip toolstrip = TSRobot.getToolstripFor((Component)((Object)dTMultipleClientFrame));
            if (toolstrip != null && (string = toolstrip.getCurrentTab()) != null && (dTGroup = (DTGroup)(toolstripTab = (ToolstripTab)toolstrip.getModel().get(string)).getAttribute(DTToolstripFactory.CONTEXTUAL_TAB_GROUP)) != null && (component == toolstrip.getComponent() || SwingUtilities.isDescendingFrom(component, toolstrip.getComponent()))) {
                JComponent jComponent = toolstripTab.getComponent();
                Point point = SwingUtilities.convertPoint(component, mouseEvent.getPoint(), jComponent);
                if (point.x >= 0 && point.x < ((Component)jComponent).getWidth() && point.y >= 0 && point.y < ((Component)jComponent).getHeight()) {
                    dTOccupant = dTGroup;
                }
            }
            if (dTOccupant != this.fPreselectedGroup) {
                if (this.fPreselectedGroup != null) {
                    this.fPreselectedGroup.setConsideringSelection(false);
                }
                if (dTOccupant != null) {
                    dTOccupant.setConsideringSelection(true);
                }
                this.fPreselectedGroup = dTOccupant;
            }
        }
    }

    private boolean toolstripComponentIsFocusable(Component component) {
        return component instanceof JComboBox || component instanceof JTextField;
    }

    void normalizeSelectionOrder(List<DTClient> list) {
        ArrayList<DTClient> arrayList = new ArrayList<DTClient>(list);
        Collections.sort(arrayList, new OrderComparator());
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            ((DTClient)arrayList.get(i)).setSelectionOrder(n - i);
        }
        this.fSelectionCount = arrayList.size();
    }

    static class OrderComparator
    implements Comparator<DTClient> {
        OrderComparator() {
        }

        @Override
        public int compare(DTClient dTClient, DTClient dTClient2) {
            return dTClient2.getSelectionOrder() - dTClient.getSelectionOrder();
        }

        @Override
        public boolean equals(Object object) {
            return object instanceof OrderComparator;
        }
    }
}

