/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.grouptable;

import com.jidesoft.grid.CellSpan;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Converter;
import com.mathworks.util.MRUList;
import com.mathworks.util.MulticastChangeListener;
import com.mathworks.widgets.grouptable.Affordance;
import com.mathworks.widgets.grouptable.ExpansionProvider;
import com.mathworks.widgets.grouptable.Group;
import com.mathworks.widgets.grouptable.GroupingMode;
import com.mathworks.widgets.grouptable.GroupingTableCellSpan;
import com.mathworks.widgets.grouptable.GroupingTableColumn;
import com.mathworks.widgets.grouptable.GroupingTablePair;
import com.mathworks.widgets.grouptable.TableConfigurationSerializer;
import com.mathworks.widgets.grouptable.VerticalAttribute;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class GroupingTableConfiguration<T> {
    private List<GroupingTableColumn<T>> fColumnsInDefaultOrder;
    private List<ColumnConfiguration> fColumns;
    private List<GroupingTablePair<T>> fPairs;
    private List<ExpansionProvider<T>> fExpansionProviders;
    private Set<Group<T>> fExpandedGroups;
    private Set<Group<T>> fCollapsedGroups;
    private MRUList<T> fExpandedItems;
    private Map<String, Integer> fAverageWidthEstimate;
    private TableConfigurationSerializer<T> fSerializer;
    private List<VerticalAttribute<T>> fAllVerticalAttributes;
    private Set<VerticalAttribute<T>> fVisibleVerticalAttributes;
    private GroupingTableColumn<T> fMainColumn;
    private List<Affordance<T>> fAffordances;
    private MulticastChangeListener fVerticalAttributeDisplayChangeListener;
    private MulticastChangeListener fGroupingWillChangeListener;
    private CellSpan[] fCellSpanCache;
    private List<GroupingTableColumn<T>> fVisibleColumnsCache;
    private Comparator<T> fPreSorter;
    private GroupingTableColumn<T> fGroupColumn;
    private GroupingMode<T> fGroupMode;
    private GroupingTableColumn<T> fSortColumn;
    private int fFixedPositionColumnCount;
    private boolean fSortDescending;
    private double fWidthEstimateScaleFactor = 1.0;
    private boolean fIgnoreMinColWidth = false;
    private final PropertyChangeSupport fPropertySupport;
    private static final int EXPANDED_ITEM_LIMIT = 65536;
    private static final String VERTICAL_ATTRIBUTE_COLUMN_PREFIX = "__vertical_attribute:";
    public static final String ALL_COLUMNS_PROPERTY = "all-columns";
    public static final String ALL_VERTICAL_ATTRIBUTES_PROPERTY = "all-vertical-attributes";
    public static final String VISIBLE_COLUMNS_PROPERTY = "visible-columns";
    public static final String ALL_COLUMN_SIZES_PROPERTY = "all-column-sizes";
    public static final String VISIBLE_COLUMN_SIZES_PROPERTY = "visible-column-sizes";
    public static final String COLUMN_POSITIONS_PROPERTY = "column-positions";
    public static final String EXPANDED_GROUPS_PROPERTY = "expanded-groups";
    public static final String COLLAPSED_GROUPS_PROPERTY = "collapsed-groups";
    public static final String SORT_COLUMN_PROPERTY = "sort-column";
    public static final String SORT_DESCENDING_PROPERTY = "sort-descending";
    public static final String EXPANSION_PROVIDERS_PROPERTY = "expansion-providers";
    public static final String GROUP_MODE_PROPERTY = "group-mode";
    public static final String PRE_SORTER_PROPERTY = "pre-sorter";
    public static final String VISIBLE_VERTICAL_ATTRIBUTES_PROPERTY = "visible-vertical-attributes";
    public static final String AFFORDANCES_PROPERTY = "affordances";

    public GroupingTableConfiguration(List<GroupingTableColumn<T>> list) {
        this(list, new ArrayList<GroupingTablePair<T>>());
    }

    public GroupingTableConfiguration(List<GroupingTableColumn<T>> list, List<GroupingTablePair<T>> list2) {
        this(list, list2, null);
    }

    public GroupingTableConfiguration(List<GroupingTableColumn<T>> list, List<GroupingTablePair<T>> list2, TableConfigurationSerializer<T> tableConfigurationSerializer) {
        this(list, null, new ArrayList(), list2, tableConfigurationSerializer, 0);
    }

    public GroupingTableConfiguration(List<GroupingTableColumn<T>> list, GroupingTableColumn<T> groupingTableColumn, List<? extends VerticalAttribute<T>> list2, List<GroupingTablePair<T>> list3, TableConfigurationSerializer<T> tableConfigurationSerializer, int n) {
        this.fFixedPositionColumnCount = n;
        this.fSerializer = tableConfigurationSerializer;
        this.fMainColumn = groupingTableColumn;
        this.fColumnsInDefaultOrder = new ArrayList<GroupingTableColumn<T>>(list);
        this.fColumns = new ArrayList<ColumnConfiguration>();
        this.fAverageWidthEstimate = new HashMap<String, Integer>();
        for (GroupingTableColumn<T> object : list) {
            this.fColumns.add(new ColumnConfiguration(object));
        }
        for (VerticalAttribute verticalAttribute : list2) {
            if (!verticalAttribute.shouldShowInColumnWhenWide()) continue;
            this.fColumns.add(new ColumnConfiguration(this.createVerticalAttributeColumn(verticalAttribute)));
        }
        this.fAllVerticalAttributes = new ArrayList<VerticalAttribute<T>>(list2);
        this.fVerticalAttributeDisplayChangeListener = new MulticastChangeListener();
        this.fGroupingWillChangeListener = new MulticastChangeListener();
        this.fPairs = new ArrayList<GroupingTablePair<T>>(list3);
        this.fExpandedGroups = new HashSet<Group<T>>();
        this.fCollapsedGroups = new HashSet<Group<T>>();
        this.fVisibleVerticalAttributes = new HashSet<VerticalAttribute<T>>();
        this.fExpandedItems = new MRUList(65536);
        this.fExpansionProviders = new ArrayList<ExpansionProvider<T>>();
        this.fAffordances = new ArrayList<Affordance<T>>();
        this.generateVisibleColumnsCache();
        this.generateCellSpanCache();
        this.fPropertySupport = new PropertyChangeSupport(this);
        if (this.fSerializer != null) {
            this.loadSerializer();
            this.fPropertySupport.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    GroupingTableConfiguration.this.fSerializer.save(GroupingTableConfiguration.this);
                }
            });
        }
    }

    public void loadSerializer() {
        if (this.fSerializer != null) {
            this.fSerializer.load(this);
        }
    }

    private GroupingTableConfiguration(GroupingTableConfiguration<T> groupingTableConfiguration) {
        this.fSerializer = groupingTableConfiguration.fSerializer;
        this.fMainColumn = groupingTableConfiguration.fMainColumn;
        this.fWidthEstimateScaleFactor = groupingTableConfiguration.fWidthEstimateScaleFactor;
        this.fColumnsInDefaultOrder = new ArrayList<GroupingTableColumn<T>>(groupingTableConfiguration.fColumnsInDefaultOrder);
        this.fColumns = new ArrayList<ColumnConfiguration>(groupingTableConfiguration.fColumns);
        this.fAverageWidthEstimate = new HashMap<String, Integer>(groupingTableConfiguration.fAverageWidthEstimate);
        this.fAllVerticalAttributes = new ArrayList<VerticalAttribute<T>>(groupingTableConfiguration.fAllVerticalAttributes);
        this.fVerticalAttributeDisplayChangeListener = new MulticastChangeListener();
        this.fGroupingWillChangeListener = new MulticastChangeListener();
        this.fPairs = new ArrayList<GroupingTablePair<T>>(groupingTableConfiguration.fPairs);
        this.fExpandedGroups = new HashSet<Group<T>>(groupingTableConfiguration.fExpandedGroups);
        this.fCollapsedGroups = new HashSet<Group<T>>(groupingTableConfiguration.fCollapsedGroups);
        this.fVisibleVerticalAttributes = new HashSet<VerticalAttribute<T>>(groupingTableConfiguration.fVisibleVerticalAttributes);
        this.fExpandedItems = new MRUList(65536);
        for (Object e : groupingTableConfiguration.fExpandedItems) {
            this.fExpandedItems.add(e);
        }
        this.fExpansionProviders = new ArrayList<ExpansionProvider<T>>(groupingTableConfiguration.fExpansionProviders);
        this.fAffordances = new ArrayList<Affordance<T>>(groupingTableConfiguration.fAffordances);
        this.fSortColumn = groupingTableConfiguration.fSortColumn;
        this.fPreSorter = groupingTableConfiguration.fPreSorter;
        this.fSortDescending = groupingTableConfiguration.fSortDescending;
        this.fGroupColumn = groupingTableConfiguration.fGroupColumn;
        this.fGroupMode = groupingTableConfiguration.fGroupMode;
        this.generateVisibleColumnsCache();
        this.generateCellSpanCache();
        this.fPropertySupport = new PropertyChangeSupport(this);
        if (this.fSerializer != null) {
            this.fPropertySupport.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    GroupingTableConfiguration.this.fSerializer.save(GroupingTableConfiguration.this);
                }
            });
        }
    }

    public GroupingTableConfiguration<T> switchConfiguration(GroupingTableConfiguration<T> groupingTableConfiguration) {
        GroupingTableConfiguration<T> groupingTableConfiguration2 = new GroupingTableConfiguration<T>(this);
        this.fVerticalAttributeDisplayChangeListener = new MulticastChangeListener();
        this.fPairs = new ArrayList<GroupingTablePair<T>>(groupingTableConfiguration.fPairs);
        this.fSerializer = groupingTableConfiguration.fSerializer;
        this.fMainColumn = groupingTableConfiguration.fMainColumn;
        this.fColumnsInDefaultOrder = new ArrayList<GroupingTableColumn<T>>(groupingTableConfiguration.fColumnsInDefaultOrder);
        this.fColumns = new ArrayList<ColumnConfiguration>(groupingTableConfiguration.fColumns);
        this.generateVisibleColumnsCache();
        this.generateCellSpanCache();
        this.fPropertySupport.firePropertyChange(ALL_COLUMNS_PROPERTY, groupingTableConfiguration2.getAllColumns(), this.getAllColumns());
        this.fPropertySupport.firePropertyChange(VISIBLE_COLUMNS_PROPERTY, groupingTableConfiguration2.getVisibleColumns(), this.getVisibleColumns());
        this.fPropertySupport.firePropertyChange(COLUMN_POSITIONS_PROPERTY, groupingTableConfiguration2.getAllColumns(), this.getAllColumns());
        this.fPropertySupport.firePropertyChange(ALL_COLUMN_SIZES_PROPERTY, groupingTableConfiguration2.getAllColumnSizes(), this.getAllColumnSizes());
        this.fPropertySupport.firePropertyChange(VISIBLE_COLUMN_SIZES_PROPERTY, groupingTableConfiguration2.getVisibleColumnSizes(), this.getVisibleColumnSizes());
        this.fPreSorter = groupingTableConfiguration.fPreSorter;
        this.fPropertySupport.firePropertyChange(PRE_SORTER_PROPERTY, groupingTableConfiguration2.fPreSorter, this.fPreSorter);
        this.fSortColumn = groupingTableConfiguration.fSortColumn;
        this.fPropertySupport.firePropertyChange(SORT_COLUMN_PROPERTY, groupingTableConfiguration2.getSortColumn(), this.getSortColumn());
        this.fSortDescending = groupingTableConfiguration.fSortDescending;
        this.fPropertySupport.firePropertyChange(SORT_DESCENDING_PROPERTY, groupingTableConfiguration2.isSortedDescending(), this.isSortedDescending());
        this.fGroupMode = groupingTableConfiguration.fGroupMode;
        this.fGroupColumn = groupingTableConfiguration.fGroupColumn;
        this.fPropertySupport.firePropertyChange(GROUP_MODE_PROPERTY, groupingTableConfiguration2.getGroupMode(), this.getGroupMode());
        this.fExpandedItems = new MRUList(65536);
        for (Object e : groupingTableConfiguration.fExpandedItems) {
            this.fExpandedItems.add(e);
        }
        this.fExpansionProviders = new ArrayList<ExpansionProvider<T>>(groupingTableConfiguration.fExpansionProviders);
        this.fPropertySupport.firePropertyChange(EXPANSION_PROVIDERS_PROPERTY, groupingTableConfiguration2.getExpansionProviders(), this.getExpansionProviders());
        this.fAffordances = new ArrayList<Affordance<T>>(groupingTableConfiguration.fAffordances);
        this.fPropertySupport.firePropertyChange(AFFORDANCES_PROPERTY, groupingTableConfiguration2.getAffordances(), this.getAffordances());
        this.fAllVerticalAttributes = new ArrayList<VerticalAttribute<T>>(groupingTableConfiguration.fAllVerticalAttributes);
        this.fVisibleVerticalAttributes = new HashSet<VerticalAttribute<T>>(groupingTableConfiguration.fVisibleVerticalAttributes);
        this.fPropertySupport.firePropertyChange(ALL_VERTICAL_ATTRIBUTES_PROPERTY, groupingTableConfiguration2.getAllVerticalAttributes(), this.getAllVerticalAttributes());
        this.fPropertySupport.firePropertyChange(VISIBLE_VERTICAL_ATTRIBUTES_PROPERTY, groupingTableConfiguration2.getVisibleVerticalAttributes(), this.getVisibleVerticalAttributes());
        this.fExpandedGroups = new HashSet<Group<T>>(groupingTableConfiguration.fExpandedGroups);
        this.fCollapsedGroups = new HashSet<Group<T>>(groupingTableConfiguration.fCollapsedGroups);
        this.fPropertySupport.firePropertyChange(EXPANDED_GROUPS_PROPERTY, groupingTableConfiguration2.getExpandedGroups(), this.getExpandedGroups());
        this.fPropertySupport.firePropertyChange(COLLAPSED_GROUPS_PROPERTY, groupingTableConfiguration2.getCollapsedGroups(), this.getCollapsedGroups());
        return groupingTableConfiguration2;
    }

    public void addGroupingWillChangeListener(ChangeListener changeListener) {
        this.fGroupingWillChangeListener.addChangeListener(changeListener);
    }

    public void removeGroupingWillChangeListener(ChangeListener changeListener) {
        this.fGroupingWillChangeListener.removeChangeListener(changeListener);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(string, propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(string, propertyChangeListener);
    }

    public int getFixedPositionColumnCount() {
        return this.fFixedPositionColumnCount;
    }

    public List<ExpansionProvider<T>> getExpansionProviders() {
        return new ArrayList<ExpansionProvider<T>>(this.fExpansionProviders);
    }

    public void addExpansionProvider(ExpansionProvider<T> expansionProvider) {
        List<ExpansionProvider<T>> list = this.getExpansionProviders();
        this.fExpansionProviders.add(expansionProvider);
        this.fPropertySupport.firePropertyChange(EXPANSION_PROVIDERS_PROPERTY, list, this.getExpansionProviders());
    }

    public void removeExpansionProvider(ExpansionProvider<T> expansionProvider) {
        List<ExpansionProvider<T>> list = this.getExpansionProviders();
        this.fExpansionProviders.remove(expansionProvider);
        this.fPropertySupport.firePropertyChange(EXPANSION_PROVIDERS_PROPERTY, list, this.getExpansionProviders());
    }

    public List<GroupingTableColumn<T>> getAllColumnsInDefaultOrder() {
        return new ArrayList<GroupingTableColumn<T>>(this.fColumnsInDefaultOrder);
    }

    public List<GroupingTableColumn<T>> getAllColumns() {
        ArrayList<GroupingTableColumn<T>> arrayList = new ArrayList<GroupingTableColumn<T>>();
        for (ColumnConfiguration columnConfiguration : this.fColumns) {
            arrayList.add(columnConfiguration.getColumn());
        }
        return arrayList;
    }

    public GroupingTableColumn<T> getColumnByKey(String string) {
        for (GroupingTableColumn<T> groupingTableColumn : this.getAllColumns()) {
            if (!groupingTableColumn.getKey().equals(string)) continue;
            return groupingTableColumn;
        }
        return null;
    }

    public void moveColumn(GroupingTableColumn<T> groupingTableColumn, GroupingTableColumn<T> groupingTableColumn2, GroupingTableColumn<T> groupingTableColumn3) {
        int n;
        List<GroupingTableColumn<T>> list = this.getVisibleColumns();
        int n2 = list.indexOf(groupingTableColumn);
        int n3 = groupingTableColumn2 == null ? -1 : list.indexOf(groupingTableColumn2);
        int n4 = n = groupingTableColumn3 == null ? -1 : list.indexOf(groupingTableColumn3);
        if (n2 > -1 && n2 < this.fFixedPositionColumnCount - 1 || n3 > -1 && n3 < this.fFixedPositionColumnCount - 1 || n > -1 && n < this.fFixedPositionColumnCount - 1) {
            return;
        }
        List<GroupingTableColumn<T>> list2 = this.getAllColumns();
        int n5 = this.getAllColumns().indexOf(groupingTableColumn);
        ColumnConfiguration columnConfiguration = this.fColumns.get(n5);
        if (groupingTableColumn2 != null) {
            this.fColumns.remove(n5);
            int n6 = this.getAllColumns().indexOf(groupingTableColumn2);
            this.fColumns.add(n6 + 1, columnConfiguration);
        } else if (groupingTableColumn3 != null) {
            this.fColumns.remove(n5);
            int n7 = this.getAllColumns().indexOf(groupingTableColumn3);
            this.fColumns.add(n7, columnConfiguration);
        }
        this.generateVisibleColumnsCache();
        this.generateCellSpanCache();
        this.fPropertySupport.firePropertyChange(COLUMN_POSITIONS_PROPERTY, list2, this.getAllColumns());
    }

    public boolean isMainColumn(GroupingTableColumn<T> groupingTableColumn) {
        if (this.fMainColumn == null || groupingTableColumn == null) {
            return false;
        }
        if (this.fMainColumn.equals(groupingTableColumn)) {
            return true;
        }
        GroupingTableColumn<T> groupingTableColumn2 = this.getPairedColumn(this.getVisibleColumns().indexOf(groupingTableColumn));
        return groupingTableColumn2 != null && groupingTableColumn2.equals(this.fMainColumn);
    }

    public boolean isColumnVisible(GroupingTableColumn<T> groupingTableColumn) {
        return this.getVisibleColumns().contains(groupingTableColumn);
    }

    public GroupingTableColumn<T> getVisibleColumn(int n) {
        return this.getVisibleColumns().get(n);
    }

    public int getVisibleColumnCount() {
        return this.fCellSpanCache.length;
    }

    public List<GroupingTableColumn<T>> getVisibleColumns() {
        return this.fVisibleColumnsCache == null || this.fVisibleColumnsCache.size() < 1 ? new ArrayList<GroupingTableColumn<T>>(0) : Collections.unmodifiableList(this.fVisibleColumnsCache);
    }

    public void setColumnVisible(GroupingTableColumn<T> groupingTableColumn, boolean bl) {
        this.setColumnVisible(groupingTableColumn, bl, true);
    }

    public void setColumnVisible(GroupingTableColumn<T> groupingTableColumn, boolean bl, boolean bl2) {
        ColumnConfiguration columnConfiguration = this.findConfiguration(groupingTableColumn);
        List<GroupingTableColumn<T>> list = this.getVisibleColumns();
        int n = list.indexOf(groupingTableColumn);
        if (n >= 0 && !bl && n < this.fFixedPositionColumnCount) {
            return;
        }
        columnConfiguration.setVisible(bl);
        this.generateVisibleColumnsCache();
        this.generateCellSpanCache();
        List<GroupingTableColumn<T>> list2 = this.getVisibleColumns();
        if (bl2 && list2.size() > list.size()) {
            this.takeSpaceBackFromOtherColumns(groupingTableColumn);
        }
        this.fPropertySupport.firePropertyChange(VISIBLE_COLUMNS_PROPERTY, list, list2);
    }

    private void takeSpaceBackFromOtherColumns(GroupingTableColumn<T> groupingTableColumn) {
        Object object = null;
        List<GroupingTableColumn<T>> list = this.getVisibleColumns();
        ArrayList<GroupingTableColumn<T>> arrayList = new ArrayList<GroupingTableColumn<T>>();
        int n = 0;
        int n2 = 0;
        for (GroupingTableColumn<T> groupingTableColumn2 : list) {
            ColumnSize columnSize = this.getColumnSize(groupingTableColumn2);
            if (!columnSize.isConfigured() && !this.isVerticalAttributeColumn(groupingTableColumn)) {
                return;
            }
            if (groupingTableColumn2.equals(groupingTableColumn)) {
                if (columnSize.isFixed()) {
                    return;
                }
                object = columnSize;
                continue;
            }
            if (!columnSize.isFixed()) {
                arrayList.add(groupingTableColumn2);
            }
            n += columnSize.getSize();
            n2 = this.getScaledWidthEstimate(groupingTableColumn2);
        }
        if (object != null) {
            int n3;
            int n4 = list.indexOf(groupingTableColumn);
            int n5 = n3 = this.isVerticalAttributeColumn(groupingTableColumn) ? Math.max(n - n2, Math.max(10, this.getScaledWidthEstimate(groupingTableColumn))) : ((ColumnSize)object).getSize();
            if (n4 > 0) {
                for (GroupingTableColumn groupingTableColumn3 : arrayList) {
                    int n6 = this.getColumnSize(groupingTableColumn3).getSize();
                    int n7 = Math.min(n6 - 10, n3);
                    this.setColumnSize(groupingTableColumn3, false, n6 - n7, false);
                    if ((n3 -= n7) != 0) continue;
                    break;
                }
            }
        }
    }

    public Map<GroupingTableColumn<T>, ColumnSize> getAllColumnSizes() {
        LinkedHashMap<GroupingTableColumn<T>, ColumnSize> linkedHashMap = new LinkedHashMap<GroupingTableColumn<T>, ColumnSize>();
        for (ColumnConfiguration columnConfiguration : this.fColumns) {
            linkedHashMap.put(columnConfiguration.getColumn(), columnConfiguration.getSize());
        }
        return linkedHashMap;
    }

    public Map<GroupingTableColumn<T>, ColumnSize> getVisibleColumnSizes() {
        LinkedHashMap<GroupingTableColumn<T>, ColumnSize> linkedHashMap = new LinkedHashMap<GroupingTableColumn<T>, ColumnSize>();
        for (ColumnConfiguration columnConfiguration : this.fColumns) {
            if (!columnConfiguration.isVisible()) continue;
            linkedHashMap.put(columnConfiguration.getColumn(), columnConfiguration.getSize());
        }
        return linkedHashMap;
    }

    public void setFixedColumnSize(GroupingTableColumn<T> groupingTableColumn, int n) {
        this.setColumnSize(groupingTableColumn, true, n);
    }

    public void setIgnoreMinColWidth() {
        this.fIgnoreMinColWidth = true;
    }

    public boolean getIgnoreMinColWidth() {
        return this.fIgnoreMinColWidth;
    }

    public void setColumnSizes(Map<GroupingTableColumn<T>, Integer> map) {
        Map<GroupingTableColumn<T>, ColumnSize> map2 = this.getAllColumnSizes();
        Map<GroupingTableColumn<T>, ColumnSize> map3 = this.getVisibleColumnSizes();
        for (Map.Entry<GroupingTableColumn<T>, Integer> entry : map.entrySet()) {
            if (this.getColumnSize(entry.getKey()).isFixed()) continue;
            this.setColumnSize(entry.getKey(), false, entry.getValue(), false);
        }
        this.fPropertySupport.firePropertyChange(ALL_COLUMN_SIZES_PROPERTY, map2, this.getAllColumnSizes());
        this.fPropertySupport.firePropertyChange(VISIBLE_COLUMN_SIZES_PROPERTY, map3, this.getVisibleColumnSizes());
    }

    public void setColumnSizeIfNotFixed(GroupingTableColumn<T> groupingTableColumn, int n) {
        if (!this.getColumnSize(groupingTableColumn).isFixed()) {
            this.setColumnSize(groupingTableColumn, false, n);
        }
    }

    private void setColumnSize(GroupingTableColumn<T> groupingTableColumn, boolean bl, int n) {
        this.setColumnSize(groupingTableColumn, bl, n, true);
    }

    private void setColumnSize(GroupingTableColumn<T> groupingTableColumn, boolean bl, int n, boolean bl2) {
        ColumnConfiguration columnConfiguration = this.findConfiguration(groupingTableColumn);
        Map<GroupingTableColumn<T>, ColumnSize> map = this.getAllColumnSizes();
        Map<GroupingTableColumn<T>, ColumnSize> map2 = this.getVisibleColumnSizes();
        columnConfiguration.setSize(new ColumnSize(bl, n));
        if (bl2) {
            this.fPropertySupport.firePropertyChange(ALL_COLUMN_SIZES_PROPERTY, map, this.getAllColumnSizes());
            this.fPropertySupport.firePropertyChange(VISIBLE_COLUMN_SIZES_PROPERTY, map2, this.getVisibleColumnSizes());
        }
    }

    public void convertToColumn(VerticalAttribute<T> verticalAttribute, boolean bl) {
        GroupingTableColumn<T> groupingTableColumn = this.getColumnForVerticalAttribute(verticalAttribute);
        this.setVerticalAttributeVisible(verticalAttribute, false);
        this.setColumnVisible(groupingTableColumn, true, bl);
    }

    public void convertToVerticalAttribute(GroupingTableColumn<T> groupingTableColumn) {
        VerticalAttribute<T> verticalAttribute = this.getVerticalAttributeForColumn(groupingTableColumn);
        this.setColumnVisible(groupingTableColumn, false);
        this.setVerticalAttributeVisible(verticalAttribute, true);
    }

    public void setAverageWidthEstimate(String string, Integer n) {
        this.fAverageWidthEstimate.put(string, n);
    }

    public int getScaledWidthEstimate(GroupingTableColumn<T> groupingTableColumn) {
        Integer n = this.fAverageWidthEstimate.get(groupingTableColumn.getKey());
        if (n == null && this.findConfiguration(groupingTableColumn).getSize().isFixed()) {
            return this.findConfiguration(groupingTableColumn).getSize().getSize();
        }
        if (n == null && this.isVerticalAttributeColumn(groupingTableColumn)) {
            return this.getScaledWidthEstimate(this.getVerticalAttributeForColumn(groupingTableColumn));
        }
        return this.scaleWidthEstimate(n);
    }

    public int getScaledWidthEstimate(VerticalAttribute<T> verticalAttribute) {
        Integer n = this.fAverageWidthEstimate.get(verticalAttribute.getKey());
        return this.scaleWidthEstimate(n);
    }

    public void setWidthEstimateScaleFactor(double d) {
        this.fWidthEstimateScaleFactor = d;
    }

    private int scaleWidthEstimate(Integer n) {
        return n == null ? 0 : (int)(this.fWidthEstimateScaleFactor * (double)n.intValue());
    }

    private GroupingTableColumn<T> createVerticalAttributeColumn(final VerticalAttribute<T> verticalAttribute) {
        return new GroupingTableColumn(VERTICAL_ATTRIBUTE_COLUMN_PREFIX + verticalAttribute.getKey(), verticalAttribute.getName(), true, new Converter<T, String>(){

            public String convert(T t) {
                return verticalAttribute.getText(t);
            }
        });
    }

    public GroupingTableColumn<T> getColumnForVerticalAttribute(VerticalAttribute<T> verticalAttribute) {
        if (!verticalAttribute.shouldShowInColumnWhenWide()) {
            throw new IllegalArgumentException("Vertical attribute " + verticalAttribute.getKey() + " cannot be shown as a column");
        }
        for (GroupingTableColumn<T> groupingTableColumn : this.getAllColumns()) {
            if (!groupingTableColumn.getKey().equals(VERTICAL_ATTRIBUTE_COLUMN_PREFIX + verticalAttribute.getKey())) continue;
            return groupingTableColumn;
        }
        return null;
    }

    public VerticalAttribute<T> getVerticalAttributeForColumn(GroupingTableColumn<T> groupingTableColumn) {
        if (!groupingTableColumn.getKey().startsWith(VERTICAL_ATTRIBUTE_COLUMN_PREFIX)) {
            throw new IllegalArgumentException("Column " + groupingTableColumn.getKey() + " does not represent a vertical attribute");
        }
        for (VerticalAttribute<T> verticalAttribute : this.getAllVerticalAttributes()) {
            if (!verticalAttribute.getKey().equals(groupingTableColumn.getKey().substring(VERTICAL_ATTRIBUTE_COLUMN_PREFIX.length()))) continue;
            return verticalAttribute;
        }
        return null;
    }

    public boolean isVerticalAttributeColumn(GroupingTableColumn<T> groupingTableColumn) {
        return groupingTableColumn.getKey().startsWith(VERTICAL_ATTRIBUTE_COLUMN_PREFIX);
    }

    public ColumnSize getColumnSize(GroupingTableColumn<T> groupingTableColumn) {
        return this.getAllColumnSizes().get(groupingTableColumn);
    }

    public boolean isGroupExpanded(Group<T> group) {
        return this.fExpandedGroups.contains(group);
    }

    public boolean isGroupCollapsed(Group<T> group) {
        return this.fCollapsedGroups.contains(group);
    }

    public Set<Group<T>> getExpandedGroups() {
        return this.fExpandedGroups;
    }

    public Set<Group<T>> getCollapsedGroups() {
        return this.fCollapsedGroups;
    }

    public List<VerticalAttribute<T>> getAllVerticalAttributes() {
        return new ArrayList<VerticalAttribute<T>>(this.fAllVerticalAttributes);
    }

    public int getVisibleVerticalAttributeCount() {
        return this.fVisibleVerticalAttributes.size();
    }

    public List<VerticalAttribute<T>> getVisibleVerticalAttributes() {
        ArrayList<VerticalAttribute<T>> arrayList = new ArrayList<VerticalAttribute<T>>();
        for (VerticalAttribute<T> verticalAttribute : this.getAllVerticalAttributes()) {
            if (!this.fVisibleVerticalAttributes.contains(verticalAttribute)) continue;
            arrayList.add(verticalAttribute);
        }
        return arrayList;
    }

    public boolean isVerticalAttributeOrColumnVisible(VerticalAttribute<T> verticalAttribute) {
        return this.fVisibleVerticalAttributes.contains(verticalAttribute) || verticalAttribute.shouldShowInColumnWhenWide() && this.isColumnVisible(this.getColumnForVerticalAttribute(verticalAttribute));
    }

    public void setVerticalAttributeVisible(VerticalAttribute<T> verticalAttribute, boolean bl) {
        if (!this.getAllVerticalAttributes().contains(verticalAttribute)) {
            throw new IllegalArgumentException("Unknown vertical attribute: " + verticalAttribute);
        }
        if (!bl && !this.fVisibleVerticalAttributes.contains(verticalAttribute) && verticalAttribute.shouldShowInColumnWhenWide()) {
            GroupingTableColumn<T> groupingTableColumn = this.getColumnForVerticalAttribute(verticalAttribute);
            if (this.isColumnVisible(groupingTableColumn)) {
                this.setColumnVisible(groupingTableColumn, false);
            }
            return;
        }
        List<VerticalAttribute<T>> list = this.getVisibleVerticalAttributes();
        if (bl) {
            this.fVisibleVerticalAttributes.add(verticalAttribute);
            verticalAttribute.addDisplayChangeListener((ChangeListener)this.fVerticalAttributeDisplayChangeListener);
        } else {
            this.fVisibleVerticalAttributes.remove(verticalAttribute);
            verticalAttribute.removeDisplayChangeListener((ChangeListener)this.fVerticalAttributeDisplayChangeListener);
        }
        List<VerticalAttribute<T>> list2 = this.getVisibleVerticalAttributes();
        this.fPropertySupport.firePropertyChange(VISIBLE_VERTICAL_ATTRIBUTES_PROPERTY, list, list2);
    }

    public void addVerticalAttributeDisplayChangeListener(ChangeListener changeListener) {
        this.fVerticalAttributeDisplayChangeListener.addChangeListener(changeListener);
    }

    public void removeVerticalAttributeDisplayChangeListener(ChangeListener changeListener) {
        this.fVerticalAttributeDisplayChangeListener.removeChangeListener(changeListener);
    }

    public void addAffordance(Affordance<T> affordance) {
        List<Affordance<T>> list = this.getAffordances();
        this.fAffordances.add(affordance);
        this.fPropertySupport.firePropertyChange(AFFORDANCES_PROPERTY, list, this.getAffordances());
    }

    public void removeAffordance(Affordance<T> affordance) {
        List<Affordance<T>> list = this.getAffordances();
        this.fAffordances.remove(affordance);
        this.fPropertySupport.firePropertyChange(AFFORDANCES_PROPERTY, list, this.getAffordances());
    }

    public List<Affordance<T>> getAffordances() {
        return new ArrayList<Affordance<T>>(this.fAffordances);
    }

    public void clearExpanded() {
        this.fExpandedGroups.clear();
    }

    public void addCollapsed() {
        this.fCollapsedGroups.addAll(this.fExpandedGroups);
    }

    public void setExpanded(Group<T> group, boolean bl) {
        Set<Group<T>> set = bl ? this.fCollapsedGroups : this.fExpandedGroups;
        Set<Group<T>> set2 = bl ? this.fExpandedGroups : this.fCollapsedGroups;
        Set<Group<T>> set3 = this.getCollapsedGroups();
        Set<Group<T>> set4 = this.getExpandedGroups();
        set2.add(group);
        set.remove(group);
        this.fPropertySupport.firePropertyChange(EXPANDED_GROUPS_PROPERTY, set4, this.getExpandedGroups());
        this.fPropertySupport.firePropertyChange(COLLAPSED_GROUPS_PROPERTY, set3, this.getCollapsedGroups());
    }

    public void setExpanded(T t, boolean bl) {
        if (!bl) {
            this.fExpandedItems.remove(t);
        } else {
            this.fExpandedItems.add(t);
        }
    }

    public void collapseAllGroups() {
        Set<Group<T>> set = this.getExpandedGroups();
        Set<Group<T>> set2 = this.getCollapsedGroups();
        this.fCollapsedGroups.addAll(this.fExpandedGroups);
        this.fExpandedGroups.clear();
        this.fPropertySupport.firePropertyChange(EXPANDED_GROUPS_PROPERTY, set, this.getExpandedGroups());
        this.fPropertySupport.firePropertyChange(COLLAPSED_GROUPS_PROPERTY, set2, this.getCollapsedGroups());
    }

    public void expandAllGroups() {
        Set<Group<T>> set = this.getExpandedGroups();
        Set<Group<T>> set2 = this.getCollapsedGroups();
        this.fExpandedGroups.addAll(this.fCollapsedGroups);
        this.fCollapsedGroups.clear();
        this.fPropertySupport.firePropertyChange(EXPANDED_GROUPS_PROPERTY, set, this.getExpandedGroups());
        this.fPropertySupport.firePropertyChange(COLLAPSED_GROUPS_PROPERTY, set2, this.getCollapsedGroups());
    }

    public boolean isExpanded(T t) {
        return this.fExpandedItems.contains(t);
    }

    public Set<T> getExpandedItems() {
        HashSet<Object> hashSet = new HashSet<Object>();
        hashSet.addAll(Arrays.asList(this.fExpandedItems.toArray(null)));
        return hashSet;
    }

    public boolean hasAnythingExpanded() {
        return this.fExpandedItems.size() > 0 || !this.fExpandedGroups.isEmpty();
    }

    public GroupingTableColumn<T> getGroupColumn() {
        return this.fGroupColumn;
    }

    public boolean isCurrentGroupMode(GroupingTableColumn<T> groupingTableColumn, GroupingMode<T> groupingMode) {
        return groupingTableColumn == null && groupingMode == null && this.fGroupMode == null && this.fGroupColumn == null || this.fGroupMode != null && this.fGroupColumn != null && this.fGroupColumn.equals(groupingTableColumn) && this.fGroupMode.equals(groupingMode);
    }

    public GroupingMode<T> getGroupMode() {
        return this.fGroupMode;
    }

    public void ungroup() {
        this.setGroupMode(null, null);
    }

    public void setGroupMode(final GroupingTableColumn<T> groupingTableColumn, final GroupingMode<T> groupingMode) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GroupingTableConfiguration.this.fGroupingWillChangeListener.stateChanged(new ChangeEvent(GroupingTableConfiguration.this));
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        GroupingMode groupingMode = GroupingTableConfiguration.this.getGroupMode();
                        GroupingTableConfiguration.this.fGroupMode = groupingMode;
                        GroupingTableConfiguration.this.fGroupColumn = groupingTableColumn;
                        GroupingTableConfiguration.this.fPropertySupport.firePropertyChange(GroupingTableConfiguration.GROUP_MODE_PROPERTY, groupingMode, GroupingTableConfiguration.this.fGroupMode);
                    }
                });
            }
        });
    }

    public GroupingTableColumn<T> getSortColumn() {
        return this.fSortColumn;
    }

    public int getSortColumnIndex() {
        GroupingTableColumn<T> groupingTableColumn = this.getSortColumn();
        return groupingTableColumn == null ? -1 : this.getVisibleColumns().indexOf(groupingTableColumn);
    }

    public boolean isSortedDescending() {
        return this.fSortDescending;
    }

    public Comparator<T> getAscendingSortComparator() {
        return new Comparator<T>(){

            @Override
            public int compare(T t, T t2) {
                int n;
                if (GroupingTableConfiguration.this.fPreSorter != null && (n = GroupingTableConfiguration.this.fPreSorter.compare(t, t2)) != 0) {
                    return n;
                }
                GroupingTableColumn groupingTableColumn = GroupingTableConfiguration.this.getSortColumn();
                if (groupingTableColumn == null) {
                    groupingTableColumn = GroupingTableConfiguration.this.getVisibleColumns().get(0);
                }
                return groupingTableColumn.getComparator().compare(t, t2);
            }
        };
    }

    public void setPreSorter(Comparator<T> comparator) {
        Comparator<T> comparator2 = this.fPreSorter;
        this.fPreSorter = comparator;
        this.fPropertySupport.firePropertyChange(PRE_SORTER_PROPERTY, comparator2, this.fPreSorter);
    }

    public void setSortColumnOrToggleDirection(GroupingTableColumn<T> groupingTableColumn) {
        this.setSortColumnAndDescending(groupingTableColumn, this.fSortColumn != null && groupingTableColumn != null && this.fSortColumn.equals(groupingTableColumn) && !this.fSortDescending);
    }

    public void setSortColumnAndDescending(GroupingTableColumn<T> groupingTableColumn, boolean bl) {
        GroupingTableColumn<T> groupingTableColumn2 = this.getSortColumn();
        boolean bl2 = this.isSortedDescending();
        this.fSortColumn = groupingTableColumn;
        this.fPropertySupport.firePropertyChange(SORT_COLUMN_PROPERTY, groupingTableColumn2, this.fSortColumn);
        this.fSortDescending = bl;
        this.fPropertySupport.firePropertyChange(SORT_DESCENDING_PROPERTY, bl2, this.fSortDescending);
    }

    public GroupingTableColumn<T> getPairedColumn(int n) {
        GroupingTableColumn<T> groupingTableColumn = this.getVisibleColumns().get(n);
        GroupingTablePair<T> groupingTablePair = this.getPair(groupingTableColumn);
        if (groupingTablePair != null) {
            return groupingTablePair.getFirstColumn().equals(groupingTableColumn) ? groupingTablePair.getSecondColumn() : groupingTablePair.getFirstColumn();
        }
        return null;
    }

    public GroupingTablePair<T> getPair(int n) {
        return this.getPair(this.getVisibleColumns().get(n));
    }

    public GroupingTablePair<T> getPair(GroupingTableColumn<T> groupingTableColumn) {
        GroupingTableColumn<T> groupingTableColumn2;
        List<GroupingTableColumn<T>> list = this.getVisibleColumns();
        int n = list.indexOf(groupingTableColumn);
        if (n == -1) {
            return null;
        }
        if (n < list.size() - 1) {
            groupingTableColumn2 = list.get(n + 1);
            for (GroupingTablePair<T> groupingTablePair : this.fPairs) {
                if (!groupingTablePair.matches(groupingTableColumn, groupingTableColumn2)) continue;
                return groupingTablePair;
            }
        }
        if (n > 0 && list.size() > 1) {
            groupingTableColumn2 = list.get(n - 1);
            for (GroupingTablePair<T> groupingTablePair : this.fPairs) {
                if (!groupingTablePair.matches(groupingTableColumn2, groupingTableColumn)) continue;
                return groupingTablePair;
            }
        }
        return null;
    }

    public CellSpan getCellSpan(int n, int n2) {
        if (n2 < 0 || n2 >= this.fCellSpanCache.length) {
            return new GroupingTableCellSpan(n, n2, 1);
        }
        return new GroupingTableCellSpan(n, this.fCellSpanCache[n2].getColumn(), this.fCellSpanCache[n2].getColumnSpan());
    }

    private void generateVisibleColumnsCache() {
        this.fVisibleColumnsCache = new ArrayList<GroupingTableColumn<T>>();
        for (ColumnConfiguration columnConfiguration : this.fColumns) {
            if (!columnConfiguration.isVisible()) continue;
            this.fVisibleColumnsCache.add(columnConfiguration.getColumn());
        }
    }

    private void generateCellSpanCache() {
        List<GroupingTableColumn<T>> list = this.getVisibleColumns();
        this.fCellSpanCache = new CellSpan[list.size()];
        for (int i = 0; i < list.size(); ++i) {
            GroupingTableColumn<T> groupingTableColumn = list.get(i);
            GroupingTablePair<T> groupingTablePair = this.getPair(groupingTableColumn);
            if (groupingTablePair != null) {
                if (groupingTablePair.getFirstColumn().equals(groupingTableColumn)) {
                    this.fCellSpanCache[i] = new GroupingTableCellSpan(0, i, 2);
                    continue;
                }
                this.fCellSpanCache[i] = new GroupingTableCellSpan(0, i - 1, 2);
                continue;
            }
            this.fCellSpanCache[i] = new GroupingTableCellSpan(0, i, 1);
        }
    }

    public void setColumnDisplayOrder(List<GroupingTableColumn<T>> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (GroupingTableColumn<T> groupingTableColumn : list) {
            arrayList.add(groupingTableColumn.getKey());
        }
        this.setColumnDisplayOrderByKeys(arrayList);
    }

    public void setColumnDisplayOrderByKeys(final List<String> list) {
        Object object;
        block0: for (int i = 0; i < list.size(); ++i) {
            object = list.get(i);
            for (VerticalAttribute<T> verticalAttribute : this.getAllVerticalAttributes()) {
                if (!verticalAttribute.shouldShowInColumnWhenWide() || !verticalAttribute.getKey().equals(object)) continue;
                list.set(i, VERTICAL_ATTRIBUTE_COLUMN_PREFIX + (String)object);
                continue block0;
            }
        }
        final List<GroupingTableColumn<T>> list2 = this.getAllColumns();
        object = this.getVisibleColumns();
        Collections.sort(this.fColumns, new Comparator<ColumnConfiguration>(){

            @Override
            public int compare(ColumnConfiguration columnConfiguration, ColumnConfiguration columnConfiguration2) {
                int n = list.indexOf(columnConfiguration.getColumn().getKey());
                int n2 = list.indexOf(columnConfiguration2.getColumn().getKey());
                if (n < 0) {
                    n = -list2.indexOf(columnConfiguration.getColumn());
                }
                if (n2 < 0) {
                    n2 = -list2.indexOf(columnConfiguration2.getColumn());
                }
                return n - n2;
            }
        });
        List<GroupingTableColumn<T>> list3 = this.getAllColumns();
        for (int i = 0; i < Math.min(list2.size(), this.fFixedPositionColumnCount); ++i) {
            int n = list3.indexOf(list2.get(i));
            Collections.swap(this.fColumns, i, n);
        }
        this.fPropertySupport.firePropertyChange(ALL_COLUMNS_PROPERTY, list2, this.getAllColumns());
        this.fPropertySupport.firePropertyChange(VISIBLE_COLUMNS_PROPERTY, object, this.getVisibleColumns());
        this.generateVisibleColumnsCache();
    }

    private ColumnConfiguration findConfiguration(GroupingTableColumn<T> groupingTableColumn) {
        for (ColumnConfiguration columnConfiguration : this.fColumns) {
            if (!columnConfiguration.getColumn().equals(groupingTableColumn)) continue;
            return columnConfiguration;
        }
        throw new IllegalArgumentException("Column not supported by this configuration: " + groupingTableColumn.getKey());
    }

    private class ColumnConfiguration {
        private final GroupingTableColumn<T> fColumn;
        private boolean fVisible;
        private ColumnSize fSize;

        ColumnConfiguration(GroupingTableColumn<T> groupingTableColumn) {
            this.fColumn = groupingTableColumn;
            this.fVisible = true;
            this.fSize = new ColumnSize();
        }

        GroupingTableColumn<T> getColumn() {
            return this.fColumn;
        }

        void setSize(ColumnSize columnSize) {
            this.fSize = columnSize;
        }

        ColumnSize getSize() {
            return this.fSize;
        }

        void setVisible(boolean bl) {
            this.fVisible = bl;
        }

        boolean isVisible() {
            return this.fVisible;
        }
    }

    public static class ColumnSize {
        private final boolean fFixed;
        private final boolean fConfigured;
        private final int fSize;

        public ColumnSize() {
            this.fFixed = false;
            this.fSize = 0;
            this.fConfigured = false;
        }

        public ColumnSize(boolean bl, int n) {
            this.fFixed = bl;
            this.fSize = n;
            this.fConfigured = true;
        }

        public boolean isConfigured() {
            return this.fConfigured;
        }

        public boolean isFixed() {
            return this.fFixed;
        }

        public int getSize() {
            if (!this.fConfigured) {
                throw new IllegalStateException("The size of this column is not currently configured; a default sizing should be used.");
            }
            return this.fSize;
        }

        public boolean equals(Object object) {
            return object instanceof ColumnSize && ((ColumnSize)object).isFixed() == this.isFixed() && ((ColumnSize)object).isConfigured() == this.isConfigured() && ((ColumnSize)object).fSize == this.fSize;
        }
    }
}

