/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.recordlist;

import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.CellViewer;
import com.mathworks.mwswing.DefaultSortableTable;
import com.mathworks.mwswing.ExtendedInputMap;
import com.mathworks.mwswing.IconUtils;
import com.mathworks.mwswing.MInputMap;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJCheckBoxMenuItem;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.TableCell;
import com.mathworks.mwswing.table.ListColorUtils;
import com.mathworks.services.Prefs;
import com.mathworks.util.ArrayUtils;
import com.mathworks.util.PlatformInfo;
import com.mathworks.widgets.recordlist.ActionUtils;
import com.mathworks.widgets.recordlist.DefaultNoSelectionPopupMenu;
import com.mathworks.widgets.recordlist.DefaultSelectionPopupMenu;
import com.mathworks.widgets.recordlist.FullRLTCellRenderer;
import com.mathworks.widgets.recordlist.IActionProvider;
import com.mathworks.widgets.recordlist.ICopyingObserver;
import com.mathworks.widgets.recordlist.ICreationObserver;
import com.mathworks.widgets.recordlist.IDeletionObserver;
import com.mathworks.widgets.recordlist.IDuplicationObserver;
import com.mathworks.widgets.recordlist.IEditingObserver;
import com.mathworks.widgets.recordlist.IOpeningObserver;
import com.mathworks.widgets.recordlist.IRecordContainer;
import com.mathworks.widgets.recordlist.IRecordFilter;
import com.mathworks.widgets.recordlist.IRecordIconProvider;
import com.mathworks.widgets.recordlist.IRecordSecondaryIconProvider;
import com.mathworks.widgets.recordlist.IRecordValueMutator;
import com.mathworks.widgets.recordlist.IRecordlistFieldConfig;
import com.mathworks.widgets.recordlist.IRecordlistModel;
import com.mathworks.widgets.recordlist.IRecordlistMutator;
import com.mathworks.widgets.recordlist.InternalActionHelper;
import com.mathworks.widgets.recordlist.ObserverAdapter;
import com.mathworks.widgets.recordlist.PrintingRLTCellRenderer;
import com.mathworks.widgets.recordlist.RecordlistResources;
import com.mathworks.widgets.recordlist.RecordlistSelectionTracker;
import com.mathworks.widgets.recordlist.RecordlistTableModel;
import com.mathworks.widgets.spreadsheet.IUndoOpProvider;
import com.mathworks.widgets.spreadsheet.UndoActionFactory;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;
import com.mathworks.widgets.spreadsheet.format.Formatter;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.DefaultListSelectionModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;

public class RecordlistTable
extends DefaultSortableTable
implements IRecordContainer,
IRecordlistFieldConfig,
IRecordlistMutator,
IRecordValueMutator,
IActionProvider,
IUndoOpProvider {
    protected RecordlistTableModel fRLTM = null;
    protected MJAbstractAction fCopyingAction = null;
    protected MJAbstractAction fCreationAction = null;
    protected MJAbstractAction fRefreshAction = null;
    protected MJAbstractAction fDeletionAction = null;
    protected MJAbstractAction fDuplicationAction = null;
    protected MJAbstractAction fOpeningAction = null;
    protected MJAbstractAction fSelectAllAction = null;
    protected MJAbstractAction fDefaultAction = null;
    private EditingAction[] fEditingActions = null;
    private MJAbstractAction fUndoAction = null;
    private MJAbstractAction fRedoAction = null;
    private boolean[] fColumnHidden = null;
    private TableColumn[] fTableColumns = null;
    private MJPopupMenu fSelectionPopupMenu = null;
    private MJPopupMenu fNoSelectionPopupMenu = null;
    private MJPopupMenu fHeaderPopupMenu = null;
    private boolean fInUpdate = false;
    private boolean fRowHeightSetWithGraphics = false;
    private MouseListener fEmptyHeaderMouseListener = null;
    private static final boolean USE_HEADER_CONTEXT_MENUS = PlatformInfo.isWindows();
    private static final String RELEASE_EXTENSION = "B2_";
    private static Timer sEditingTimer = null;
    protected static final String PREF_HIDDEN_COLUMNS = "RLHiddenB2_";
    protected static final String PREF_WIDTH_COLUMNS = "RLWidthB2_";
    protected static final String PREF_ORDER_COLUMNS = "RLOrderB2_";
    protected static final String PREF_PREVIOUSLY_INITIALIZED = "RLPrevInitB2_";
    protected String fPrefKey = null;
    protected RecordlistSelectionTracker fRLST = null;
    protected boolean[] fEditableColumnIsCurrentlyEditable = ArrayUtils.EmptyPrimitives.BOOLEAN;
    private static final TableCellEditor[] ETCE = new TableCellEditor[0];
    protected TableCellEditor[] fFieldEditors = ETCE;
    private int[] fLastSelectedRows = EIntA;
    private int fLastAnchorColumn = -2;
    private Date fLastDateSelectionChanged = new Date();
    private int fCurrentlyEditingRow = -1;
    private int fCurrentlyEditingCol = -1;
    private IRecordIconProvider fRIP = null;
    private IRecordSecondaryIconProvider fRSIP = null;
    private boolean fIsPrimaryFocusOwner;
    private List<Integer> fSelectionList = null;
    private boolean fFullCellSelection;
    private transient List<ChangeListener> fChronSelectionListeners = null;
    private MJLabel fCellPainter;
    private static final Formatter sEditingFormatter = FormatIdentifier.getDefaultInstance().getEditorIdentifier().getFormatter();
    private static final MJCheckBoxMenuItem[] EMJCMIA = new MJCheckBoxMenuItem[0];
    private static final int[] EIntA = new int[0];
    private final MInputMap fInputMap;
    private final InternalActionHelper fActionHelper;
    private boolean fAutoSaveColumnPrefs = false;
    private final ColumnPrefsListener fColumnPrefsListener = new ColumnPrefsListener();
    private boolean fColumnPrefsListenerAdded = false;
    private SelectionRecorder fRowSelectionRecorder;

    public RecordlistTable(IRecordlistModel iRecordlistModel) {
        this(new RecordlistTableModel(iRecordlistModel), null);
    }

    public RecordlistTable(IRecordlistModel iRecordlistModel, String string) {
        this(new RecordlistTableModel(iRecordlistModel), string);
    }

    public RecordlistTable(RecordlistTableModel recordlistTableModel) {
        this(recordlistTableModel, null);
    }

    public RecordlistTable(RecordlistTableModel recordlistTableModel, String string) {
        super((TableModel)recordlistTableModel);
        this.fInputMap = ActionUtils.createMInputMap((JComponent)((Object)this));
        this.fActionHelper = new ActionHelper();
        this.setFullCellSelection(false);
        this.fRLTM = recordlistTableModel;
        this.fRLST = new RecordlistSelectionTracker();
        this.setCellSelectionEnabled(true);
        this.setFillEmptyColumnHeader(true);
        this.fRowSelectionRecorder = new SelectionRecorder();
        this.getSelectionModel().addListSelectionListener(this.fRowSelectionRecorder);
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel(){

            @Override
            public void removeSelectionInterval(int n, int n2) {
                if (n < 0 || n != n2 || RecordlistTable.this.getSelectedRowCount() < 1) {
                    super.removeSelectionInterval(n, n2);
                }
            }
        };
        this.getColumnModel().setSelectionModel(defaultListSelectionModel);
        defaultListSelectionModel.addListSelectionListener(new ColumnSelectionRecorder());
        if (this.fRLTM.isRecordIconProvider()) {
            this.fRIP = this.fRLTM;
            this.setRowHeight(17);
            if (this.fRLTM.isRecordSecondaryIconProvider()) {
                this.fRSIP = this.fRLTM;
            }
        }
        this.initCellPainter();
        this.setDefaultRenderer(Object.class, new FullRLTCellRenderer(2, this.fRIP, this.fRSIP));
        this.setDefaultRenderer(Number.class, new FullRLTCellRenderer(4, this.fRIP, this.fRSIP));
        this.setDefaultEditor(Object.class, new FieldEditor((JTextField)new MJTextField()));
        this.setDefaultEditor(Number.class, new FieldEditor((JTextField)new MJTextField()));
        this.fPrefKey = string;
        this.setAutoResizeMode(0);
        this.setCellViewerEnabled(true);
        this.setRightSelectionEnabled(true);
        this.fColumnHidden = new boolean[this.getFieldCount()];
        this.fTableColumns = new TableColumn[this.getFieldCount()];
        this.fHeaderPopupMenu = new HeaderPopupMenu(this.getShowHideMenuItems());
        this.createActions();
        this.loadPrefs();
        this.fRLTM.setPrivateDeletionObserver(new ObserverAdapter(this.fRLTM));
        this.fSelectionPopupMenu = new DefaultSelectionPopupMenu(this);
        this.fNoSelectionPopupMenu = new DefaultNoSelectionPopupMenu(this);
        this.addMouseListener(new MouseL());
        if (USE_HEADER_CONTEXT_MENUS) {
            this.getTableHeader().addMouseListener(new HeaderListener());
        }
        Prefs.setBooleanPref((String)(PREF_PREVIOUSLY_INITIALIZED + this.fPrefKey), (boolean)true);
        this.setHasAppearanceFocus(true);
        AppearanceFocusDispatcher appearanceFocusDispatcher = new AppearanceFocusDispatcher();
        appearanceFocusDispatcher.addAppearanceFocusListener((AppearanceFocusListener)new AppFocusL());
        this.addFocusListener((FocusListener)appearanceFocusDispatcher);
        ListColorUtils.setupForList((JTable)((Object)this));
    }

    private static void setInitialHiddenColumns(String string, int[] nArray) {
        if (!Prefs.exists((String)(PREF_PREVIOUSLY_INITIALIZED + string))) {
            int n = 0;
            for (int n2 : nArray) {
                n += 2 << n2;
            }
            Prefs.setIntegerPref((String)(PREF_HIDDEN_COLUMNS + string), (int)n);
        }
    }

    public static void setInitialShownColumns(String string, int[] nArray, int n) {
        RecordlistTable.setInitialHiddenColumns(string, RecordlistTable.getColsToHideFromColsToShow(nArray, n));
    }

    public static void setInitialShownColumnWidths(String string, int[] nArray) {
        if (!Prefs.exists((String)(PREF_PREVIOUSLY_INITIALIZED + string))) {
            for (int i = 0; i < nArray.length; ++i) {
                RecordlistTable.setColumnWidthPref(string, i, nArray[i]);
            }
        }
    }

    private static int[] getColsToHideFromColsToShow(int[] nArray, int n) {
        int[] nArray2 = new int[n - nArray.length];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            boolean bl = false;
            for (int n3 : nArray) {
                if (i != n3) continue;
                bl = true;
            }
            if (bl) continue;
            nArray2[n2++] = i;
        }
        return nArray2;
    }

    private static int getColumnWidthPref(String string, int n, int n2) {
        return Prefs.getIntegerPref((String)(PREF_WIDTH_COLUMNS + string + '_' + n), (int)n2);
    }

    private static void setColumnWidthPref(String string, int n, int n2) {
        Prefs.setIntegerPref((String)(PREF_WIDTH_COLUMNS + string + '_' + n), (int)n2);
    }

    protected void loadPrefs() {
        if (this.fPrefKey != null) {
            int n;
            Object object;
            int n2 = Prefs.getIntegerPref((String)(PREF_HIDDEN_COLUMNS + this.fPrefKey), (int)0);
            int n3 = 1;
            for (int i = 0; i < 30 && n3 < n2; ++i) {
                if (((n3 <<= 1) & n2) != n3) continue;
                this.hideField(i);
            }
            if (Prefs.exists((String)(PREF_ORDER_COLUMNS + this.fPrefKey))) {
                object = RecordlistTable.decodeColumnMap(Prefs.getStringPref((String)(PREF_ORDER_COLUMNS + this.fPrefKey)));
                TableColumn[] tableColumnArray = this.getColumnsInModel();
                try {
                    for (n = 0; n < ((Object)object).length; ++n) {
                        TableColumn tableColumn = tableColumnArray[object[n]];
                        TableColumn[] tableColumnArray2 = this.getColumnsInView();
                        for (int i = 0; i < tableColumnArray2.length; ++i) {
                            tableColumnArray2 = this.getColumnsInView();
                            if (!tableColumnArray2[i].equals(tableColumn)) continue;
                            this.moveColumn(i, n);
                        }
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            object = this.getColumnModel();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                n = RecordlistTable.getColumnWidthPref(this.fPrefKey, i, 130);
                object.getColumn(i).setPreferredWidth(n);
            }
            this.sizeColumnsToFit(-1);
        }
    }

    public void useStandardRenderers() {
        this.setDefaultRenderer(Object.class, new FullRLTCellRenderer(2, this.fRIP, this.fRSIP));
        this.setDefaultRenderer(Number.class, new FullRLTCellRenderer(4, this.fRIP, this.fRSIP));
    }

    public void usePrintingRenderers() {
        this.setDefaultRenderer(Object.class, new PrintingRLTCellRenderer(2, this.fRIP));
        this.setDefaultRenderer(Number.class, new PrintingRLTCellRenderer(4, this.fRIP));
    }

    public void savePrefs() {
        if (this.fPrefKey != null) {
            int n = 0;
            for (int i = 0; i < this.fColumnHidden.length; ++i) {
                if (!this.fColumnHidden[i]) continue;
                n += 2 << i;
            }
            Prefs.setIntegerPref((String)(PREF_HIDDEN_COLUMNS + this.fPrefKey), (int)n);
            TableColumnModel tableColumnModel = this.getColumnModel();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                RecordlistTable.setColumnWidthPref(this.fPrefKey, i, tableColumnModel.getColumn(i).getWidth());
            }
            TableColumn[] tableColumnArray = this.getColumnsInModel();
            TableColumn[] tableColumnArray2 = this.getColumnsInView();
            int[] nArray = new int[tableColumnArray.length];
            for (int i = 0; i < tableColumnArray.length; ++i) {
                for (int j = 0; j < tableColumnArray.length; ++j) {
                    if (tableColumnArray[i] != tableColumnArray2[j]) continue;
                    nArray[j] = i;
                }
            }
            Prefs.setStringPref((String)(PREF_ORDER_COLUMNS + this.fPrefKey), (String)RecordlistTable.encodeColumnMap(nArray));
        }
    }

    private static String encodeColumnMap(int[] nArray) {
        StringBuilder stringBuilder = new StringBuilder(nArray.length * 2);
        for (int n : nArray) {
            stringBuilder.append(n).append(':');
        }
        return stringBuilder.toString();
    }

    private static int[] decodeColumnMap(String string) {
        String[] stringArray = string.split(":");
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = Integer.parseInt(stringArray[i]);
        }
        return nArray;
    }

    private TableColumn[] getColumnsInModel() {
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        ArrayList<TableColumn> arrayList = new ArrayList<TableColumn>(1);
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        Collections.sort(arrayList, new Comparator<TableColumn>(){

            @Override
            public int compare(TableColumn tableColumn, TableColumn tableColumn2) {
                if (tableColumn.getModelIndex() < tableColumn2.getModelIndex()) {
                    return -1;
                }
                if (tableColumn.getModelIndex() == tableColumn2.getModelIndex()) {
                    return 0;
                }
                return 1;
            }
        });
        return arrayList.toArray(new TableColumn[arrayList.size()]);
    }

    private TableColumn[] getColumnsInView() {
        TableColumn[] tableColumnArray = new TableColumn[this.getColumnCount()];
        Enumeration<TableColumn> enumeration = this.getColumnModel().getColumns();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            tableColumnArray[n] = enumeration.nextElement();
            ++n;
        }
        for (int i = 0; i < this.getColumnCount(); ++i) {
            tableColumnArray[i] = this.getColumnModel().getColumn(i);
        }
        return tableColumnArray;
    }

    @Override
    public int getRecordCount() {
        return this.fRLTM.getRowCount();
    }

    @Override
    public int getFieldCount() {
        return this.fRLTM.getColumnCount();
    }

    @Override
    public String getFieldName(int n) {
        return this.fRLTM.getColumnName(n);
    }

    @Override
    public Class getFieldClass(int n) {
        return this.fRLTM.getColumnClass(n);
    }

    public int getPrimaryFieldIndex() {
        return this.fRLTM.getPrimaryFieldIndex();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paint(Graphics graphics) {
        Object object = this.fRLTM.getSemaphore();
        synchronized (object) {
            super.paint(graphics);
        }
    }

    public void setFont(Font font) {
        super.setFont(font);
        if (this.fCellPainter != null) {
            this.fCellPainter.setFont(font);
        }
        this.setTableRowHeight();
    }

    public void doLayout() {
        if (!this.fRowHeightSetWithGraphics) {
            this.setTableRowHeight();
        }
        super.doLayout();
    }

    private void setTableRowHeight() {
        int n = -1;
        Graphics graphics = this.getGraphics();
        if (graphics != null) {
            n = graphics.getFontMetrics().getHeight();
            graphics.dispose();
            this.fRowHeightSetWithGraphics = true;
        }
        this.setRowHeight(n);
    }

    public void setRowHeight(int n) {
        int n2;
        int n3 = n;
        if (this.fRIP != null && (n2 = this.fRIP.getMaxIconHeight()) > 0) {
            n3 = Math.max(n, n2 + 1);
        }
        if (n > 0) {
            super.setRowHeight(n3);
        }
    }

    @Override
    public boolean isRecordCreator() {
        return this.fRLTM.isRecordCreator();
    }

    @Override
    public void createRecord() {
        this.prepSelectionTrackerForCreate();
        this.stopCellEditing();
        this.fRLTM.createRecord();
    }

    @Override
    public void setCreationObserver(ICreationObserver iCreationObserver) {
        this.fRLTM.setCreationObserver(iCreationObserver);
    }

    @Override
    public boolean isRecordDeleter() {
        return this.fRLTM.isRecordDeleter();
    }

    @Override
    public boolean areRecordsDeletable(int[] nArray) {
        return this.fRLTM.areRecordsDeletable(nArray);
    }

    @Override
    public void deleteRecords(int[] nArray) {
        this.fRLTM.deleteRecords(nArray);
    }

    @Override
    public void setDeletionObserver(IDeletionObserver iDeletionObserver) {
        this.fRLTM.setDeletionObserver(iDeletionObserver);
    }

    @Override
    public boolean isRecordDuplicator() {
        return this.fRLTM.isRecordDuplicator();
    }

    @Override
    public boolean areRecordsDuplicatable(int[] nArray) {
        return this.fRLTM.areRecordsDuplicatable(nArray);
    }

    @Override
    public void duplicateRecords(int[] nArray) {
        this.prepSelectionTrackerForDuplicate();
        this.fRLTM.duplicateRecords(nArray);
    }

    @Override
    public void setDuplicationObserver(IDuplicationObserver iDuplicationObserver) {
        this.fRLTM.setDuplicationObserver(iDuplicationObserver);
    }

    private boolean isRefresher() {
        return this.fRLTM.isRefresher();
    }

    private void refresh() {
        if (this.isRefresher()) {
            this.fRLTM.refresh();
        }
    }

    @Override
    public boolean isRecordEditor() {
        return this.fRLTM.isRecordEditor();
    }

    @Override
    public boolean areRecordsEditable(int[] nArray, int n) {
        return this.fRLTM.areRecordsEditable(nArray, n);
    }

    @Override
    public void setRecordValues(int[] nArray, int n, Object[] objectArray) {
        this.fRLTM.setRecordValues(nArray, n, objectArray);
    }

    @Override
    public void setEditingObserver(IEditingObserver iEditingObserver) {
        this.fRLTM.setEditingObserver(iEditingObserver);
    }

    @Override
    public String[] getEditingDescriptions() {
        return this.fRLTM.getEditingDescriptions();
    }

    @Override
    public int[] getEditableFields() {
        return this.fRLTM.getEditableFields();
    }

    @Override
    public MJAbstractAction getAction(int n) {
        MJAbstractAction mJAbstractAction = null;
        switch (n) {
            case 0: {
                mJAbstractAction = this.fCopyingAction;
                break;
            }
            case 10: {
                mJAbstractAction = this.fCreationAction;
                break;
            }
            case 20: {
                mJAbstractAction = this.fDeletionAction;
                break;
            }
            case 30: {
                mJAbstractAction = this.fDuplicationAction;
                break;
            }
            case 40: {
                mJAbstractAction = this.fOpeningAction;
                break;
            }
            case 50: {
                mJAbstractAction = this.fSelectAllAction;
                break;
            }
            case 15: {
                mJAbstractAction = this.fRefreshAction;
                break;
            }
            case 45: {
                mJAbstractAction = this.fDefaultAction;
            }
        }
        return mJAbstractAction;
    }

    @Override
    public MJAbstractAction[] getEditingActions() {
        return this.fEditingActions != null ? (EditingAction[])this.fEditingActions.clone() : null;
    }

    @Override
    public MJAbstractAction[] getInsertActions() {
        return null;
    }

    public void setDefaultAction(MJAbstractAction mJAbstractAction) {
        this.fDefaultAction = mJAbstractAction;
        this.registerAsDefaultAction((Action)mJAbstractAction);
        this.setSelectionPopupMenu(new DefaultSelectionPopupMenu(this));
    }

    public MJAbstractAction getDefaultAction() {
        return this.fDefaultAction;
    }

    public boolean isRecordOpener() {
        return this.fRLTM.isRecordOpener();
    }

    public boolean areRecordsOpenable(int[] nArray) {
        return this.fRLTM.areRecordsOpenable(nArray);
    }

    public void openRecords(int[] nArray) {
        this.fRLTM.openRecords(nArray);
    }

    public void setOpeningObserver(IOpeningObserver iOpeningObserver) {
        this.fRLTM.setOpeningObserver(iOpeningObserver);
    }

    public boolean isRecordCopier() {
        return this.fRLTM.isRecordCopier();
    }

    public boolean isRecordFieldCopier() {
        return this.fRLTM.isRecordFieldCopier();
    }

    public boolean areRecordsCopyable(int[] nArray) {
        return this.fRLTM.areRecordsCopyable(nArray);
    }

    public void copyRecords(int[] nArray) {
        this.fRLTM.copyRecords(nArray);
    }

    public void copyRecords(int[] nArray, int n) {
        this.fRLTM.copyRecords(nArray, n);
    }

    public void setCopyingObserver(ICopyingObserver iCopyingObserver) {
        this.fRLTM.setCopyingObserver(iCopyingObserver);
    }

    private void copySelection() {
        if (this.isRecordFieldCopier()) {
            this.copyRecords(this.convertRowIndicesToUnderlyingModel(this.getSelectedRowsChron()), this.convertColumnIndexToModel(this.getSelectedColumn()));
        } else {
            this.copyRecords(this.convertRowIndicesToUnderlyingModel(this.getSelectedRowsChron()));
        }
    }

    private void deleteSelection() {
        this.deleteRecords(this.convertRowIndicesToUnderlyingModel(this.getSelectedRowsChron()));
    }

    private void duplicateSelection() {
        this.duplicateRecords(this.convertRowIndicesToUnderlyingModel(this.getSelectedRowsChron()));
    }

    private void openSelection() {
        this.openRecords(this.convertRowIndicesToUnderlyingModel(this.getSelectedRowsChron()));
    }

    public int[] convertRowIndicesToUnderlyingModel(int[] nArray) {
        int n = nArray.length;
        int[] nArray2 = new int[n];
        for (int i = 0; i < n; ++i) {
            nArray2[i] = this.convertRowIndexToUnderlyingModel(nArray[i]);
        }
        return nArray2;
    }

    public int convertRowIndexToUnderlyingModel(int n) {
        return super.convertRowIndexToUnderlyingModel(n);
    }

    public void setFilter(IRecordFilter iRecordFilter, int n) {
        this.fRLTM.setFilter(iRecordFilter, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoSaveColumnPrefs(boolean bl) {
        this.fAutoSaveColumnPrefs = bl;
        ColumnPrefsListener columnPrefsListener = this.fColumnPrefsListener;
        synchronized (columnPrefsListener) {
            if (bl && !this.fColumnPrefsListenerAdded) {
                this.getColumnModel().addColumnModelListener(this.fColumnPrefsListener);
                this.fColumnPrefsListenerAdded = true;
            } else if (!bl && this.fColumnPrefsListenerAdded) {
                this.getColumnModel().removeColumnModelListener(this.fColumnPrefsListener);
                this.fColumnPrefsListenerAdded = false;
            }
        }
    }

    public boolean getAutoSaveColumnPrefs() {
        return this.fAutoSaveColumnPrefs;
    }

    public void showField(int n) {
        this.showFieldAtInitialization(n);
        if (this.fAutoSaveColumnPrefs) {
            this.savePrefs();
        }
    }

    private void showFieldAtInitialization(int n) {
        if (this.fColumnHidden[n]) {
            this.fColumnHidden[n] = false;
            this.addColumn(this.fTableColumns[n]);
            this.moveColumn(this.getColumnCount() - 1, Math.min(n, this.getColumnCount() - 1));
            this.sizeColumnsToFit(-1);
            this.reexamineEditingActions();
        }
    }

    public void hideField(int n) {
        this.hideFieldAtInitialization(n);
        if (this.fAutoSaveColumnPrefs) {
            this.savePrefs();
        }
    }

    private void hideFieldAtInitialization(int n) {
        if (!this.fColumnHidden[n]) {
            TableColumn tableColumn;
            this.fColumnHidden[n] = true;
            this.fTableColumns[n] = tableColumn = this.getColumn(this.getFieldName(n));
            this.removeColumn(tableColumn);
            this.sizeColumnsToFit(-1);
            this.reexamineEditingActions();
        }
    }

    private void reexamineEditingActions() {
        if (this.fEditingActions == null) {
            return;
        }
        for (EditingAction editingAction : this.fEditingActions) {
            if (editingAction == null) continue;
            editingAction.valueChanged(null);
        }
    }

    public boolean isFieldShowing(int n) {
        return !this.fColumnHidden[n];
    }

    public MJPopupMenu getSelectionPopupMenu() {
        return this.fSelectionPopupMenu;
    }

    public MJPopupMenu getNoSelectionPopupMenu() {
        return this.fNoSelectionPopupMenu;
    }

    public void setSelectionPopupMenu(MJPopupMenu mJPopupMenu) {
        this.fSelectionPopupMenu = mJPopupMenu;
    }

    public void setNoSelectionPopupMenu(MJPopupMenu mJPopupMenu) {
        this.fNoSelectionPopupMenu = mJPopupMenu;
    }

    public IRecordFilter getFilter(int n) {
        return this.fRLTM.getFilter(n);
    }

    protected void createActions() {
        this.fSelectAllAction = new ActionUtils.SelectAllAction(this.fActionHelper);
        if (this.isRecordOpener()) {
            this.fDefaultAction = this.fOpeningAction = new RLTOpeningAction();
            this.registerAsDefaultAction((Action)this.fDefaultAction);
        }
        if (this.isRecordCreator()) {
            this.fCreationAction = new ActionUtils.CreationAction(this.fActionHelper);
        }
        if (this.isRefresher()) {
            this.fRefreshAction = new RefreshAction();
        }
        if (this.isRecordCopier()) {
            this.fCopyingAction = new RTLCopyingAction();
        }
        if (this.isRecordDuplicator()) {
            this.fDuplicationAction = new RLTDuplicationAction();
        }
        if (this.isRecordDeleter()) {
            this.fDeletionAction = new RLTDeletionAction();
            this.registerWithInputAndActionMaps(this.fDeletionAction);
        }
        if (this.isRecordEditor()) {
            int[] nArray = this.getEditableFields();
            this.fEditingActions = new EditingAction[nArray.length];
            this.fFieldEditors = new FieldEditor[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                if (this.getColumnClass(nArray[i]).equals(Boolean.class)) continue;
                this.fEditingActions[i] = new EditingAction(i);
                this.fFieldEditors[i] = new FieldEditor((JTextField)new MJTextField());
                this.getColumn(this.getFieldName(nArray[i])).setCellEditor(this.fFieldEditors[i]);
            }
            this.fEditableColumnIsCurrentlyEditable = new boolean[nArray.length];
        }
        this.fUndoAction = UndoActionFactory.getUndoAction(this.fRLTM);
        this.fRedoAction = UndoActionFactory.getRedoAction(this.fRLTM);
        this.registerWithInputAndActionMaps(this.fUndoAction);
        this.registerWithInputAndActionMaps(this.fRedoAction);
    }

    protected void registerWithInputAndActionMaps(MJAbstractAction mJAbstractAction) {
        ActionUtils.registerWithInputAndActionMaps(mJAbstractAction, (ExtendedInputMap)this.fInputMap, this.getActionMap());
    }

    protected void registerAsDefaultAction(Action action) {
        this.fInputMap.put(KeyStroke.getKeyStroke(10, 0), action.getValue("Name"));
        this.getActionMap().put(action.getValue("Name"), action);
    }

    protected void processPossiblePopup(MouseEvent mouseEvent) {
        Object object;
        if (mouseEvent.isPopupTrigger() && (object = mouseEvent.getSource()) instanceof Component) {
            if (this.getSelectedRows().length > 0) {
                if (this.fSelectionPopupMenu != null) {
                    this.fSelectionPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
                    mouseEvent.consume();
                }
            } else if (this.fNoSelectionPopupMenu != null) {
                this.fNoSelectionPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            }
        }
    }

    private boolean hasSelection() {
        return this.getRowCount() != 0 && this.getSelectedRow() != -1;
    }

    public void selectAll() {
        int n = this.getRecordCount();
        if (n > 0) {
            int n2 = this.convertColumnIndexToView(this.getPrimaryFieldIndex());
            this.changeSelection(0, n2, false, false);
            this.changeSelection(n - 1, n2, false, true);
        }
    }

    protected void configureEnclosingScrollPane() {
        JScrollPane jScrollPane;
        super.configureEnclosingScrollPane();
        if (USE_HEADER_CONTEXT_MENUS) {
            this.addContextMenuToEmptyColumnHeader();
        }
        if ((jScrollPane = this.getEnclosingScrollPane()) != null) {
            jScrollPane.getViewport().addMouseListener(this.getOffTableMouseListener());
        }
    }

    protected void unconfigureEnclosingScrollPane() {
        if (USE_HEADER_CONTEXT_MENUS) {
            this.removeContextMenuFromEmptyColumnHeader();
        }
        super.unconfigureEnclosingScrollPane();
    }

    private Component getScrollPaneColumnHeaderView() {
        Component component = null;
        JScrollPane jScrollPane = this.getEnclosingScrollPane();
        if (jScrollPane != null) {
            component = jScrollPane.getColumnHeader().getView();
        }
        return component;
    }

    private JScrollPane getEnclosingScrollPane() {
        Container container;
        JScrollPane jScrollPane = null;
        Container container2 = this.getParent();
        if (container2 instanceof JViewport && (container = container2.getParent()) instanceof JScrollPane) {
            jScrollPane = (JScrollPane)container;
        }
        return jScrollPane;
    }

    private void addContextMenuToEmptyColumnHeader() {
        Component component = this.getScrollPaneColumnHeaderView();
        if (component != null) {
            if (this.fEmptyHeaderMouseListener == null) {
                this.fEmptyHeaderMouseListener = new HeaderListener();
            }
            component.addMouseListener(this.fEmptyHeaderMouseListener);
        }
    }

    private void removeContextMenuFromEmptyColumnHeader() {
        Component component = this.getScrollPaneColumnHeaderView();
        if (component != null) {
            component.removeMouseListener(this.fEmptyHeaderMouseListener);
        }
        this.fEmptyHeaderMouseListener = null;
    }

    public MJCheckBoxMenuItem[] getShowHideMenuItems() {
        MJCheckBoxMenuItem[] mJCheckBoxMenuItemArray = new MJCheckBoxMenuItem[this.getFieldCount()];
        for (int i = 0; i < mJCheckBoxMenuItemArray.length; ++i) {
            mJCheckBoxMenuItemArray[i] = new MJCheckBoxMenuItem((Action)((Object)new HeaderCheckBoxAA(this.getFieldName(i), this.isFieldShowing(i), i)));
            mJCheckBoxMenuItemArray[i].setName("HeaderColumn" + i);
        }
        return mJCheckBoxMenuItemArray;
    }

    public MJCheckBoxMenuItem[] getSortMenuItems() {
        if (this.getFieldCount() == 0) {
            return EMJCMIA;
        }
        MJCheckBoxMenuItem[] mJCheckBoxMenuItemArray = new MJCheckBoxMenuItem[this.getFieldCount()];
        for (int i = 0; i < this.getFieldCount(); ++i) {
            mJCheckBoxMenuItemArray[i] = new MJCheckBoxMenuItem((Action)((Object)new HeaderSortCheckBoxAA(this.getFieldName(i), this.isFieldShowing(i), this.getSortColumn() == i, i)));
        }
        return mJCheckBoxMenuItemArray;
    }

    public MJCheckBoxMenuItem[] getSortDirectionMenuItems() {
        if (this.getFieldCount() == 0) {
            return EMJCMIA;
        }
        MJCheckBoxMenuItem[] mJCheckBoxMenuItemArray = new MJCheckBoxMenuItem[]{new MJCheckBoxMenuItem((Action)((Object)new HeaderSortDirCheckBoxAA(RecordlistResources.getSortAscending(), 0, this.getSortDirection()))), new MJCheckBoxMenuItem((Action)((Object)new HeaderSortDirCheckBoxAA(RecordlistResources.getSortDescending(), 1, this.getSortDirection())))};
        return mJCheckBoxMenuItemArray;
    }

    protected void rememberSelectedRecords() {
        if (this.fRLST != null) {
            this.fRLST.recordSelection(this.getPrimaryRecordIdentifiers(this.getSelectedRows()));
        }
    }

    protected void rememberAllRecords() {
        if (this.fRLST != null) {
            this.fRLST.recordAll(this.getPrimaryRecordIdentifiers());
        }
    }

    private void prepSelectionTrackerForCreate() {
        Object[] objectArray = new String[]{""};
        this.rememberAllRecords();
        this.fRLST.newRecords(objectArray);
        this.fRLST.setCreationPending(true);
    }

    private void prepSelectionTrackerForDuplicate() {
        Object[] objectArray = new String[]{""};
        this.rememberAllRecords();
        this.fRLST.newRecords(objectArray);
        this.fRLST.setDuplicationPending(true);
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        boolean bl = this.fInUpdate;
        this.fInUpdate = true;
        super.tableChanged(tableModelEvent);
        if (tableModelEvent.getLastRow() == Integer.MAX_VALUE && tableModelEvent.getFirstRow() == 0 && tableModelEvent.getColumn() == -1 && tableModelEvent.getType() == 0 && this.fRLST != null) {
            Object object;
            int n;
            int n2 = this.getPrimaryFieldIndex();
            try {
                int n3;
                Object[] objectArray = this.fRLST.getNewSelection(this.getPrimaryRecordIdentifiers());
                ListSelectionModel listSelectionModel = this.getSelectionModel();
                listSelectionModel.clearSelection();
                n = 0;
                object = new ArrayList<Integer>();
                for (Object object2 : objectArray) {
                    for (int i = 0; i < this.getRecordCount(); ++i) {
                        if (!this.getValueAt(i, n2).equals(object2)) continue;
                        object.add(i);
                        if (n != 0) continue;
                        n = 1;
                        if (this.fLastAnchorColumn < 0) continue;
                        this.setColumnSelectionInterval(this.fLastAnchorColumn, this.fLastAnchorColumn);
                    }
                }
                if (object.size() >= 2) {
                    this.getSelectionModel().removeListSelectionListener(this.fRowSelectionRecorder);
                    this.selectionModel.removeListSelectionListener((ListSelectionListener)((Object)this));
                    int n4 = Integer.MAX_VALUE;
                    n3 = Integer.MIN_VALUE;
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        int n5 = (Integer)iterator.next();
                        n4 = n4 > n5 ? n5 : n4;
                        n3 = n3 < n5 ? n5 : n3;
                        listSelectionModel.addSelectionInterval(n5, n5);
                    }
                    this.selectionModel.addListSelectionListener((ListSelectionListener)((Object)this));
                    this.getSelectionModel().addListSelectionListener(this.fRowSelectionRecorder);
                    this.fRowSelectionRecorder.valueChanged(new ListSelectionEvent(this, n4, n3, false));
                    this.valueChanged(new ListSelectionEvent(this, n4, n3, false));
                } else {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        n3 = (Integer)iterator.next();
                        listSelectionModel.addSelectionInterval(n3, n3);
                    }
                }
            }
            catch (Exception exception) {
                this.getSelectionModel().removeListSelectionListener(this.fRowSelectionRecorder);
                this.selectionModel.removeListSelectionListener((ListSelectionListener)((Object)this));
                this.getSelectionModel().addListSelectionListener(this.fRowSelectionRecorder);
                this.selectionModel.addListSelectionListener((ListSelectionListener)((Object)this));
            }
            boolean bl2 = this.fRLST.isCreationPending();
            boolean bl3 = this.fRLST.isDuplicationPending();
            this.fRLST.setCreationPending(false);
            this.fRLST.setDuplicationPending(false);
            if (bl2 || bl3) {
                n = this.getSelectedRow();
                if (n != -1) {
                    this.scrollRectToVisible(this.getCellRect(n, 0, false));
                }
            } else {
                this.editingCanceled(new ChangeEvent(this));
            }
            if (bl2) {
                MJAbstractAction[] mJAbstractActionArray;
                n = -1;
                object = this.getEditableFields();
                for (int i = 0; i < ((Object)object).length; ++i) {
                    if (object[i] != n2) continue;
                    n = i;
                    break;
                }
                if (n != -1 && n <= (mJAbstractActionArray = this.getEditingActions()).length) {
                    mJAbstractActionArray[n].actionPerformed(null);
                }
            }
        }
        this.fInUpdate = bl;
    }

    private Object[] getPrimaryRecordIdentifiers(int[] nArray) {
        int n = this.getPrimaryFieldIndex();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this.getValueAt(nArray[i], n);
        }
        return objectArray;
    }

    Object[] getPrimaryRecordIdentifiers() {
        int n = this.getPrimaryFieldIndex();
        int n2 = this.fRLTM.getRowCount();
        Object[] objectArray = new Object[n2];
        for (int i = 0; i < n2; ++i) {
            objectArray[i] = this.getValueAt(i, n);
        }
        return objectArray;
    }

    private boolean stopCellEditing() {
        return this.cellEditor == null || this.cellEditor.stopCellEditing();
    }

    private void doRename(int n, int n2, TableCellEditor tableCellEditor) {
        this.fCurrentlyEditingRow = n;
        this.fCurrentlyEditingCol = n2;
        this.editCellAt(n, this.convertColumnIndexToView(n2));
        ((DefaultCellEditor)tableCellEditor).getComponent().requestFocus();
    }

    private void setIsPrimaryFocusOwner(boolean bl) {
        this.setHasAppearanceFocus(bl);
    }

    public boolean hasAppearanceFocus() {
        return this.fIsPrimaryFocusOwner;
    }

    private void setHasAppearanceFocus(boolean bl) {
        this.fIsPrimaryFocusOwner = bl;
    }

    public void changeSelection(int n, int n2, boolean bl, boolean bl2) {
        boolean bl3;
        int[] nArray = this.getEditableFields();
        boolean bl4 = bl3 = n2 == this.getPrimaryFieldIndex();
        if (!bl3) {
            for (int n3 : nArray) {
                bl3 |= n3 == this.convertColumnIndexToModel(n2);
            }
        }
        if (bl3) {
            super.changeSelection(n, n2, bl, bl2);
        } else if (PlatformInfo.isMacintosh() || this.getFullCellSelection()) {
            super.changeSelection(n, this.getPrimaryFieldIndex(), bl, bl2);
        } else {
            this.clearSelectionKeepingAnchorRow();
        }
    }

    private void clearSelectionKeepingAnchorRow() {
        int n = this.getSelectionModel().getAnchorSelectionIndex();
        this.clearSelection();
        this.getSelectionModel().setAnchorSelectionIndex(n);
        this.getColumnModel().getSelectionModel().setAnchorSelectionIndex(this.getPrimaryFieldIndex());
    }

    public int[] getSelectedRowsChron() {
        if (this.fSelectionList == null) {
            this.fSelectionList = new ArrayList<Integer>(1);
        }
        int[] nArray = new int[this.fSelectionList.size()];
        for (int i = 0; i < this.fSelectionList.size(); ++i) {
            nArray[i] = this.fSelectionList.get(i);
        }
        return nArray;
    }

    public void addChronSelectionChangeListener(ChangeListener changeListener) {
        if (this.fChronSelectionListeners == null) {
            this.fChronSelectionListeners = new ArrayList<ChangeListener>(2);
        }
        if (!this.fChronSelectionListeners.contains(changeListener)) {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(2);
            arrayList.addAll(this.fChronSelectionListeners);
            arrayList.add(changeListener);
            this.fChronSelectionListeners = arrayList;
        }
    }

    public void removeChronSelectionChangeListener(ChangeListener changeListener) {
        if (this.fChronSelectionListeners != null && this.fChronSelectionListeners.contains(changeListener)) {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(2);
            arrayList.addAll(this.fChronSelectionListeners);
            arrayList.remove(changeListener);
            this.fChronSelectionListeners = arrayList;
        }
    }

    public List<ChangeListener> getChronSelectionChangeListeners() {
        return this.fChronSelectionListeners == null ? Collections.emptyList() : new ArrayList<ChangeListener>(this.fChronSelectionListeners);
    }

    protected void fireChronSelectionChangeEvent(ChangeEvent changeEvent) {
        if (this.fChronSelectionListeners != null) {
            ArrayList<ChangeListener> arrayList = new ArrayList<ChangeListener>(2);
            arrayList.addAll(this.fChronSelectionListeners);
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                ((ChangeListener)arrayList.get(i)).stateChanged(changeEvent);
            }
        }
    }

    public void setFullCellSelection(boolean bl) {
        this.fFullCellSelection = bl;
    }

    boolean getFullCellSelection() {
        return this.fFullCellSelection;
    }

    public MouseListener getOffTableMouseListener() {
        return new OffTableMouseListener(this);
    }

    public void handleSelectionForOffTableClick() {
        if (this.getFullCellSelection()) {
            super.changeSelection(this.getRowCount() - 1, this.getPrimaryFieldIndex(), false, false);
        } else {
            this.clearSelectionKeepingAnchorRow();
        }
        this.stopCellEditing();
    }

    public static Icon createSelectedIcon(Icon icon) {
        if (icon == null) {
            return null;
        }
        return IconUtils.createSelectedIcon((Icon)icon);
    }

    public boolean isCellEditable(int n, int n2) {
        boolean bl = this.fCurrentlyEditingRow == n && this.convertColumnIndexToView(this.fCurrentlyEditingCol) == n2;
        boolean bl2 = this.getColumnClass(n2).equals(Boolean.class);
        return bl || bl2;
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        if (this.fCellPainter != null) {
            this.fCellPainter.setForeground(color);
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.fCellPainter != null) {
            this.fCellPainter.setBackground(color);
        }
    }

    public Component getCellPainter(TableCell tableCell) {
        Object object = this.getValueAt(tableCell.getRow(), tableCell.getColumn());
        this.fCellPainter.setText(object == null ? "" : object.toString());
        return this.fCellPainter;
    }

    private void initCellPainter() {
        this.fCellPainter = new MJLabel();
        this.fCellPainter.setBackground(this.getBackground());
        this.fCellPainter.setForeground(this.getForeground());
        this.fCellPainter.setFont(this.getFont());
        this.fCellPainter.setBorder(BorderFactory.createEmptyBorder(0, 3, 0, 3));
    }

    public boolean shouldShowCellViewer(TableCell tableCell) {
        Rectangle rectangle = this.getVisibleRect();
        Rectangle rectangle2 = this.getCellRect(tableCell.getRow(), tableCell.getColumn(), false);
        Component component = this.getCellPainter(tableCell);
        Dimension dimension = component.getPreferredSize();
        int n = 1;
        if (this.accountForPrimaryIconWidth(tableCell.getColumn())) {
            n += this.fRIP.getMaxIconHeight();
        }
        if (this.accountForSecondaryIconWidth(tableCell.getColumn())) {
            n += this.fRSIP.getMaxSecondaryIconHeight() + 2;
        }
        dimension.width += n;
        return CellViewer.shouldShow((Rectangle)rectangle, (Rectangle)rectangle2, (Dimension)dimension);
    }

    private boolean accountForPrimaryIconWidth(int n) {
        return this.fRIP != null && this.getPrimaryFieldIndex() == n;
    }

    private boolean accountForSecondaryIconWidth(int n) {
        return this.fRSIP != null && this.getPrimaryFieldIndex() == n && this.fRSIP.hasRecordSecondaryIcons();
    }

    public Dimension getCellViewerOffset(TableCell tableCell) {
        Dimension dimension = super.getCellViewerOffset(tableCell);
        if (this.accountForPrimaryIconWidth(tableCell.getColumn())) {
            dimension.width = this.fRIP.getMaxIconHeight();
        }
        if (this.accountForSecondaryIconWidth(tableCell.getColumn())) {
            dimension.width += this.fRSIP.getMaxSecondaryIconHeight();
        }
        return dimension;
    }

    public void cleanup() {
        if (this.fSelectionPopupMenu != null) {
            this.fSelectionPopupMenu.dispose();
            this.fSelectionPopupMenu = null;
        }
        if (this.fNoSelectionPopupMenu != null) {
            this.fNoSelectionPopupMenu.dispose();
            this.fNoSelectionPopupMenu = null;
        }
        this.fHeaderPopupMenu.dispose();
        this.fHeaderPopupMenu = null;
        this.fChronSelectionListeners = null;
        this.fUndoAction = null;
        this.fRedoAction = null;
    }

    @Override
    public final Action getUndoAction() {
        return this.fUndoAction;
    }

    @Override
    public final Action getRedoAction() {
        return this.fRedoAction;
    }

    static /* synthetic */ int[] access$2302(RecordlistTable recordlistTable, int[] nArray) {
        recordlistTable.fLastSelectedRows = nArray;
        return nArray;
    }

    private class ActionHelper
    implements InternalActionHelper {
        private ActionHelper() {
        }

        @Override
        public void selectAll() {
            RecordlistTable.this.selectAll();
        }

        @Override
        public void openSelection() {
            RecordlistTable.this.openSelection();
        }

        @Override
        public void createRecord() {
            RecordlistTable.this.createRecord();
        }

        @Override
        public void duplicateSelection() {
            RecordlistTable.this.duplicateSelection();
        }

        @Override
        public void deleteSelection() {
            RecordlistTable.this.deleteSelection();
        }

        @Override
        public void copySelection() {
            RecordlistTable.this.copySelection();
        }

        @Override
        public MInputMap getMInputMap() {
            return RecordlistTable.this.fInputMap;
        }

        @Override
        public ActionMap getActionMap() {
            return RecordlistTable.this.getActionMap();
        }
    }

    private static class OffTableMouseListener
    extends MouseAdapter {
        private WeakReference<RecordlistTable> fTable;

        OffTableMouseListener(RecordlistTable recordlistTable) {
            this.fTable = new WeakReference<RecordlistTable>(recordlistTable);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            RecordlistTable recordlistTable = (RecordlistTable)this.fTable.get();
            if (recordlistTable != null) {
                super.mousePressed(mouseEvent);
                recordlistTable.handleSelectionForOffTableClick();
                recordlistTable.processPossiblePopup(mouseEvent);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            RecordlistTable recordlistTable = (RecordlistTable)this.fTable.get();
            if (recordlistTable != null) {
                super.mouseReleased(mouseEvent);
                recordlistTable.processPossiblePopup(mouseEvent);
            }
        }
    }

    private class AppFocusL
    implements AppearanceFocusListener {
        private AppFocusL() {
        }

        public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
            Component component = appearanceFocusEvent.getFocusEvent().getComponent();
            boolean bl = false;
            for (Component component2 = appearanceFocusEvent.getFocusEvent().getOppositeComponent(); !bl && component2 != null; component2 = component2.getParent()) {
                bl = component2.equals(component);
            }
            if (!bl) {
                RecordlistTable.this.setIsPrimaryFocusOwner(false);
            }
        }

        public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
            RecordlistTable.this.setIsPrimaryFocusOwner(true);
        }
    }

    private class FieldEditor
    extends DefaultCellEditor {
        private boolean fLocalIsStillEditing;

        FieldEditor(JTextField jTextField) {
            super(jTextField);
            this.fLocalIsStillEditing = false;
            jTextField.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent focusEvent) {
                    ((JTextComponent)focusEvent.getSource()).selectAll();
                }

                @Override
                public void focusLost(FocusEvent focusEvent) {
                    if (!focusEvent.isTemporary()) {
                        FieldEditor.this.stopCellEditing();
                    }
                }
            });
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            Border border = BorderFactory.createLineBorder(this.getTableForegroundColor((JTable)((Object)RecordlistTable.this)), 1);
            Border border2 = BorderFactory.createEmptyBorder(1, PlatformInfo.isMacintosh() ? 1 : 4, 1, PlatformInfo.isMacintosh() ? 1 : 13);
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(border, border2);
            this.editorComponent.setBorder(compoundBorder);
            String string = sEditingFormatter.format(object);
            Icon icon = null;
            if (RecordlistTable.this.accountForPrimaryIconWidth(n2)) {
                icon = RecordlistTable.this.fRIP.getRecordIcon(n);
            }
            Color color = PlatformInfo.isMacintosh() ? this.getTableBackgroundColor(jTable, n) : jTable.getBackground();
            Color color2 = this.getTableForegroundColor(jTable);
            Component component = super.getTableCellEditorComponent(jTable, string, bl, n, n2);
            if (string.toString().startsWith("<") && string.toString().endsWith(">")) {
                ((JTextComponent)component).setText("");
            } else {
                ((JTextComponent)component).setText(string.toString());
            }
            component.setBackground(color);
            component.setForeground(color2);
            component.setFont(jTable.getFont());
            MJPanel mJPanel = new MJPanel();
            mJPanel.setLayout((LayoutManager)new BorderLayout());
            mJPanel.setBackground(color);
            mJPanel.setForeground(color2);
            MJPanel mJPanel2 = new MJPanel();
            mJPanel2.setLayout((LayoutManager)new BorderLayout());
            MJLabel mJLabel = new MJLabel();
            mJLabel.setBackground(color);
            mJLabel.setForeground(color2);
            mJLabel.setIcon(RecordlistTable.createSelectedIcon(icon));
            mJLabel.setOpaque(true);
            mJPanel.add(component, (Object)"Center");
            mJPanel2.add((Component)mJLabel, (Object)"West");
            mJPanel2.add((Component)mJPanel, (Object)"Center");
            this.fLocalIsStillEditing = true;
            return mJPanel2;
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl = true;
            if (this.fLocalIsStillEditing) {
                this.fLocalIsStillEditing = false;
                bl = super.stopCellEditing();
                RecordlistTable.this.requestFocus();
                RecordlistTable.this.fCurrentlyEditingRow = -1;
                RecordlistTable.this.fCurrentlyEditingCol = -1;
            }
            return bl;
        }

        @Override
        public void cancelCellEditing() {
            this.fLocalIsStillEditing = false;
            super.cancelCellEditing();
        }

        private Color getTableBackgroundColor(JTable jTable, int n) {
            return ListColorUtils.getListBackgroundColor((JTable)jTable, (int)n, (boolean)false, (boolean)RecordlistTable.this.fIsPrimaryFocusOwner);
        }

        private Color getTableForegroundColor(JTable jTable) {
            return ListColorUtils.getListForegroundColor((JTable)jTable, (boolean)false, (boolean)RecordlistTable.this.fIsPrimaryFocusOwner);
        }
    }

    private class ColumnSelectionRecorder
    implements ListSelectionListener {
        private ColumnSelectionRecorder() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            if (!listSelectionEvent.getValueIsAdjusting() && (n = RecordlistTable.this.getColumnModel().getSelectionModel().getAnchorSelectionIndex()) != -1) {
                RecordlistTable.this.fLastAnchorColumn = n;
                RecordlistTable.this.fLastDateSelectionChanged = new Date();
            }
        }
    }

    private class SelectionRecorder
    implements ListSelectionListener {
        private SelectionRecorder() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n;
            int n2;
            int n3;
            int n4;
            int[] nArray;
            int n5;
            if (RecordlistTable.this.fSelectionList == null) {
                RecordlistTable.this.fSelectionList = new ArrayList(1);
            }
            RecordlistTable.access$2302(RecordlistTable.this, RecordlistTable.this.getSelectedRows());
            RecordlistTable.this.fLastDateSelectionChanged = new Date();
            if (!RecordlistTable.this.fInUpdate) {
                RecordlistTable.this.rememberSelectedRecords();
            }
            if ((n5 = (nArray = RecordlistTable.this.getSelectedRows()).length) == 0) {
                RecordlistTable.this.fSelectionList.clear();
                RecordlistTable.this.fireChronSelectionChangeEvent(new ChangeEvent(RecordlistTable.this));
                return;
            }
            if (n5 == 1) {
                RecordlistTable.this.fSelectionList.clear();
                RecordlistTable.this.fSelectionList.add(nArray[0]);
                RecordlistTable.this.fireChronSelectionChangeEvent(new ChangeEvent(RecordlistTable.this));
                return;
            }
            Integer[] integerArray = RecordlistTable.this.fSelectionList.toArray(new Integer[RecordlistTable.this.fSelectionList.size()]);
            for (int i = integerArray.length - 1; i >= 0; --i) {
                n4 = integerArray[i];
                n3 = 0;
                for (n2 = 0; n2 < n5; ++n2) {
                    n = nArray[n2];
                    if (n4 != n) continue;
                    n3 = 1;
                    break;
                }
                if (n3 != 0) continue;
                RecordlistTable.this.fSelectionList.remove(i);
            }
            Integer[] integerArray2 = RecordlistTable.this.fSelectionList.toArray(new Integer[RecordlistTable.this.fSelectionList.size()]);
            n4 = integerArray2.length;
            for (n3 = 0; n3 < n5; ++n3) {
                n2 = nArray[n3];
                n = 0;
                for (int i = n4 - 1; i >= 0; --i) {
                    int n6 = integerArray2[i];
                    if (n6 != n2) continue;
                    n = 1;
                    break;
                }
                if (n != 0) continue;
                RecordlistTable.this.fSelectionList.add(n2);
            }
            RecordlistTable.this.fireChronSelectionChangeEvent(new ChangeEvent(RecordlistTable.this));
        }
    }

    private class HeaderSortDirCheckBoxAA
    extends MJAbstractAction
    implements ChangeListener {
        private int fPermanentDirection;

        HeaderSortDirCheckBoxAA(String string, int n, int n2) {
            super(string, n2 == n);
            this.fPermanentDirection = 0;
            this.fPermanentDirection = n;
            if (n == 1) {
                this.setEnabled(RecordlistTable.this.isBidirectionalSortEnabled());
            }
            RecordlistTable.this.addSortingChangeListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RecordlistTable.this.sortByColumn(RecordlistTable.this.getSortColumn(), this.fPermanentDirection);
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setSelected(RecordlistTable.this.getSortDirection() == this.fPermanentDirection);
            if (this.fPermanentDirection == 1) {
                this.setEnabled(RecordlistTable.this.isBidirectionalSortEnabled());
            }
        }
    }

    private class HeaderSortCheckBoxAA
    extends MJAbstractAction
    implements TableColumnModelListener,
    ChangeListener {
        private int fIndex;

        HeaderSortCheckBoxAA(String string, boolean bl, boolean bl2, int n) {
            super(string, bl2);
            this.fIndex = -1;
            this.setEnabled(this.maySortByColumn(n, bl));
            this.fIndex = n;
            RecordlistTable.this.getColumnModel().addColumnModelListener(this);
            RecordlistTable.this.addSortingChangeListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RecordlistTable.this.sortByColumn(this.fIndex, 0);
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.setEnabled(this.maySortByColumn(this.fIndex, RecordlistTable.this.isFieldShowing(this.fIndex)));
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.setEnabled(this.maySortByColumn(this.fIndex, RecordlistTable.this.isFieldShowing(this.fIndex)));
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.setSelected(RecordlistTable.this.getSortColumn() == this.fIndex);
        }

        private boolean maySortByColumn(int n, boolean bl) {
            int[] nArray = RecordlistTable.this.fRLTM.getUnsortableColumns();
            boolean bl2 = bl;
            for (int n2 : nArray) {
                bl2 &= n != n2;
            }
            return bl2;
        }
    }

    private class HeaderCheckBoxAA
    extends MJAbstractAction
    implements TableColumnModelListener {
        private int fIndex;

        HeaderCheckBoxAA(String string, boolean bl, int n) {
            super(string, bl);
            this.fIndex = -1;
            this.fIndex = n;
            if (RecordlistTable.this.getPrimaryFieldIndex() == n) {
                this.setEnabled(false);
            }
            RecordlistTable.this.getColumnModel().addColumnModelListener(this);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.isSelected()) {
                RecordlistTable.this.showField(this.fIndex);
            } else {
                RecordlistTable.this.hideField(this.fIndex);
            }
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
            this.setSelected(RecordlistTable.this.isFieldShowing(this.fIndex));
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
            this.setSelected(RecordlistTable.this.isFieldShowing(this.fIndex));
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }
    }

    private class ColumnPrefsListener
    extends MJAbstractAction
    implements TableColumnModelListener {
        private ColumnPrefsListener() {
        }

        @Override
        public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent changeEvent) {
            if (RecordlistTable.this.fAutoSaveColumnPrefs) {
                RecordlistTable.this.savePrefs();
            }
        }

        @Override
        public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
            if (RecordlistTable.this.fAutoSaveColumnPrefs) {
                RecordlistTable.this.savePrefs();
            }
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
        }

        public void actionPerformed(ActionEvent actionEvent) {
        }
    }

    private static class HeaderPopupMenu
    extends MJPopupMenu {
        HeaderPopupMenu(MJCheckBoxMenuItem[] mJCheckBoxMenuItemArray) {
            HeaderPopupMenu.setDefaultLightWeightPopupEnabled((boolean)false);
            for (MJCheckBoxMenuItem mJCheckBoxMenuItem : mJCheckBoxMenuItemArray) {
                this.add((JMenuItem)mJCheckBoxMenuItem);
            }
        }
    }

    private class MouseL
    extends MouseAdapter {
        private MouseL() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            Point point = mouseEvent.getPoint();
            int n = RecordlistTable.this.rowAtPoint(point);
            int n2 = RecordlistTable.this.columnAtPoint(point);
            if (n == -1) {
                RecordlistTable.this.processPossiblePopup(mouseEvent);
                return;
            }
            if (n2 == -1) {
                this.handleOffTableClick(mouseEvent);
                return;
            }
            if (PlatformInfo.isMacintosh() || RecordlistTable.this.getFullCellSelection()) {
                RecordlistTable.this.processPossiblePopup(mouseEvent);
            } else {
                int n3 = RecordlistTable.this.getFontMetrics(RecordlistTable.this.getFont()).stringWidth(RecordlistTable.this.getValueAt(n, n2).toString());
                int n4 = 0;
                if (RecordlistTable.this.accountForPrimaryIconWidth(n2)) {
                    n4 = RecordlistTable.this.fRIP.getMaxIconHeight() + 2;
                }
                int n5 = n3 + 2 + n4 + 6;
                Rectangle rectangle = RecordlistTable.this.getCellRect(n, n2, true);
                int n6 = point.x - rectangle.x;
                if (n6 >= n5) {
                    RecordlistTable.this.changeSelection(-1, -1, false, false);
                }
                RecordlistTable.this.processPossiblePopup(mouseEvent);
            }
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            super.mouseClicked(mouseEvent);
            int n = mouseEvent.getClickCount();
            if (n == 0) {
                return;
            }
            switch (n %= 2) {
                case 0: {
                    if ((mouseEvent.getModifiers() | 0x10) != 16 || RecordlistTable.this.fDefaultAction == null) break;
                    RecordlistTable.this.fDefaultAction.actionPerformed(new ActionEvent(RecordlistTable.this, mouseEvent.getModifiers(), "Default"));
                    mouseEvent.consume();
                    break;
                }
                case 1: {
                    if (!SwingUtilities.isLeftMouseButton(mouseEvent) || PlatformInfo.isMacintosh() && mouseEvent.isControlDown()) break;
                    Date date = new Date();
                    Point point = mouseEvent.getPoint();
                    int n2 = RecordlistTable.this.rowAtPoint(point);
                    int n3 = RecordlistTable.this.columnAtPoint(point);
                    if (n2 == -1 || n3 == -1) {
                        this.handleOffTableClick(mouseEvent);
                        break;
                    }
                    int n4 = RecordlistTable.this.getFontMetrics(RecordlistTable.this.getFont()).stringWidth(RecordlistTable.this.getValueAt(n2, n3).toString());
                    int n5 = 0;
                    if (RecordlistTable.this.accountForPrimaryIconWidth(n3)) {
                        n5 = RecordlistTable.this.fRIP.getMaxIconHeight() + 2;
                        if (RecordlistTable.this.accountForSecondaryIconWidth(n3)) {
                            n5 += RecordlistTable.this.fRSIP.getMaxSecondaryIconHeight() + 2;
                        }
                    }
                    int n6 = n4 + 2 + n5 + 6;
                    Rectangle rectangle = RecordlistTable.this.getCellRect(n2, n3, true);
                    int n7 = point.x - rectangle.x;
                    if (n7 >= n6) {
                        this.handleOffTableClick(mouseEvent);
                        break;
                    }
                    if (n7 < n5) {
                        mouseEvent.consume();
                        break;
                    }
                    if (RecordlistTable.this.getColumnClass(n3).equals(Boolean.class)) {
                        return;
                    }
                    if (n3 == RecordlistTable.this.fLastAnchorColumn) {
                        for (int n8 : RecordlistTable.this.fLastSelectedRows) {
                            int n9;
                            long l;
                            long l2;
                            if (n8 != n2 || (l2 = date.getTime()) - (l = RecordlistTable.this.fLastDateSelectionChanged.getTime()) <= (long)((n9 = Math.max(MJUtilities.getDoubleClickInterval(), 2500)) / 5)) continue;
                            int[] nArray = new int[]{n2};
                            int[] nArray2 = RecordlistTable.this.getEditableFields();
                            if (!RecordlistTable.this.areRecordsEditable(nArray, RecordlistTable.this.convertColumnIndexToModel(n3))) continue;
                            int n10 = -1;
                            for (int i = 0; i < nArray2.length; ++i) {
                                n10 = n3 == RecordlistTable.this.convertColumnIndexToView(nArray2[i]) ? i : n10;
                            }
                            if (n10 == -1) continue;
                            if (sEditingTimer == null) {
                                sEditingTimer = new Timer();
                            }
                            EditTT editTT = new EditTT(n10);
                            sEditingTimer.schedule((TimerTask)editTT, MJUtilities.getDoubleClickInterval());
                        }
                    }
                    RecordlistTable.this.fLastAnchorColumn = n3;
                }
            }
        }

        private void handleOffTableClick(MouseEvent mouseEvent) {
            if (!PlatformInfo.isMacintosh() && !RecordlistTable.this.getFullCellSelection()) {
                RecordlistTable.this.changeSelection(-1, -1, false, false);
            }
            mouseEvent.consume();
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            RecordlistTable.this.processPossiblePopup(mouseEvent);
        }

        private class EditTT
        extends TimerTask
        implements MouseListener {
            private int fRow = -1;

            EditTT(int n) {
                RecordlistTable.this.addMouseListener(this);
                this.fRow = n;
            }

            @Override
            public void run() {
                RecordlistTable.this.removeMouseListener(this);
                SwingUtilities.invokeLater(new DoEdit());
            }

            @Override
            public boolean cancel() {
                RecordlistTable.this.removeMouseListener(this);
                return super.cancel();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.cancel();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            private class DoEdit
            implements Runnable {
                private DoEdit() {
                }

                @Override
                public void run() {
                    RecordlistTable.this.fEditingActions[EditTT.this.fRow].actionPerformed(null);
                }
            }
        }
    }

    private class EditingAction
    extends MJAbstractAction
    implements ListSelectionListener {
        private int fIndIntoFieldArray;

        EditingAction(int n) {
            super(RecordlistTable.this.getEditingDescriptions()[n]);
            this.fIndIntoFieldArray = -1;
            this.setComponentName("RecordEditing");
            this.fIndIntoFieldArray = n;
            RecordlistTable.this.selectionModel.addListSelectionListener(this);
            this.valueChanged(null);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RecordlistTable.this.doRename(RecordlistTable.this.getSelectedRow(), RecordlistTable.this.getEditableFields()[this.fIndIntoFieldArray], RecordlistTable.this.fFieldEditors[this.fIndIntoFieldArray]);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int[] nArray = RecordlistTable.this.getEditableFields();
            int[] nArray2 = RecordlistTable.this.convertRowIndicesToUnderlyingModel(RecordlistTable.this.getSelectedRows());
            this.setEnabled(nArray2.length == 1 && RecordlistTable.this.areRecordsEditable(nArray2, nArray[this.fIndIntoFieldArray]) && RecordlistTable.this.isFieldShowing(nArray[this.fIndIntoFieldArray]));
        }
    }

    private class RLTOpeningAction
    extends ActionUtils.OpeningAction
    implements ListSelectionListener {
        RLTOpeningAction() {
            super(RecordlistTable.this.fActionHelper);
            RecordlistTable.this.selectionModel.addListSelectionListener(this);
            this.valueChanged(null);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RecordlistTable.this.hasSelection() && RecordlistTable.this.areRecordsOpenable(RecordlistTable.this.convertRowIndicesToUnderlyingModel(RecordlistTable.this.getSelectedRows())));
        }
    }

    private class RLTDeletionAction
    extends ActionUtils.DeletionAction
    implements ListSelectionListener {
        RLTDeletionAction() {
            super(RecordlistTable.this.fActionHelper);
            RecordlistTable.this.selectionModel.addListSelectionListener(this);
            this.valueChanged(null);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RecordlistTable.this.hasSelection() && RecordlistTable.this.areRecordsDeletable(RecordlistTable.this.convertRowIndicesToUnderlyingModel(RecordlistTable.this.getSelectedRows())));
        }
    }

    private class RLTDuplicationAction
    extends ActionUtils.DuplicationAction
    implements ListSelectionListener {
        RLTDuplicationAction() {
            super(RecordlistTable.this.fActionHelper);
            RecordlistTable.this.selectionModel.addListSelectionListener(this);
            this.valueChanged(null);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RecordlistTable.this.hasSelection() && RecordlistTable.this.areRecordsDuplicatable(RecordlistTable.this.convertRowIndicesToUnderlyingModel(RecordlistTable.this.getSelectedRows())));
        }
    }

    private class RefreshAction
    extends ActionUtils.BaseAction {
        RefreshAction() {
            super("refresh", "Refresh", RecordlistTable.this.fInputMap, RecordlistTable.this.getActionMap());
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RecordlistTable.this.refresh();
        }
    }

    private class RTLCopyingAction
    extends ActionUtils.CopyingAction
    implements ListSelectionListener {
        RTLCopyingAction() {
            super(RecordlistTable.this.fActionHelper);
            this.setEnabled(false);
            RecordlistTable.this.selectionModel.addListSelectionListener(this);
            this.valueChanged(null);
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.setEnabled(RecordlistTable.this.hasSelection() && RecordlistTable.this.areRecordsCopyable(RecordlistTable.this.convertRowIndicesToUnderlyingModel(RecordlistTable.this.getSelectedRows())));
        }
    }

    private class HeaderListener
    extends MouseAdapter {
        private HeaderListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            super.mousePressed(mouseEvent);
            this.processPossibleHeaderPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            super.mouseReleased(mouseEvent);
            this.processPossibleHeaderPopup(mouseEvent);
        }

        private void processPossibleHeaderPopup(MouseEvent mouseEvent) {
            Object object;
            if (mouseEvent.isPopupTrigger() && (object = mouseEvent.getSource()) instanceof Component) {
                RecordlistTable.this.fHeaderPopupMenu.show((Component)object, mouseEvent.getX(), mouseEvent.getY());
                mouseEvent.consume();
            }
        }
    }
}

