/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.spreadsheet.data;

import com.mathworks.widgets.spreadsheet.SpreadsheetPrefs;
import com.mathworks.widgets.spreadsheet.data.ComplexScalar;
import com.mathworks.widgets.spreadsheet.format.ComplexScalarFormatter;
import com.mathworks.widgets.spreadsheet.format.FormatIdentifier;

public abstract class ComplexArray {
    private final boolean fIsSigned;
    private static final String INITIAL_STRING_MATLAB = "[";
    private static final String TERMINAL_STRING_MATLAB = "]";
    private static final String COLUMN_DELIMITER_MATLAB = ",";
    private static final String ROW_DELIMITER_MATLAB = ";";
    private static final String SPACE_DELIMITER = " ";
    private static final String INITIAL_STRING_SPREADSHEET = "";
    private static final String TERMINAL_STRING_SPREADSHEET = "";
    private static final String COLUMN_DELIMITER_SPREADSHEET = "\t";
    private static final String ROW_DELIMITER_SPREADSHEET = "\n";
    private static final int MATLAB = 0;
    private static final int SPREADSHEET = 1;

    ComplexArray(boolean bl) {
        this.fIsSigned = bl;
    }

    public abstract boolean isReal();

    public final boolean isSigned() {
        return this.fIsSigned;
    }

    public String toString() {
        return FormatIdentifier.getDefaultInstance().getFormatter().format(this);
    }

    public abstract int[] getLengths();

    public boolean isEmpty() {
        int[] nArray = this.getLengths();
        return nArray[1] == 0 || nArray[0] == 0;
    }

    public abstract ComplexScalar getValueAt(int var1, int var2);

    public final String format(ComplexScalarFormatter complexScalarFormatter) {
        return this.format(complexScalarFormatter, 0);
    }

    private static String getMatlabColumnDelimiter() {
        if (COLUMN_DELIMITER_MATLAB.equals(String.valueOf(SpreadsheetPrefs.getDecimalSeparator()))) {
            return SPACE_DELIMITER;
        }
        return COLUMN_DELIMITER_MATLAB;
    }

    private String format(ComplexScalarFormatter complexScalarFormatter, int n) {
        switch (n) {
            case 0: {
                return this.format(complexScalarFormatter, INITIAL_STRING_MATLAB, TERMINAL_STRING_MATLAB, ROW_DELIMITER_MATLAB, ComplexArray.getMatlabColumnDelimiter());
            }
            case 1: {
                return this.format(complexScalarFormatter, "", "", ROW_DELIMITER_SPREADSHEET, COLUMN_DELIMITER_SPREADSHEET);
            }
        }
        throw new IllegalArgumentException("Invalid format style specified.");
    }

    private String format(ComplexScalarFormatter complexScalarFormatter, String string, String string2, String string3, String string4) {
        int[] nArray = this.getLengths();
        int n = nArray[0];
        int n2 = nArray[1];
        StringBuilder stringBuilder = new StringBuilder(string);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                stringBuilder.append(complexScalarFormatter.format(this.getValueAt(i, j)));
                if (j >= n2 - 1) continue;
                stringBuilder.append(string4);
            }
            if (i >= n - 1) continue;
            stringBuilder.append(string3);
        }
        stringBuilder.append(string2);
        return stringBuilder.toString();
    }
}

