/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text;

import com.mathworks.mwswing.AppearanceFocusDispatcher;
import com.mathworks.mwswing.AppearanceFocusEvent;
import com.mathworks.mwswing.AppearanceFocusListener;
import com.mathworks.mwswing.ColorUtils;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.util.Log;
import com.mathworks.widgets.Tokenizer;
import com.mathworks.widgets.TokenizerFactory;
import com.mathworks.widgets.text.EditorPrefsAccessor;
import com.mathworks.widgets.text.MWDrawLayerFactory;
import com.mathworks.widgets.text.MWKit;
import com.mathworks.widgets.text.MWSettingsDefaults;
import com.mathworks.widgets.text.MarkPair;
import com.mathworks.widgets.text.TextDragAndDrop;
import com.mathworks.widgets.text.fold.CodeFoldingUtilities;
import com.mathworks.widgets.tokenmatch.TokenMatchPopup;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.dnd.DropTargetListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import javax.swing.SwingUtilities;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.api.editor.fold.Fold;
import org.netbeans.api.editor.fold.FoldHierarchy;
import org.netbeans.api.editor.fold.FoldUtilities;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.BaseKit;
import org.netbeans.editor.BaseTextUI;
import org.netbeans.editor.Coloring;
import org.netbeans.editor.DrawContext;
import org.netbeans.editor.DrawLayer;
import org.netbeans.editor.EditorUI;
import org.netbeans.editor.InvalidMarkException;
import org.netbeans.editor.MarkFactory;
import org.netbeans.editor.SettingsAdapter;
import org.netbeans.editor.SettingsChangeEvent;
import org.netbeans.editor.SettingsUtil;
import org.netbeans.editor.TokenID;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtCaret;
import org.netbeans.editor.ext.ExtSyntaxSupport;

public class MWCaret
extends ExtCaret {
    public static final int UNDERLINE = 1;
    public static final int HIGHLIGHT = 2;
    public static final int BALANCE = 3;
    public static final int BEEP = 4;
    public static final int STRIKETHRU = 5;
    public static final int NONE = 6;
    public static final String MW_BRACE_LAYER_NAME = "m-brace-layer";
    public static final int MW_BRACE_LAYER_VISIBILITY = 11001;
    private boolean fMatchBraceOnKeyOption;
    private boolean fMatchBraceOnArrowOption;
    private Coloring fColoringMatchOnKeyPressed;
    private Coloring fColoringMismatchOnKeyPressed;
    private Coloring fColoringMatchOnMouse;
    private Coloring fColoringMismatchOnMouse;
    private boolean fBeepOnMismatchKey;
    private boolean fBeepOnMismatchMouse;
    private boolean fBalanceWhileTyping;
    private boolean fSimpleMatchBrace;
    private Coloring fCurrentColoring;
    private boolean fBraceMarksValid = false;
    private MarkPair fMarkBrace;
    private MarkPair fMarkCaret;
    private HighlightBraceLayer fHighlightBraceLayer;
    private boolean fInFocus;
    private boolean fFocusOverride = false;
    private static Coloring sBlankColoring = new Coloring();
    private TextDragAndDrop fDnd;
    private AppearanceFocusDispatcher fAppearanceFocusDispatcher;
    private DelimiterMatchingController fDelimiterMatchingController = new DelimiterMatchingImpl();
    private Tokenizer fDelimiterMatchingTokenizer = TokenizerFactory.getPlainTokenizer();

    public void install(JTextComponent jTextComponent) {
        super.install(jTextComponent);
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
        Class clazz = Utilities.getKitClass((JTextComponent)jTextComponent);
        this.fDelimiterMatchingTokenizer = TokenizerFactory.getTokenizerForKitClass(clazz);
        this.fHighlightBraceLayer = new HighlightBraceLayer();
        this.updateSettings(clazz, editorUI);
        this.fCurrentColoring = null;
        editorUI.removeLayer("caret-layer");
        editorUI.addLayer((DrawLayer)new MWDrawLayerFactory.MCaretLayer(), 10000);
        if (this.fDnd == null) {
            this.fDnd = new TextDragAndDrop(jTextComponent);
        } else {
            this.fDnd.changeDragRecognizerRegistration(true);
        }
        AppearanceFocusListener appearanceFocusListener = new AppearanceFocusListener(){

            public void appearanceFocusGained(AppearanceFocusEvent appearanceFocusEvent) {
                block3: {
                    MWCaret.this.fInFocus = true;
                    if (MWCaret.this.isSelection() && !MWCaret.this.fFocusOverride) {
                        try {
                            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)MWCaret.this.component);
                            editorUI.repaintBlock(MWCaret.this.getDot(), MWCaret.this.getMark());
                        }
                        catch (BadLocationException badLocationException) {
                            if (System.getProperty("netbeans.debug.exceptions") == null) break block3;
                            badLocationException.printStackTrace();
                        }
                    }
                }
            }

            public void appearanceFocusLost(AppearanceFocusEvent appearanceFocusEvent) {
                block4: {
                    MWCaret.this.fInFocus = false;
                    if (MWCaret.this.isSelection() && !MWCaret.this.fFocusOverride) {
                        Coloring coloring;
                        Coloring coloring2 = SettingsUtil.getColoring(MWKit.class, (String)"mw-selection-outof-focus", (boolean)false);
                        Color color = ColorUtils.getUnfocusedSelectionForegroundColor((Component)MWCaret.this.component);
                        Color color2 = ColorUtils.getUnfocusedSelectionBackgroundColor((Component)MWCaret.this.component);
                        if (!color.equals(coloring2.getForeColor()) || !color2.equals(coloring2.getBackColor())) {
                            coloring = Coloring.changeBackColor((Coloring)coloring2, (Color)color2);
                            coloring = Coloring.changeForeColor((Coloring)coloring, (Color)color);
                            SettingsAdapter.setColoring((Object)this, MWKit.class, (String)"mw-selection-outof-focus", (Object)coloring);
                        }
                        try {
                            coloring = Utilities.getEditorUI((JTextComponent)MWCaret.this.component);
                            coloring.repaintBlock(MWCaret.this.getDot(), MWCaret.this.getMark());
                        }
                        catch (BadLocationException badLocationException) {
                            if (System.getProperty("netbeans.debug.exceptions") == null) break block4;
                            badLocationException.printStackTrace();
                        }
                    }
                }
            }
        };
        this.fAppearanceFocusDispatcher = new AppearanceFocusDispatcher();
        this.fAppearanceFocusDispatcher.addAppearanceFocusListener(appearanceFocusListener);
        jTextComponent.addFocusListener((FocusListener)this.fAppearanceFocusDispatcher);
        this.fInFocus = jTextComponent.hasFocus();
    }

    public void deinstall(JTextComponent jTextComponent) {
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
        editorUI.removeLayer(MW_BRACE_LAYER_NAME);
        if (this.fAppearanceFocusDispatcher != null) {
            jTextComponent.removeFocusListener((FocusListener)this.fAppearanceFocusDispatcher);
            this.fAppearanceFocusDispatcher = null;
        }
        if (this.fDnd != null) {
            this.fDnd.changeDragRecognizerRegistration(false);
        }
        super.deinstall(jTextComponent);
    }

    protected boolean shouldCaretBeDisplayed() {
        return super.shouldCaretBeDisplayed() && this.component.isEditable();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        super.propertyChange(propertyChangeEvent);
        String string = propertyChangeEvent.getPropertyName();
        if ("editable".equals(string)) {
            this.setVisible(this.shouldCaretBeDisplayed() && this.component.isFocusOwner());
        }
    }

    public DropTargetListener getDropTargetListener() {
        return this.fDnd;
    }

    public boolean isDragAndDropEnabled() {
        return this.fDnd != null && this.fDnd.isDragAndDropEnabled();
    }

    public void setTextDragAndDropEnabled(boolean bl) {
        if (this.fDnd != null) {
            this.fDnd.setDragAndDropEnabled(bl);
        }
    }

    public void settingsChange(SettingsChangeEvent settingsChangeEvent) {
        super.settingsChange(settingsChangeEvent);
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null && settingsChangeEvent != null) {
            String string = settingsChangeEvent.getSettingName();
            String string2 = "default-coloring";
            if (string.equals("mw-highlight-match-brace") || string.equals("mw-highlight-match-brace-on-arrow") || string.equals("mw-bracematch-key") || string.equals("mw-bracematch-arrow") || string.equals("mw-bracemismatch-key") || string.equals("mw-bracemismatch-arrow")) {
                Class clazz = Utilities.getKitClass((JTextComponent)jTextComponent);
                this.updateSettings(clazz, Utilities.getEditorUI((JTextComponent)jTextComponent));
            } else if (string.equals(string2)) {
                this.updateSettings(Utilities.getKitClass((JTextComponent)jTextComponent), Utilities.getEditorUI((JTextComponent)jTextComponent));
            }
        }
    }

    private Coloring makeColoring(int n) {
        Coloring coloring;
        if (n == 1 || n == 5) {
            Color color = SettingsUtil.getColoring((Class)Utilities.getKitClass((JTextComponent)this.component), (String)"default", (boolean)false).getForeColor();
            coloring = n == 1 ? new Coloring(null, 1, null, null, color, null) : new Coloring(null, 1, null, null, null, color);
        } else {
            coloring = n == 2 || n == 3 ? new Coloring(null, TokenMatchPopup.getHighlightForegroundColor(), TokenMatchPopup.getHighlightBackgroundColor()) : sBlankColoring;
        }
        return coloring;
    }

    public boolean isInFocus() {
        return this.fFocusOverride || this.fInFocus;
    }

    public void setSelFocusOverride(boolean bl) {
        block3: {
            this.fFocusOverride = bl;
            if (this.isSelection()) {
                try {
                    EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.component);
                    editorUI.repaintBlock(this.getDot(), this.getMark());
                }
                catch (BadLocationException badLocationException) {
                    if (System.getProperty("netbeans.debug.exceptions") == null) break block3;
                    badLocationException.printStackTrace();
                }
            }
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        boolean bl;
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getComponent();
        boolean bl2 = bl = jTextComponent.getSelectionStart() != jTextComponent.getSelectionEnd();
        if ((MJUtilities.isPopupPrecursor((MouseEvent)mouseEvent) || mouseEvent.isPopupTrigger()) && bl && !MWCaret.isClickInSelection(mouseEvent)) {
            this.setDot(this.getDot());
        }
        super.mousePressed(mouseEvent);
        if (!MJUtilities.isPopupPrecursor((MouseEvent)mouseEvent) && !mouseEvent.isPopupTrigger()) {
            this.updateMatchBrace(false);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.handleMouseReleased(mouseEvent);
        super.mouseReleased(mouseEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMouseReleased(MouseEvent mouseEvent) {
        block11: {
            JTextComponent jTextComponent = this.component;
            if (jTextComponent != null && SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.getClickCount() == 1) {
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                int n = baseTextUI.viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
                try {
                    Rectangle rectangle = baseTextUI.modelToView(jTextComponent, n);
                    if (!(rectangle.getX() < (double)mouseEvent.getX())) break block11;
                    FoldHierarchy foldHierarchy = FoldHierarchy.get((JTextComponent)jTextComponent);
                    Document document = jTextComponent.getDocument();
                    if (!(document instanceof AbstractDocument) || foldHierarchy == null) break block11;
                    AbstractDocument abstractDocument = (AbstractDocument)document;
                    abstractDocument.readLock();
                    try {
                        foldHierarchy.lock();
                        try {
                            int n2;
                            Fold fold = FoldUtilities.findCollapsedFold((FoldHierarchy)foldHierarchy, (int)n, (int)n);
                            if (fold == null || fold.getStartOffset() > n || fold.getEndOffset() < n) break block11;
                            foldHierarchy.expand(fold);
                            FoldUtilities.expandAllFoldsAtOffset((FoldHierarchy)foldHierarchy, (int)fold.getStartOffset(), (int)fold.getEndOffset());
                            try {
                                n2 = Utilities.getRowStart((JTextComponent)jTextComponent, (int)fold.getStartOffset());
                            }
                            catch (BadLocationException badLocationException) {
                                n2 = fold.getStartOffset();
                            }
                            this.setDot(n2, false);
                        }
                        finally {
                            foldHierarchy.unlock();
                        }
                    }
                    finally {
                        abstractDocument.readUnlock();
                    }
                }
                catch (BadLocationException badLocationException) {
                    Log.logException((Exception)badLocationException);
                }
            }
        }
    }

    protected boolean isDragPossible(MouseEvent mouseEvent) {
        return false;
    }

    boolean doSelectWordAction(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getComponent();
        if (jTextComponent != null) {
            if (this.selectWordAction == null) {
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                this.selectWordAction = ((BaseKit)baseTextUI.getEditorKit(jTextComponent)).getActionByName("select-word");
            }
            this.selectWordAction.actionPerformed(null);
            return true;
        }
        return false;
    }

    boolean doSelectLineAction(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getComponent();
        if (jTextComponent != null) {
            if (this.selectLineAction == null) {
                BaseTextUI baseTextUI = (BaseTextUI)jTextComponent.getUI();
                this.selectLineAction = ((BaseKit)baseTextUI.getEditorKit(jTextComponent)).getActionByName("select-line");
            }
            this.selectLineAction.actionPerformed(null);
            return true;
        }
        return false;
    }

    static int getOffsetFromEvent(MouseEvent mouseEvent) {
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getSource();
        if (jTextComponent != null) {
            return ((BaseTextUI)jTextComponent.getUI()).viewToModel(jTextComponent, mouseEvent.getX(), mouseEvent.getY());
        }
        return 0;
    }

    protected static int getWordStart(Object object, int n) {
        try {
            int n2 = Utilities.getWordEnd((JTextComponent)((JTextComponent)object), (int)n);
            if (n2 != -1 && n2 <= n) {
                int n3 = Utilities.getFirstNonWhiteBwd((BaseDocument)((BaseDocument)((JTextComponent)object).getDocument()), (int)n);
                if (n3 != -1) {
                    return n3 + 1;
                }
                return n;
            }
            int n4 = Utilities.getWordStart((JTextComponent)((JTextComponent)object), (int)n);
            return n4 == -1 ? n : n4;
        }
        catch (BadLocationException badLocationException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                badLocationException.printStackTrace();
            }
            return n;
        }
    }

    protected static int getWordEnd(Object object, int n) {
        try {
            int n2 = Utilities.getWordStart((JTextComponent)((JTextComponent)object), (int)n);
            if (n2 != -1 && n2 >= n) {
                int n3 = Utilities.getFirstNonWhiteFwd((BaseDocument)((BaseDocument)((JTextComponent)object).getDocument()), (int)n);
                if (n3 != -1) {
                    return n3;
                }
                return n;
            }
            int n4 = Utilities.getWordEnd((JTextComponent)((JTextComponent)object), (int)n);
            return n4 == -1 ? n : n4;
        }
        catch (BadLocationException badLocationException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                badLocationException.printStackTrace();
            }
            return n;
        }
    }

    static int getLineStart(Object object, int n) {
        try {
            return Utilities.getRowStart((JTextComponent)((JTextComponent)object), (int)n);
        }
        catch (BadLocationException badLocationException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                badLocationException.printStackTrace();
            }
            return n;
        }
    }

    static int getLineEnd(Object object, int n) {
        try {
            int n2 = Utilities.getRowEnd((JTextComponent)((JTextComponent)object), (int)n);
            JTextComponent jTextComponent = (JTextComponent)object;
            int n3 = jTextComponent.getUI().getNextVisualPositionFrom(jTextComponent, n2, Position.Bias.Forward, 3, null);
            n3 = Math.min(n3, jTextComponent.getDocument().getLength());
            return n3;
        }
        catch (BadLocationException badLocationException) {
            if (Boolean.getBoolean("netbeans.debug.exceptions")) {
                badLocationException.printStackTrace();
            }
            return n;
        }
    }

    public static boolean isClickInSelection(MouseEvent mouseEvent) {
        int n;
        JTextComponent jTextComponent = (JTextComponent)mouseEvent.getComponent();
        int n2 = jTextComponent.getSelectionStart();
        if (n2 == (n = jTextComponent.getSelectionEnd())) {
            return false;
        }
        Point point = mouseEvent.getPoint();
        int n3 = jTextComponent.viewToModel(point);
        try {
            int n4 = Utilities.getLineOffset((BaseDocument)((BaseDocument)jTextComponent.getDocument()), (int)n3);
            int n5 = Utilities.getLineOffset((BaseDocument)((BaseDocument)jTextComponent.getDocument()), (int)n2);
            int n6 = Utilities.getLineOffset((BaseDocument)((BaseDocument)jTextComponent.getDocument()), (int)n);
            if (n4 == n5) {
                if (jTextComponent.modelToView((int)n2).x > (int)point.getX()) {
                    return false;
                }
                return n5 != n6 || jTextComponent.modelToView((int)n).x >= (int)point.getX();
            }
            return n4 >= n5 && (n4 < n6 || n4 == n6 && point.getX() <= (double)jTextComponent.modelToView((int)n).x);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }

    protected void modelChanged(BaseDocument baseDocument, BaseDocument baseDocument2) {
        this.fBraceMarksValid = false;
        if (this.fMarkBrace != null) {
            this.fMarkBrace.remove();
            this.fMarkCaret.remove();
            this.fMarkBrace = null;
            this.fMarkCaret = null;
        }
        super.modelChanged(baseDocument, baseDocument2);
    }

    public void doDelimiterMatch(char c, int n) {
        if (this.isStartDelimiter(c, n) || this.isEndDelimiter(c, n)) {
            this.updateMatchBrace(true);
        }
    }

    private void updateMatchBrace(boolean bl) {
        this.updateMatchBrace(bl, this.getDot());
    }

    void updateMatchBrace(boolean bl, int n) {
        assert (SwingUtilities.isEventDispatchThread());
        JTextComponent jTextComponent = this.component;
        if (jTextComponent != null && !this.isSelection() && this.fMatchBraceOnKeyOption && bl || this.fMatchBraceOnArrowOption && !bl) {
            try {
                EditorUI editorUI = Utilities.getEditorUI((JTextComponent)jTextComponent);
                BaseDocument baseDocument = (BaseDocument)jTextComponent.getDocument();
                boolean bl2 = false;
                if (n > 0) {
                    Object object;
                    char[] cArray = baseDocument.getChars(n - 1, 1);
                    if (!this.fSimpleMatchBrace && (object = ((BaseDocument)this.component.getDocument()).getSyntaxSupport()) instanceof ExtSyntaxSupport) {
                        TokenID tokenID = ((ExtSyntaxSupport)object).getTokenID(n - 1);
                        TokenID[] tokenIDArray = ((ExtSyntaxSupport)object).getBracketSkipTokens();
                        for (int i = tokenIDArray.length - 1; i >= 0; --i) {
                            if (tokenID != tokenIDArray[i]) continue;
                            return;
                        }
                    }
                    object = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).findMatchingBlock(n - 1, this.fSimpleMatchBrace);
                    boolean bl3 = false;
                    boolean bl4 = false;
                    if (object != null) {
                        bl4 = true;
                    } else if (this.isEndDelimiter(cArray[0], n - 1) || this.isStartDelimiter(cArray[0], n - 1) && !bl) {
                        object = this.getDelimiterMisMatchMarkPositions(n, cArray[0]);
                        bl4 = true;
                        bl3 = true;
                    }
                    if (bl4) {
                        if (bl3) {
                            if (bl) {
                                if (this.fBeepOnMismatchKey) {
                                    this.doBeep();
                                    return;
                                }
                                if (this.fColoringMismatchOnKeyPressed.equals((Object)sBlankColoring)) {
                                    return;
                                }
                            } else {
                                if (this.fBeepOnMismatchMouse) {
                                    this.doBeep();
                                    return;
                                }
                                if (this.fColoringMismatchOnMouse.equals((Object)sBlankColoring)) {
                                    return;
                                }
                            }
                        }
                        if (!CodeFoldingUtilities.isWithinCollapsedFold(this.component, (int)object[0]) && !CodeFoldingUtilities.isWithinCollapsedFold(this.component, n)) {
                            this.drawNewMarks(bl, bl3, (int[])object, n);
                        }
                        this.fBraceMarksValid = true;
                        bl2 = true;
                    }
                }
                if (!bl2 && this.fBraceMarksValid) {
                    this.fBraceMarksValid = false;
                    if (this.fMarkBrace != null) {
                        this.fMarkBrace.repaint(editorUI);
                    }
                }
            }
            catch (BadLocationException badLocationException) {
                if (System.getProperty("netbeans.debug.exceptions") != null) {
                    badLocationException.printStackTrace();
                }
                this.fMatchBraceOnKeyOption = false;
            }
            catch (InvalidMarkException invalidMarkException) {
                if (System.getProperty("netbeans.debug.exceptions") != null) {
                    invalidMarkException.printStackTrace();
                }
                this.fMatchBraceOnKeyOption = false;
            }
        }
    }

    protected boolean isStartDelimiter(char c, int n) {
        return c == '(' || c == '{' || c == '[';
    }

    protected boolean isEndDelimiter(char c, int n) {
        return c == ')' || c == '}' || c == ']';
    }

    private boolean isSelection() {
        return this.getDot() - this.getMark() != 0;
    }

    private void updateSettings(Class clazz, EditorUI editorUI) {
        this.fMatchBraceOnKeyOption = SettingsUtil.getBoolean((Class)clazz, (String)"mw-highlight-match-brace", (Boolean)MWSettingsDefaults.defaultMWMatchBraceOnKeyOption);
        this.fMatchBraceOnArrowOption = SettingsUtil.getBoolean((Class)clazz, (String)"mw-highlight-match-brace-on-arrow", (Boolean)MWSettingsDefaults.defaultMWMatchBraceOnArrowOption);
        int n = SettingsUtil.getInteger((Class)clazz, (String)"mw-bracematch-key", (Integer)MWSettingsDefaults.defaultMWMatchBraceKeyAction);
        this.fColoringMatchOnKeyPressed = this.makeColoring(n);
        this.fBalanceWhileTyping = n == 3;
        int n2 = SettingsUtil.getInteger((Class)clazz, (String)"mw-bracemismatch-key", (Integer)MWSettingsDefaults.defaultMWMismatchBraceKeyAction);
        this.fColoringMismatchOnKeyPressed = this.makeColoring(n2);
        this.fBeepOnMismatchKey = n2 == 4;
        this.fColoringMatchOnMouse = this.makeColoring(SettingsUtil.getInteger((Class)clazz, (String)"mw-bracematch-arrow", (Integer)MWSettingsDefaults.defaultMWMatchBraceArrowAction));
        int n3 = SettingsUtil.getInteger((Class)clazz, (String)"mw-bracemismatch-arrow", (Integer)MWSettingsDefaults.defaultMWMismatchBraceArrowAction);
        this.fColoringMismatchOnMouse = this.makeColoring(n3);
        this.fBeepOnMismatchMouse = n3 == 4;
        this.fSimpleMatchBrace = SettingsUtil.getBoolean((Class)clazz, (String)"caret-simple-match-brace", (Boolean)MWSettingsDefaults.defaultCaretSimpleMatchBrace);
        if (this.fMatchBraceOnKeyOption || this.fMatchBraceOnArrowOption) {
            if (editorUI.findLayer(MW_BRACE_LAYER_NAME) == null) {
                editorUI.addLayer((DrawLayer)this.fHighlightBraceLayer, 11001);
            }
        } else if (editorUI.findLayer(MW_BRACE_LAYER_NAME) != null) {
            editorUI.removeLayer(MW_BRACE_LAYER_NAME);
        }
    }

    private void drawNewMarks(boolean bl, boolean bl2, int[] nArray, int n) {
        EditorUI editorUI = Utilities.getEditorUI((JTextComponent)this.component);
        BaseDocument baseDocument = (BaseDocument)this.component.getDocument();
        try {
            if (bl2) {
                this.doStartMisMatchTimer(nArray);
            } else {
                boolean bl3 = SettingsUtil.getBoolean((Class)Utilities.getKitClass((JTextComponent)this.component), (String)"line-number-visible", (boolean)MWSettingsDefaults.defaultShowLineNumbers);
                int n2 = bl3 ? Utilities.getLineOffset((BaseDocument)baseDocument, (int)nArray[0]) + 1 : -1;
                this.doTokenMatchPopup(nArray, bl, n2);
            }
            if (bl) {
                this.fCurrentColoring = bl2 ? this.fColoringMismatchOnKeyPressed : this.fColoringMatchOnKeyPressed;
            } else {
                Coloring coloring = this.fCurrentColoring = bl2 ? this.fColoringMismatchOnMouse : this.fColoringMatchOnMouse;
            }
            if (this.fMarkBrace == null) {
                this.fMarkBrace = new MarkPair(MW_BRACE_LAYER_NAME, editorUI, baseDocument);
                this.fMarkCaret = new MarkPair(MW_BRACE_LAYER_NAME, editorUI, baseDocument);
            }
            if (this.fBalanceWhileTyping && bl || bl2) {
                this.moveBothMarks(nArray[0], nArray[1]);
            } else if (nArray[1] == n - 1) {
                this.moveBothMarks(nArray[0], n);
            } else {
                this.moveAndRepaint(this.fMarkBrace, editorUI, nArray[0], nArray[1]);
                int[] nArray2 = this.getDelimiterMatchMarkPositions(n, nArray);
                this.moveAndRepaint(this.fMarkCaret, editorUI, nArray2[0], nArray2[1]);
            }
        }
        catch (BadLocationException badLocationException) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                badLocationException.printStackTrace();
            }
            this.fMatchBraceOnKeyOption = false;
        }
        catch (InvalidMarkException invalidMarkException) {
            if (System.getProperty("netbeans.debug.exceptions") != null) {
                invalidMarkException.printStackTrace();
            }
            this.fMatchBraceOnKeyOption = false;
        }
    }

    protected int[] getDelimiterMatchMarkPositions(int n, int[] nArray) {
        return new int[]{n - 1, n};
    }

    protected int[] getDelimiterMisMatchMarkPositions(int n, char c) {
        return new int[]{n - 1, n};
    }

    private void moveBothMarks(int n, int n2) throws BadLocationException, InvalidMarkException {
        this.fDelimiterMatchingController.moveBothMarks(n, n2);
    }

    private void moveAndRepaint(MarkPair markPair, EditorUI editorUI, int n, int n2) throws BadLocationException, InvalidMarkException {
        this.fDelimiterMatchingController.moveAndRepaint(markPair, editorUI, n, n2);
    }

    private void doStartMisMatchTimer(int[] nArray) {
        this.fDelimiterMatchingController.startTimer(this.component, new EditorTokenMatchListener(nArray));
    }

    private void doTokenMatchPopup(int[] nArray, boolean bl, int n) {
        boolean bl2 = bl ? EditorPrefsAccessor.getDelimMatchTypeWhileTyping() == 1 : EditorPrefsAccessor.getDelimMatchTypeWhileMousing() == 1;
        this.fDelimiterMatchingController.startTimerAndShowPopupIfNecessary(this.component, nArray, bl2, n, new EditorTokenMatchListener(nArray), this.fDelimiterMatchingTokenizer);
    }

    private void unHighlight(Rectangle rectangle) {
        if (this.fMarkBrace != null) {
            try {
                this.fCurrentColoring = sBlankColoring;
                this.fMarkCaret.repaint(Utilities.getEditorUI((JTextComponent)this.component), rectangle);
                this.fMarkBrace.repaint(Utilities.getEditorUI((JTextComponent)this.component), rectangle);
            }
            catch (BadLocationException badLocationException) {
                if (System.getProperty("netbeans.debug.exceptions") != null) {
                    badLocationException.printStackTrace();
                }
                this.fMatchBraceOnKeyOption = false;
            }
            catch (InvalidMarkException invalidMarkException) {
                if (System.getProperty("netbeans.debug.exceptions") != null) {
                    invalidMarkException.printStackTrace();
                }
                this.fMatchBraceOnKeyOption = false;
            }
        }
    }

    private void setDelimiterMatchingInterface(DelimiterMatchingController delimiterMatchingController) {
        this.fDelimiterMatchingController = delimiterMatchingController;
    }

    protected void setDelimiterMatchingTokenizer(Tokenizer tokenizer) {
        this.fDelimiterMatchingTokenizer = tokenizer;
    }

    private boolean isBraceMarkValid() {
        return this.fBraceMarksValid;
    }

    protected void doBeep() {
        Toolkit.getDefaultToolkit().beep();
    }

    private class EditorTokenMatchListener
    implements TokenMatchPopup.TokenMatchListener {
        private int[] iMatchPositions;

        private EditorTokenMatchListener(int[] nArray) {
            this.iMatchPositions = nArray;
        }

        @Override
        public void clearMatchIndications(Rectangle rectangle) {
            assert (SwingUtilities.isEventDispatchThread());
            if (MWCaret.this.fMarkBrace != null) {
                MWCaret.this.unHighlight(rectangle);
            }
        }

        @Override
        public void userClickedOnPopup() {
            MWCaret.this.component.select(this.iMatchPositions[0], this.iMatchPositions[1]);
        }
    }

    public static interface DelimiterMatchingController {
        public void startTimerAndShowPopupIfNecessary(JTextComponent var1, int[] var2, boolean var3, int var4, TokenMatchPopup.TokenMatchListener var5, Tokenizer var6);

        public void startTimer(JTextComponent var1, TokenMatchPopup.TokenMatchListener var2);

        public void moveBothMarks(int var1, int var2) throws BadLocationException, InvalidMarkException;

        public void moveAndRepaint(MarkPair var1, EditorUI var2, int var3, int var4) throws InvalidMarkException, BadLocationException;
    }

    private class DelimiterMatchingImpl
    implements DelimiterMatchingController {
        private DelimiterMatchingImpl() {
        }

        @Override
        public void startTimerAndShowPopupIfNecessary(JTextComponent jTextComponent, int[] nArray, boolean bl, int n, TokenMatchPopup.TokenMatchListener tokenMatchListener, Tokenizer tokenizer) {
            TokenMatchPopup.getInstance().startTimerAndShowPopupIfNecessary(jTextComponent, nArray, bl, n, tokenMatchListener, tokenizer);
        }

        @Override
        public void startTimer(JTextComponent jTextComponent, TokenMatchPopup.TokenMatchListener tokenMatchListener) {
            TokenMatchPopup.getInstance().startTimer(jTextComponent, tokenMatchListener);
        }

        @Override
        public void moveBothMarks(int n, int n2) throws BadLocationException, InvalidMarkException {
            EditorUI editorUI = Utilities.getEditorUI((JTextComponent)MWCaret.this.component);
            MWCaret.this.fMarkCaret.move(n, n2);
            MWCaret.this.fMarkBrace.moveAndRepaint(editorUI, n, n2);
        }

        @Override
        public void moveAndRepaint(MarkPair markPair, EditorUI editorUI, int n, int n2) throws InvalidMarkException, BadLocationException {
            markPair.moveAndRepaint(editorUI, n, n2);
        }
    }

    private class HighlightBraceLayer
    extends DrawLayer.AbstractLayer {
        private HighlightBraceLayer() {
            super(MWCaret.MW_BRACE_LAYER_NAME);
        }

        public boolean isActive(DrawContext drawContext, MarkFactory.DrawMark drawMark) {
            boolean bl = false;
            if (drawMark != null && MWCaret.this.fBraceMarksValid) {
                bl = drawMark.getActivateLayer();
            }
            return bl;
        }

        public void updateContext(DrawContext drawContext) {
            if (MWCaret.this.fCurrentColoring != null) {
                MWCaret.this.fCurrentColoring.apply(drawContext);
            }
        }
    }
}

