/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.mcode.variables;

import com.mathworks.mwswing.TextComponentUtils;
import com.mathworks.widgets.text.IndentingStyle;
import com.mathworks.widgets.text.STPBaseInterface;
import com.mathworks.widgets.text.SmartFormatter;
import com.mathworks.widgets.text.mcode.variables.HighlightEvent;
import com.mathworks.widgets.text.mcode.variables.Variable;
import com.mathworks.widgets.text.mcode.variables.VariableEvent;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightDataListener;
import com.mathworks.widgets.text.mcode.variables.VariableHighlightUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Timer;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.editor.BaseDocument;

public class VariableHighlightData {
    private static final int KEYSTROKE_DELAY = 1333;
    private static final int UPDATE_DELAY = 125;
    private final Timer fHighlightDelayTimer;
    private final Timer fClearDelayTimer;
    private final Timer fUpdateDelayTimer;
    private ActionListener fCurrentActionListener;
    private Variable fCurrentVariable;
    private Variable fLastVariable;
    private IndentingStyle fOldFormatingType;
    private Set<VariableHighlightDataListener> fVariableHighlightDataListeners = new HashSet<VariableHighlightDataListener>();
    private boolean fInRenamingMode = false;
    private boolean fCurrentlyRenaming = false;

    public VariableHighlightData() {
        this.fHighlightDelayTimer = new Timer(1333, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableHighlightData.this.highlightNow();
            }
        });
        this.fHighlightDelayTimer.setRepeats(false);
        this.fClearDelayTimer = new Timer(1333, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                VariableHighlightData.this.cancelHighlight();
            }
        });
        this.fClearDelayTimer.setRepeats(false);
        this.fUpdateDelayTimer = new Timer(125, null);
        this.fUpdateDelayTimer.setRepeats(false);
    }

    public VHDataCurrentState getCurrentState() {
        if (this.fUpdateDelayTimer.isRunning()) {
            this.fUpdateDelayTimer.stop();
            this.fCurrentActionListener.actionPerformed(null);
        }
        return new VHDataCurrentState(this.fInRenamingMode, this.fLastVariable != null ? this.fLastVariable.getText() : "", this.fCurrentVariable != null ? this.fCurrentVariable.getText() : "");
    }

    public void addVariableHighlightDataListener(VariableHighlightDataListener variableHighlightDataListener) {
        this.fVariableHighlightDataListeners.add(variableHighlightDataListener);
    }

    public void removeVariableHighlightDataListener(VariableHighlightDataListener variableHighlightDataListener) {
        this.fVariableHighlightDataListeners.remove(variableHighlightDataListener);
    }

    public void highlightNow() {
        this.highlightNow(false);
    }

    public void highlightNow(boolean bl) {
        if (this.fCurrentlyRenaming) {
            return;
        }
        this.cancelPendingClear();
        this.cancelPendingHighlight();
        this.fireAllClearHighlightListeners();
        if (!this.fInRenamingMode) {
            this.fireAllClearRenameListeners();
        }
        this.fireAllHighlightListeners(bl);
    }

    public void highlightLater() {
        this.cancelPendingClear();
        this.cancelPendingHighlight();
        this.setPendingHighlight();
    }

    public void cancelHighlight() {
        this.cancelPendingClear();
        this.cancelPendingHighlight();
        this.fireAllClearHighlightListeners();
        this.reset();
        this.fLastVariable = null;
        this.fireAllClearRenameListeners();
    }

    public void renameNow(STPBaseInterface sTPBaseInterface) {
        if (!this.fInRenamingMode) {
            return;
        }
        if (this.fLastVariable != null && this.fCurrentVariable != null) {
            this.fCurrentlyRenaming = true;
            this.fireAllRenameListeners();
            this.fCurrentlyRenaming = false;
        }
        this.reset();
        this.fLastVariable = null;
        this.updateNow(sTPBaseInterface, VariableHighlightEventType.OTHER, VariableHighlightPostAction.HIGHLIGHT_NOW);
    }

    private void executePostAction(VariableHighlightPostAction variableHighlightPostAction) {
        switch (variableHighlightPostAction) {
            case HIGHLIGHT_NOW: {
                this.highlightNow();
                break;
            }
            case HIGHLIGHT_NOW_UNCONDITIONAL: {
                this.highlightNow(true);
                break;
            }
            case CANCEL_HIGHLIGHT: {
                this.cancelHighlight();
                break;
            }
            case HIGHLIGHT_LATER: {
                this.highlightLater();
                break;
            }
            case NONE: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNow(STPBaseInterface sTPBaseInterface, VariableHighlightEventType variableHighlightEventType, VariableHighlightPostAction variableHighlightPostAction) {
        try {
            if (VariableHighlightData.isLastVariableInvalid(sTPBaseInterface, variableHighlightEventType, this.fLastVariable)) {
                this.fLastVariable = null;
            }
            if (this.fLastVariable != null) {
                this.fLastVariable.updatePositions(sTPBaseInterface);
            }
            boolean bl = variableHighlightEventType == VariableHighlightEventType.DOCUMENT_UPDATE;
            this.fCurrentVariable = new Variable(sTPBaseInterface, this.fLastVariable, bl);
            if (this.fCurrentVariable.hasSelectionBeyondVariable()) {
                this.fLastVariable = null;
            }
            if (!this.fCurrentVariable.isVariable() || sTPBaseInterface.getDocument().getLength() <= 0) {
                this.reset();
                this.fireAllClearRenameListeners();
                return;
            }
            if (this.fCurrentVariable.isRenaming()) {
                if (this.fOldFormatingType == null) {
                    SmartFormatter smartFormatter = (SmartFormatter)((BaseDocument)sTPBaseInterface.getDocument()).getFormatter();
                    this.fOldFormatingType = smartFormatter.getFormattingType();
                    smartFormatter.setFormattingType(IndentingStyle.NONE);
                }
                this.fInRenamingMode = true;
                this.highlightNow(true);
                return;
            }
            this.fInRenamingMode = false;
            this.fireAllClearRenameListeners();
            if (!bl) {
                this.fLastVariable = this.fCurrentVariable;
            }
        }
        finally {
            if (this.fOldFormatingType != null && !this.fInRenamingMode) {
                SmartFormatter smartFormatter = (SmartFormatter)((BaseDocument)sTPBaseInterface.getDocument()).getFormatter();
                smartFormatter.setFormattingType(this.fOldFormatingType);
                this.fOldFormatingType = null;
            }
            this.executePostAction(variableHighlightPostAction);
        }
    }

    public void update(final STPBaseInterface sTPBaseInterface, final VariableHighlightEventType variableHighlightEventType, VariableHighlightAction variableHighlightAction, final VariableHighlightPostAction variableHighlightPostAction) {
        if (((BaseDocument)sTPBaseInterface.getDocument()).isAtomicLock()) {
            return;
        }
        if (!VariableHighlightUtils.isActiveEditor(sTPBaseInterface)) {
            variableHighlightAction = VariableHighlightAction.NONE;
        }
        switch (variableHighlightAction) {
            case UPDATE_LATER: {
                this.clearUpdateActionListener();
                this.fCurrentActionListener = new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        VariableHighlightData.this.updateNow(sTPBaseInterface, variableHighlightEventType, variableHighlightPostAction);
                    }
                };
                this.fUpdateDelayTimer.addActionListener(this.fCurrentActionListener);
                this.fUpdateDelayTimer.restart();
                break;
            }
            case NONE: {
                this.clearUpdateActionListener();
                this.executePostAction(variableHighlightPostAction);
                break;
            }
            default: {
                this.clearUpdateActionListener();
                this.updateNow(sTPBaseInterface, variableHighlightEventType, variableHighlightPostAction);
            }
        }
    }

    private void clearUpdateActionListener() {
        this.fUpdateDelayTimer.stop();
        this.fUpdateDelayTimer.removeActionListener(this.fCurrentActionListener);
        this.fCurrentActionListener = null;
    }

    private static boolean isLastVariableInvalid(STPBaseInterface sTPBaseInterface, VariableHighlightEventType variableHighlightEventType, Variable variable) {
        boolean bl;
        block4: {
            if (variable == null) {
                return true;
            }
            try {
                if (variable.getLineNumber() != -1 && sTPBaseInterface.getLineFromPos(sTPBaseInterface.getCaretPosition()) != variable.getLineNumber()) {
                    return true;
                }
            }
            catch (BadLocationException badLocationException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError((Object)("The position should always be on a valid line: " + badLocationException));
            }
        }
        TextComponentUtils.FullIdentifier fullIdentifier = TextComponentUtils.getFullIdentifierAt((Document)sTPBaseInterface.getDocument(), (int)variable.getStartPosition(), (boolean)false);
        int n = sTPBaseInterface.getCaretPosition();
        boolean bl2 = bl = fullIdentifier != null && fullIdentifier.getIdentifier() != null && n >= fullIdentifier.getStartPosition() && n <= fullIdentifier.getStartPosition() + fullIdentifier.getIdentifier().length();
        return variableHighlightEventType == VariableHighlightEventType.MOUSE_CLICK && !bl;
    }

    private void reset() {
        this.fCurrentVariable = null;
        this.fInRenamingMode = false;
    }

    private void cancelPendingClear() {
        this.fClearDelayTimer.stop();
    }

    private void cancelPendingHighlight() {
        this.fHighlightDelayTimer.stop();
    }

    private void setPendingHighlight() {
        this.fHighlightDelayTimer.restart();
    }

    private void fireAllHighlightListeners(boolean bl) {
        if (this.fCurrentVariable == null || this.fLastVariable == null || this.fCurrentVariable.getOtherInstances().isEmpty()) {
            return;
        }
        HighlightEvent highlightEvent = new HighlightEvent(this, this.fInRenamingMode, this.fCurrentVariable, this.fLastVariable, bl);
        for (VariableHighlightDataListener variableHighlightDataListener : this.fVariableHighlightDataListeners) {
            variableHighlightDataListener.highlightReceived(highlightEvent);
        }
    }

    private void fireAllClearHighlightListeners() {
        for (VariableHighlightDataListener variableHighlightDataListener : this.fVariableHighlightDataListeners) {
            variableHighlightDataListener.clearHighlightRecieved();
        }
    }

    private void fireAllRenameListeners() {
        if (this.fCurrentVariable == null || this.fCurrentVariable.getOtherInstances().isEmpty()) {
            return;
        }
        VariableEvent variableEvent = new VariableEvent(this, this.fCurrentVariable);
        for (VariableHighlightDataListener variableHighlightDataListener : this.fVariableHighlightDataListeners) {
            variableHighlightDataListener.renameReceived(variableEvent);
        }
    }

    private void fireAllClearRenameListeners() {
        for (VariableHighlightDataListener variableHighlightDataListener : this.fVariableHighlightDataListeners) {
            variableHighlightDataListener.clearRenameReceived();
        }
    }

    public static class VHDataCurrentState {
        private final boolean fVariableRenaming;
        private final String fLastVariableName;
        private final String fCurrentVariableName;

        private VHDataCurrentState(boolean bl, String string, String string2) {
            this.fVariableRenaming = bl;
            this.fLastVariableName = string;
            this.fCurrentVariableName = string2;
        }

        public boolean isVariableRenaming() {
            return this.fVariableRenaming;
        }

        public String getLastVariableName() {
            return this.fLastVariableName;
        }

        public String getCurrentVariableName() {
            return this.fCurrentVariableName;
        }
    }

    public static enum VariableHighlightPostAction {
        CANCEL_HIGHLIGHT,
        HIGHLIGHT_NOW,
        HIGHLIGHT_NOW_UNCONDITIONAL,
        HIGHLIGHT_LATER,
        NONE;

    }

    public static enum VariableHighlightAction {
        UPDATE_LATER,
        UPDATE_NOW,
        NONE;

    }

    public static enum VariableHighlightEventType {
        DOCUMENT_UPDATE,
        MOUSE_CLICK,
        OTHER;

    }
}

