/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.text.xml;

import com.mathworks.matlab.api.editor.EditorLanguage;
import com.mathworks.matlab.api.editor.EditorLanguagePriority;
import com.mathworks.util.FileUtils;
import com.mathworks.widgets.text.EditorPreferences;
import com.mathworks.widgets.text.xml.XMLKit;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;

public class XMLLanguage
implements EditorLanguage {
    public static final EditorLanguage INSTANCE = new XMLLanguage();
    static final ResourceBundle BUNDLE = ResourceBundle.getBundle(XMLLanguage.class.getPackage().getName() + ".resources.RES_xml");

    public boolean isMatchingExtension(String string) {
        return FileUtils.isMatchingExtension((String)string, EditorPreferences.getFileExtensions(this));
    }

    public String getInternalName() {
        return "XML";
    }

    public List<String> getDefaultExtensions() {
        return Arrays.asList("xml", "xsl", "wsdl", "html", "htm", "shtml");
    }

    public EditorLanguagePriority getPriority() {
        return EditorLanguagePriority.COMMON;
    }

    public String getMimeType() {
        return "text/xml-MATLAB";
    }

    public String getName() {
        return "XML/HTML";
    }

    public String getDescription() {
        return BUNDLE.getString("description");
    }

    public XMLKit createDefaultKit() {
        return new XMLKit(){

            @Override
            public String getContentType() {
                return XMLLanguage.this.getMimeType();
            }

            @Override
            public boolean isModifiable() {
                return false;
            }
        };
    }
}

