/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.propertyeditor;

import com.mathworks.jmi.MatlabWorker;
import com.mathworks.mwswing.MJLabel;
import com.mathworks.mwswing.MJSlider;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.toolbox.testmeas.propertyeditor.BoundedConstraintValues;
import com.mathworks.toolbox.testmeas.propertyeditor.IPropertySetter;
import com.mathworks.toolbox.testmeas.propertyeditor.MLNumberUtil;
import com.mathworks.toolbox.testmeas.propertyeditor.Property;
import com.mathworks.toolbox.testmeas.propertyeditor.UIConstants;
import com.mathworks.toolbox.testmeas.propertyeditor.Widget;
import com.mathworks.toolbox.testmeas.tmswing.TMAbstractStyleGuideJPanel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.EventListener;
import java.util.Formatter;
import java.util.Hashtable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SliderWithTextFieldWidget
extends Widget {
    private MJSlider fSlider;
    private MJTextField fTextField;
    private int fDoubleMultiplier = 10;
    private volatile boolean fVetoFocusLost = false;

    public SliderWithTextFieldWidget(IPropertySetter iPropertySetter, Property property) {
        super(iPropertySetter, property);
    }

    @Override
    public void addContent(TMAbstractStyleGuideJPanel tMAbstractStyleGuideJPanel) {
        this.createSlider();
        this.fTextField = new MJTextField(UIConstants.TEXT_FIELD_WIDTH);
        this.fTextField.setName(this.getProperty().getName() + "textfield");
        this.updateSliderAndTextField(this.getProperty().getValue(), true);
        this.addSetListeners();
        JComponent[][] jComponentArray = new JComponent[][]{{this.fTextField, this.fSlider, null}};
        tMAbstractStyleGuideJPanel.addLine(jComponentArray, 0, 2);
    }

    @Override
    public void displayValue(Object object) {
        this.updateSliderAndTextField(object, false);
    }

    @Override
    public void enableWidget(boolean bl) {
        this.fSlider.setEnabled(bl);
        this.fTextField.setEnabled(bl);
    }

    @Override
    public void cleanup() {
        int n;
        ChangeListener[] changeListenerArray = this.fSlider.getChangeListeners();
        EventListener[] eventListenerArray = changeListenerArray;
        int n2 = eventListenerArray.length;
        for (n = 0; n < n2; ++n) {
            ChangeListener changeListener = eventListenerArray[n];
            this.fSlider.removeChangeListener(changeListener);
        }
        EventListener[] eventListenerArray2 = eventListenerArray = this.fTextField.getActionListeners();
        n = eventListenerArray2.length;
        for (int i = 0; i < n; ++i) {
            EventListener eventListener = eventListenerArray2[i];
            this.fTextField.removeActionListener((ActionListener)eventListener);
        }
        for (EventListener eventListener : eventListenerArray2 = this.fTextField.getFocusListeners()) {
            this.fTextField.removeFocusListener((FocusListener)eventListener);
        }
    }

    private void createSlider() {
        Serializable serializable;
        assert (this.getProperty().getConstraintValues() instanceof BoundedConstraintValues) : "Constraints should be bounded for slider widget.";
        BoundedConstraintValues boundedConstraintValues = (BoundedConstraintValues)this.getProperty().getConstraintValues();
        int n = ((Number)boundedConstraintValues.getLowerBound()).intValue();
        int n2 = ((Number)boundedConstraintValues.getUpperBound()).intValue();
        String string = String.valueOf(n);
        String string2 = String.valueOf(n2);
        if (this.isDoubleBound()) {
            serializable = (Double)boundedConstraintValues.getLowerBound();
            Double d = (Double)boundedConstraintValues.getUpperBound();
            double d2 = (Double)serializable - (double)((Double)serializable).intValue();
            double d3 = d - (double)d.intValue();
            double d4 = 1.0 / (double)this.fDoubleMultiplier;
            String string3 = String.valueOf(d2);
            int n3 = string3.substring(string3.indexOf(".")).length();
            string3 = String.valueOf(d3);
            int n4 = string3.substring(string3.indexOf(".")).length();
            if (boundedConstraintValues.isSmallBound() || d2 <= d4 || n3 > 1 || d3 <= d4 || n4 > 1) {
                this.fDoubleMultiplier = 1000000;
                n = (int)((Double)serializable * (double)this.fDoubleMultiplier);
                while ((double)n / ((double)this.fDoubleMultiplier * 1.0) < (Double)serializable) {
                    ++n;
                }
                n2 = (int)(d * (double)this.fDoubleMultiplier);
                while ((double)n2 / ((double)this.fDoubleMultiplier * 1.0) > d) {
                    --n2;
                }
                string = new Formatter().format("%.2f", serializable).toString();
                string2 = new Formatter().format("%.2f", d).toString();
            } else {
                n *= this.fDoubleMultiplier;
                n2 *= this.fDoubleMultiplier;
            }
        }
        this.fSlider = new MJSlider(n, n2, n);
        this.fSlider.setName(this.getProperty().getName() + "slider");
        serializable = new Hashtable();
        ((Hashtable)serializable).put(n, new JLabel(string));
        ((Hashtable)serializable).put(n2, new MJLabel(string2));
        if (n2 < Integer.MAX_VALUE) {
            this.fSlider.setPaintLabels(true);
            this.fSlider.setLabelTable((Dictionary)((Object)serializable));
        }
    }

    private void updateSliderAndTextField(final Object object, final boolean bl) {
        new MatlabWorker(){
            double doubleValue = -1.0;

            public Object runOnMatlabThread() throws Exception {
                String string = MLNumberUtil.getString(false, object);
                if (string == null || string.length() == 0) {
                    return string;
                }
                if (SliderWithTextFieldWidget.this.isDoubleBound()) {
                    this.doubleValue = MLNumberUtil.getDouble(string);
                    this.doubleValue *= (double)SliderWithTextFieldWidget.this.fDoubleMultiplier;
                } else {
                    this.doubleValue = MLNumberUtil.getInteger(string);
                    string = MLNumberUtil.getString(false, this.doubleValue);
                }
                return string;
            }

            public void runOnAWTEventDispatchThread(Object object2) {
                SliderWithTextFieldWidget.this.updateTextField((String)object2);
                if (bl && SliderWithTextFieldWidget.this.fTextField.getText().length() > 0) {
                    SliderWithTextFieldWidget.this.fTextField.setCaretPosition(0);
                }
                SliderWithTextFieldWidget.this.updateSlider((int)this.doubleValue);
            }
        }.start();
    }

    private void updateSlider(int n) {
        ChangeListener[] changeListenerArray;
        for (ChangeListener changeListener : changeListenerArray = this.fSlider.getChangeListeners()) {
            this.fSlider.removeChangeListener(changeListener);
        }
        this.fSlider.setValue(n);
        for (ChangeListener changeListener : changeListenerArray) {
            this.fSlider.addChangeListener(changeListener);
        }
    }

    private void updateTextField(String string) {
        ActionListener[] actionListenerArray = this.fTextField.getActionListeners();
        EventListener[] eventListenerArray = actionListenerArray;
        int n = eventListenerArray.length;
        for (int i = 0; i < n; ++i) {
            ActionListener actionListener = eventListenerArray[i];
            this.fTextField.removeActionListener(actionListener);
        }
        for (EventListener eventListener : eventListenerArray = this.fTextField.getFocusListeners()) {
            this.fTextField.removeFocusListener((FocusListener)eventListener);
        }
        this.fTextField.setText(string);
        for (EventListener eventListener : actionListenerArray) {
            this.fTextField.addActionListener((ActionListener)eventListener);
        }
        for (EventListener eventListener : eventListenerArray) {
            this.fTextField.addFocusListener((FocusListener)eventListener);
        }
        this.fVetoFocusLost = false;
    }

    private void addSetListeners() {
        this.fTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SliderWithTextFieldWidget.this.fVetoFocusLost = true;
                SliderWithTextFieldWidget.this.set(SliderWithTextFieldWidget.this.fTextField.getText(), (Component)SliderWithTextFieldWidget.this.fTextField);
            }
        });
        this.fTextField.addFocusListener((FocusListener)new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (SliderWithTextFieldWidget.this.fVetoFocusLost) {
                    return;
                }
                SliderWithTextFieldWidget.this.set(SliderWithTextFieldWidget.this.fTextField.getText(), (Component)SliderWithTextFieldWidget.this.fTextField);
            }
        });
        this.fSlider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                double d = SliderWithTextFieldWidget.this.fSlider.getValue();
                if (SliderWithTextFieldWidget.this.isDoubleBound()) {
                    d /= (double)SliderWithTextFieldWidget.this.fDoubleMultiplier;
                }
                if (!SliderWithTextFieldWidget.this.fSlider.getValueIsAdjusting()) {
                    SliderWithTextFieldWidget.this.set(d, (Component)SliderWithTextFieldWidget.this.fSlider);
                }
                String string = String.valueOf(d);
                if (!SliderWithTextFieldWidget.this.isDoubleBound()) {
                    string = String.valueOf((int)d);
                }
                SliderWithTextFieldWidget.this.updateTextField(string);
            }
        });
    }

    private boolean isDoubleBound() {
        return !((BoundedConstraintValues)this.getProperty().getConstraintValues()).isIntegerBound();
    }
}

