/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.toolbox.testmeas.tmswing.tree;

import com.jidesoft.tree.TreeUtils;
import com.mathworks.jmi.Callback;
import com.mathworks.mwswing.MJMenu;
import com.mathworks.mwswing.MJMenuItem;
import com.mathworks.mwswing.MJPopupMenu;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTree;
import com.mathworks.toolbox.testmeas.propertyeditor.TMNoMarginPanel;
import com.mathworks.toolbox.testmeas.tmswing.TMAbstractStyleGuideJPanel;
import com.mathworks.toolbox.testmeas.tmswing.tree.ClipboardEventData;
import com.mathworks.toolbox.testmeas.tmswing.tree.KeyPressedEventData;
import com.mathworks.toolbox.testmeas.tmswing.tree.MenuSelectedEventData;
import com.mathworks.toolbox.testmeas.tmswing.tree.Node;
import com.mathworks.toolbox.testmeas.tmswing.tree.NodeEditedEventData;
import com.mathworks.toolbox.testmeas.tmswing.tree.NodePathEventData;
import com.mathworks.toolbox.testmeas.tmswing.tree.StringCellEditor;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class TreePanel {
    private TMAbstractStyleGuideJPanel fPanel = new TMNoMarginPanel();
    private MJTree fTree = new MJTree();
    private MJPopupMenu fRightClickMenu = new MJPopupMenu();
    private TreeSelectionListener fTreeSelectionListener;
    private Icon fContainerIcon = null;
    private Icon fLeafIcon = null;
    private Callback fNodeSelectedCallback = new Callback();
    private Callback fKeyPressedCallback = new Callback();
    private Callback fNodeEditedCallback = new Callback();
    private Callback fMenuSelectedCallback = new Callback();
    private Callback fClipboardCallback = new Callback();
    private static final String BASE_IMAGE_PATH = "/com/mathworks/toolbox/testmeas/tmswing/tree/resources/";
    private static final Map<String, KeyStroke> CUT_COPY_PASTE_CONFIGURATION = new LinkedHashMap<String, KeyStroke>();

    public TreePanel(Node node, String string) {
        this.initializeTree(node);
        this.fTree.setName(string + ".Tree");
        this.fPanel.setName(string + ".Panel");
        this.fContainerIcon = new ImageIcon(this.getClass().getResource("/com/mathworks/toolbox/testmeas/tmswing/tree/resources/bus_object.png"));
    }

    public void setMenuNames(List<String> list, String string, String string2) {
        assert (list != null) : "Menu Names list cannot be null";
        this.fRightClickMenu.setName("TreeContextMenu");
        for (final String string3 : list) {
            if (string3.equals(string)) {
                this.fRightClickMenu.addSeparator();
                continue;
            }
            if (string3.equals(string2)) {
                if (list.indexOf(string3) != 0) {
                    this.fRightClickMenu.addSeparator();
                }
                this.addCutCopyPasteMenuItems();
                if (list.indexOf(string3) == list.size() - 1) continue;
                this.fRightClickMenu.addSeparator();
                continue;
            }
            MJMenuItem mJMenuItem = new MJMenuItem(string3);
            mJMenuItem.setName("TreeContextMenuItem." + string3);
            this.fRightClickMenu.add((JMenuItem)mJMenuItem);
            mJMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string = TreePanel.convertTreePathtoString(TreePanel.this.fTree.getSelectionPath());
                    TreePanel.this.fMenuSelectedCallback.postCallback(new Object[]{new MenuSelectedEventData(string, string3)});
                }
            });
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            private void showRightClickMenu(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                TreePath treePath = TreePanel.this.fTree.getPathForLocation(n, n2);
                if (treePath == null) {
                    return;
                }
                if (mouseEvent.isPopupTrigger()) {
                    TreePanel.this.fTree.setSelectionPath(treePath);
                    ArrayList<NodePathEventData> arrayList = new ArrayList<NodePathEventData>();
                    arrayList.add(new NodePathEventData(TreePanel.convertTreePathtoString(treePath)));
                    TreePanel.this.fNodeSelectedCallback.postCallback(new Object[]{arrayList});
                    TreePanel.this.fRightClickMenu.show((Component)TreePanel.this.fTree, n, n2);
                }
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.showRightClickMenu(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.showRightClickMenu(mouseEvent);
            }
        };
        this.fTree.addMouseListener((MouseListener)mouseAdapter);
    }

    public void addCascadingMenu(final String string, List<String> list) {
        assert (string != null) : "Menu name cannot be null";
        assert (list != null) : "Menu Names list cannot be null";
        for (int i = 0; i < this.fRightClickMenu.getComponentCount(); ++i) {
            MJMenuItem mJMenuItem;
            if (!(this.fRightClickMenu.getComponent(i) instanceof MJMenuItem) || !(mJMenuItem = (MJMenuItem)this.fRightClickMenu.getComponent(i)).getText().equals(string)) continue;
            this.fRightClickMenu.remove((Component)mJMenuItem);
            MJMenu mJMenu = new MJMenu(string);
            this.fRightClickMenu.add((Component)mJMenu, i);
            for (final String string2 : list) {
                MJMenuItem mJMenuItem2 = new MJMenuItem(string2);
                mJMenuItem2.setName("TreeContextMenuItem." + string2);
                mJMenu.add((JMenuItem)mJMenuItem2);
                mJMenuItem2.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        String string3 = TreePanel.convertTreePathtoString(TreePanel.this.fTree.getSelectionPath());
                        TreePanel.this.fMenuSelectedCallback.postCallback(new Object[]{new MenuSelectedEventData(string3, string + '.' + string2)});
                    }
                });
            }
        }
    }

    public void enableMenus(String[] stringArray, boolean[] blArray) {
        assert (stringArray != null) : "Menu Name cannot be null";
        assert (blArray != null) : "isEnabled cannot be null";
        for (Component component : this.fRightClickMenu.getComponents()) {
            if (!(component instanceof MJMenuItem)) continue;
            MJMenuItem mJMenuItem = (MJMenuItem)component;
            for (int i = 0; i < stringArray.length; ++i) {
                if (!mJMenuItem.getText().equals(stringArray[i])) continue;
                mJMenuItem.setEnabled(blArray[i]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedNodes(List list) {
        TreeModel treeModel = this.fTree.getModel();
        Node node = (Node)treeModel.getRoot();
        int n = 0;
        TreePath[] treePathArray = new TreePath[list.size()];
        for (Object e : list) {
            String string = (String)e;
            treePathArray[n++] = node.getTreePath(string.split("\\."));
        }
        try {
            this.fTree.removeTreeSelectionListener(this.fTreeSelectionListener);
            this.fTree.setSelectionPaths(treePathArray);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.fTree.addTreeSelectionListener(this.fTreeSelectionListener);
        }
    }

    public void addNode(String string, boolean bl) {
        String[] stringArray;
        TreeModel treeModel = this.fTree.getModel();
        Node node = (Node)treeModel.getRoot();
        String[] stringArray2 = string.split("\\.");
        if (stringArray2.length > 1) {
            stringArray = new String[stringArray2.length - 1];
            System.arraycopy(stringArray2, 0, stringArray, 0, stringArray2.length - 1);
            node = node.getChildAt(stringArray);
        }
        stringArray = new Node(stringArray2[stringArray2.length - 1], node, bl);
        node.insertChildAt(node.getChildCount(), (Node)stringArray);
        Enumeration enumeration = TreeUtils.saveExpansionStateByTreePath((JTree)this.fTree);
        ((DefaultTreeModel)this.fTree.getModel()).reload();
        TreeUtils.loadExpansionStateByTreePath((JTree)this.fTree, (Enumeration)enumeration);
    }

    public void deleteNode(String string) {
        TreeModel treeModel = this.fTree.getModel();
        Node node = (Node)treeModel.getRoot();
        Node node2 = node.getChildAt(string.split("\\."));
        ((Node)node2.getParent()).removeChild(node2);
        Enumeration enumeration = TreeUtils.saveExpansionStateByTreePath((JTree)this.fTree);
        ((DefaultTreeModel)this.fTree.getModel()).reload();
        TreeUtils.loadExpansionStateByTreePath((JTree)this.fTree, (Enumeration)enumeration);
    }

    public void deleteAllNodes() {
        TreeModel treeModel = this.fTree.getModel();
        Node node = (Node)treeModel.getRoot();
        node.removeAllChildren();
        ((DefaultTreeModel)this.fTree.getModel()).reload();
    }

    public void renameNode(String string, String string2) {
        TreeModel treeModel = this.fTree.getModel();
        Node node = (Node)treeModel.getRoot();
        Node node2 = node.getChildAt(string.split("\\."));
        String[] stringArray = string2.split("\\.");
        node2.setName(stringArray[stringArray.length - 1]);
        Enumeration enumeration = TreeUtils.saveExpansionStateByTreePath((JTree)this.fTree);
        ((DefaultTreeModel)this.fTree.getModel()).reload();
        TreeUtils.loadExpansionStateByTreePath((JTree)this.fTree, (Enumeration)enumeration);
    }

    public void setEditable(boolean bl) {
        this.fTree.setEditable(bl);
    }

    public void editNode(String string) {
        assert (this.fTree.isEditable()) : "Attempting to edit nodes of a non-editable tree.";
        TreeModel treeModel = this.fTree.getModel();
        Node node = (Node)treeModel.getRoot();
        TreePath treePath = node.getTreePath(string.split("\\."));
        this.fTree.startEditingAtPath(treePath);
    }

    public TMAbstractStyleGuideJPanel getPanel() {
        return this.fPanel;
    }

    public Callback getNodeSelectedCallback() {
        return this.fNodeSelectedCallback;
    }

    public Callback getKeyPressedCallback() {
        return this.fKeyPressedCallback;
    }

    public Callback getNodeEditedCallback() {
        return this.fNodeEditedCallback;
    }

    public Callback getMenuSelectedCallback() {
        return this.fMenuSelectedCallback;
    }

    public Callback getClipboardCallback() {
        return this.fClipboardCallback;
    }

    public void destroy() {
        for (int i = 0; i < this.fRightClickMenu.getComponentCount(); ++i) {
            ActionListener[] actionListenerArray;
            if (!(this.fRightClickMenu.getComponent(i) instanceof MJMenuItem)) continue;
            MJMenuItem mJMenuItem = (MJMenuItem)this.fRightClickMenu.getComponent(i);
            for (ActionListener actionListener : actionListenerArray = mJMenuItem.getActionListeners()) {
                mJMenuItem.removeActionListener(actionListener);
            }
        }
        this.fRightClickMenu.dispose();
        this.fTree.removeTreeSelectionListener(this.fTreeSelectionListener);
        this.fTree.setModel(null);
    }

    private void initializeTree(Node node) {
        this.fTree.setRootVisible(node.getName() != null);
        this.fTree.setShowsRootHandles(true);
        this.fTree.setEditable(true);
        this.fTree.setCellEditor((TreeCellEditor)new StringCellEditor());
        this.addTreeModel(node);
        this.addTreeSelectionListener();
        this.addKeyListener();
        TreeUtils.expandAll((JTree)this.fTree, (boolean)true);
        this.addTreeCellRenderer();
        MJScrollPane mJScrollPane = new MJScrollPane((Component)this.fTree);
        mJScrollPane.getViewport().setBackground(Color.WHITE);
        mJScrollPane.setVerticalScrollBarPolicy(20);
        mJScrollPane.setHorizontalScrollBarPolicy(30);
        mJScrollPane.setPreferredSize(new Dimension(200, 200));
        this.fPanel.addLine((JComponent)mJScrollPane, 8);
    }

    private void addTreeModel(Node node) {
        this.fTree.setModel((TreeModel)new DefaultTreeModel(node){

            @Override
            public void valueForPathChanged(TreePath treePath, Object object) {
                Node node = (Node)treePath.getLastPathComponent();
                String string = TreePanel.convertTreePathtoString(treePath);
                TreePanel.this.fNodeEditedCallback.postCallback(new Object[]{new NodeEditedEventData(string, node.getName(), (String)object)});
            }
        });
    }

    private void addTreeSelectionListener() {
        this.fTreeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                ArrayList<NodePathEventData> arrayList = new ArrayList<NodePathEventData>();
                if (TreePanel.this.fTree.getSelectionPaths() != null) {
                    for (TreePath treePath : TreePanel.this.fTree.getSelectionPaths()) {
                        arrayList.add(new NodePathEventData(TreePanel.convertTreePathtoString(treePath)));
                    }
                }
                TreePanel.this.fNodeSelectedCallback.postCallback(new Object[]{arrayList});
            }
        };
        this.fTree.addTreeSelectionListener(this.fTreeSelectionListener);
    }

    private void addTreeCellRenderer() {
        this.fTree.setCellRenderer((TreeCellRenderer)new DefaultTreeCellRenderer(){

            @Override
            public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
                super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
                if (((Node)object).isCanContainChildren()) {
                    this.setIcon(TreePanel.this.fContainerIcon);
                } else {
                    this.setIcon(TreePanel.this.fLeafIcon);
                }
                return this;
            }
        });
    }

    private void addKeyListener() {
        this.fTree.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                TreePath treePath = TreePanel.this.fTree.getSelectionModel().getSelectionPath();
                if (treePath == null) {
                    return;
                }
                String string = TreePanel.convertTreePathtoString(treePath);
                String string2 = KeyEvent.getKeyText(keyEvent.getKeyCode());
                if (keyEvent.isControlDown()) {
                    String string3 = "";
                    if (string2.equalsIgnoreCase("x")) {
                        string3 = "Cut";
                    } else if (string2.equalsIgnoreCase("c")) {
                        string3 = "Copy";
                    } else if (string2.equalsIgnoreCase("v")) {
                        string3 = "Paste";
                    }
                    if (string3.length() > 0) {
                        TreePanel.this.fClipboardCallback.postCallback(new Object[]{new ClipboardEventData(string, string3)});
                        return;
                    }
                }
                TreePanel.this.fKeyPressedCallback.postCallback(new Object[]{new KeyPressedEventData(string, keyEvent.getKeyChar(), string2, KeyEvent.getKeyModifiersText(keyEvent.getModifiers()), keyEvent.getKeyCode())});
            }
        });
    }

    private void addCutCopyPasteMenuItems() {
        for (Map.Entry<String, KeyStroke> entry : CUT_COPY_PASTE_CONFIGURATION.entrySet()) {
            final String string = entry.getKey();
            MJMenuItem mJMenuItem = new MJMenuItem(string);
            mJMenuItem.setName("TreeContextMenuItem." + string);
            mJMenuItem.setAccelerator(entry.getValue());
            this.fRightClickMenu.add((JMenuItem)mJMenuItem);
            mJMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String string2 = TreePanel.convertTreePathtoString(TreePanel.this.fTree.getSelectionPath());
                    TreePanel.this.fClipboardCallback.postCallback(new Object[]{new ClipboardEventData(string2, string)});
                }
            });
        }
    }

    private static String convertTreePathtoString(TreePath treePath) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = treePath.getPathCount();
        for (int i = 0; i < n; ++i) {
            Node node = (Node)treePath.getPathComponent(i);
            if (node.getName() == null) continue;
            stringBuilder.append(node).append(".");
        }
        return stringBuilder.toString().substring(0, stringBuilder.length() - 1);
    }

    static {
        CUT_COPY_PASTE_CONFIGURATION.put("Cut", KeyStroke.getKeyStroke(88, 2));
        CUT_COPY_PASTE_CONFIGURATION.put("Copy", KeyStroke.getKeyStroke(67, 2));
        CUT_COPY_PASTE_CONFIGURATION.put("Paste", KeyStroke.getKeyStroke(86, 2));
    }
}

