/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.register.impl;

import com.mathworks.comparisons.param.ComparisonParameter;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.param.impl.ComparisonParameterSetImpl;
import com.mathworks.comparisons.register.ComparisonDataType;
import com.mathworks.comparisons.register.ComparisonType;
import com.mathworks.comparisons.register.ComparisonTypeDeterminant;
import com.mathworks.comparisons.register.ComparisonTypeFeature;
import com.mathworks.comparisons.source.ComparisonSource;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;

public abstract class ComparisonTypeImpl
implements ComparisonType {
    private final String mDescription;
    private final ComparisonDataType mDataType;
    private final Set<ComparisonTypeDeterminant> mDeterminants = new HashSet<ComparisonTypeDeterminant>();
    private final Set<ComparisonTypeFeature> mFeatures = EnumSet.noneOf(ComparisonTypeFeature.class);
    private final ComparisonParameterSet mDefaultParameters = new ComparisonParameterSetImpl();

    protected ComparisonTypeImpl(String string, ComparisonDataType comparisonDataType) {
        this.mDescription = string;
        this.mDataType = comparisonDataType;
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    public String getDescription() {
        return this.mDescription;
    }

    @Override
    public ComparisonDataType getDataType() {
        return this.mDataType;
    }

    @Override
    public ComparisonDataType getParentDataType() {
        return this.mDataType.getParentDataType();
    }

    @Override
    public Collection<ComparisonTypeDeterminant> getDeterminants() {
        return Collections.unmodifiableCollection(this.mDeterminants);
    }

    @Override
    public boolean hasFeature(ComparisonTypeFeature comparisonTypeFeature) {
        return this.mFeatures.contains((Object)comparisonTypeFeature);
    }

    @Override
    public Collection<ComparisonParameter> getParameters() {
        return this.mDefaultParameters.getParameters();
    }

    @Override
    public ComparisonSource prepareForComparison(ComparisonSource comparisonSource) {
        return comparisonSource;
    }

    @Override
    public void prepareForComparison(ComparisonParameterSet comparisonParameterSet) {
        for (ComparisonParameter comparisonParameter : this.getParameters()) {
            if (comparisonParameterSet.hasParameter(comparisonParameter)) continue;
            comparisonParameterSet.setValue(comparisonParameter, this.mDefaultParameters.getValue(comparisonParameter));
        }
    }

    protected void addDeterminant(ComparisonTypeDeterminant comparisonTypeDeterminant) {
        this.mDeterminants.add(comparisonTypeDeterminant);
    }

    protected void addFeature(ComparisonTypeFeature comparisonTypeFeature) {
        this.mFeatures.add(comparisonTypeFeature);
    }

    protected void setDefaultParameter(ComparisonParameter comparisonParameter, Object object) {
        this.mDefaultParameters.setValue(comparisonParameter, object);
    }
}

