/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.comparisons.selection;

import com.mathworks.comparisons.param.ComparisonParameter;
import com.mathworks.comparisons.param.ComparisonParameterSet;
import com.mathworks.comparisons.param.impl.ComparisonParameterSetImpl;
import com.mathworks.comparisons.register.ComparisonType;
import com.mathworks.comparisons.selection.InvalidConversionException;
import com.mathworks.comparisons.selection.SelectionDataType;
import com.mathworks.comparisons.selection.SelectionPoliciesRegister;
import com.mathworks.comparisons.source.ComparisonSource;
import com.mathworks.comparisons.util.ResourceManager;
import java.util.Collection;

public class ComparisonSelection
implements ComparisonParameterSet {
    private final SelectionPoliciesRegister mSelectionPoliciesRegister;
    private final SingleSelection[] mSelections = new SingleSelection[]{new SingleSelection(), new SingleSelection()};
    private ComparisonType mComparisonType = null;
    private final ComparisonParameterSet mComparisonParameterSet = new ComparisonParameterSetImpl();

    public ComparisonSelection(SelectionPoliciesRegister selectionPoliciesRegister) {
        this.mSelectionPoliciesRegister = selectionPoliciesRegister;
    }

    public ComparisonSelection(ComparisonSource comparisonSource, ComparisonSource comparisonSource2) {
        this.mSelections[0].setComparisonSource(comparisonSource);
        this.mSelections[1].setComparisonSource(comparisonSource2);
        this.mSelectionPoliciesRegister = null;
    }

    public SelectionDataType getSelectionDataType(Index index) {
        return this.mSelections[index.ordinal()].getSelectionDataType();
    }

    public Object getSelection(Index index) {
        return this.mSelections[index.ordinal()].getSelection();
    }

    public <T> void setSelection(Index index, SelectionDataType<T> selectionDataType, T t) {
        if (this.mSelectionPoliciesRegister != null && this.mSelections[index.ordinal()].setSelection(selectionDataType, t)) {
            this.mComparisonType = null;
        }
    }

    public ComparisonSource getComparisonSource(Index index) {
        return this.mSelections[index.ordinal()].getComparisonSource();
    }

    public void convertToComparisonSource(Index index) throws InvalidConversionException {
        if (this.mSelectionPoliciesRegister != null && this.mSelections[index.ordinal()].convertToComparisonSource()) {
            this.mComparisonType = null;
        }
    }

    public ComparisonType getComparisonType() {
        return this.mComparisonType;
    }

    public void setComparisonType(ComparisonType comparisonType) {
        this.mComparisonType = comparisonType;
    }

    public void swap() {
        this.refresh();
        SingleSelection singleSelection = this.mSelections[0];
        this.mSelections[0] = this.mSelections[1];
        this.mSelections[1] = singleSelection;
    }

    public void refresh() {
        this.mSelections[0].refresh();
        this.mSelections[1].refresh();
    }

    public boolean hasSelection(Index index) {
        return this.mSelections[index.ordinal()].hasSelection();
    }

    public boolean hasComparisonSource(Index index) {
        return this.mSelections[index.ordinal()].hasComparisonSource();
    }

    public boolean hasSelections() {
        return this.mSelections[0].hasSelection() && this.mSelections[1].hasSelection();
    }

    public boolean hasComparisonSources() {
        return this.mSelections[0].hasComparisonSource() && this.mSelections[1].hasComparisonSource();
    }

    public boolean hasComparisonType() {
        return this.mComparisonType != null;
    }

    public boolean isSelectionReady() {
        return this.mSelections[0].hasComparisonSource() && this.mSelections[1].hasComparisonSource() && this.mComparisonType != null;
    }

    public void prepareForComparison() {
        if (this.isSelectionReady()) {
            this.mSelections[0].prepareSourceForComparison();
            this.mSelections[1].prepareSourceForComparison();
            this.mComparisonType.prepareForComparison(this.mComparisonParameterSet);
        }
    }

    @Override
    public synchronized void dispose() {
        this.mSelections[0].dispose();
        this.mSelections[1].dispose();
        this.mComparisonParameterSet.dispose();
        this.mComparisonType = null;
    }

    @Override
    public Collection<ComparisonParameter> getParameters() {
        return this.mComparisonParameterSet.getParameters();
    }

    @Override
    public boolean hasParameter(ComparisonParameter comparisonParameter) {
        return this.mComparisonParameterSet.hasParameter(comparisonParameter);
    }

    @Override
    public void removeParameter(ComparisonParameter comparisonParameter) {
        this.mComparisonParameterSet.removeParameter(comparisonParameter);
    }

    @Override
    public Object getValue(ComparisonParameter comparisonParameter) {
        return this.mComparisonParameterSet.getValue(comparisonParameter);
    }

    @Override
    public void setValue(ComparisonParameter comparisonParameter, Object object) {
        this.mComparisonParameterSet.setValue(comparisonParameter, object);
    }

    private class SingleSelection {
        private SelectionDataType mSelectionDataType = null;
        private Object mSelectionObject = null;
        private ComparisonSource mComparisonSource = null;
        private boolean mIsComparisonSourcePrepared = false;

        public <T> boolean setSelection(SelectionDataType<T> selectionDataType, T t) {
            assert (selectionDataType != null);
            boolean bl = false;
            if (t == null || selectionDataType.getApplicableType().isAssignableFrom(t.getClass()) || t.getClass().equals(String.class)) {
                if (this.mSelectionObject == null || !this.mSelectionObject.equals(t)) {
                    this.mComparisonSource = null;
                    this.mIsComparisonSourcePrepared = false;
                    this.mSelectionObject = t;
                    this.mSelectionDataType = selectionDataType;
                    bl = true;
                }
            } else {
                throw new IllegalArgumentException(ResourceManager.format("exception.incompatibleclasses", t.getClass().getName(), selectionDataType.getApplicableType().getName()));
            }
            return bl;
        }

        public SelectionDataType getSelectionDataType() {
            return this.mSelectionDataType;
        }

        public Object getSelection() {
            return this.mSelectionObject;
        }

        public boolean hasSelection() {
            return this.mSelectionObject != null;
        }

        public boolean convertToComparisonSource() throws InvalidConversionException {
            boolean bl = false;
            if (this.mComparisonSource == null && this.mSelectionObject != null) {
                this.mComparisonSource = ComparisonSelection.this.mSelectionPoliciesRegister.convertToComparisonSource(this.mSelectionDataType, this.mSelectionObject);
                bl = true;
            }
            return bl;
        }

        public ComparisonSource getComparisonSource() {
            return this.mComparisonSource;
        }

        public void setComparisonSource(ComparisonSource comparisonSource) {
            this.mComparisonSource = comparisonSource;
        }

        public void refresh() {
            if (this.mComparisonSource != null) {
                this.mComparisonSource.refresh();
            }
        }

        public void prepareSourceForComparison() {
            if (!this.mIsComparisonSourcePrepared) {
                this.mComparisonSource = ComparisonSelection.this.mComparisonType.prepareForComparison(this.mComparisonSource);
                this.mIsComparisonSourcePrepared = true;
            }
        }

        public boolean hasComparisonSource() {
            return this.mComparisonSource != null;
        }

        public void dispose() {
            if (this.mComparisonSource != null) {
                this.mComparisonSource.dispose();
                this.mComparisonSource = null;
                this.mIsComparisonSourcePrepared = false;
            }
            if (this.mSelectionDataType != null) {
                this.mSelectionDataType = null;
            }
            if (this.mSelectionObject != null) {
                this.mSelectionObject = null;
            }
        }
    }

    public static enum Index {
        FIRST,
        SECOND;

    }
}

