/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.page.plottool.propertyeditor.controls;

import com.mathworks.mwswing.MJComponent;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.ItemSelectable;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.HashSet;
import java.util.Set;

public abstract class AbstractPositionSelector
extends MJComponent
implements ItemSelectable {
    private Object fValue = null;
    private Set fRegions = new HashSet();
    private Set fActionLsnrs = new HashSet();
    private Set fItemLsnrs = new HashSet();
    private SelectableRegion fSelected = null;
    private SelectableRegion fRollover = null;
    private Dimension fSize;
    private final Rectangle fOuterRect;
    private final Rectangle fInnerRect;
    private final Color fItemColor = new Color(180, 180, 180);
    private final Color fOuterBkgndColor = new Color(235, 235, 235);
    private final Color fInnerBkgndColor = Color.white;
    private final Color fBorderColor = Color.black;
    private final Color fRolloverColor = new Color(50, 50, 50);

    public AbstractPositionSelector() {
        this.fSize = this.getOverallSize();
        this.fOuterRect = this.getOuterRect();
        this.fInnerRect = this.getInnerRect();
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                AbstractPositionSelector.this.onMousePressed(mouseEvent);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                AbstractPositionSelector.this.onMouseMoved(mouseEvent);
            }
        });
    }

    public abstract Dimension getOverallSize();

    public abstract Rectangle getOuterRect();

    public abstract Rectangle getInnerRect();

    public Object getSelectedItem() {
        return this.fValue;
    }

    public void setSelectedItem(Object object) {
        Object object2 = this.fValue;
        this.setSelectedItemWithoutEvents(object);
        this.fireSelectionEvents(object2, object);
        this.onValueChanged(object);
    }

    public void setSelectedItemWithoutEvents(Object object) {
        this.fSelected = null;
        this.fValue = object;
        if (object != null) {
            for (SelectableRegion selectableRegion : this.fRegions) {
                if (!object.equals(selectableRegion.getValue())) continue;
                this.fSelected = selectableRegion;
                this.fValue = object;
                break;
            }
        }
        this.repaint();
    }

    @Override
    public Object[] getSelectedObjects() {
        return new Object[]{this.fValue};
    }

    public void addActionListener(ActionListener actionListener) {
        this.fActionLsnrs.add(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.fActionLsnrs.remove(actionListener);
    }

    @Override
    public void addItemListener(ItemListener itemListener) {
        this.fItemLsnrs.add(itemListener);
    }

    @Override
    public void removeItemListener(ItemListener itemListener) {
        this.fItemLsnrs.remove(itemListener);
    }

    protected void fireSelectionEvents(Object object, Object object2) {
        Object object32;
        ActionEvent actionEvent = new ActionEvent(this, 1001, object2.toString());
        for (Object object32 : this.fActionLsnrs) {
            object32.actionPerformed(actionEvent);
        }
        object32 = new ItemEvent(this, 701, object2, 1);
        for (ItemListener itemListener : this.fItemLsnrs) {
            itemListener.itemStateChanged((ItemEvent)object32);
        }
    }

    protected void onMousePressed(MouseEvent mouseEvent) {
        for (SelectableRegion selectableRegion : this.fRegions) {
            if (!selectableRegion.getRect().contains(mouseEvent.getPoint())) continue;
            Object object = this.fValue;
            this.fSelected = selectableRegion;
            this.fValue = selectableRegion.getValue();
            this.repaint();
            this.fireSelectionEvents(object, this.fValue);
            this.onValueChanged(this.fValue);
            return;
        }
    }

    protected void onMouseMoved(MouseEvent mouseEvent) {
        for (SelectableRegion selectableRegion : this.fRegions) {
            if (!selectableRegion.getRect().contains(mouseEvent.getPoint())) continue;
            this.setToolTipText(selectableRegion.getLabel());
            this.fRollover = selectableRegion;
            this.repaint();
            return;
        }
        this.fRollover = null;
        this.repaint();
    }

    protected void onValueChanged(Object object) {
    }

    protected void addRegion(SelectableRegion selectableRegion) {
        if (selectableRegion != null) {
            this.fRegions.add(selectableRegion);
        }
    }

    public Dimension getPreferredSize() {
        return this.fSize;
    }

    public Dimension getMaximumSize() {
        return this.fSize;
    }

    public Dimension getMinimumSize() {
        return this.fSize;
    }

    public void paint(Graphics graphics) {
        if (this.fOuterRect == null || this.fInnerRect == null) {
            return;
        }
        graphics.setColor(this.fOuterBkgndColor);
        graphics.fillRect(this.fOuterRect.x, this.fOuterRect.y, this.fOuterRect.width, this.fOuterRect.height);
        graphics.setColor(this.fBorderColor);
        graphics.drawRect(this.fOuterRect.x, this.fOuterRect.y, this.fOuterRect.width, this.fOuterRect.height);
        graphics.setColor(this.fInnerBkgndColor);
        graphics.fillRect(this.fInnerRect.x, this.fInnerRect.y, this.fInnerRect.width, this.fInnerRect.height);
        graphics.setColor(this.fBorderColor);
        graphics.drawRect(this.fInnerRect.x, this.fInnerRect.y, this.fInnerRect.width, this.fInnerRect.height);
        for (SelectableRegion selectableRegion : this.fRegions) {
            Rectangle rectangle = selectableRegion.getRect();
            if (selectableRegion == this.fSelected) {
                graphics.setColor(this.fItemColor);
                graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                continue;
            }
            if (selectableRegion == this.fRollover) {
                graphics.setColor(this.fRolloverColor);
                graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                continue;
            }
            graphics.setColor(this.fItemColor);
            graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    class SelectableRegion {
        private final String fLabel;
        private final Object fValue;
        private final Rectangle fRect;

        public SelectableRegion(String string, Object object, Dimension dimension, int n, int n2) {
            this.fLabel = string;
            this.fValue = object;
            this.fRect = new Rectangle(n, n2, dimension.width, dimension.height);
        }

        public String getLabel() {
            return this.fLabel;
        }

        public Object getValue() {
            return this.fValue;
        }

        public Rectangle getRect() {
            return this.fRect;
        }
    }
}

