/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.discovery.internal;

import com.sun.jini.discovery.DatagramBufferFactory;
import com.sun.jini.discovery.internal.BaseProvider;
import com.sun.jini.discovery.internal.Plaintext;
import com.sun.jini.logging.Levels;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UTFDataFormatException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertPathBuilderException;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXCertPathBuilderResult;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.auth.Subject;
import javax.security.auth.x500.X500Principal;
import javax.security.auth.x500.X500PrivateCredential;
import net.jini.security.AuthenticationPermission;

class X500Provider
extends BaseProvider {
    private static final String NAME = "com.sun.jini.discovery.x500";
    private static final String JSSE = "javax.net.ssl";
    private static final int INT_LEN = 4;
    private static final Pattern hostPortPattern = Pattern.compile("^(.+):(\\d+?)$");
    static final Logger logger = Logger.getLogger("com.sun.jini.discovery.x500");
    protected final String signatureAlgorithm;
    protected final int maxSignatureLength;
    protected final String keyAlgorithm;
    protected final String keyAlgorithmOID;
    private KeyStore trustStore = null;
    private CertStore[] certStores = null;
    private final Object storeLock = new Object();
    static /* synthetic */ Class class$javax$security$auth$x500$X500Principal;
    static /* synthetic */ Class class$javax$security$auth$x500$X500PrivateCredential;

    X500Provider(String string, String string2, int n, String string3, String string4) throws NoSuchAlgorithmException {
        super(string);
        Signature.getInstance(string2);
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (string3 == null || string4 == null) {
            throw new NullPointerException();
        }
        this.signatureAlgorithm = string2;
        this.maxSignatureLength = n;
        this.keyAlgorithm = string3;
        this.keyAlgorithmOID = string4;
    }

    protected Certificate getCertificate(final X500Principal x500Principal) throws IOException, GeneralSecurityException {
        try {
            return (Certificate)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, GeneralSecurityException {
                    return X500Provider.this.getCertificate0(x500Principal);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Throwable throwable = privilegedActionException.getCause();
            if (throwable instanceof IOException) {
                throw (IOException)throwable;
            }
            throw (GeneralSecurityException)throwable;
        }
    }

    X500PrivateCredential[] getPrivateCredentials() {
        final AccessControlContext accessControlContext = AccessController.getContext();
        Collection[] collectionArray = (Collection[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Collection[] collectionArray;
                Subject subject = Subject.getSubject(accessControlContext);
                if (subject != null) {
                    Collection[] collectionArray2 = new Collection[2];
                    collectionArray2[0] = X500Provider.syncGetInstances(subject.getPrincipals(), class$javax$security$auth$x500$X500Principal == null ? (class$javax$security$auth$x500$X500Principal = X500Provider.class$("javax.security.auth.x500.X500Principal")) : class$javax$security$auth$x500$X500Principal);
                    collectionArray = collectionArray2;
                    collectionArray2[1] = X500Provider.syncGetInstances(subject.getPrivateCredentials(), class$javax$security$auth$x500$X500PrivateCredential == null ? (class$javax$security$auth$x500$X500PrivateCredential = X500Provider.class$("javax.security.auth.x500.X500PrivateCredential")) : class$javax$security$auth$x500$X500PrivateCredential);
                } else {
                    Collection[] collectionArray3 = new Collection[2];
                    collectionArray3[0] = Collections.EMPTY_SET;
                    collectionArray = collectionArray3;
                    collectionArray3[1] = Collections.EMPTY_SET;
                }
                return collectionArray;
            }
        });
        Collection collection = collectionArray[0];
        Collection collection2 = collectionArray[1];
        ArrayList<X500PrivateCredential> arrayList = new ArrayList<X500PrivateCredential>();
        Iterator iterator = collection2.iterator();
        while (iterator.hasNext()) {
            X500PrivateCredential x500PrivateCredential = (X500PrivateCredential)iterator.next();
            X509Certificate x509Certificate = x500PrivateCredential.getCertificate();
            try {
                X500Provider.checkCertificate(x509Certificate);
            }
            catch (CertificateException certificateException) {
                logger.log(Levels.HANDLED, "invalid certificate", certificateException);
                continue;
            }
            if (!this.keyAlgorithm.equals(x500PrivateCredential.getPrivateKey().getAlgorithm()) || !collection.contains(x509Certificate.getSubjectX500Principal())) continue;
            arrayList.add(x500PrivateCredential);
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "obtained private credentials {0}", new Object[]{arrayList});
        }
        return arrayList.toArray(new X500PrivateCredential[arrayList.size()]);
    }

    void checkAuthenticationPermission(X500Principal x500Principal, String string) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new AuthenticationPermission(Collections.singleton(x500Principal), null, string));
        }
    }

    boolean verify(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, PublicKey publicKey) throws SignatureException, InvalidKeyException {
        byteBuffer = X500Provider.ensureArrayBacking(byteBuffer);
        byteBuffer2 = X500Provider.ensureArrayBacking(byteBuffer2);
        Signature signature = this.getSignature();
        signature.initVerify(publicKey);
        signature.update(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
        return signature.verify(byteBuffer2.array(), byteBuffer2.arrayOffset() + byteBuffer2.position(), byteBuffer2.remaining());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Certificate getCertificate0(X500Principal x500Principal) throws IOException, GeneralSecurityException {
        PKIXCertPathBuilderResult pKIXCertPathBuilderResult;
        Object object = this.storeLock;
        synchronized (object) {
            if (this.trustStore == null) {
                this.initStores();
            }
        }
        object = new X509CertSelector();
        ((X509CertSelector)object).setSubject(x500Principal.getName());
        ((X509CertSelector)object).setSubjectPublicKeyAlgID(this.keyAlgorithmOID);
        ((X509CertSelector)object).setCertificateValid(new Date());
        ((X509CertSelector)object).setKeyUsage(new boolean[]{true});
        PKIXBuilderParameters pKIXBuilderParameters = new PKIXBuilderParameters(this.trustStore, (CertSelector)object);
        for (int i = 0; i < this.certStores.length; ++i) {
            pKIXBuilderParameters.addCertStore(this.certStores[i]);
        }
        try {
            pKIXCertPathBuilderResult = (PKIXCertPathBuilderResult)CertPathBuilder.getInstance("PKIX").build(pKIXBuilderParameters);
        }
        catch (CertPathBuilderException certPathBuilderException) {
            logger.log(Levels.HANDLED, "exception building certificate path", certPathBuilderException);
            return null;
        }
        List<? extends Certificate> list = pKIXCertPathBuilderResult.getCertPath().getCertificates();
        return list.isEmpty() ? pKIXCertPathBuilderResult.getTrustAnchor().getTrustedCert() : list.get(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initStores() throws IOException, GeneralSecurityException {
        String string;
        String string2;
        String string3 = System.getProperty("com.sun.jini.discovery.x500.trustStore");
        if (string3 != null) {
            string2 = System.getProperty("com.sun.jini.discovery.x500.trustStoreType", KeyStore.getDefaultType());
            string = System.getProperty("com.sun.jini.discovery.x500.trustStorePassword");
        } else {
            string3 = System.getProperty("javax.net.ssl.trustStore");
            if (string3 != null) {
                string2 = System.getProperty("javax.net.ssl.trustStoreType", KeyStore.getDefaultType());
                string = System.getProperty("javax.net.ssl.trustStorePassword");
            } else {
                string3 = System.getProperty("java.home") + "/lib/security/cacerts";
                string2 = KeyStore.getDefaultType();
                string = null;
            }
        }
        KeyStore keyStore = KeyStore.getInstance(string2);
        FileInputStream fileInputStream = new FileInputStream(string3);
        try {
            keyStore.load(fileInputStream, string != null ? string.toCharArray() : null);
        }
        finally {
            ((InputStream)fileInputStream).close();
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "loaded trust store from {0} ({1})", new Object[]{string3, string2});
        }
        String string4 = System.getProperty("com.sun.jini.discovery.x500.ldapCertStores");
        ArrayList<CertStore> arrayList = new ArrayList<CertStore>();
        if (string4 != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(string4, ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string5 = stringTokenizer.nextToken().trim();
                Matcher matcher = hostPortPattern.matcher(string5);
                try {
                    LDAPCertStoreParameters lDAPCertStoreParameters = matcher.matches() ? new LDAPCertStoreParameters(matcher.group(1), Integer.parseInt(matcher.group(2))) : new LDAPCertStoreParameters(string5);
                    arrayList.add(CertStore.getInstance("LDAP", lDAPCertStoreParameters));
                }
                catch (Exception exception) {
                    logger.log(Level.WARNING, "exception initializing cert store", exception);
                }
            }
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "using cert stores {0}", new Object[]{arrayList});
        }
        this.certStores = arrayList.toArray(new CertStore[arrayList.size()]);
        this.trustStore = keyStore;
    }

    private Signature getSignature() {
        try {
            return Signature.getInstance(this.signatureAlgorithm);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new AssertionError((Object)noSuchAlgorithmException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Collection syncGetInstances(Collection collection, Class clazz) {
        Collection collection2 = collection;
        synchronized (collection2) {
            ArrayList arrayList = new ArrayList(collection.size());
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                Object e = iterator.next();
                if (!clazz.isInstance(e)) continue;
                arrayList.add(e);
            }
            return arrayList;
        }
    }

    private static void checkCertificate(X509Certificate x509Certificate) throws CertificateException {
        x509Certificate.checkValidity();
        boolean[] blArray = x509Certificate.getKeyUsage();
        if (blArray != null && blArray.length > 0 && !blArray[0]) {
            throw new CertificateException("certificate not permitted for digital signatures: " + x509Certificate);
        }
    }

    private static ByteBuffer ensureArrayBacking(ByteBuffer byteBuffer) {
        return byteBuffer.hasArray() ? byteBuffer : ByteBuffer.allocate(byteBuffer.remaining()).put(byteBuffer);
    }

    class SigningBufferFactory
    implements DatagramBufferFactory {
        private final List buffers = new ArrayList();
        private final DatagramBufferFactory factory;
        private final byte[] principalName;
        private final Signature signature;

        SigningBufferFactory(DatagramBufferFactory datagramBufferFactory, X500PrivateCredential x500PrivateCredential) throws InvalidKeyException, UTFDataFormatException {
            this.factory = datagramBufferFactory;
            this.principalName = Plaintext.toUtf(x500PrivateCredential.getCertificate().getSubjectX500Principal().getName());
            this.signature = X500Provider.this.getSignature();
            this.signature.initSign(x500PrivateCredential.getPrivateKey());
        }

        public ByteBuffer newBuffer() {
            BufferInfo bufferInfo = new BufferInfo(this.factory.newBuffer());
            this.buffers.add(bufferInfo);
            return bufferInfo.getDataBuffer();
        }

        public void sign() throws SignatureException {
            Iterator iterator = this.buffers.iterator();
            while (iterator.hasNext()) {
                ((BufferInfo)iterator.next()).sign();
            }
        }

        private class BufferInfo {
            private final ByteBuffer buf;
            private final ByteBuffer data;
            private final boolean overflow;

            BufferInfo(ByteBuffer byteBuffer) {
                this.buf = byteBuffer;
                this.data = byteBuffer.duplicate();
                int n = SigningBufferFactory.this.principalName.length + ((SigningBufferFactory)SigningBufferFactory.this).X500Provider.this.maxSignatureLength;
                if (this.data.remaining() >= 4 + n) {
                    this.data.position(this.data.position() + 4);
                    this.data.limit(this.data.limit() - n);
                    this.overflow = false;
                } else {
                    this.data.limit(this.data.position());
                    this.overflow = true;
                }
            }

            ByteBuffer getDataBuffer() {
                return this.data;
            }

            void sign() throws SignatureException {
                if (this.overflow) {
                    throw new BufferOverflowException();
                }
                this.buf.putInt(this.data.position() - (this.buf.position() + 4));
                this.buf.position(this.data.position());
                this.buf.put(SigningBufferFactory.this.principalName);
                ByteBuffer byteBuffer = X500Provider.ensureArrayBacking((ByteBuffer)this.data.duplicate().flip());
                SigningBufferFactory.this.signature.update(byteBuffer.array(), byteBuffer.arrayOffset() + byteBuffer.position(), byteBuffer.remaining());
                this.buf.put(SigningBufferFactory.this.signature.sign());
            }
        }
    }
}

