/*
 * Decompiled with CFR 0.152.
 */
package net.jini.core.lookup;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;

public final class ServiceID
implements Serializable {
    private static final long serialVersionUID = -7803375959559762239L;
    private final long mostSig;
    private final long leastSig;

    public ServiceID(long l, long l2) {
        this.mostSig = l;
        this.leastSig = l2;
    }

    public ServiceID(DataInput dataInput) throws IOException {
        this.mostSig = dataInput.readLong();
        this.leastSig = dataInput.readLong();
    }

    public long getMostSignificantBits() {
        return this.mostSig;
    }

    public long getLeastSignificantBits() {
        return this.leastSig;
    }

    public void writeBytes(DataOutput dataOutput) throws IOException {
        dataOutput.writeLong(this.mostSig);
        dataOutput.writeLong(this.leastSig);
    }

    public int hashCode() {
        return (int)(this.mostSig >> 32 ^ this.mostSig ^ this.leastSig >> 32 ^ this.leastSig);
    }

    public boolean equals(Object object) {
        if (!(object instanceof ServiceID)) {
            return false;
        }
        ServiceID serviceID = (ServiceID)object;
        return this.mostSig == serviceID.mostSig && this.leastSig == serviceID.leastSig;
    }

    public String toString() {
        return ServiceID.digits(this.mostSig >> 32, 8) + "-" + ServiceID.digits(this.mostSig >> 16, 4) + "-" + ServiceID.digits(this.mostSig, 4) + "-" + ServiceID.digits(this.leastSig >> 48, 4) + "-" + ServiceID.digits(this.leastSig, 12);
    }

    private static String digits(long l, int n) {
        long l2 = 1L << n * 4;
        return Long.toHexString(l2 | l & l2 - 1L).substring(1);
    }
}

