/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer;

import com.mathworks.hg.peer.ActiveXCanvas;
import com.mathworks.hg.peer.BlockedOnPositionState;
import com.mathworks.hg.peer.FigureBoundsNotification;
import com.mathworks.hg.peer.FigureClient;
import com.mathworks.hg.peer.FigureHG2Client;
import com.mathworks.hg.peer.FigureHG2Mediator;
import com.mathworks.hg.peer.FigurePeer;
import com.mathworks.hg.peer.HG1WindowRectHandler;
import com.mathworks.hg.peer.HeavyweightLightweightContainerFactory;
import com.mathworks.hg.peer.JavaSceneServerPeer;
import com.mathworks.hg.peer.NoBlockOnResizeAndWindowStyleChangeState;
import com.mathworks.hg.peer.WindowRectHandler;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.hg.util.HGUtils;
import com.mathworks.widgets.desk.Desktop;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import javax.swing.SwingUtilities;

public class HG2FigurePeer
extends FigurePeer {
    public FigureHG2Client fHG2Client;

    public HG2FigurePeer() throws Throwable {
        this(null, 0);
    }

    public HG2FigurePeer(int n) throws Throwable {
        super(n);
    }

    public HG2FigurePeer(Desktop desktop, int n) throws Throwable {
        super(desktop, n);
    }

    @Override
    protected WindowRectHandler createWindowRectHandler() {
        return new HG1WindowRectHandler();
    }

    @Override
    protected FigureClient createFigureClient(Desktop desktop, String string, boolean bl, String string2, int n) {
        this.fHG2Client = new FigureHG2Mediator(desktop, string, bl, string2, this);
        return this.fHG2Client;
    }

    @Override
    public void addSceneServerPeer(final JavaSceneServerPeer javaSceneServerPeer) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 24, 0, false){

            @Override
            public void run() {
                HG2FigurePeer.this.fHG2Client.addSceneServerPeer(javaSceneServerPeer);
            }
        });
    }

    @Override
    public void setBackgroundColor(final Color color) {
        HGUtils.invokeLater(new HGPeerRunnable(this, 25, 7){

            @Override
            public void run() {
                HG2FigurePeer.this.fHG2Client.setBackgroundColor(color);
            }
        });
    }

    @Override
    protected ActiveXCanvas getActiveXCanvasImpl() {
        ActiveXCanvas activeXCanvas = HeavyweightLightweightContainerFactory.getActiveXContainer(this);
        this.addActiveXControl(activeXCanvas);
        return activeXCanvas;
    }

    @Override
    protected void createHWNDForActiveXImpl(ActiveXCanvas activeXCanvas) {
        if (activeXCanvas.getNativeWindowHandle() == 0L) {
            this.doCreateFigureHidden();
        }
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
    }

    @Override
    public BlockedOnPositionState createBlockedOnPositionState() {
        return new NoBlockOnResizeAndWindowStyleChangeState();
    }

    @Override
    public void clearWaitForResize(boolean bl, boolean bl2) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Must call this method from the MATLAB thread";
        this.fBlockedOnPositionState.clearWaitForResize(bl, bl2);
    }

    @Override
    public void setWaitForResize(boolean bl) {
        this.fBlockedOnPositionState.setWaitForResize(bl);
    }

    @Override
    public boolean getWaitForResize() {
        Rectangle rectangle;
        Rectangle rectangle2;
        boolean bl = this.fBlockedOnPositionState.getWaitForResize();
        if (bl && (rectangle2 = this.fWindowRectHandler.getBounds()).equals(rectangle = this.fWindowRectHandler.getBounds(true))) {
            this.fBlockedOnPositionState.stopWaiting();
        }
        return bl;
    }

    @Override
    public boolean getWaitForWindowStyle() {
        return this.fBlockedOnPositionState.getWaitForWindowStyle();
    }

    @Override
    protected void handleFigureBoundsNotification(FigureBoundsNotification figureBoundsNotification) {
        Rectangle rectangle = figureBoundsNotification.getInnerBounds();
        Rectangle rectangle2 = figureBoundsNotification.getOuterBounds();
        if (rectangle2.isEmpty() || rectangle.isEmpty()) {
            return;
        }
        this.handleFigureBoundsNotificationHelper(false, false, rectangle2, rectangle);
    }
}

