/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.peer.ui.borders;

import com.mathworks.hg.peer.ui.borders.BorderWithThickness;
import com.mathworks.util.PlatformInfo;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;

public class TitledBorder
extends AbstractBorder {
    protected String title;
    protected Border border;
    protected int titlePosition;
    protected int titleJustification;
    protected Font titleFont;
    protected Color titleColor;
    private Insets fGrooveInsets;
    private Point textLoc = new Point();
    public static final int DEFAULT_POSITION = 0;
    public static final int ABOVE_TOP = 1;
    public static final int TOP = 2;
    public static final int BELOW_TOP = 3;
    public static final int ABOVE_BOTTOM = 4;
    public static final int BOTTOM = 5;
    public static final int BELOW_BOTTOM = 6;
    public static final int DEFAULT_JUSTIFICATION = 0;
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int LEADING = 4;
    public static final int TRAILING = 5;
    protected static final int EDGE_SPACING = 0;
    protected static final int TEXT_SPACING = 0;
    protected static final int TEXT_INSET_H = 5;

    public TitledBorder(String string) {
        this(null, string, 4, 2, null, null);
    }

    public TitledBorder(Border border) {
        this(border, "", 4, 2, null, null);
    }

    public TitledBorder(Border border, String string) {
        this(border, string, 4, 2, null, null);
    }

    public TitledBorder(Border border, String string, int n, int n2) {
        this(border, string, n, n2, null, null);
    }

    public TitledBorder(Border border, String string, int n, int n2, Font font) {
        this(border, string, n, n2, font, null);
    }

    public TitledBorder(Border border, String string, int n, int n2, Font font, Color color) {
        this.title = string;
        this.border = border;
        this.titleFont = font;
        this.titleColor = color;
        this.fGrooveInsets = new Insets(0, 0, 0, 0);
        this.setTitleJustification(n);
        this.setTitlePosition(n2);
    }

    public static FontMetrics getFontMetrics(JComponent jComponent, Graphics graphics) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String string = TitledBorder.getSwingUtilitiesClassName();
        Class<?> clazz = Class.forName(string);
        Object[] objectArray = new Object[]{jComponent, graphics};
        Method method = clazz.getMethod("getFontMetrics", JComponent.class, Graphics.class);
        FontMetrics fontMetrics = (FontMetrics)method.invoke(null, objectArray);
        return fontMetrics;
    }

    public static int stringWidth(JComponent jComponent, FontMetrics fontMetrics, String string) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String string2 = TitledBorder.getSwingUtilitiesClassName();
        Class<?> clazz = Class.forName(string2);
        Object[] objectArray = new Object[]{jComponent, fontMetrics, string};
        Method method = clazz.getMethod("stringWidth", JComponent.class, FontMetrics.class, String.class);
        int n = (Integer)method.invoke(null, objectArray);
        return n;
    }

    public static void drawString(JComponent jComponent, Graphics graphics, String string, int n, int n2) throws ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String string2 = TitledBorder.getSwingUtilitiesClassName();
        Class<?> clazz = Class.forName(string2);
        Object[] objectArray = new Object[]{jComponent, graphics, string, n, n2};
        Method method = clazz.getMethod("drawString", JComponent.class, Graphics.class, String.class, Integer.TYPE, Integer.TYPE);
        method.invoke(null, objectArray);
    }

    private static String getSwingUtilitiesClassName() {
        String string = PlatformInfo.isVersion15() ? "com.sun.java.swing.SwingUtilities2" : "sun.swing.SwingUtilities2";
        return string;
    }

    @Override
    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8;
        JComponent jComponent;
        Color color;
        Font font;
        Rectangle rectangle;
        Border border;
        block38: {
            border = this.getBorder();
            if (this.getTitle() == null || this.getTitle().equals("")) {
                if (border != null) {
                    border.paintBorder(component, graphics, n, n2, n3, n4);
                }
                return;
            }
            rectangle = new Rectangle(n + 0, n2 + 0, n3 - 0, n4 - 0);
            font = graphics.getFont();
            color = graphics.getColor();
            graphics.setFont(this.getFont(component));
            jComponent = component instanceof JComponent ? (JComponent)component : null;
            FontMetrics fontMetrics = null;
            try {
                fontMetrics = TitledBorder.getFontMetrics(jComponent, graphics);
            }
            catch (Exception exception) {
                throw new Error("Has JVM changed? Unable to get font metrics");
            }
            n8 = fontMetrics.getHeight();
            n7 = fontMetrics.getDescent();
            n6 = fontMetrics.getAscent();
            n5 = 0;
            try {
                n5 = TitledBorder.stringWidth(jComponent, fontMetrics, this.getTitle());
            }
            catch (Exception exception) {
                if ($assertionsDisabled || n5 != 0) break block38;
                throw new AssertionError();
            }
        }
        Insets insets = border != null ? border.getBorderInsets(component) : new Insets(0, 0, 0, 0);
        int n9 = this.getTitlePosition();
        switch (n9) {
            case 1: {
                int n10 = n6 + n7 + (Math.max(0, 0) - 0);
                rectangle.y += n10;
                rectangle.height -= n10;
                this.textLoc.y = rectangle.y - (n7 + 0);
                break;
            }
            case 0: 
            case 2: {
                int n11 = this.isBorderWidthLessThanFontHeight(n8) ? Math.max(0, n6 / 2 + 0 - 0) : 0;
                rectangle.y += n11;
                rectangle.height -= n11;
                this.textLoc.y = rectangle.y - n7 + (insets.top + n6 + n7) / 2;
                this.updateGrooveInsets(component, n4, rectangle);
                break;
            }
            case 3: {
                this.textLoc.y = rectangle.y + insets.top + n6 + 0;
                break;
            }
            case 4: {
                this.textLoc.y = rectangle.y + rectangle.height - (insets.bottom + n7 + 0);
                break;
            }
            case 5: {
                rectangle.height = rectangle.height - (this.isBorderWidthLessThanFontHeight(n8) ? n8 / 2 : 0);
                this.textLoc.y = rectangle.y + rectangle.height - n7 + (n6 + n7 - insets.bottom) / 2;
                this.updateGrooveInsets(component, n4, rectangle);
                break;
            }
            case 6: {
                rectangle.height -= n8;
                this.textLoc.y = rectangle.y + rectangle.height + n6 + 0;
            }
        }
        int n12 = this.getTitleJustification();
        if (component.getComponentOrientation().isLeftToRight()) {
            if (n12 == 4 || n12 == 0) {
                n12 = 1;
            } else if (n12 == 5) {
                n12 = 3;
            }
        } else if (n12 == 4 || n12 == 0) {
            n12 = 3;
        } else if (n12 == 5) {
            n12 = 1;
        }
        switch (n12) {
            case 1: {
                this.textLoc.x = rectangle.x + 5 + insets.left;
                break;
            }
            case 3: {
                this.textLoc.x = rectangle.x + rectangle.width - (n5 + 5 + insets.right);
                break;
            }
            case 2: {
                this.textLoc.x = rectangle.x + (rectangle.width - n5) / 2;
            }
        }
        if (border != null) {
            if ((n9 == 2 || n9 == 0) && rectangle.y > this.textLoc.y - n6 || n9 == 5 && rectangle.y + rectangle.height < this.textLoc.y + n7) {
                Rectangle rectangle2 = new Rectangle();
                Rectangle rectangle3 = graphics.getClipBounds();
                rectangle2.setBounds(rectangle3);
                if (TitledBorder.computeIntersection(rectangle2, n, n2, this.textLoc.x - 1 - n, n4)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                rectangle2.setBounds(rectangle3);
                if (TitledBorder.computeIntersection(rectangle2, this.textLoc.x + n5 + 1, n2, n + n3 - (this.textLoc.x + n5 + 1), n4)) {
                    graphics.setClip(rectangle2);
                    border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                if (n9 == 2 || n9 == 0) {
                    rectangle2.setBounds(rectangle3);
                    if (TitledBorder.computeIntersection(rectangle2, this.textLoc.x - 1, this.textLoc.y + n7, n5 + 2, n2 + n4 - this.textLoc.y - n7)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                } else {
                    rectangle2.setBounds(rectangle3);
                    if (TitledBorder.computeIntersection(rectangle2, this.textLoc.x - 1, n2, n5 + 2, this.textLoc.y - n6 - n2)) {
                        graphics.setClip(rectangle2);
                        border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    }
                }
                graphics.setClip(rectangle3);
            } else {
                border.paintBorder(component, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
        }
        graphics.setColor(this.getTitleColor());
        try {
            TitledBorder.drawString(jComponent, graphics, this.getTitle(), this.textLoc.x, this.textLoc.y);
        }
        catch (Exception exception) {
            throw new DrawStringException("Unable to draw the title in TitledBorder.java: (" + exception + ") " + exception.getMessage());
        }
        graphics.setFont(font);
        graphics.setColor(color);
    }

    private void updateGrooveInsets(Component component, int n, Rectangle rectangle) {
        int n2 = this.getTitlePosition();
        this.fGrooveInsets = new Insets(0, 0, 0, 0);
        switch (n2) {
            case 0: 
            case 2: {
                if (rectangle.y <= 0) break;
                this.fGrooveInsets.top += rectangle.y;
                break;
            }
            case 5: {
                if (n - rectangle.height <= 0) break;
                this.fGrooveInsets.bottom = n - rectangle.height;
            }
        }
        component.doLayout();
    }

    @Override
    public Insets getBorderInsets(Component component) {
        return this.getBorderInsets(component, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component component, Insets insets) {
        Serializable serializable;
        int n = 0;
        int n2 = 16;
        int n3 = 16;
        Border border = this.getBorder();
        if (border != null) {
            if (border instanceof AbstractBorder) {
                insets = ((AbstractBorder)border).getBorderInsets(component, insets);
            } else {
                serializable = border.getBorderInsets(component);
                insets.top = serializable.top;
                insets.right = serializable.right;
                insets.bottom = serializable.bottom;
                insets.left = serializable.left;
            }
        } else {
            insets.bottom = 0;
            insets.right = 0;
            insets.top = 0;
            insets.left = 0;
        }
        insets.left += 0;
        insets.right += 0;
        insets.top += 0;
        insets.bottom += 0;
        if (component == null || this.getTitle() == null || this.getTitle().equals("")) {
            return insets;
        }
        serializable = this.getFont(component);
        FontMetrics fontMetrics = component.getFontMetrics((Font)serializable);
        if (fontMetrics != null) {
            n = fontMetrics.getDescent();
            n2 = fontMetrics.getAscent();
            n3 = fontMetrics.getHeight();
        }
        switch (this.getTitlePosition()) {
            case 1: {
                insets.top += n2 + n + (Math.max(0, 0) - 0);
                break;
            }
            case 0: 
            case 2: {
                insets.top = this.isBorderWidthLessThanFontHeight(n3) ? this.fGrooveInsets.top + n2 + n : insets.top;
                break;
            }
            case 3: {
                insets.top += n2 + n + 0;
                break;
            }
            case 4: {
                insets.bottom += n2 + n + 0;
                break;
            }
            case 5: {
                insets.bottom = this.isBorderWidthLessThanFontHeight(n3) ? this.fGrooveInsets.bottom + n2 + n : insets.bottom;
                break;
            }
            case 6: {
                insets.bottom += n3;
            }
        }
        return insets;
    }

    private boolean isBorderWidthLessThanFontHeight(int n) {
        Border border = this.getBorder();
        int n2 = 0;
        if (border instanceof BorderWithThickness) {
            n2 = ((BorderWithThickness)((Object)border)).getThickness();
        }
        return n2 < n;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    public String getTitle() {
        return this.title;
    }

    public Border getBorder() {
        Border border = this.border;
        if (border == null) {
            border = UIManager.getBorder("TitledBorder.border");
        }
        return border;
    }

    public int getTitlePosition() {
        return this.titlePosition;
    }

    public int getTitleJustification() {
        return this.titleJustification;
    }

    public Font getTitleFont() {
        Font font = this.titleFont;
        if (font == null) {
            font = UIManager.getFont("TitledBorder.font");
        }
        return font;
    }

    public Color getTitleColor() {
        Color color = this.titleColor;
        if (color == null) {
            color = UIManager.getColor("TitledBorder.titleColor");
        }
        return color;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public void setBorder(Border border) {
        this.border = border;
    }

    public void setTitlePosition(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.titlePosition = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid title position.");
            }
        }
    }

    public void setTitleJustification(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                this.titleJustification = n;
                break;
            }
            default: {
                throw new IllegalArgumentException(n + " is not a valid title justification.");
            }
        }
    }

    public void setTitleFont(Font font) {
        this.titleFont = font;
    }

    public void setTitleColor(Color color) {
        this.titleColor = color;
    }

    public Dimension getMinimumSize(Component component) {
        Insets insets = this.getBorderInsets(component);
        Dimension dimension = new Dimension(insets.right + insets.left, insets.top + insets.bottom);
        Font font = this.getFont(component);
        FontMetrics fontMetrics = component.getFontMetrics(font);
        JComponent jComponent = component instanceof JComponent ? (JComponent)component : null;
        switch (this.titlePosition) {
            case 1: 
            case 6: {
                try {
                    dimension.width = Math.max(TitledBorder.stringWidth(jComponent, fontMetrics, this.getTitle()), dimension.width);
                    break;
                }
                catch (Exception exception) {
                    throw new Error("Has JVM changed? Unable to calculate the string width");
                }
            }
            default: {
                try {
                    dimension.width += TitledBorder.stringWidth(jComponent, fontMetrics, this.getTitle());
                    break;
                }
                catch (Exception exception) {
                    throw new Error("Has JVM changed? Unable to calculate the string width");
                }
            }
        }
        return dimension;
    }

    protected Font getFont(Component component) {
        Font font = this.getTitleFont();
        if (font != null) {
            return font;
        }
        if (component != null && (font = component.getFont()) != null) {
            return font;
        }
        return new Font("Dialog", 0, 12);
    }

    private static boolean computeIntersection(Rectangle rectangle, int n, int n2, int n3, int n4) {
        int n5 = Math.max(n, rectangle.x);
        int n6 = Math.min(n + n3, rectangle.x + rectangle.width);
        int n7 = Math.max(n2, rectangle.y);
        int n8 = Math.min(n2 + n4, rectangle.y + rectangle.height);
        rectangle.x = n5;
        rectangle.y = n7;
        rectangle.width = n6 - n5;
        rectangle.height = n8 - n7;
        return rectangle.width > 0 && rectangle.height > 0;
    }

    public class DrawStringException
    extends RuntimeException {
        DrawStringException(String string) {
            super(string);
        }
    }
}

