/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.uij;

import com.mathworks.hg.uij.TextureMap;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;

public class Texture2DPaint
implements Paint {
    private Point2D fVertex0;
    private Point2D fVertex1;
    private Point2D fVertex2;
    private Point2D fTCoords0;
    private Point2D fTCoords1;
    private Point2D fTCoords2;
    private float fQ0;
    private float fQ1;
    private float fQ2;
    private TextureMap fTexture = null;
    private boolean fOpaque = true;
    private boolean fIsLine;

    public Texture2DPaint(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, float f11, float f12, float f13, float f14, float f15, TextureMap textureMap) {
        this.fVertex0 = new Point2D.Float(f, f2);
        this.fVertex1 = new Point2D.Float(f6, f7);
        this.fVertex2 = new Point2D.Float(f11, f12);
        this.fTCoords0 = new Point2D.Float(f3 * f5, f4 * f5);
        this.fTCoords1 = new Point2D.Float(f8 * f10, f9 * f10);
        this.fTCoords2 = new Point2D.Float(f13 * f15, f14 * f15);
        this.fQ0 = f5;
        this.fQ1 = f10;
        this.fQ2 = f15;
        this.fTexture = textureMap;
        this.fIsLine = false;
        this.checkTransparency();
    }

    public Texture2DPaint(float f, float f2, float f3, float f4, float f5, float f6, float f7, float f8, float f9, float f10, TextureMap textureMap) {
        this.fVertex0 = new Point2D.Float(f, f2);
        this.fVertex1 = new Point2D.Float(f6, f7);
        this.fTCoords0 = new Point2D.Float(f3 * f5, f4 * f5);
        this.fTCoords1 = new Point2D.Float(f8 * f10, f9 * f10);
        this.fQ0 = f5;
        this.fQ1 = f10;
        this.fTexture = textureMap;
        this.fIsLine = true;
        this.checkTransparency();
    }

    private void checkTransparency() {
        this.fOpaque = this.fTexture.isTransparent();
    }

    @Override
    public PaintContext createContext(ColorModel colorModel, Rectangle rectangle, Rectangle2D rectangle2D, AffineTransform affineTransform, RenderingHints renderingHints) {
        Point2D point2D = affineTransform.transform(this.fVertex0, null);
        Point2D point2D2 = affineTransform.transform(this.fVertex1, null);
        double d = point2D.getX();
        double d2 = point2D.getY();
        double d3 = point2D2.getX();
        double d4 = point2D2.getY();
        double d5 = this.fTexture.getWidth();
        double d6 = this.fTexture.getHeight();
        double d7 = this.fTCoords0.getX() * d5;
        double d8 = this.fTCoords0.getY() * d6;
        double d9 = this.fTCoords1.getX() * d5;
        double d10 = this.fTCoords1.getY() * d6;
        double d11 = this.fQ0;
        double d12 = this.fQ1;
        double d13 = 0.0;
        double d14 = 0.0;
        double d15 = 0.0;
        double d16 = 0.0;
        double d17 = 0.0;
        double d18 = 0.0;
        if (this.fIsLine) {
            double d19 = (d3 - d) * (d3 - d) + (d4 - d2) * (d4 - d2);
            if (d19 != 0.0) {
                d19 = 1.0 / d19;
                d13 = (d9 - d7) * (d3 - d) * d19;
                d14 = (d9 - d7) * (d4 - d2) * d19;
                d15 = (d10 - d8) * (d3 - d) * d19;
                d16 = (d10 - d8) * (d4 - d2) * d19;
                d17 = (d12 - d11) * (d3 - d) * d19;
                d18 = (d12 - d11) * (d4 - d2) * d19;
            }
        } else {
            Point2D point2D3 = affineTransform.transform(this.fVertex2, null);
            double d20 = point2D3.getX();
            double d21 = point2D3.getY();
            double d22 = this.fTCoords2.getX() * d5;
            double d23 = this.fTCoords2.getY() * d6;
            double d24 = this.fQ2;
            double d25 = d * (d21 - d4) + d3 * (d2 - d21) + d20 * (d4 - d2);
            if (d25 != 0.0) {
                d25 = 1.0 / d25;
                d13 = (d7 * (d21 - d4) + d9 * (d2 - d21) + d22 * (d4 - d2)) * d25;
                d14 = -(d7 * (d20 - d3) + d9 * (d - d20) + d22 * (d3 - d)) * d25;
                d15 = (d8 * (d21 - d4) + d10 * (d2 - d21) + d23 * (d4 - d2)) * d25;
                d16 = -(d8 * (d20 - d3) + d10 * (d - d20) + d23 * (d3 - d)) * d25;
                d17 = (d11 * (d21 - d4) + d12 * (d2 - d21) + d24 * (d4 - d2)) * d25;
                d18 = -(d11 * (d20 - d3) + d12 * (d - d20) + d24 * (d3 - d)) * d25;
            }
        }
        return new Texture2DPaintContext(colorModel, d, d2, d7, d8, d11, d13, d14, d15, d16, d17, d18, this.fTexture);
    }

    @Override
    public int getTransparency() {
        return this.fOpaque ? 1 : 3;
    }

    private class Texture2DPaintContext
    implements PaintContext {
        private ColorModel fColorModel;
        private double fX;
        private double fY;
        private double fUQ;
        private double fVQ;
        private double fQ;
        private double f_dUQdX;
        private double f_dUQdY;
        private double f_dVQdX;
        private double f_dVQdY;
        private double f_dQdX;
        private double f_dQdY;

        public Texture2DPaintContext(ColorModel colorModel, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9, double d10, double d11, TextureMap textureMap) {
            this.fColorModel = colorModel;
            this.fX = d;
            this.fY = d2;
            this.fUQ = d3;
            this.fVQ = d4;
            this.fQ = d5;
            this.f_dUQdX = d6;
            this.f_dUQdY = d7;
            this.f_dVQdX = d8;
            this.f_dVQdY = d9;
            this.f_dQdX = d10;
            this.f_dQdY = d11;
            Texture2DPaint.this.fTexture = textureMap;
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int n, int n2, int n3, int n4) {
            WritableRaster writableRaster = this.getColorModel().createCompatibleWritableRaster(n3, n4);
            int n5 = Texture2DPaint.this.fTexture.getWidth();
            int n6 = n5 - 1;
            int n7 = Texture2DPaint.this.fTexture.getHeight() - 1;
            double d = (double)n - this.fX;
            double d2 = (double)n2 - this.fY;
            double d3 = this.fUQ + d * this.f_dUQdX + d2 * this.f_dUQdY;
            double d4 = this.fVQ + d * this.f_dVQdX + d2 * this.f_dVQdY;
            double d5 = this.fQ + d * this.f_dQdX + d2 * this.f_dQdY;
            for (int i = 0; i < n4; ++i) {
                double d6 = d3;
                double d7 = d4;
                double d8 = d5;
                for (int j = 0; j < n3; ++j) {
                    int n8 = (int)Math.floor(d6 / d8);
                    int n9 = (int)Math.floor(d7 / d8);
                    int[] nArray = Texture2DPaint.this.fTexture.getIntArrayColor(n8, n9);
                    writableRaster.setPixel(j, i, nArray);
                    d6 += this.f_dUQdX;
                    d7 += this.f_dVQdX;
                    d8 += this.f_dQdX;
                }
                d3 += this.f_dUQdY;
                d4 += this.f_dVQdY;
                d5 += this.f_dQdY;
            }
            return writableRaster;
        }
    }
}

