/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.hg.util;

import com.mathworks.hg.peer.AbstractUicontrolPeer;
import com.mathworks.hg.peer.IPrintableComponent;
import com.mathworks.hg.util.HGPeerQueue;
import com.mathworks.hg.util.HGPeerRunnable;
import com.mathworks.mwswing.MacAppearanceUtils;
import com.mathworks.mwswing.SynchronousInvokeUtility;
import com.mathworks.util.PlatformInfo;
import java.awt.EventQueue;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;

public class HGUtils {
    private static boolean sUsingHGPeerQueue = true;
    public static final int R13MODE_ALL = -1;
    public static final int R13MODE_NONE = 0;
    public static final int R13MODE_NOSCROLLBARS = 1;
    public static final int R13MODE_FLOORFONTS = 2;
    public static final int R13MODE_COMPRESSEXTENT = 4;
    private static int sR13CompatibilityMode = 0;

    private HGUtils() {
    }

    public static void invokeLater(HGPeerRunnable hGPeerRunnable) {
        if (sUsingHGPeerQueue) {
            assert (!EventQueue.isDispatchThread()) : "Must call not call this from EventDispatch thread";
            HGPeerQueue.getInstance().add(hGPeerRunnable);
        } else {
            SwingUtilities.invokeLater(hGPeerRunnable);
        }
    }

    public static void flushHGPeerQueue() {
        HGUtils.flushHGPeerQueue(false);
    }

    public static void flushHGPeerQueue(boolean bl) {
        assert (!EventQueue.isDispatchThread()) : "Must call not call this from EventDispatch thread";
        HGPeerQueue.getInstance().flush(bl);
    }

    public static void setUsingHGPeerQueue(boolean bl) {
        if (sUsingHGPeerQueue != bl) {
            HGUtils.flushHGPeerQueue(false);
            sUsingHGPeerQueue = bl;
        }
    }

    public static boolean isEchoNeeded() {
        assert (!EventQueue.isDispatchThread()) : "Must call not call this from EventDispatch thread";
        return HGPeerQueue.getInstance().isEchoNeeded();
    }

    public static void clearEchoNeeded() {
        assert (!EventQueue.isDispatchThread()) : "Must call not call this from EventDispatch thread";
        HGPeerQueue.getInstance().clearEchoNeeded();
    }

    public static Image getComponentImage(Object object) {
        return (Image)HGUtils.getComponentImage(object, -1, -1, false);
    }

    public static int[] getComponentImageArray(Object object) {
        return (int[])HGUtils.getComponentImage(object, -1, -1, true);
    }

    private static Object getComponentImage(final Object object, final int n, final int n2, final boolean bl) {
        ComponentImageRunnable componentImageRunnable = new ComponentImageRunnable(){

            @Override
            public void run() {
                try {
                    this.setResult(HGUtils.getComponentImageEDT(object, n, n2, bl));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            componentImageRunnable.run();
        } else {
            SynchronousInvokeUtility.queueSynchronousEvent((SynchronousInvokeUtility.SynchronousEvent)new SynchronousInvokeUtility.SynchronousEventAdapter((Runnable)componentImageRunnable));
        }
        return componentImageRunnable.getResult();
    }

    private static Object getComponentImageEDT(Object object, int n, int n2, boolean bl) {
        assert (EventQueue.isDispatchThread()) : "Must call getComponentImage from the java event thread";
        JComponent jComponent = null;
        if (object instanceof JComponent) {
            jComponent = (JComponent)object;
        } else if (object instanceof AbstractUicontrolPeer) {
            jComponent = ((AbstractUicontrolPeer)object).getComponentPeer();
        } else if (object instanceof IPrintableComponent) {
            jComponent = ((IPrintableComponent)object).getPrintableComponent();
        }
        if (null != jComponent && null != jComponent.getParent()) {
            if (-1 == n || -1 == n2) {
                n = jComponent.getWidth();
                n2 = jComponent.getHeight();
            }
            try {
                BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
                Graphics2D graphics2D = bufferedImage.createGraphics();
                graphics2D.setColor(jComponent.getBackground());
                graphics2D.fillRect(0, 0, n, n2);
                jComponent.print(graphics2D);
                if (bl) {
                    int[] nArray = bufferedImage.getRGB(0, 0, n, n2, null, 0, n);
                    for (int i = 0; i < n2; ++i) {
                        for (int j = 0; j < n; ++j) {
                            int n3 = j + i * n;
                            nArray[n3] = nArray[n3] & 0xFFFFFF;
                        }
                    }
                    return nArray;
                }
                return bufferedImage;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static int setR13CompatibilityMode(int n) {
        sR13CompatibilityMode = n;
        return n;
    }

    public static int getR13CompatibilityMode() {
        return sR13CompatibilityMode;
    }

    public static void applyMacControlSizeVariant(JComponent jComponent, double d, double d2, double d3) {
        if (PlatformInfo.isMacintosh()) {
            if (d <= d2) {
                MacAppearanceUtils.SizeVariant.MINI.apply(jComponent);
            } else if (d <= d3) {
                MacAppearanceUtils.SizeVariant.SMALL.apply(jComponent);
            } else {
                MacAppearanceUtils.SizeVariant.REGULAR.apply(jComponent);
            }
        }
    }

    public static void applyMacCheckboxSizeVariant(JComponent jComponent, double d) {
        HGUtils.applyMacControlSizeVariant(jComponent, d, 12.0, 16.0);
    }

    public static void applyMacRadioSizeVariant(JComponent jComponent, double d) {
        HGUtils.applyMacControlSizeVariant(jComponent, d, 10.0, 14.0);
    }

    public static String[] getClassNames() {
        return new String[]{"com.mathworks.hg.peer.ActiveXCanvas", "com.mathworks.hg.peer.AxisCanvas", "com.mathworks.hg.peer.AxisComponent", "com.mathworks.hg.peer.AxisPanel", "com.mathworks.hg.peer.CallbackTrigger", "com.mathworks.hg.peer.CheckboxPeer", "com.mathworks.hg.peer.ComboboxPeer", "com.mathworks.hg.peer.ContextMenuPeer", "com.mathworks.hg.peer.Echo", "com.mathworks.hg.peer.EchoBeanInfo", "com.mathworks.hg.peer.EchoEvent", "com.mathworks.hg.peer.EchoListener", "com.mathworks.hg.peer.EditTextPeer", "com.mathworks.hg.peer.FigureAxisComponentProxy", "com.mathworks.hg.peer.FigureChild", "com.mathworks.hg.peer.FigureClientProxy", "com.mathworks.hg.peer.FigureComponentContainer", "com.mathworks.hg.peer.FigureEvent", "com.mathworks.hg.peer.FigureFocusTraversalPolicyFactory", "com.mathworks.hg.peer.FigureFrameProxy", "com.mathworks.hg.peer.FigureFrameProxyBase", "com.mathworks.hg.peer.FigureFrameProxyBaseAdapter", "com.mathworks.hg.peer.FigureJavaComponentListener", "com.mathworks.hg.peer.FigureListener", "com.mathworks.hg.peer.FigurePanel", "com.mathworks.hg.peer.FigurePeer", "com.mathworks.hg.peer.FigurePeerAcceleratorKeyEvent", "com.mathworks.hg.peer.FigurePeerAcceleratorKeyListener", "com.mathworks.hg.peer.FigurePeerBeanInfo", "com.mathworks.hg.peer.FigurePeerButtonMotionListener", "com.mathworks.hg.peer.FigurePeerComponentEvent", "com.mathworks.hg.peer.FigurePeerComponentListener", "com.mathworks.hg.peer.FigurePeerFocusEvent", "com.mathworks.hg.peer.FigurePeerFocusListener", "com.mathworks.hg.peer.FigurePeerKeyEvent", "com.mathworks.hg.peer.FigurePeerKeyListener", "com.mathworks.hg.peer.FigurePeerMouseEvent", "com.mathworks.hg.peer.FigurePeerMouseListener", "com.mathworks.hg.peer.FigurePeerPaintEvent", "com.mathworks.hg.peer.FigurePeerPaintListener", "com.mathworks.hg.peer.FigurePeerWindowEvent", "com.mathworks.hg.peer.FigurePeerWindowListener", "com.mathworks.hg.peer.FigurePeerWindowStyleEvent", "com.mathworks.hg.peer.FigurePeerWindowStyleListener", "com.mathworks.hg.peer.FramePeer", "com.mathworks.hg.peer.LabelPeer", "com.mathworks.hg.peer.ListboxPeer", "com.mathworks.hg.peer.MenuPeer", "com.mathworks.hg.peer.PopupMenuHideHelper", "com.mathworks.hg.peer.PushButtonPeer", "com.mathworks.hg.peer.RadioButtonPeer", "com.mathworks.hg.peer.SliderPeer", "com.mathworks.hg.peer.TextObjectEdit", "com.mathworks.hg.peer.ToggleButtonPeer", "com.mathworks.hg.peer.ToolPushButtonPeer", "com.mathworks.hg.peer.ToolToggleButtonPeer", "com.mathworks.hg.peer.ToolbarPeer", "com.mathworks.hg.peer.UIPanel", "com.mathworks.hg.peer.UITabGroupPeer", "com.mathworks.hg.peer.UITreeNode", "com.mathworks.hg.peer.UITreePeer", "com.mathworks.hg.peer.UITreePeerBeanInfo", "com.mathworks.hg.peer.UITreePeerRenderer", "com.mathworks.hg.peer.UicontrolBuilder", "com.mathworks.hg.peer.UitablePeer", "com.mathworks.hg.peer.UitablePeerBeanInfo", "com.mathworks.hg.peer.UnitPos", "com.mathworks.hg.peer.WindowRectHandler", "com.mathworks.hg.peer.WindowsTextMetric", "com.mathworks.hg.peer.event.DataChangedEvent", "com.mathworks.hg.peer.event.DataChangedListener", "com.mathworks.hg.peer.event.NodeDroppedEvent", "com.mathworks.hg.peer.event.NodeDroppedListener", "com.mathworks.hg.peer.event.NodeExpandedEvent", "com.mathworks.hg.peer.event.NodeExpandedListener", "com.mathworks.hg.peer.event.NodeSelectedEvent", "com.mathworks.hg.peer.event.NodeSelectedListener", "com.mathworks.hg.peer.event.ToolbuttonEvent", "com.mathworks.hg.peer.event.ToolbuttonListener", "com.mathworks.hg.peer.event.UiMenuEvent", "com.mathworks.hg.peer.event.UiMenuListener", "com.mathworks.hg.peer.event.UicontrolEvent", "com.mathworks.hg.peer.event.UicontrolKeyListener", "com.mathworks.hg.peer.event.UicontrolListener", "com.mathworks.hg.peer.event.UicontrolUserEvent", "com.mathworks.hg.peer.event.UicontrolUserListener", "com.mathworks.hg.peer.ui.event.UIKeyListener", "com.mathworks.hg.peer.ui.table.event.UITableCellEditListener", "com.mathworks.hg.peer.ui.table.event.UITableCellEditValidationListener", "com.mathworks.hg.peer.utils.MJMultilineLabel", "com.mathworks.hg.peer.utils.MJMultilineText", "com.mathworks.hg.peer.utils.MultilineLabel", "com.mathworks.hg.peer.utils.UIScrollPane", "com.mathworks.jmi.bean.HGpropertyDescriptor", "com.mathworks.jmi.bean.ClassFileConstants", "com.mathworks.jmi.bean.ListenerClassServer", "com.mathworks.jmi.bean.ClassFileEditor", "com.mathworks.jmi.bean.BeanUDDListenerAdapter", "com.mathworks.jmi.bean.EventServer", "com.mathworks.jmi.bean.PropInfo", "com.mathworks.jmi.bean.ClassWrapper", "com.mathworks.jmi.bean.EventInfo", "com.mathworks.jmi.bean.MethodInfo", "com.mathworks.jmi.bean.BeanWrapper", "com.mathworks.jmi.bean.EventCallback", "com.mathworks.jmi.bean.MatlabCallbackInterface", "com.mathworks.jmi.bean.EventQueue", "com.mathworks.jmi.bean.CallbackData", "com.mathworks.jmi.bean.CallbackInfo", "com.mathworks.jmi.bean.BeanManager", "com.mathworks.jmi.bean.BeanFileData", "com.mathworks.jmi.bean.class_file", "com.mathworks.jmi.bean.cp_info", "com.mathworks.jmi.bean.constant_utf8_info", "com.mathworks.jmi.bean.constant_class_info", "com.mathworks.jmi.bean.constant_fieldref_info", "com.mathworks.jmi.bean.constant_methodref_info", "com.mathworks.jmi.bean.constant_interfaceref_info", "com.mathworks.jmi.bean.constant_string_info", "com.mathworks.jmi.bean.constant_integer_info", "com.mathworks.jmi.bean.constant_float_info", "com.mathworks.jmi.bean.constant_long_info", "com.mathworks.jmi.bean.constant_double_info", "com.mathworks.jmi.bean.constant_nameandtype_info", "com.mathworks.jmi.bean.attribute_info", "com.mathworks.jmi.bean.sourcefile_attribute_info", "com.mathworks.jmi.bean.constantvalue_attribute_info", "com.mathworks.jmi.bean.code_attribute_info", "com.mathworks.jmi.bean.exceptions_attribute_info", "com.mathworks.jmi.bean.generic_attribute_info", "com.mathworks.jmi.bean.generic_info", "com.mathworks.jmi.bean.method_info"};
    }

    private static abstract class ComponentImageRunnable
    implements Runnable {
        private Object fResult = null;

        private ComponentImageRunnable() {
        }

        public void setResult(Object object) {
            this.fResult = object;
        }

        public Object getResult() {
            return this.fResult;
        }
    }
}

