/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.index.DocumentationDocument;
import com.mathworks.helpsearch.index.HtmlParser;
import com.mathworks.helpsearch.index.HtmlParserFactory;
import com.mathworks.helpsearch.index.HtmlToDomAdapter;
import com.mathworks.helpsearch.index.LocalizedFileLocator;
import com.mathworks.helpsearch.index.microdata.MicrodataDocumentBuilder;
import com.mathworks.helpsearch.index.microdata.MicrodataItem;
import com.mathworks.helpsearch.index.microdata.MicrodataParser;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.List;
import org.w3c.dom.Document;

public class DocumentParser {
    private final ContentFormat fFormat;
    private final HtmlToDomAdapter fDomAdapter;
    private final HtmlParserFactory fParserFactory;
    private final LocalizedFileLocator fLocalizer;

    public DocumentParser(ContentFormat format, HtmlToDomAdapter domAdapter, HtmlParserFactory factory) {
        this(format, domAdapter, factory, null);
    }

    public DocumentParser(ContentFormat format, HtmlToDomAdapter domAdapter, HtmlParserFactory factory, LocalizedFileLocator localizer) {
        this.fFormat = format;
        this.fDomAdapter = domAdapter;
        this.fParserFactory = factory;
        this.fLocalizer = localizer;
    }

    public boolean parseDocument(DocumentationDocument doc, File prodDir) throws Exception {
        return this.parseDocument(doc, prodDir, ParserType.values());
    }

    private boolean parseDocument(DocumentationDocument doc, File prodDir, ParserType ... types) throws Exception {
        DocumentPopulationStrategy[] strategies = this.getPopulationStrategies(types);
        return this.parseDocument(doc, prodDir, strategies);
    }

    boolean parseDocument(DocumentationDocument doc, File prodDir, DocumentPopulationStrategy ... strategies) throws Exception {
        if (strategies == null || strategies.length == 0) {
            throw new IllegalArgumentException("Cannot parse document without using microdata, DOM parsing, or both");
        }
        File file = this.getLocalizedFile(new File(prodDir, doc.getRelativePath()));
        if (this.doesFileExist(file)) {
            this.parseExistingFile(doc, file, strategies);
            return true;
        }
        return false;
    }

    private File getLocalizedFile(File file) {
        if (this.fLocalizer != null) {
            return this.fLocalizer.findLocalizedFile(file);
        }
        return file;
    }

    protected boolean doesFileExist(File file) {
        return file.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseExistingFile(DocumentationDocument doc, File fileToParse, DocumentPopulationStrategy ... strategies) throws Exception {
        InputStream is = this.getInputStream(fileToParse);
        try {
            Document domDoc = this.fDomAdapter.parseDocument(is);
            this.parseDocument(doc, domDoc, strategies);
        }
        finally {
            is.close();
        }
    }

    public void parseDocument(DocumentationDocument doc, Document domDoc, ParserType ... types) throws Exception {
        DocumentPopulationStrategy[] strategies = this.getPopulationStrategies(types);
        this.parseDocument(doc, domDoc, strategies);
    }

    private void parseDocument(DocumentationDocument doc, Document domDoc, DocumentPopulationStrategy ... strategies) throws Exception {
        if (strategies == null || strategies.length == 0) {
            throw new IllegalArgumentException("Cannot parse document without using microdata, DOM parsing, or both");
        }
        for (DocumentPopulationStrategy strategy : strategies) {
            strategy.populateDocument(doc, domDoc);
        }
    }

    private DocumentPopulationStrategy[] getPopulationStrategies(ParserType ... types) {
        DocumentPopulationStrategy[] strategies = new DocumentPopulationStrategy[types.length];
        for (int i = 0; i < types.length; ++i) {
            strategies[i] = this.getParserStrategy(types[i]);
        }
        return strategies;
    }

    protected InputStream getInputStream(File file) throws IOException {
        String htmlString = DocumentParser.readInputStream(new FileInputStream(file));
        htmlString = htmlString.replaceAll("<#[^>]*>", "");
        return new ByteArrayInputStream(htmlString.getBytes(Charset.forName("UTF-8")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readInputStream(InputStream inputStream) throws IOException {
        StringBuilder contents = new StringBuilder();
        InputStreamReader isr = new InputStreamReader(inputStream, "utf-8");
        BufferedReader br = new BufferedReader(isr);
        try {
            String line = br.readLine();
            while (line != null) {
                contents.append(line).append("\n");
                line = br.readLine();
            }
            String string = contents.toString();
            return string;
        }
        finally {
            br.close();
        }
    }

    private DocumentPopulationStrategy getParserStrategy(ParserType type) {
        switch (type) {
            case MICRODATA: {
                return new MicrodataPopulationStrategy();
            }
            case DOM: {
                return new DomParserPopulationStrategy();
            }
        }
        return null;
    }

    private class MicrodataPopulationStrategy
    implements DocumentPopulationStrategy {
        private MicrodataPopulationStrategy() {
        }

        @Override
        public void populateDocument(DocumentationDocument doc, Document domDoc) throws Exception {
            MicrodataParser parser = new MicrodataParser(domDoc);
            parser.parseDocument();
            List<MicrodataItem> items = parser.getTopLevelItems();
            if (items != null && !items.isEmpty()) {
                for (MicrodataItem topLevelItem : items) {
                    MicrodataDocumentBuilder docBuilder = new MicrodataDocumentBuilder(DocumentParser.this.fFormat);
                    docBuilder.populateDocument(doc, topLevelItem);
                }
            }
        }
    }

    private class DomParserPopulationStrategy
    implements DocumentPopulationStrategy {
        private DomParserPopulationStrategy() {
        }

        @Override
        public void populateDocument(DocumentationDocument doc, Document domDoc) throws Exception {
            String relativePath = doc.getRelativePath();
            HtmlParser parser = DocumentParser.this.fParserFactory.createParserForDocument(domDoc, relativePath);
            parser.parseDocument(doc, relativePath);
        }
    }

    public static interface DocumentPopulationStrategy {
        public void populateDocument(DocumentationDocument var1, Document var2) throws Exception;
    }

    public static enum ParserType {
        MICRODATA,
        DOM;

    }
}

