/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.SearchDirectory;
import com.mathworks.helpsearch.index.DocSearchIndexerType;
import com.mathworks.helpsearch.index.HtmlToDomAdapter;
import com.mathworks.helpsearch.index.IndexDocumentBuilder;
import com.mathworks.helpsearch.index.IndexUtils;
import com.mathworks.helpsearch.index.IndexerConfig;
import com.mathworks.helpsearch.index.IndexerType;
import com.mathworks.helpsearch.index.ProductIndexer;
import com.mathworks.helpsearch.index.report.ReportSummary;
import com.mathworks.helpsearch.index.report.SimpleReport;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.search.Indexer;
import com.mathworks.search.SearchField;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class DocumentationIndexer {
    private final IndexerConfig fConfig;
    private final DocumentationSet fDocSet;
    private final String fProduct;
    private final HtmlToDomAdapter fDomAdapter;
    private final IndexerType<? extends SearchField> fIndexerType;

    public DocumentationIndexer(IndexerConfig config, DocumentationSet docSet, String product, HtmlToDomAdapter domAdapter) throws IllegalArgumentException {
        this(config, docSet, product, domAdapter, new DocSearchIndexerType(config, docSet.getLanguage().getSearchLanguage()));
    }

    public DocumentationIndexer(IndexerConfig config, DocumentationSet docSet, String product, HtmlToDomAdapter domAdapter, IndexerType<? extends SearchField> indexerType) throws IllegalArgumentException {
        this.fConfig = config;
        this.fDocSet = docSet;
        this.fProduct = product;
        this.fDomAdapter = domAdapter;
        this.fIndexerType = indexerType;
    }

    public boolean index() {
        boolean success;
        try {
            success = this.indexProducts();
        }
        catch (IOException ioe) {
            success = false;
        }
        if (!success) {
            this.deleteFilesFromIndex();
        }
        return success;
    }

    private void deleteFilesFromIndex() {
        File[] filesInIndex;
        SearchDirectory sd = new SearchDirectory(this.fConfig);
        File indexDir = sd.getIndexDir();
        for (File file : filesInIndex = indexDir.listFiles()) {
            file.delete();
        }
    }

    private boolean indexProducts() throws IOException {
        boolean allSucceeded = true;
        ReportSummary reportSummary = new ReportSummary();
        List<DocProduct> products = this.getProductsToIndex();
        for (int i = 0; i < products.size(); ++i) {
            DocProduct product = products.get(i);
            System.out.println("***** Indexing " + product.getDisplayName() + " (product " + String.valueOf(i + 1) + " of " + products.size() + ") *****");
            boolean createNewIndex = i == 0 && this.fProduct == null;
            IndexDocumentBuilder<? extends SearchField> indexDocBuilder = this.fIndexerType.createIndexDocumentBuilder(product);
            Indexer indexer = this.fIndexerType.createIndexer(product, createNewIndex);
            ProductIndexer prodIndexer = new ProductIndexer(this.fConfig, product, this.fDomAdapter, indexDocBuilder, indexer);
            boolean success = prodIndexer.index();
            allSucceeded = allSucceeded && success;
            Map<SimpleReport, Integer> prodReportSummary = prodIndexer.getReportBuilder().createProductReportSummary();
            reportSummary.addProductSummary(product, prodReportSummary);
        }
        try {
            this.writeReportSummaryFile(reportSummary);
        }
        catch (IOException e) {
            // empty catch block
        }
        return allSucceeded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeReportSummaryFile(ReportSummary summary) throws IOException {
        File resourceDir = IndexUtils.getResourceDirectory(this.fConfig, true);
        if (resourceDir != null) {
            Properties props = summary.toProperties();
            FileWriter writer = new FileWriter(new File(resourceDir, "report-summary.properties"));
            try {
                props.store(writer, null);
            }
            finally {
                writer.close();
            }
        }
    }

    private List<DocProduct> getProductsToIndex() {
        if (this.fProduct == null) {
            return this.fDocSet.getAllProducts();
        }
        return Arrays.asList(this.fDocSet.getProductByIndexString(this.fProduct));
    }
}

