/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.index;

import com.mathworks.helpsearch.index.HtmlToDomAdapter;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlToDomAdapterValidator {
    private final HtmlToDomAdapter fAdapter;

    public HtmlToDomAdapterValidator(HtmlToDomAdapter adapter) {
        this.fAdapter = adapter;
    }

    public List<ValidationResponse> validateAll() {
        LinkedList<ValidationResponse> responses = new LinkedList<ValidationResponse>();
        responses.add(this.validateBasicHtml());
        responses.add(this.validateHtml5Tags());
        responses.add(this.validateHtmlAttributes());
        responses.add(this.validateMicrodataAttributes());
        return responses;
    }

    public ValidationResponse validateBasicHtml() {
        String html = "<html><body>Hello</body></html>";
        TagStructure tagStructure = new TagStructure("html");
        tagStructure.addChild("body", "Hello");
        return this.validate(html, tagStructure);
    }

    public ValidationResponse validateHtml5Tags() {
        String html = "<html><body><header>Header</header><nav>Navigation</nav><section>Section</section><footer>Footer</footer></body></html>";
        TagStructure tagStructure = new TagStructure("html");
        TagStructure body = tagStructure.addChild("body");
        body.addChild("header", "Header");
        body.addChild("nav", "Navigation");
        body.addChild("section", "Section");
        body.addChild("footer", "Footer");
        return this.validate(html, tagStructure);
    }

    public ValidationResponse validateHtmlAttributes() {
        String html = "<html><body><div id=\"testId\" class=\"testClass\">content</div></body></html>";
        TagStructure tagStructure = new TagStructure("html");
        TagStructure div = tagStructure.addChild("body").addChild("div", "content");
        div.addAttribute("id", "testId");
        div.addAttribute("class", "testClass");
        return this.validate(html, tagStructure);
    }

    public ValidationResponse validateMicrodataAttributes() {
        String html = "<html itemscope itemtype=\"TestType\"><body><div itemprop=\"testProp\">content</div></body></html>";
        TagStructure tagStructure = new TagStructure("html");
        tagStructure.addAttribute("itemscope", Pattern.compile("^(itemscope)?$"));
        tagStructure.addAttribute("itemtype", "TestType");
        TagStructure div = tagStructure.addChild("body").addChild("div", "content");
        div.addAttribute("itemprop", "testProp");
        return this.validate(html, tagStructure);
    }

    private ValidationResponse validate(String html, TagStructure expectedStructure) {
        ValidationResponse response = new ValidationResponse();
        Document doc = this.parseHtml(html);
        Element docElt = doc.getDocumentElement();
        String validationString = this.validate(docElt, expectedStructure);
        if (validationString != null) {
            response.addMessage(validationString);
        }
        return response;
    }

    private String validate(Node elt, TagStructure expectedStructure) {
        String expectedName = expectedStructure.getTagName();
        if (!elt.getNodeName().equalsIgnoreCase(expectedName)) {
            return "Expected tag " + HtmlToDomAdapterValidator.getLocationString(expectedStructure) + " had wrong tag name.  Found [" + elt.getNodeName() + "]";
        }
        String expectedContent = expectedStructure.getTagContent();
        String actualContent = HtmlToDomAdapterValidator.getNodeText(elt);
        if (expectedContent != null && !actualContent.equals(expectedContent)) {
            return "Tag at position " + HtmlToDomAdapterValidator.getLocationString(expectedStructure) + " had incorrect content.  Expected [" + expectedContent + "], found [" + actualContent + "]";
        }
        String attrValidation = HtmlToDomAdapterValidator.validateAttributes(elt, expectedStructure);
        if (attrValidation != null) {
            return attrValidation;
        }
        String childValidation = this.validateChildren(elt, expectedStructure);
        if (childValidation != null) {
            return childValidation;
        }
        return null;
    }

    private static String validateAttributes(Node elt, TagStructure expectedStructure) {
        Map expectedAttributes = expectedStructure.getAttributePatterns();
        NamedNodeMap actualAttributes = elt.getAttributes();
        if (expectedAttributes.size() > actualAttributes.getLength()) {
            return "Tag at position " + HtmlToDomAdapterValidator.getLocationString(expectedStructure) + " had too few attributes.  Expected " + expectedAttributes.size() + " , found " + actualAttributes.getLength();
        }
        for (Map.Entry expAttribute : expectedAttributes.entrySet()) {
            String actualAttrValue;
            String expName = (String)expAttribute.getKey();
            Node actualAttr = actualAttributes.getNamedItem(expName);
            if (actualAttr == null) {
                return "Tag at position " + HtmlToDomAdapterValidator.getLocationString(expectedStructure) + " had no attribute named " + expName;
            }
            Pattern expPattern = (Pattern)expAttribute.getValue();
            if (expPattern.matcher(actualAttrValue = actualAttr.getNodeValue()).matches()) continue;
            return "Tag at position " + HtmlToDomAdapterValidator.getLocationString(expectedStructure) + " had the wrong value for the attribute [" + expName + "].  " + actualAttrValue + " does not match pattern " + expPattern;
        }
        return null;
    }

    private String validateChildren(Node elt, TagStructure expectedStructure) {
        List expectedChildren = expectedStructure.getChildren();
        NodeList eltChildren = elt.getChildNodes();
        if (expectedChildren.size() > eltChildren.getLength()) {
            return "Tag at position " + HtmlToDomAdapterValidator.getLocationString(expectedStructure) + " had too few children.  Expected " + expectedChildren.size() + ", found " + eltChildren.getLength();
        }
        int lastFound = -1;
        for (int i = 0; i < expectedChildren.size(); ++i) {
            TagStructure expChild = (TagStructure)expectedChildren.get(i);
            lastFound = HtmlToDomAdapterValidator.findChildPosition(eltChildren, expChild.getTagName(), lastFound);
            if (lastFound < 0) {
                return "Could not find expected child " + i + " of node " + HtmlToDomAdapterValidator.getLocationString(expectedStructure) + ", named " + expChild.getTagName();
            }
            Node actChild = eltChildren.item(lastFound);
            String childValidation = this.validate(actChild, expChild);
            if (childValidation == null) continue;
            return childValidation;
        }
        return null;
    }

    private static String getNodeText(Node node) {
        List<Node> textNodes = HtmlToDomAdapterValidator.getTextNodeChildren(node);
        StringBuilder sb = new StringBuilder();
        for (Node textNode : textNodes) {
            sb.append(textNode.getNodeValue());
        }
        return sb.toString();
    }

    private static List<Node> getTextNodeChildren(Node node) {
        LinkedList<Node> textNodes = new LinkedList<Node>();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 3) continue;
            textNodes.add(child);
        }
        return textNodes;
    }

    private static int findChildPosition(NodeList children, String nodeName, int after) {
        for (int i = after + 1; i < children.getLength(); ++i) {
            Node candidate = children.item(i);
            if (!candidate.getNodeName().equalsIgnoreCase(nodeName)) continue;
            return i;
        }
        return -1;
    }

    private static String getLocationString(TagStructure tag) {
        StringBuilder sb = new StringBuilder("]");
        TagStructure current = tag;
        while (current != null) {
            sb.insert(0, current.getTagName());
            if ((current = current.getParent()) == null) continue;
            sb.insert(0, " > ");
        }
        sb.insert(0, '[');
        return sb.toString();
    }

    private Document parseHtml(String html) {
        InputStream is = HtmlToDomAdapterValidator.getTestInputStream(html);
        return this.fAdapter.parseDocument(is);
    }

    private static InputStream getTestInputStream(String html) {
        return new ByteArrayInputStream(html.getBytes());
    }

    private static class TagStructure {
        private final TagStructure iParent;
        private final String iTagName;
        private final String iTagContent;
        private final Map<String, Pattern> iAttributes = new HashMap<String, Pattern>();
        private final List<TagStructure> iChildren = new LinkedList<TagStructure>();

        private TagStructure(String tagName) {
            this(null, tagName, null);
        }

        private TagStructure(TagStructure parent, String tagName, String tagContent) {
            this.iParent = parent;
            this.iTagName = tagName;
            this.iTagContent = tagContent;
        }

        private TagStructure addChild(String tagName) {
            return this.addChild(tagName, null);
        }

        private TagStructure addChild(String tagName, String tagContent) {
            TagStructure child = new TagStructure(this, tagName, tagContent);
            this.addChild(child);
            return child;
        }

        private void addChild(TagStructure child) {
            this.iChildren.add(child);
        }

        private void addAttribute(String name, String value) {
            this.addAttribute(name, Pattern.compile(Pattern.quote(value)));
        }

        private void addAttribute(String name, Pattern pattern) {
            this.iAttributes.put(name, pattern);
        }

        private String getTagName() {
            return this.iTagName;
        }

        private String getTagContent() {
            return this.iTagContent;
        }

        private Map<String, Pattern> getAttributePatterns() {
            return Collections.unmodifiableMap(this.iAttributes);
        }

        private List<TagStructure> getChildren() {
            return Collections.unmodifiableList(this.iChildren);
        }

        private TagStructure getParent() {
            return this.iParent;
        }
    }

    public static class ValidationResponse {
        private final List<String> iMessages = new LinkedList<String>();

        private ValidationResponse() {
        }

        public boolean isValid() {
            return this.iMessages.isEmpty();
        }

        private void addMessage(String message) {
            this.iMessages.add(message);
        }

        public List<String> getMessages() {
            return Collections.unmodifiableList(this.iMessages);
        }

        public String getMessageString() {
            StringBuilder sb = new StringBuilder();
            for (String message : this.iMessages) {
                sb.append('\n').append(message);
            }
            if (sb.length() > 0) {
                sb.deleteCharAt(0);
            }
            return sb.toString();
        }
    }
}

