/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.DocumentationSearchField;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.search.SearchResult;
import com.mathworks.search.SearchResultFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ProductFilter
implements SearchResultFilter {
    private final Set<String> fAcceptedProducts;

    private ProductFilter(Set<String> shortNames) {
        this.fAcceptedProducts = Collections.unmodifiableSet(shortNames);
    }

    public static ProductFilter includeShortNames(Collection<String> shortNames) {
        return new ProductFilter(new HashSet<String>(shortNames));
    }

    public static ProductFilter includeShortNames(String ... shortNames) {
        return ProductFilter.includeShortNames(Arrays.asList(shortNames));
    }

    public static ProductFilter includeProducts(Collection<DocProduct> products) {
        Set<String> shortNames = ProductFilter.toShortNames(products);
        return new ProductFilter(shortNames);
    }

    public static ProductFilter includeProducts(DocProduct ... products) {
        return ProductFilter.includeProducts(Arrays.asList(products));
    }

    public static ProductFilter excludeProducts(DocumentationSet docSet, Collection<DocProduct> products) {
        Set<String> excluded = ProductFilter.toShortNames(products);
        return ProductFilter.excludeShortNames(docSet, excluded);
    }

    public static ProductFilter excludeProducts(DocumentationSet docSet, DocProduct ... products) {
        return ProductFilter.excludeProducts(docSet, Arrays.asList(products));
    }

    public static ProductFilter excludeShortNames(DocumentationSet docSet, Collection<String> shortNames) {
        Set<String> included = ProductFilter.toShortNames(docSet.getAllProducts());
        included.removeAll(shortNames);
        return new ProductFilter(included);
    }

    public static ProductFilter excludeShortNames(DocumentationSet docSet, String ... shortNames) {
        return ProductFilter.excludeShortNames(docSet, Arrays.asList(shortNames));
    }

    private static Set<String> toShortNames(Collection<DocProduct> prods) {
        HashSet<String> shortNames = new HashSet<String>();
        for (DocProduct prod : prods) {
            shortNames.add(prod.getIndexValue());
        }
        return shortNames;
    }

    public boolean accept(SearchResult result) {
        String prod = result.getFieldValue(DocumentationSearchField.PRODUCT.getFieldName());
        return this.fAcceptedProducts.contains(prod);
    }

    public boolean equals(Object o) {
        if (o instanceof ProductFilter) {
            ProductFilter other = (ProductFilter)o;
            return this.fAcceptedProducts.size() == other.fAcceptedProducts.size() && this.fAcceptedProducts.containsAll(other.fAcceptedProducts);
        }
        return false;
    }
}

