/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.helpsearch.product;

import com.mathworks.helpsearch.ContentFormat;
import com.mathworks.helpsearch.DocLanguage;
import com.mathworks.helpsearch.product.DocProduct;
import com.mathworks.helpsearch.product.DocumentationSet;
import com.mathworks.helpsearch.product.ProductBaseCodeMap;
import com.mathworks.helpsearch.product.ProductResolver;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class SimpleDocumentationSet
implements ProductResolver,
DocumentationSet {
    private final List<DocProduct> fProducts = new LinkedList<DocProduct>();
    private final Map<String, DocProduct> fProductsByIndexString = new HashMap<String, DocProduct>();
    private final Map<String, DocProduct> fProductsByFacetString = new HashMap<String, DocProduct>();
    private final Map<String, DocProduct> fProductsByFullName = new HashMap<String, DocProduct>();
    private final ContentFormat fFormat;
    private final DocLanguage fLanguage;
    private final ProductBaseCodeMap fBaseCodeMap;

    public SimpleDocumentationSet(ContentFormat format, DocLanguage language) {
        this.fFormat = format;
        this.fLanguage = language;
        this.fBaseCodeMap = new ProductBaseCodeMap();
    }

    @Override
    public void addProduct(DocProduct product) {
        this.fProducts.add(product);
        this.fProductsByFacetString.put(product.getQueryStringValue(), product);
        this.fProductsByIndexString.put(product.getIndexValue(), product);
        this.fProductsByFullName.put(product.getDisplayName(), product);
    }

    @Override
    public List<DocProduct> getAllProducts() {
        return Collections.unmodifiableList(this.fProducts);
    }

    @Override
    public DocProduct getProductByIndexString(String indexString) {
        return this.fProductsByIndexString.get(indexString);
    }

    @Override
    public DocProduct getProductByFacetString(String facetString) {
        return this.fProductsByFacetString.get(facetString);
    }

    public DocProduct getProductByFullName(String fullName) {
        return this.fProductsByFullName.get(fullName);
    }

    @Override
    public ContentFormat getFormat() {
        return this.fFormat;
    }

    @Override
    public DocLanguage getLanguage() {
        return this.fLanguage;
    }

    @Override
    public ProductBaseCodeMap getBaseCodeMap() {
        return this.fBaseCodeMap;
    }
}

