/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.engine;

import com.mathworks.project.api.Command;
import com.mathworks.project.api.CommandExecutionException;
import com.mathworks.project.api.CommandStatus;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.util.PlatformInfo;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

public class CopyCommand
implements Command {
    private final File fSource;
    private final File fDestination;
    private final String fLabel;
    private final boolean fOptional;

    public CopyCommand(String string) {
        XmlReader xmlReader;
        try {
            xmlReader = XmlApi.getInstance().read(string);
        }
        catch (Exception exception) {
            throw new IllegalArgumentException("Invalid command XML: " + string, exception);
        }
        this.fSource = new File(xmlReader.readAttribute("src"));
        this.fDestination = new File(xmlReader.readAttribute("dest"));
        this.fLabel = this.fSource.equals(this.fDestination) ? "" : "copy '" + this.fSource.getAbsolutePath() + "' '" + this.fDestination.getAbsolutePath() + "'";
        this.fOptional = xmlReader.readAttribute("optional") != null && xmlReader.readAttribute("optional").equals("true");
    }

    public void execute(CommandStatus commandStatus) {
        if (this.fSource.equals(this.fDestination)) {
            commandStatus.finished();
            return;
        }
        if (!this.fSource.exists()) {
            if (this.fOptional) {
                commandStatus.finished();
            } else {
                commandStatus.printErrorLine("Source file does not exist: '" + this.fSource.getAbsolutePath() + "'");
                commandStatus.failed(new CommandExecutionException((Command)this));
            }
            return;
        }
        try {
            if (this.removeDestination(commandStatus)) {
                boolean bl;
                String string = this.fDestination.getAbsolutePath();
                boolean bl2 = bl = this.fSource.exists() && this.fSource.isDirectory();
                String[] stringArray = new String[PlatformInfo.isWindows() ? (bl ? 9 : 5) : (bl ? 4 : 3)];
                int n = 0;
                if (PlatformInfo.isWindows()) {
                    stringArray[n++] = "cmd.exe";
                    stringArray[n++] = "/C";
                    if (!bl) {
                        stringArray[n++] = "copy";
                    } else {
                        stringArray[n++] = "xcopy";
                        stringArray[n++] = "/s";
                        stringArray[n++] = "/i";
                        stringArray[n++] = "/q";
                        stringArray[n++] = "/y";
                    }
                } else {
                    stringArray[n++] = "cp";
                    if (bl) {
                        string = this.fDestination.getParentFile().getAbsolutePath();
                        stringArray[n++] = PlatformInfo.isIntelMac64() ? "-RH" : "-r";
                    }
                }
                String string2 = PlatformInfo.isWindows() ? "\"" : "";
                stringArray[n++] = string2 + this.fSource.getAbsolutePath() + string2;
                stringArray[n] = string2 + string + string2;
                Runtime.getRuntime().exec(stringArray).waitFor();
                commandStatus.finished();
            }
        }
        catch (IOException iOException) {
            commandStatus.printErrorLine("Copy failed: " + iOException.getMessage());
            commandStatus.failed(new CommandExecutionException((Command)this, (Throwable)iOException));
        }
        catch (InterruptedException interruptedException) {
            commandStatus.printErrorLine("Copy failed: " + interruptedException.getMessage());
            commandStatus.failed(new CommandExecutionException((Command)this, (Throwable)interruptedException));
        }
    }

    private boolean removeDestination(CommandStatus commandStatus) {
        try {
            if (this.fDestination.exists()) {
                if (this.fDestination.isDirectory()) {
                    FileUtils.deleteDirectory((File)this.fDestination);
                } else {
                    this.fDestination.delete();
                }
            }
            return true;
        }
        catch (IOException iOException) {
            commandStatus.printErrorLine("Could not remove old copy of '" + this.fDestination + "'");
            commandStatus.failed(new CommandExecutionException((Command)this, (Throwable)iOException));
            return false;
        }
    }

    public void cancel() {
    }

    public String toString() {
        return this.fLabel;
    }
}

