/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mlwidgets.explorer.util.FileSystemUtils;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.model.Plugin;
import com.mathworks.xml.XMLUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ProjectVersionUtils {
    private ProjectVersionUtils() {
    }

    public static boolean canConvertToVersion(XmlReader xmlReader, Plugin plugin, String string) throws IOException {
        if (xmlReader.getCurrentElementName().equals("deployment-project")) {
            String string2 = xmlReader.readAttribute("plugin-version");
            if (string2 == null) {
                string2 = "1.0";
            }
            if (string2.equals(string)) {
                return true;
            }
            Map<String, Map<String, File>> map = ProjectVersionUtils.buildTranslationTable(plugin);
            List<File> list = ProjectVersionUtils.findTranslationPath(string2, string, map);
            return list != null;
        }
        return false;
    }

    public static XmlReader convertToVersion(XmlReader xmlReader, Plugin plugin, String string) throws IOException {
        if (xmlReader.getCurrentElementName().equals("deployment-project")) {
            String string2 = xmlReader.readAttribute("plugin-version");
            if (string2 == null) {
                string2 = "1.0";
            }
            if (string2.equals(string)) {
                return xmlReader;
            }
            String string3 = ProjectVersionUtils.convertToVersion(xmlReader.getXML(), plugin, string2, string);
            if (string3 == null) {
                return xmlReader;
            }
            return XmlApi.getInstance().read(string3);
        }
        return null;
    }

    public static String convertToVersion(String string, Plugin plugin, String string2, String string3) throws IOException {
        if (!string2.equals(string3)) {
            Map<String, Map<String, File>> map = ProjectVersionUtils.buildTranslationTable(plugin);
            List<File> list = ProjectVersionUtils.findTranslationPath(string2, string3, map);
            if (list == null) {
                return null;
            }
            for (File file : list) {
                String string4 = FileSystemUtils.readText((FileSystemEntry)RealFileSystem.getInstance().getEntry(new FileLocation(file)));
                string = XMLUtils.transform((String)string, (String)string4);
            }
        }
        return string;
    }

    private static Map<String, Map<String, File>> buildTranslationTable(Plugin plugin) {
        HashMap<String, Map<String, File>> hashMap = new HashMap<String, Map<String, File>>();
        File file = new File(plugin.getFolder(), "resources");
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (!file2.getName().startsWith("translate_") || !file2.getName().endsWith(".xsl") || file2.isDirectory()) continue;
                int n = file2.getName().indexOf("_to_");
                int n2 = file2.getName().indexOf(".xsl");
                if (n <= -1 || n2 <= n) continue;
                String string = file2.getName().substring("translate_".length(), n);
                String string2 = file2.getName().substring(n + "_to_".length(), n2);
                HashMap<String, File> hashMap2 = (HashMap<String, File>)hashMap.get(string);
                if (hashMap2 == null) {
                    hashMap2 = new HashMap<String, File>();
                    hashMap.put(string, hashMap2);
                }
                hashMap2.put(string2, file2);
            }
        }
        return hashMap;
    }

    private static List<File> findTranslationPath(String string, String string2, Map<String, Map<String, File>> map) {
        if (string.equals(string2)) {
            return new ArrayList<File>(0);
        }
        Map<String, File> map2 = map.get(string);
        if (map2 == null) {
            return null;
        }
        File file = map2.get(string2);
        if (file != null) {
            return Arrays.asList(file);
        }
        ArrayList arrayList = new ArrayList();
        for (String string3 : map2.keySet()) {
            HashMap<String, Map<String, File>> hashMap = new HashMap<String, Map<String, File>>(map);
            hashMap.remove(string);
            List<File> list = ProjectVersionUtils.findTranslationPath(string3, string2, hashMap);
            if (list == null) continue;
            ArrayList<File> arrayList2 = new ArrayList<File>();
            arrayList2.add(map2.get(string3));
            arrayList2.addAll(list);
            arrayList.add(arrayList2);
        }
        Collections.sort(arrayList, new Comparator<List<File>>(){

            @Override
            public int compare(List<File> list, List<File> list2) {
                return list.size() - list2.size();
            }
        });
        return arrayList.isEmpty() ? null : (List)arrayList.get(0);
    }
}

