/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.model;

import com.mathworks.project.api.XmlWriter;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public final class VariableGraph {
    private final Map<String, Generator> fDefaultGenerators;
    private final Map<String, XmlSerializer> fSerializers = new HashMap<String, XmlSerializer>();
    private final Map<String, Object> fDefaultValues;
    private final Map<String, Object> fExplicitValues;
    private final Map<String, String> fXml;
    private final Map<String, Set<String>> fDependencies;
    private final Map<String, Integer> fSetCounts;
    private final Map<String, String> fSignatures;
    private final Map<String, VariableGraph> fViews;
    private final Set<String> fVariablesWithPendingAsyncLoads;
    private final Set<String> fAsyncLoadedVariables;
    private final PropertyChangeSupport fPropertySupport;
    public static final Generator NULL_GENERATOR = new Generator(){

        @Override
        public Object generateValue(String string, VariableGraph variableGraph) {
            return null;
        }
    };

    public VariableGraph() {
        this.fDefaultGenerators = new HashMap<String, Generator>();
        this.fDefaultValues = new HashMap<String, Object>();
        this.fExplicitValues = new HashMap<String, Object>();
        this.fDependencies = new HashMap<String, Set<String>>();
        this.fXml = new HashMap<String, String>();
        this.fSetCounts = new HashMap<String, Integer>();
        this.fSignatures = new HashMap<String, String>();
        this.fPropertySupport = new PropertyChangeSupport(this);
        this.fViews = new HashMap<String, VariableGraph>();
        this.fVariablesWithPendingAsyncLoads = new HashSet<String>();
        this.fAsyncLoadedVariables = new HashSet<String>();
    }

    private VariableGraph(VariableGraph variableGraph, String string) {
        this();
        for (String string2 : variableGraph.getDependenciesOf(string)) {
            if (variableGraph.fXml.containsKey(string2)) {
                this.fXml.put(string2, variableGraph.fXml.get(string2));
            }
            if (variableGraph.fDefaultValues.containsKey(string2)) {
                this.fDefaultValues.put(string2, variableGraph.fDefaultValues.get(string2));
            }
            if (!variableGraph.isExplicitlySet(string2)) continue;
            this.fExplicitValues.put(string2, variableGraph.fExplicitValues.get(string2));
        }
    }

    private synchronized VariableGraph getView(String string) {
        String string2 = this.getSignature(string);
        VariableGraph variableGraph = this.fViews.get(string2);
        if (variableGraph == null) {
            variableGraph = new VariableGraph(this, string);
            this.fViews.put(string2, variableGraph);
        }
        return variableGraph;
    }

    private synchronized String generateSignature(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string2 : this.getDependenciesOf(string)) {
            stringBuilder.append(string2);
            stringBuilder.append(':');
            stringBuilder.append(this.fSetCounts.containsKey(string) ? Integer.toString(this.fSetCounts.get(string)) : "0");
            stringBuilder.append(',');
        }
        return stringBuilder.toString();
    }

    private synchronized String getSignature(String string) {
        String string2 = this.fSignatures.get(string);
        if (string2 == null) {
            string2 = this.generateSignature(string);
            this.fSignatures.put(string, string2);
        }
        return string2;
    }

    private synchronized void updateState(String string) {
        this.fSetCounts.put(string, this.fSetCounts.containsKey(string) ? this.fSetCounts.get(string) + 1 : 1);
        this.fSignatures.put(string, this.generateSignature(string));
        for (String string2 : this.getAllAffectedVariables(string)) {
            String string3 = this.fSignatures.get(string2);
            if (string3 != null) {
                this.fViews.remove(string3);
            }
            this.fSignatures.remove(string2);
        }
    }

    public synchronized boolean hasVariable(String string) {
        return this.fExplicitValues.containsKey(string) || this.fDefaultValues.containsKey(string) || this.fDefaultGenerators.containsKey(string) || this.fSerializers.containsKey(string);
    }

    public synchronized Set<String> getKeys() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(this.fExplicitValues.keySet());
        hashSet.addAll(this.fDefaultValues.keySet());
        hashSet.addAll(this.fDefaultGenerators.keySet());
        hashSet.addAll(this.fSerializers.keySet());
        return hashSet;
    }

    public synchronized void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.addPropertyChangeListener(propertyChangeListener);
    }

    public synchronized void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.fPropertySupport.removePropertyChangeListener(propertyChangeListener);
    }

    public synchronized void setDefaultGenerator(String string, Generator generator) {
        assert (this.fDefaultValues.isEmpty());
        this.fDefaultGenerators.put(string, generator);
    }

    public synchronized void setSerializer(String string, XmlSerializer xmlSerializer) {
        assert (this.fDefaultValues.isEmpty());
        this.fSerializers.put(string, xmlSerializer);
    }

    public synchronized void addDependency(String string, String string2) {
        assert (this.fDefaultValues.isEmpty());
        Set<String> set = this.fDependencies.get(string);
        if (set == null) {
            set = new HashSet<String>();
            this.fDependencies.put(string, set);
        }
        set.add(string2);
    }

    public synchronized boolean hasDependency(String string, String string2) {
        Set<String> set = this.fDependencies.get(string);
        return set != null && set.contains(string2);
    }

    public synchronized Set<String> getDependenciesOf(String string) {
        Set<String> set = this.fDependencies.get(string);
        return set == null ? new TreeSet<String>() : new TreeSet<String>(set);
    }

    public synchronized Set<String> getAllAffectedVariables(String string) {
        HashSet<String> hashSet = new HashSet<String>();
        this.getAllAffectedVariables(hashSet, string);
        return hashSet;
    }

    private synchronized void getAllAffectedVariables(Set<String> set, String string) {
        for (Map.Entry<String, Set<String>> entry : this.fDependencies.entrySet()) {
            if (!entry.getValue().contains(string)) continue;
            set.add(entry.getKey());
            this.getAllAffectedVariables(set, entry.getKey());
        }
    }

    public synchronized String getXml(String string) {
        String string2 = this.fXml.get(string);
        if (string2 == null && this.fSerializers.get(string) != null) {
            this.generateDefaults();
            string2 = this.fXml.get(string);
        }
        return string2;
    }

    public synchronized Object getValue(String string) {
        if (this.isExplicitlySet(string)) {
            return this.fExplicitValues.get(string);
        }
        return this.getDefaultValue(string);
    }

    public synchronized Object getExplicitValue(String string) {
        return this.fExplicitValues.get(string);
    }

    public synchronized boolean isExplicitlySet(String string) {
        return this.fExplicitValues.containsKey(string);
    }

    public synchronized void notifyPendingAsyncLoad(String string) {
        this.fVariablesWithPendingAsyncLoads.add(string);
        this.fAsyncLoadedVariables.add(string);
    }

    public synchronized void setDefaultValue(String string, Object object) {
        this.fVariablesWithPendingAsyncLoads.remove(string);
        if (!this.isExplicitlySet(string)) {
            Object object2 = null;
            if (this.fDefaultValues.containsKey(string)) {
                object2 = this.getValue(string);
            }
            this.fDefaultValues.put(string, object);
            this.updateState(string);
            this.serialize(string);
            this.generateDefaults(this.getAllAffectedVariables(string));
            this.fPropertySupport.firePropertyChange(string, object2, object);
        } else {
            this.fDefaultValues.put(string, object);
        }
    }

    public synchronized void setValue(String string, Object object) {
        Object object2 = this.getValue(string);
        if (!this.fVariablesWithPendingAsyncLoads.contains(string) && VariableGraph.valueEquals(object, this.fDefaultValues.get(string))) {
            this.fExplicitValues.remove(string);
        } else if (!this.fVariablesWithPendingAsyncLoads.contains(string) || object2 == null || object != null && !object.equals(object2)) {
            this.fExplicitValues.put(string, object);
        }
        this.updateState(string);
        this.serialize(string);
        this.fPropertySupport.firePropertyChange(string, object2, object);
        this.generateDefaults(this.getAllAffectedVariables(string));
    }

    public synchronized Object getDefaultValue(String string) {
        if (!this.fDefaultValues.containsKey(string)) {
            if (this.fVariablesWithPendingAsyncLoads.contains(string)) {
                return null;
            }
            if (this.fDefaultGenerators.get(string) == null) {
                throw new IllegalArgumentException("No default generator for " + string + " or something has a non-configured dependency on it.");
            }
            this.generateDefaults();
            assert (this.fDefaultValues.containsKey(string));
        }
        return this.fDefaultValues.get(string);
    }

    public synchronized void writeAllXml(XmlWriter xmlWriter) {
        for (String string : this.getKeys()) {
            String string2 = this.getXml(string);
            if (string2 == null) continue;
            xmlWriter.writeXML(string2);
        }
    }

    public synchronized void generateDefaults() {
        assert (this.fDefaultValues.isEmpty());
        this.generateDefaults(new TreeSet<String>(this.fDefaultGenerators.keySet()));
    }

    public synchronized void generateDefaults(Set<String> set) {
        Object object;
        HashMap<String, Object> hashMap = new HashMap<String, Object>(this.fDefaultValues);
        for (String object22 : set) {
            this.fDefaultValues.remove(object22);
        }
        ArrayList arrayList = new ArrayList();
        while (!set.isEmpty()) {
            final String string = this.findVariableWithSatisfiedDependencies(set);
            if (string == null) {
                throw new IllegalStateException("Circular dependency prevents evaluation from completing for: " + Arrays.toString(set.toArray()));
            }
            object = this.fDefaultGenerators.get(string).generateValue(string, this.getView(string));
            final Object v = hashMap.get(string);
            this.updateState(string);
            this.fDefaultValues.put(string, object);
            if (this.fExplicitValues.get(string) == null && object != null) {
                this.serialize(string);
                arrayList.add(new Runnable(){

                    @Override
                    public void run() {
                        VariableGraph.this.fPropertySupport.firePropertyChange(string, v, object);
                    }
                });
            }
            set.remove(string);
        }
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            object = (Runnable)iterator.next();
            object.run();
        }
    }

    private synchronized void serialize(String string) {
        this.fXml.remove(string);
        Object object = this.getValue(string);
        XmlSerializer xmlSerializer = this.fSerializers.get(string);
        if (xmlSerializer != null) {
            this.fXml.put(string, xmlSerializer.serialize(object));
        }
    }

    private synchronized String findVariableWithSatisfiedDependencies(Set<String> set) {
        for (String string : set) {
            if (this.hasAnyUnsatisfiedDependencies(string)) continue;
            return string;
        }
        return null;
    }

    private synchronized boolean hasAnyUnsatisfiedDependencies(String string) {
        for (String string2 : this.getDependenciesOf(string)) {
            if (this.isExplicitlySet(string2) || this.fDefaultValues.containsKey(string2)) continue;
            return true;
        }
        return false;
    }

    private static boolean valueEquals(Object object, Object object2) {
        return object == null && object2 == null || object != null && object2 != null && object.equals(object2);
    }

    public static interface XmlSerializer {
        public String serialize(Object var1);
    }

    public static interface Generator {
        public Object generateValue(String var1, VariableGraph var2);
    }
}

