/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.plugin;

import com.mathworks.project.api.Command;
import com.mathworks.project.api.ReadableConfiguration;
import com.mathworks.project.api.WritableConfiguration;
import com.mathworks.project.api.XmlApi;
import com.mathworks.project.api.XmlLooper;
import com.mathworks.project.api.XmlReader;
import com.mathworks.project.impl.engine.CopyCommand;
import com.mathworks.project.impl.engine.DeploymentScriptWriter;
import com.mathworks.project.impl.engine.ZipCommand;
import com.mathworks.project.impl.model.DynamicTargetScript;
import com.mathworks.project.impl.model.GeneratedReferenceSet;
import com.mathworks.project.impl.model.PackageType;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.model.ProjectManager;
import com.mathworks.xml.XMLUtils;
import java.io.File;
import java.lang.reflect.Constructor;
import java.util.Map;
import java.util.TreeMap;

final class XslBasedTargetScript
implements DynamicTargetScript {
    private final Map<String, String> fFunctions = new TreeMap<String, String>();
    private final String fNormalizedXsl;

    XslBasedTargetScript(String string, String string2) {
        this.fNormalizedXsl = XslBasedTargetScript.normalizeXsl(string2, "configuration", string, this.fFunctions);
    }

    @Override
    public void evaluate(final Project project, GeneratedReferenceSet generatedReferenceSet, final DeploymentScriptWriter deploymentScriptWriter, PackageType packageType, File file) {
        try {
            String string = ProjectManager.configurationToXml(project, packageType, file, generatedReferenceSet);
            XmlReader xmlReader = XmlApi.getInstance().read(XMLUtils.transform((String)string, (String)this.fNormalizedXsl)).getChild(new String[0]);
            XmlLooper xmlLooper = new XmlLooper(){

                public void iterate(XmlReader xmlReader) {
                    if (!(xmlReader.getCurrentElementName().equals("function") || xmlReader.getCurrentElementName().equals("type") || xmlReader.getCurrentElementName().equals("output") || xmlReader.getCurrentElementName().equals("validation") || xmlReader.getCurrentElementName().equals("command-line-adapter"))) {
                        if (xmlReader.getCurrentElementName().equals("matlab")) {
                            String string = xmlReader.readAttribute("echo");
                            boolean bl = true;
                            if (string != null && string.equals("false")) {
                                bl = false;
                            }
                            String string2 = xmlReader.readText().trim();
                            deploymentScriptWriter.writeMatlabCommand(string2, bl);
                        } else if (xmlReader.getCurrentElementName().equals("ant")) {
                            String string = xmlReader.getCurrentSubtree().getXML();
                            deploymentScriptWriter.writeAntScript(string);
                        } else {
                            if (XslBasedTargetScript.this.fFunctions.get(xmlReader.getCurrentElementName()) != null) {
                                String string = (String)XslBasedTargetScript.this.fFunctions.get(xmlReader.getCurrentElementName());
                                String string3 = ProjectManager.configurationToXslInput(project, null, xmlReader.readAttributes());
                                try {
                                    XmlReader xmlReader2 = XmlApi.getInstance().read(XMLUtils.transform((String)string3, (String)string)).getChild(new String[0]).getChild(new String[]{"function"});
                                    xmlReader2.loop((XmlLooper)this, new String[0]);
                                }
                                catch (Exception exception) {
                                    throw new IllegalStateException(exception);
                                }
                            }
                            if (xmlReader.getCurrentElementName().equals("copy")) {
                                deploymentScriptWriter.writeArbitraryCommand(new CopyCommand(xmlReader.getCurrentSubtree().getXML()));
                            } else if (xmlReader.getCurrentElementName().equals("zip")) {
                                deploymentScriptWriter.writeArbitraryCommand(new ZipCommand(xmlReader.getCurrentSubtree().getXML()));
                            } else {
                                if (xmlReader.getCurrentElementName().equals("java")) {
                                    try {
                                        Constructor<?> constructor;
                                        String string = xmlReader.readAttribute("class");
                                        Class<?> clazz = Class.forName(string);
                                        try {
                                            constructor = clazz.getConstructor(File.class, ReadableConfiguration.class, XmlReader.class);
                                        }
                                        catch (Exception exception) {
                                            constructor = clazz.getConstructor(File.class, WritableConfiguration.class, XmlReader.class);
                                        }
                                        Command command = (Command)constructor.newInstance(project.getFile(), project.getConfiguration(), xmlReader.getCurrentSubtree());
                                        deploymentScriptWriter.writeArbitraryCommand(command);
                                    }
                                    catch (Exception exception) {
                                        throw new IllegalStateException("Invalid java command (class should have a String constructor, implement Command, and be specified with fully qualified name: " + xmlReader.getCurrentElementName(), exception);
                                    }
                                }
                                throw new IllegalStateException("Unrecognized command: " + xmlReader.getCurrentElementName());
                            }
                        }
                    }
                }
            };
            xmlReader.loop(xmlLooper, new String[0]);
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception);
        }
    }

    private static String normalizeXsl(final String string, final String string2, String string3, final Map<String, String> map) {
        if (map != null && string3 != null) {
            try {
                XmlReader xmlReader = XmlApi.getInstance().read(string3);
                xmlReader.loop(new XmlLooper(){

                    public void iterate(XmlReader xmlReader) {
                        map.put(xmlReader.readAttribute("name"), XslBasedTargetScript.normalizeXsl(string, string2, "<" + string + ">" + xmlReader.getXML() + "</" + string + ">", null));
                    }
                }, new String[]{"function"});
            }
            catch (Exception exception) {
                throw new IllegalStateException(exception);
            }
        }
        return "<?xml version=\"1.0\" ?>\r\n\r\n<xsl:stylesheet version=\"1.0\" xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\">\r\n<xsl:output method=\"xml\" />\r\n<xsl:template match=\"/" + string2 + "\">\r\n" + "<build-script>\r\n" + (string3 == null ? "" : string3) + "\r\n" + "</build-script>\r\n" + "</xsl:template>\r\n" + "</xsl:stylesheet>";
    }
}

