/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.mathworks.matlab.api.explorer.CoreFileDecoration;
import com.mathworks.matlab.api.explorer.DetailPanel;
import com.mathworks.matlab.api.explorer.ExtensionRegistry;
import com.mathworks.matlab.api.explorer.FileInfoProvider;
import com.mathworks.matlab.api.explorer.FileLocation;
import com.mathworks.matlab.api.explorer.FileSystemEntry;
import com.mathworks.mlwidgets.explorer.extensions.basic.ImageFileInfoProvider;
import com.mathworks.mlwidgets.explorer.model.FileDecorationModel;
import com.mathworks.mlwidgets.explorer.model.MatlabPathModel;
import com.mathworks.mlwidgets.explorer.model.realfs.RealFileSystem;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.FileChooser;
import com.mathworks.project.impl.filesetui.FileSetLinkUtils;
import com.mathworks.project.impl.model.FileSetFilter;
import com.mathworks.project.impl.model.FileSetRule;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import com.mathworks.project.impl.settingsui.DetailedToolTip;
import com.mathworks.util.ParameterRunnable;
import com.mathworks.util.RequestQueue;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.RoundRectangle2D;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public final class ScreenshotPicker
extends AbstractParamWidget<File> {
    private final MJPanel fComponent;
    private final MJPanel fPrompt;
    private final RequestQueue fRequestQueue;
    private Component fPreview;
    private File fSelectedFile;
    private Timer fRepaintTimer;
    private Set<ChangeListener> fChangeListeners = new HashSet<ChangeListener>();

    public ScreenshotPicker(Param param, Project project) {
        this.fRequestQueue = new RequestQueue("Screenshot loader");
        this.fComponent = new MJPanel(){

            public void doLayout() {
                super.doLayout();
                if (ScreenshotPicker.this.fPreview != null) {
                    ScreenshotPicker.this.fPreview.setLocation(0, 0);
                    ScreenshotPicker.this.fPreview.setSize(this.getWidth(), this.getHeight());
                }
                ScreenshotPicker.this.fPrompt.setLocation((int)((double)(this.getWidth() / 2) - ScreenshotPicker.this.fPrompt.getPreferredSize().getWidth() / 2.0), (int)((double)(this.getHeight() / 2) - ScreenshotPicker.this.fPrompt.getPreferredSize().getHeight() / 2.0));
                ScreenshotPicker.this.fPrompt.setSize((int)Math.min(ScreenshotPicker.this.fPrompt.getPreferredSize().getWidth(), (double)this.getWidth()), (int)Math.min(ScreenshotPicker.this.fPrompt.getPreferredSize().getHeight(), (double)this.getHeight()));
            }
        };
        this.fComponent.setLayout(null);
        this.fComponent.setToolTipText(BuiltInResources.getString("details.screenshot"));
        this.fComponent.setBorder((Border)new LineBorder(new Color(0xDDDDDD)));
        this.fComponent.setOpaque(false);
        final JComponent jComponent = FileSetLinkUtils.createLink(BuiltInResources.getString("details.selectscreenshot"), "selectfile", new Runnable(){

            @Override
            public void run() {
                FileSetFilter fileSetFilter = new FileSetFilter(BuiltInResources.getString("details.imagefiles"));
                fileSetFilter.addRule(new FileSetRule("*.jpg", false));
                fileSetFilter.addRule(new FileSetRule("*.jpeg", false));
                fileSetFilter.addRule(new FileSetRule("*.bmp", false));
                fileSetFilter.addRule(new FileSetRule("*.png", false));
                File file = MatlabPathModel.getInstance().getCurrentFolder().toFile();
                if (ScreenshotPicker.this.fSelectedFile != null) {
                    file = ScreenshotPicker.this.fSelectedFile.getParentFile();
                }
                FileChooser fileChooser = FileChooser.create((Component)ScreenshotPicker.this.fComponent, BuiltInResources.getString("details.chooser"), file, false, Arrays.asList(fileSetFilter));
                fileChooser.setMultiSelectionEnabled(false);
                fileChooser.setAcceptAllFileFilterUsed(false);
                File[] fileArray = fileChooser.showOpenDialog();
                if (fileArray != null && fileArray.length == 1) {
                    ScreenshotPicker.this.select(fileArray[0]);
                    ScreenshotPicker.this.setData(fileArray[0]);
                }
            }
        }).getComponent();
        this.fPrompt = new MJPanel(new FlowLayout()){

            public void paintComponent(Graphics graphics) {
                Graphics2D graphics2D = (Graphics2D)graphics.create();
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics2D.setColor(new Color(0, 0, 0, 0));
                graphics2D.fillRect(0, 0, this.getWidth(), this.getHeight());
                graphics2D.setColor(new Color(255, 255, 255, 160));
                graphics2D.fill(new RoundRectangle2D.Double(jComponent.getX() - 4, jComponent.getY() - 4, jComponent.getWidth() + 4, jComponent.getHeight() + 8, 14.0, 14.0));
                graphics2D.dispose();
            }
        };
        this.fPrompt.add((Component)jComponent);
        this.fPrompt.setOpaque(false);
        this.fComponent.add((Component)this.fPrompt);
        this.fRepaintTimer = new Timer(20, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ScreenshotPicker.this.fComponent.repaint();
            }
        });
        this.fRepaintTimer.setRepeats(true);
        this.fRepaintTimer.start();
        DetailedToolTip.install((Component)this.fComponent, project.getConfiguration(), param);
    }

    public void dispose() {
        this.fRepaintTimer.stop();
    }

    public Component getComponent() {
        return this.fComponent;
    }

    private void select(File file) {
        try {
            FileSetFilter fileSetFilter = new FileSetFilter(BuiltInResources.getString("details.imagefiles"));
            fileSetFilter.addRule(new FileSetRule("*.jpg", false));
            fileSetFilter.addRule(new FileSetRule("*.jpeg", false));
            fileSetFilter.addRule(new FileSetRule("*.bmp", false));
            fileSetFilter.addRule(new FileSetRule("*.png", false));
            fileSetFilter.addRule(new FileSetRule("*.gif", false));
            if (fileSetFilter.accept(file) && file != null && file.exists()) {
                FileSystemEntry fileSystemEntry = RealFileSystem.getInstance().getEntry(new FileLocation(file));
                ExtensionRegistry extensionRegistry = new ExtensionRegistry();
                extensionRegistry.addInfoProvider((FileInfoProvider)new ImageFileInfoProvider(false, 1.0));
                FileDecorationModel fileDecorationModel = new FileDecorationModel(extensionRegistry, this.fRequestQueue, fileSystemEntry);
                fileDecorationModel.getDecorations().get(CoreFileDecoration.DETAIL_PANEL, false, (ParameterRunnable)new ParameterRunnable<DetailPanel>(){

                    public void run(DetailPanel detailPanel) {
                        ScreenshotPicker.this.fPreview = detailPanel.getComponent();
                        ScreenshotPicker.this.fComponent.removeAll();
                        ScreenshotPicker.this.fComponent.add(ScreenshotPicker.this.fPreview);
                        ScreenshotPicker.this.fComponent.add((Component)ScreenshotPicker.this.fPrompt);
                        ScreenshotPicker.this.fComponent.setComponentZOrder(ScreenshotPicker.this.fPreview, 1);
                        ScreenshotPicker.this.fComponent.setComponentZOrder((Component)ScreenshotPicker.this.fPrompt, 0);
                        ScreenshotPicker.this.fComponent.revalidate();
                        ScreenshotPicker.this.fComponent.repaint();
                    }
                });
                this.fSelectedFile = file;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setEnabled(boolean bl) {
    }

    public void setData(File file) {
        if (file != null && file.exists()) {
            this.select(file);
            this.changeEvent();
        }
    }

    public File getData() {
        return this.fSelectedFile;
    }

    private void changeEvent() {
        for (ChangeListener changeListener : this.fChangeListeners) {
            changeListener.stateChanged(new ChangeEvent(this));
        }
    }

    @Override
    public void addChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.add(changeListener);
    }

    @Override
    public void removeChangeListener(ChangeListener changeListener) {
        this.fChangeListeners.remove(changeListener);
    }
}

