/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.mathworks.mwswing.MJComboBox;
import com.mathworks.mwswing.MJPanel;
import com.mathworks.mwswing.MJScrollPane;
import com.mathworks.mwswing.MJTextArea;
import com.mathworks.mwswing.MJTextField;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.api.ValidationMessage;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.Project;
import com.mathworks.project.impl.settingsui.AbstractParamWidget;
import com.mathworks.project.impl.settingsui.DetailedToolTip;
import com.mathworks.project.impl.settingsui.ParamUtils;
import com.mathworks.project.impl.settingsui.StringWidgetStyle;
import com.mathworks.project.impl.settingsui.TextFieldWithValidation;
import com.mathworks.project.impl.settingsui.validation.BasicTextValidator;
import com.mathworks.widgets.SyntaxTextPane;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.AbstractDocument;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.DocumentFilter;
import javax.swing.text.JTextComponent;

public class StringWidget
extends AbstractParamWidget<String> {
    private final TextFieldWithValidation fFieldWithValidation;
    private final JTextComponent fField;
    private final MJComboBox fComboBox;
    private final JComponent fComponent;
    private final Project fProject;
    private final PropertyChangeListener fSyntaxListener;
    private final PropertyChangeListener fPropertyChangeListener;

    public StringWidget(String string, String string2, int n, int n2, boolean bl, final boolean bl2, final Param param, Project project) {
        Object object;
        this.fProject = project;
        String string3 = project.getConfiguration().getParamSyntax(param.getKey());
        if (string3 != null) {
            this.fComboBox = null;
            this.fField = ParamUtils.createSyntaxTextPane(n, n2);
            this.fSyntaxListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (Configuration.isParamSyntaxChange(propertyChangeEvent)) {
                        ParamUtils.updateSyntax((SyntaxTextPane)StringWidget.this.fField, (String)propertyChangeEvent.getNewValue());
                    }
                }
            };
            this.fProject.addPropertyChangeListener(this.fSyntaxListener);
            ParamUtils.updateSyntax((SyntaxTextPane)this.fField, string3);
            this.fFieldWithValidation = null;
            this.fComponent = new MJScrollPane((Component)this.fField);
        } else if (ParamUtils.getStringWidgetStyle(param) == StringWidgetStyle.SUGGESTION_BOX) {
            this.fComboBox = new MJComboBox();
            this.fComboBox.setEditable(true);
            this.fField = null;
            this.fFieldWithValidation = null;
            this.fSyntaxListener = null;
            for (String string4 : ParamUtils.getSuggestions(param)) {
                this.fComboBox.addItem((Object)string4);
            }
            this.fComponent = this.fComboBox;
        } else if (n < 2) {
            this.fComboBox = null;
            this.fSyntaxListener = null;
            if (bl) {
                Insets insets;
                this.fField = new MJTextField(){

                    public void setEnabled(boolean bl) {
                        super.setEnabled(true);
                        super.setEditable(bl);
                    }

                    public Dimension getPreferredSize() {
                        if (bl2) {
                            return new Dimension(10, (int)super.getPreferredSize().getHeight());
                        }
                        return super.getPreferredSize();
                    }

                    public Dimension getMinimumSize() {
                        if (bl2) {
                            return new Dimension(0, (int)super.getMinimumSize().getHeight());
                        }
                        return super.getMinimumSize();
                    }
                };
                ((MJTextField)this.fField).setColumns(20);
                this.fField.setOpaque(false);
                object = null;
                if (this.fField.getBorder() != null && (insets = this.fField.getBorder().getBorderInsets(this.fField)) != null) {
                    object = BorderFactory.createEmptyBorder(insets.top, insets.left, insets.bottom, insets.right);
                }
                this.fField.setBorder((Border)object);
                this.fFieldWithValidation = null;
            } else {
                this.fFieldWithValidation = new TextFieldWithValidation();
                this.fField = this.fFieldWithValidation.getTextField();
                if (n2 > 0 && this.fField instanceof JTextField) {
                    ((JTextField)this.fField).setColumns(n2);
                } else {
                    ((JTextField)this.fField).setColumns(20);
                }
            }
            this.fComponent = new MJPanel();
            if (n2 > 0) {
                this.fComponent.setLayout((LayoutManager)new FormLayout("fill:d", "d"));
            } else {
                this.fComponent.setLayout((LayoutManager)new FormLayout("fill:d:grow", "d"));
            }
            this.fComponent.add((Component)this.fField, new CellConstraints(1, 1));
            this.fComponent.setOpaque(false);
        } else {
            this.fComboBox = null;
            this.fSyntaxListener = null;
            this.fFieldWithValidation = null;
            this.fField = new MJTextArea(n, 1);
            if (n2 == 0) {
                ((MJTextArea)this.fField).setLineWrap(true);
                ((MJTextArea)this.fField).setWrapStyleWord(true);
            }
            this.fComponent = new MJScrollPane((Component)this.fField);
        }
        if (this.fField != null && string2 != null && string3 == null) {
            DetailedToolTip.install((Component)this.fField, project.getConfiguration(), param);
        }
        if (this.fField != null) {
            this.fField.setName(string + ".field");
            this.fField.getDocument().addDocumentListener(this.createDocumentListener());
        } else if (this.fComboBox != null) {
            this.fComboBox.setName(string + ".field");
            this.fComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent itemEvent) {
                    StringWidget.this.fireListeners();
                }
            });
            if (this.fComboBox.getEditor().getEditorComponent() instanceof JTextComponent) {
                ((JTextComponent)this.fComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this.createDocumentListener());
            }
        }
        if (param.getOptionExpression() != null) {
            this.fPropertyChangeListener = new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName().equals(Configuration.getEnumOptionsKey(param))) {
                        StringWidget.this.updateOptions((String)propertyChangeEvent.getNewValue());
                    }
                }
            };
            project.addPropertyChangeListener(this.fPropertyChangeListener);
            object = project.getConfiguration().getParamAsString(param.getKey());
            this.updateOptions((String)object);
        } else {
            this.fPropertyChangeListener = null;
        }
        if (param.getValidationRule() != null) {
            new BasicTextValidator(this.fField, param.getValidationRule());
        }
    }

    private void updateOptions(final String string) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                StringWidget.this.setData(string);
            }
        });
    }

    @Override
    public boolean showValidationMessage(ValidationMessage validationMessage) {
        if (this.fFieldWithValidation != null) {
            this.fFieldWithValidation.setValidationMessage(validationMessage);
            return true;
        }
        return false;
    }

    @Override
    public void clearValidationMessage() {
        if (this.fFieldWithValidation != null) {
            this.fFieldWithValidation.clearValidationMessage();
        }
    }

    public void setData(String string) {
        if (this.fField != null) {
            this.fField.setText(string);
            this.fField.scrollRectToVisible(new Rectangle(0, 0, 1, 1));
        } else {
            this.fComboBox.setSelectedItem((Object)string);
        }
    }

    public String getData() {
        if (this.fField != null) {
            return this.fField.getText().replaceAll("\r", "");
        }
        if (this.fComboBox.getEditor().getEditorComponent().hasFocus()) {
            return (String)this.fComboBox.getEditor().getItem();
        }
        return this.fComboBox.getSelectedItem().toString();
    }

    public Component getComponent() {
        return this.fComponent;
    }

    public JTextComponent getField() {
        return this.fField;
    }

    public void setFont(Font font) {
        if (this.fField != null) {
            this.fField.setFont(font);
        } else {
            this.fComboBox.setFont(font);
        }
    }

    public void dispose() {
        if (this.fSyntaxListener != null) {
            this.fProject.removePropertyChangeListener(this.fSyntaxListener);
        }
        if (this.fPropertyChangeListener != null) {
            this.fProject.removePropertyChangeListener(this.fPropertyChangeListener);
        }
        DetailedToolTip.uninstall(this.fField);
    }

    public void setEnabled(boolean bl) {
        if (this.fField != null) {
            this.fField.setEnabled(bl);
        } else {
            this.fComboBox.setEnabled(bl);
        }
    }

    public void setCharacterLimit(final int n) {
        Document document = this.getField().getDocument();
        DocumentFilter documentFilter = new DocumentFilter(){

            @Override
            public void replace(DocumentFilter.FilterBypass filterBypass, int n3, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                if (filterBypass.getDocument().getLength() + string.length() - n2 <= n) {
                    super.replace(filterBypass, n3, n2, string, attributeSet);
                } else if (string.length() > n) {
                    super.replace(filterBypass, n3, n2, string.substring(0, n), attributeSet);
                }
            }

            @Override
            public void insertString(DocumentFilter.FilterBypass filterBypass, int n2, String string, AttributeSet attributeSet) throws BadLocationException {
                if (filterBypass.getDocument().getLength() + string.length() < n) {
                    super.insertString(filterBypass, n2, string, attributeSet);
                }
            }
        };
        ((AbstractDocument)document).setDocumentFilter(documentFilter);
    }
}

