/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.settingsui.table;

import com.mathworks.jmi.Matlab;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.project.impl.BuiltInResources;
import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.Param;
import com.mathworks.project.impl.model.ParamType;
import com.mathworks.project.impl.table.PropertyTableColumn;
import com.mathworks.project.impl.util.StringUtils;
import com.mathworks.widgets.HyperlinkTextLabel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ValueColumn
implements PropertyTableColumn<Param> {
    private final Configuration fConfiguration;
    private final PropertyChangeListener fConfigurationListener;
    private final String fName;
    private final Map<String, HyperlinkTextLabel> fLinks;

    public ValueColumn(Configuration configuration) {
        this(configuration, BuiltInResources.getString("settings.header.value"));
    }

    public ValueColumn(Configuration configuration, String string) {
        this.fConfiguration = configuration;
        this.fName = string;
        this.fLinks = new HashMap<String, HyperlinkTextLabel>();
        this.fConfigurationListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (Configuration.isMoreInfoVisibilityChange(propertyChangeEvent)) {
                    ValueColumn.this.updateLinkVisibility(ValueColumn.this.fConfiguration.getParamWithAffectedState(propertyChangeEvent));
                }
            }
        };
        this.fConfiguration.addPropertyChangeListener(this.fConfigurationListener);
    }

    @Override
    public String getName() {
        return this.fName;
    }

    @Override
    public boolean isEditable() {
        return true;
    }

    @Override
    public String getText(Param param) {
        int n;
        String string;
        if (param == null) {
            return "";
        }
        Object object = this.fConfiguration.getParamAsObject(param.getKey());
        if (object != null && param.getType() == ParamType.ENUM && !param.getOptions().isEmpty()) {
            object = param.getOptions().get(object);
        }
        if (object instanceof List) {
            object = StringUtils.listToDelimitedString((List)object);
        }
        if ((string = "" + object).equals("null") || string.equals("[]")) {
            return "";
        }
        if (string.equals("true")) {
            string = BuiltInResources.getString("param.boolean.true");
        }
        if (string.equals("false")) {
            string = BuiltInResources.getString("param.boolean.false");
        }
        if ((n = string.indexOf(10)) > -1) {
            string = string.substring(0, n) + " [...]";
        }
        return string;
    }

    private void updateLinkVisibility(final Param param) {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                HyperlinkTextLabel hyperlinkTextLabel = (HyperlinkTextLabel)ValueColumn.this.fLinks.get(param.getKey());
                if (hyperlinkTextLabel != null) {
                    hyperlinkTextLabel.getComponent().setVisible(ValueColumn.this.fConfiguration.isMoreInfoVisible(param.getKey()));
                }
            }
        });
    }

    @Override
    public HyperlinkTextLabel createLink(final Param param) {
        HyperlinkTextLabel hyperlinkTextLabel = this.fLinks.get(param.getKey());
        if (hyperlinkTextLabel != null) {
            return hyperlinkTextLabel;
        }
        if (param.getMoreInfoLinkText() != null && this.fConfiguration.isMoreInfoVisible(param.getKey())) {
            HyperlinkTextLabel hyperlinkTextLabel2 = new HyperlinkTextLabel("<html><a href=\"\">" + param.getMoreInfoLinkText() + "</a></html>", new HyperlinkTextLabel.HyperlinkHandler(){

                public void processHyperlink(String string) {
                    new Matlab().evalConsoleOutput(param.getMoreInfoLinkCallback());
                }
            });
            hyperlinkTextLabel2.getComponent().setVisible(this.fConfiguration.isMoreInfoVisible(param.getKey()));
            this.fLinks.put(param.getKey(), hyperlinkTextLabel2);
            return hyperlinkTextLabel2;
        }
        return null;
    }

    public void dispose() {
        this.fConfiguration.removePropertyChangeListener(this.fConfigurationListener);
        this.fLinks.clear();
    }
}

