/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.project.impl.workflowui;

import com.mathworks.project.impl.model.Configuration;
import com.mathworks.project.impl.model.WorkflowStep;
import java.util.LinkedList;
import java.util.List;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

final class WorkflowTreeModel
implements TreeModel {
    private final Object fRoot = new Object();
    private final Configuration fConfiguration;

    WorkflowTreeModel(Configuration configuration) {
        this.fConfiguration = configuration;
    }

    @Override
    public Object getRoot() {
        return this.fRoot;
    }

    @Override
    public Object getChild(Object object, int n) {
        return this.getChildren(object).get(n);
    }

    private List<WorkflowStep> getChildren(Object object) {
        if (object.equals(this.fRoot)) {
            return this.fConfiguration.getTarget().getWorkflow().getSteps();
        }
        List<WorkflowStep> list = ((WorkflowStep)object).getSubSteps();
        LinkedList<WorkflowStep> linkedList = new LinkedList<WorkflowStep>();
        for (WorkflowStep workflowStep : list) {
            if (!this.fConfiguration.isStepVisible(workflowStep)) continue;
            linkedList.add(workflowStep);
        }
        return linkedList;
    }

    @Override
    public int getChildCount(Object object) {
        return this.getChildren(object).size();
    }

    @Override
    public boolean isLeaf(Object object) {
        return false;
    }

    @Override
    public void valueForPathChanged(TreePath treePath, Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getIndexOfChild(Object object, Object object2) {
        return this.getChildren(object).indexOf(object2);
    }

    @Override
    public void addTreeModelListener(TreeModelListener treeModelListener) {
    }

    @Override
    public void removeTreeModelListener(TreeModelListener treeModelListener) {
    }
}

