/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.util;

import com.mathworks.util.FactoryUtils;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.util.Vector;
import sun.awt.DisplayChangedListener;
import sun.java2d.SunGraphicsEnvironment;

public class GraphicsDeviceUtilities {
    private static int sScreenWidth;
    private static int sScreenHeight;
    private static int sScreenDPI;
    private static int sNumberOfScreens;
    private static int sScreenDepth;
    private static Rectangle sPrimaryScreenRect;
    private static GraphicsDevice[] sGraphicsDevices;
    private static boolean sReadyForCacheLookup;
    private static DisplayChangedListener sDisplayConfigurationChangedListener;
    private static boolean sInCachingState;
    private static Vector<Runnable> sLoadLibraryHooks;
    private static Vector<DisplayChangeListener> sDisplayChangeInterestedListeners;

    private static void addDisplayChangedListener() {
        if (sDisplayConfigurationChangedListener == null) {
            sDisplayConfigurationChangedListener = new DisplayChangedListener(){

                @Override
                public void displayChanged() {
                    GraphicsDeviceUtilities.queryGraphicsEnvironmentForDeviceInformation();
                    if (!sDisplayChangeInterestedListeners.isEmpty()) {
                        for (DisplayChangeListener displayChangeListener : sDisplayChangeInterestedListeners) {
                            displayChangeListener.sendDisplayChangedEvent(sScreenDPI, sNumberOfScreens, sScreenDepth, sPrimaryScreenRect);
                        }
                    }
                }

                @Override
                public void paletteChanged() {
                }
            };
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            assert (graphicsEnvironment instanceof SunGraphicsEnvironment);
            SunGraphicsEnvironment sunGraphicsEnvironment = (SunGraphicsEnvironment)graphicsEnvironment;
            sunGraphicsEnvironment.addDisplayChangedListener(sDisplayConfigurationChangedListener);
        }
    }

    public static void registerLoadLibraryMethod(Runnable runnable) {
        sLoadLibraryHooks.addElement(runnable);
    }

    public static void registerNotifyDisplayChangeMethod(DisplayChangeListener displayChangeListener) {
        sDisplayChangeInterestedListeners.addElement(displayChangeListener);
    }

    private static void queryGraphicsEnvironmentForDeviceInformation() {
        if (!sInCachingState) {
            sInCachingState = true;
            sGraphicsDevices = GraphicsDeviceUtilities.fetchAllDevices();
            sScreenWidth = GraphicsDeviceUtilities.fetchDefaultScreenWidth();
            sScreenHeight = GraphicsDeviceUtilities.fetchDefaultScreenHeight();
            sScreenDPI = GraphicsDeviceUtilities.fetchScreenDPI();
            sNumberOfScreens = GraphicsDeviceUtilities.fetchNumberOfScreens();
            sScreenDepth = GraphicsDeviceUtilities.fetchScreenDepth();
            sPrimaryScreenRect = GraphicsDeviceUtilities.fetchPrimaryScreenRect();
            sInCachingState = false;
        }
    }

    protected static void initializeClass() {
        GraphicsDeviceUtilities.turnOptimizationOnForLocalCaching();
        GraphicsDeviceUtilities.loadLibraries();
    }

    private static void loadLibraries() {
        for (Runnable runnable : sLoadLibraryHooks) {
            runnable.run();
        }
    }

    private static void turnOptimizationOnForLocalCaching() {
        GraphicsDeviceUtilities.queryGraphicsEnvironmentForDeviceInformation();
        if (!sInCachingState) {
            GraphicsDeviceUtilities.addDisplayChangedListener();
            sReadyForCacheLookup = true;
        }
    }

    private static GraphicsDevice[] fetchAllDevices() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] graphicsDeviceArray = null;
        try {
            assert (graphicsEnvironment != null);
            graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return graphicsDeviceArray;
    }

    private static int fetchScreenDepth() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        assert (graphicsEnvironment != null);
        int n = -1;
        try {
            GraphicsDevice graphicsDevice = graphicsEnvironment.getDefaultScreenDevice();
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            int n2 = -1;
            try {
                n2 = graphicsDevice.getDisplayMode().getBitDepth();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            n = n2 == -1 ? graphicsConfiguration.getColorModel().getPixelSize() : n2;
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return n;
    }

    private static Rectangle fetchPrimaryScreenRect() {
        Rectangle rectangle = GraphicsDeviceUtilities.getMonitorRectangle(0);
        for (int i = 0; i < GraphicsDeviceUtilities.getNumberOfScreens(); ++i) {
            Rectangle rectangle2 = GraphicsDeviceUtilities.getMonitorRectangle(i);
            if (rectangle2.getX() != 0.0 || rectangle2.getY() != 0.0) continue;
            rectangle = rectangle2;
        }
        return rectangle;
    }

    private static int fetchNumberOfScreens() {
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        int n = 0;
        try {
            assert (graphicsEnvironment != null);
            GraphicsDevice[] graphicsDeviceArray = graphicsEnvironment.getScreenDevices();
            n = graphicsDeviceArray.length;
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
        return n;
    }

    private static int fetchScreenDPI() {
        final int[] nArray = new int[1];
        FactoryUtils.invokeAndWait(new Runnable(){

            @Override
            public void run() {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                nArray[0] = toolkit.getScreenResolution();
            }
        });
        return nArray[0];
    }

    private static int fetchDefaultScreenHeight() {
        GraphicsConfiguration graphicsConfiguration = GraphicsDeviceUtilities.getDefaultGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return 0;
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        return (int)rectangle.getHeight();
    }

    private static int fetchDefaultScreenWidth() {
        GraphicsConfiguration graphicsConfiguration = GraphicsDeviceUtilities.getDefaultGraphicsConfiguration();
        if (graphicsConfiguration == null) {
            return 0;
        }
        Rectangle rectangle = graphicsConfiguration.getBounds();
        return (int)rectangle.getWidth();
    }

    public static GraphicsConfiguration getDefaultGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration;
        block4: {
            graphicsConfiguration = null;
            try {
                if (!GraphicsEnvironment.isHeadless()) {
                    graphicsConfiguration = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
                }
            }
            catch (HeadlessException headlessException) {
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
        assert (graphicsConfiguration != null);
        return graphicsConfiguration;
    }

    public static int getDefaultScreenWidth() {
        if (!sReadyForCacheLookup) {
            GraphicsDeviceUtilities.turnOptimizationOnForLocalCaching();
        }
        return sScreenWidth;
    }

    public static int getDefaultScreenHeight() {
        if (!sReadyForCacheLookup) {
            GraphicsDeviceUtilities.turnOptimizationOnForLocalCaching();
        }
        return sScreenHeight;
    }

    public static int getNumberOfScreens() {
        if (!sReadyForCacheLookup) {
            GraphicsDeviceUtilities.turnOptimizationOnForLocalCaching();
        }
        return sNumberOfScreens;
    }

    public static int getDefaultScreenResolution() {
        if (!sReadyForCacheLookup) {
            GraphicsDeviceUtilities.turnOptimizationOnForLocalCaching();
        }
        return sScreenDPI;
    }

    public static Rectangle getMonitorRectangle(int n) {
        if (!sReadyForCacheLookup) {
            GraphicsDeviceUtilities.turnOptimizationOnForLocalCaching();
        }
        GraphicsConfiguration graphicsConfiguration = sGraphicsDevices[n].getDefaultConfiguration();
        return graphicsConfiguration.getBounds();
    }

    public static Rectangle getPrimaryScreenRect() {
        if (!sReadyForCacheLookup) {
            GraphicsDeviceUtilities.turnOptimizationOnForLocalCaching();
        }
        return sPrimaryScreenRect;
    }

    public static int getScreenDepth() {
        if (!sReadyForCacheLookup) {
            GraphicsDeviceUtilities.turnOptimizationOnForLocalCaching();
        }
        return sScreenDepth;
    }

    static {
        sReadyForCacheLookup = false;
        sDisplayConfigurationChangedListener = null;
        sInCachingState = false;
        sLoadLibraryHooks = new Vector();
        sDisplayChangeInterestedListeners = new Vector();
    }

    public static interface DisplayChangeListener {
        public void sendDisplayChangedEvent(int var1, int var2, int var3, Rectangle var4);
    }
}

