/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.Tracker;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class TrackerResize
extends Tracker {
    private int fPart;
    private int fResizeIndex = -2;
    private int fOriginalSize;
    private int fOriginalOffset;

    public TrackerResize() {
        super(67);
    }

    @Override
    public boolean mousePressed(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.getSource() instanceof Table) {
            Table table = (Table)mouseEvent.getSource();
            Point point = mouseEvent.getPoint();
            this.fPart = table.findPart(point.x, point.y);
            if (this.fPart == 5 || this.fPart == 3) {
                this.fResizeIndex = table.getResizeIndex(point.x, point.y);
                if (this.fResizeIndex != -2) {
                    if (this.fPart == 5) {
                        this.fOriginalSize = table.getRowHeight(this.fResizeIndex);
                        this.fOriginalOffset = point.y;
                    } else if (this.fPart == 3) {
                        this.fOriginalSize = table.getColumnWidth(this.fResizeIndex);
                        this.fOriginalOffset = point.x;
                    }
                    bl = true;
                }
            }
        }
        return bl;
    }

    @Override
    public boolean mouseDragged(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.getSource() instanceof Table && this.fResizeIndex != -2) {
            Table table = (Table)mouseEvent.getSource();
            if (this.fPart == 5) {
                int n = mouseEvent.getPoint().y;
                int n2 = this.fOriginalSize + (n - this.fOriginalOffset);
                if (n2 < 10) {
                    n2 = 10;
                }
                if (n2 != table.getRowHeight(this.fResizeIndex)) {
                    table.setRowHeight(this.fResizeIndex, n2);
                    table.repaint();
                }
            } else if (this.fPart == 3) {
                int n = table.getAutoExpandColumn();
                int n3 = mouseEvent.getPoint().x;
                int n4 = n != -1 && n < this.fResizeIndex ? this.fOriginalSize + (this.fOriginalOffset - n3) : this.fOriginalSize + (n3 - this.fOriginalOffset);
                if (n4 < 10) {
                    n4 = 10;
                }
                if (n != -1) {
                    int n5 = table.getColumnWidth(n) - table.getMinAutoExpandColumnWidth();
                    int n6 = table.getColumnWidth(this.fResizeIndex);
                    int n7 = n4 - n6;
                    if (n5 == 0) {
                        int n8;
                        int n9;
                        int n10 = table.getData().getWidth();
                        if (n < this.fResizeIndex) {
                            n9 = this.fResizeIndex - 1;
                            n8 = table.getColumnWidth(n9);
                            while (!(n8 != 0 && n9 != n || n9 == n && n7 <= 0 || table.isResizeZeroWidthColumns() || --n9 < 0)) {
                                n8 = table.getColumnWidth(n9);
                            }
                        } else {
                            n9 = this.fResizeIndex + 1;
                            n8 = table.getColumnWidth(n9);
                            while (!(n8 != 0 && n9 != n || n9 == n && n7 <= 0 || table.isResizeZeroWidthColumns() || ++n9 >= n10)) {
                                n8 = table.getColumnWidth(n9);
                            }
                        }
                        if (n8 < 10 && n7 > 0 && n9 != n) {
                            n9 = n10;
                        }
                        if (n9 != n) {
                            if (n9 == n10 || n9 < 0) {
                                n4 = n6;
                            } else {
                                int n11 = table.getColumnWidth(n9);
                                n5 = n11 - 10;
                                if (n5 > n7) {
                                    n5 = n7;
                                }
                                n4 = n6 + n5;
                                table.setColumnWidth(n9, n11 - n5);
                            }
                        }
                    } else if (n7 > n5) {
                        n4 = n6 + n5;
                    }
                }
                if (n4 != table.getColumnWidth(this.fResizeIndex)) {
                    table.setColumnWidth(this.fResizeIndex, n4);
                    table.repaint();
                }
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean mouseReleased(MouseEvent mouseEvent) {
        boolean bl = false;
        if (mouseEvent.getSource() instanceof Table && this.fResizeIndex != -2) {
            ((Table)mouseEvent.getSource()).layoutScrollbars();
            ((Table)mouseEvent.getSource()).repaint();
            this.fResizeIndex = -2;
            bl = true;
        }
        return bl;
    }
}

