/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.table;

import com.mathworks.mwt.table.Selection;
import com.mathworks.mwt.table.Table;
import com.mathworks.mwt.table.TableUtils;
import com.mathworks.mwt.table.Tracker;
import com.mathworks.util.PlatformInfo;
import java.awt.Point;
import java.awt.event.MouseEvent;

public class TrackerSelection
extends Tracker {
    private Selection fSelection;
    private Point fLastPoint;
    private boolean fIsTracking;

    TrackerSelection(Selection selection) {
        super(67);
        this.fSelection = selection;
        this.fLastPoint = null;
        this.fIsTracking = false;
    }

    @Override
    public boolean mousePressed(MouseEvent mouseEvent) {
        Table table = (Table)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        Point point2 = table.findCell(point.x, point.y);
        int n = TableUtils.getSelectionModifier(mouseEvent.getModifiers());
        int n2 = table.findPart(point.x, point.y);
        boolean bl = table.getRowOptions().isHeaderSelectable();
        boolean bl2 = table.getColumnOptions().isHeaderSelectable();
        boolean bl3 = true;
        if (point2.x == -1 && !bl) {
            bl3 = false;
        } else if (point2.y == -1 && !bl2) {
            bl3 = false;
        } else if (n2 == 3 || n2 == 5) {
            bl3 = false;
        } else if (table.isContextTriggerAware() && this.willPop(mouseEvent)) {
            if (!table.isSelected(point2.y, point2.x)) {
                this.fSelection.clearSelection(point2.x == -2 || point2.y == -2);
                table.select(point2.y, point2.x);
            }
            bl3 = false;
        } else if (point2.x == -2 || point2.y == -2) {
            if (this.fSelection.getSelection().length > 0) {
                this.fSelection.clearSelection(true);
                table.repaint();
            }
            bl3 = false;
        } else if ((mouseEvent.getModifiers() & 0x10) == 0) {
            bl3 = false;
        }
        if (bl3) {
            this.fLastPoint = point2;
            this.fIsTracking = true;
            this.fSelection.trackSelection(point2.y, point2.x, n);
        }
        return false;
    }

    @Override
    public boolean mouseDragged(MouseEvent mouseEvent) {
        Table table = (Table)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        Point point2 = table.findCell(point.x, point.y);
        int n = TableUtils.getSelectionModifier(mouseEvent.getModifiers());
        if (this.fLastPoint != null && !this.fLastPoint.equals(point2) && this.fIsTracking) {
            this.fLastPoint = point2;
            this.fSelection.trackSelection(point2.y, point2.x, n);
        }
        return false;
    }

    @Override
    public boolean mouseReleased(MouseEvent mouseEvent) {
        Table table = (Table)mouseEvent.getSource();
        Point point = mouseEvent.getPoint();
        Point point2 = table.findCell(point.x, point.y);
        int n = TableUtils.getSelectionModifier(mouseEvent.getModifiers());
        if (this.fIsTracking) {
            this.fLastPoint = null;
            this.fIsTracking = false;
            this.fSelection.commitSelection(point2.y, point2.x, n);
        }
        return false;
    }

    private boolean willPop(MouseEvent mouseEvent) {
        boolean bl = false;
        switch (PlatformInfo.getPlatform()) {
            case 0: {
                bl = (mouseEvent.getModifiers() & 2) != 0;
                break;
            }
            case 2: {
                bl = mouseEvent.isPopupTrigger();
                break;
            }
            case 1: {
                bl = (mouseEvent.getModifiers() & 4) != 0;
            }
        }
        return bl;
    }
}

