/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.mwt.text;

import com.mathworks.mwt.MWClipboard;
import com.mathworks.mwt.MWClipboardMonitor;
import com.mathworks.mwt.MWComponent;
import com.mathworks.mwt.MWContainer;
import com.mathworks.mwt.MWFrame;
import com.mathworks.mwt.MWLabel;
import com.mathworks.mwt.MWMouseWheelTarget;
import com.mathworks.mwt.MWPanel;
import com.mathworks.mwt.MWScrollLayout;
import com.mathworks.mwt.MWScrollbar;
import com.mathworks.mwt.MWTextField;
import com.mathworks.mwt.MWUtils;
import com.mathworks.mwt.decorations.Decorations;
import com.mathworks.mwt.dialog.MWDialog;
import com.mathworks.mwt.dnd.DragItem;
import com.mathworks.mwt.dnd.DragMessage;
import com.mathworks.mwt.floater.Floater;
import com.mathworks.mwt.floater.FloaterOwner;
import com.mathworks.mwt.floater.FloaterPanel;
import com.mathworks.mwt.text.MWKeyMap;
import com.mathworks.mwt.text.MWStyle;
import com.mathworks.mwt.text.MWTextAdapter;
import com.mathworks.mwt.text.MWTextComponent;
import com.mathworks.mwt.text.MWTextEvent;
import com.mathworks.mwt.text.MWTextModel;
import com.mathworks.mwt.text.MWTextViewEvent;
import com.mathworks.mwt.text.MWTextViewListener;
import com.mathworks.util.Assert;
import com.mathworks.util.CharBuffer;
import com.mathworks.util.IntBuffer;
import com.mathworks.util.IntHashtable;
import com.mathworks.util.Log;
import com.mathworks.util.NativeJava;
import com.mathworks.util.PlatformInfo;
import com.mathworks.util.QueueEvent;
import com.mathworks.util.Range;
import com.mathworks.util.Timer;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class MWTextView
extends MWContainer
implements MWMouseWheelTarget,
FloaterOwner {
    public static final int CARET_BLINK_DELAY = NativeJava.getCaretBlinkRate() > 0 ? NativeJava.getCaretBlinkRate() : 550;
    private static final int CARET_HOLD_DELAY = 1000000000;
    private static final int AUTO_SCROLL_DELAY = 25;
    public static final int SCROLLBAR_MIN = 1;
    public static final int SCROLLBAR_NEVER = 1;
    public static final int SCROLLBAR_ALWAYS = 2;
    public static final int SCROLLBAR_MAX = 2;
    public static final int TEXT_COLORS = 0;
    public static final int WINDOW_COLORS = 1;
    public static final int CUSTOM_COLORS = 2;
    public static final int FIRST_CMD_ID = 0;
    public static final int CHAR_LEFT = 0;
    public static final int CHAR_LEFT_EXTEND = 1;
    public static final int CHAR_LEFT_DELETE = 2;
    public static final int CHAR_RIGHT = 3;
    public static final int CHAR_RIGHT_EXTEND = 4;
    public static final int CHAR_RIGHT_DELETE = 5;
    public static final int WORD_LEFT = 6;
    public static final int WORD_LEFT_EXTEND = 7;
    public static final int WORD_RIGHT = 8;
    public static final int WORD_RIGHT_EXTEND = 9;
    public static final int WORD_RIGHT_DELETE = 10;
    public static final int WORD_RIGHT_EMACS = 11;
    public static final int WORD_RIGHT_EXTEND_EMACS = 12;
    public static final int LINE_UP = 13;
    public static final int LINE_UP_EXTEND = 14;
    public static final int LINE_DOWN = 15;
    public static final int LINE_DOWN_EXTEND = 16;
    public static final int LINE_START = 17;
    public static final int LINE_START_EXTEND = 18;
    public static final int LINE_END = 19;
    public static final int LINE_END_EXTEND = 20;
    public static final int PAGE_UP = 21;
    public static final int PAGE_UP_EXTEND = 22;
    public static final int PAGE_DOWN = 23;
    public static final int PAGE_DOWN_EXTEND = 24;
    public static final int BUFFER_START = 25;
    public static final int BUFFER_START_EXTEND = 26;
    public static final int BUFFER_END = 27;
    public static final int BUFFER_END_EXTEND = 28;
    public static final int BUFFER_SELECT = 29;
    public static final int INSERT_LINE_BREAK = 30;
    public static final int INSERT_CHAR = 31;
    public static final int CUT = 32;
    public static final int COPY = 33;
    public static final int PASTE = 34;
    public static final int UNDO = 35;
    public static final int REDO = 36;
    public static final int NO_OP = 37;
    public static final int KILL_LINE = 38;
    public static final int CLEAR_SELECTION = 39;
    public static final int INCREMENTAL_SEARCH = 40;
    public static final int TEST = 100;
    public static final int LAST_CMD_ID = 100;
    private static Timer sCaretTimer;
    private static long sCaretTimerIdle;
    private static MWTextView sCaretTimerOwner;
    private static CaretTimerHandler sCaretTimerListener;
    private MWTextModel fText;
    private MWKeyMap fKeyMap;
    private IntHashtable fOverrides;
    private static MWKeyMap sKeyMap;
    private Range fSel = new Range();
    public static final int SEL_CHAR = 1;
    public static final int SEL_WORD = 2;
    public static final int SEL_LINE = 3;
    public static final int SEL_NORMAL = 0;
    public static final int SEL_ACTIVE = 1;
    public static final int SEL_CLICK = 8;
    private int fMouseSelMode = 1;
    private boolean fDragging = false;
    private Range fSelBeforeDrag = null;
    private Range fDragAnchor = new Range();
    private int fCurrChunkStart = 0;
    private int fCurrChunkEnd = 0;
    private int fGoalCol = 0;
    private boolean fCaretOn = false;
    private boolean fCaretEnabled = true;
    private boolean fLastShouldDrawCaret = false;
    private CaretTimerHandler fCaretTimerListener = new CaretTimerHandler();
    private Image fOffScreenBuffer;
    private Graphics fOffScreenGraphics;
    private boolean fHasFocus = false;
    private boolean fSelVisibleWhenNoFocus = false;
    private int fSelFocusOverride = 0;
    private boolean fBlackHighlight = false;
    private boolean fDimBGWhenNotEditable = true;
    private boolean fDimBGWhenDisabled = true;
    private boolean fDimFGWhenDisabled = true;
    private int fColorMode = 0;
    private int fVScrollStyle = 1;
    private MWScrollbar fVScroll;
    private VScrollEventHandler fVScrollEventHandler;
    private int fTopLine = 0;
    private int fHScrollStyle = 1;
    private MWScrollbar fHScroll;
    private HScrollEventHandler fHScrollEventHandler;
    private int fHScrollAmount = 0;
    private int fMaxLineWidth = 0;
    private boolean fHScrollLock;
    private TextCanvas fTextCanvas;
    private KeyListener fTextCanvasKeyHandler;
    private KeyListener fTextCanvasCtrlCKeyHandler;
    private Gutter fGutter;
    private TextContainer fTextContainer;
    private Vector fKeyFilters;
    private static final int REPAINT_NONE = 0;
    private static final int REPAINT_LINES = 1;
    private static final int REPAINT_ALL = 2;
    private static final int REPAINT_CANVAS = 3;
    private int fDeferUpdatesCounter = 0;
    private int fRepaintState = 0;
    private Range fLinesToRepaint = new Range(-1, -1);
    private int fDeferredScrollPos = -1;
    private boolean fRepaintPending = false;
    private boolean fAllowDragAndDrop = true;
    private boolean fSelInProgress;
    private boolean fDragInProgress;
    private int fDragPos = -1;
    private Graphics fDragGraphics;
    private Rectangle fDragRect;
    private Point fDragPoint;
    private Component fDragSource;
    private long fCaretTime;
    private long fAutoScrollTime;
    private MouseEventHandler fAutoScrollHandler;
    private MouseEventHandler fMouseHandler;
    private DragItem fDragItem;
    private CharBuffer fTabBuf = new CharBuffer();
    private RunInfo fRunInfo = new RunInfo();
    private MWTextModel.StyleRun fStyleRunX = new MWTextModel.StyleRun();
    private long fLastBorderBeep;
    private boolean fBeepOn = true;
    private boolean fBorderBeepOn = true;
    private boolean fEnabled = true;
    private TextEventHandler fTextEventHandler;
    private Vector fListeners = new Vector();
    private PropertyEventHandler fPropertyEventHandler;
    private int fEmacsKillSelStart = -1;
    private int fEmacsKillSelEnd = -1;
    private static Clipboard sClip;
    private int fIsPainting;
    private boolean fSwingHack;
    private boolean fDragTransfer;
    private String fSearchString;
    private KeyListener fMiniBufferKeyFilter;
    private ISearchPanel fMiniBufferPanel;
    private Container fMiniBufferParent;
    static int i;

    public MWTextView(MWTextModel mWTextModel) {
        if (mWTextModel == null) {
            throw new IllegalArgumentException("MWTextView(MWTextModel): text model must not be null");
        }
        if (sKeyMap == null) {
            sKeyMap = new MWKeyMap();
        }
        this.setLayout(new MWScrollLayout());
        this.fPropertyEventHandler = new PropertyEventHandler();
        this.setModel(mWTextModel);
        TextContainer textContainer = new TextContainer();
        textContainer.setLayout(new BorderLayout());
        this.fTextContainer = textContainer;
        this.fTextCanvas = new TextCanvas();
        textContainer.add((Component)this.fTextCanvas, "Center");
        this.fTextCanvasKeyHandler = new KeyEventHandler();
        this.fTextCanvas.addKeyListener(this.fTextCanvasKeyHandler);
        MouseEventHandler mouseEventHandler = new MouseEventHandler();
        this.addMouseListener(mouseEventHandler);
        this.addMouseMotionListener(mouseEventHandler);
        this.fTextCanvas.addComponentListener(new ComponentEventHandler());
        this.fMouseHandler = mouseEventHandler;
        this.fTextCanvas.addFocusListener(new FocusEventHandler());
        this.fGutter = new Gutter(0);
        textContainer.add((Component)this.fGutter, "West");
        this.add((Component)textContainer, "Center");
        if (sClip == null) {
            sClip = this.getToolkit().getSystemClipboard();
        }
        this.setCursor(Cursor.getPredefinedCursor(2));
        this.setSelVisibleWhenNoFocus(true);
        if (PlatformInfo.isMacintosh()) {
            this.setDimBGWhenNotEditable(false);
            this.setDimBGWhenDisabled(false);
        }
        this.updateBackground();
    }

    public void setModel(MWTextModel mWTextModel) {
        if (mWTextModel == this.fText) {
            return;
        }
        if (this.fTextEventHandler == null) {
            this.fTextEventHandler = new TextEventHandler();
        }
        if (this.fText != null) {
            this.fText.removeView(this);
            this.fText.removeTextListener(this.fTextEventHandler);
            this.fText.removePropertyChangeListener(this.fPropertyEventHandler);
        }
        if (mWTextModel != null) {
            mWTextModel.addPropertyChangeListener(this.fPropertyEventHandler);
            mWTextModel.addTextListener(this.fTextEventHandler);
            mWTextModel.addView(this, this.fTextEventHandler);
        }
        this.fText = mWTextModel;
    }

    public boolean getAllowDragAndDrop() {
        return this.fAllowDragAndDrop;
    }

    public void setAllowDragAndDrop(boolean bl) {
        this.fAllowDragAndDrop = bl;
    }

    @Override
    public void setCursor(Cursor cursor) {
        this.fTextCanvas.setCursor(cursor);
    }

    private void handleCursor(Point point) {
        Range range = this.getSel();
        if (!range.isEmpty()) {
            int n = this.selectionPosFromPixel(point);
            if (range.intersect(n, n)) {
                this.setCursor(Cursor.getPredefinedCursor(0));
            } else {
                MWStyle mWStyle = this.fText.getStyleAt(this.posFromPixel(point));
                if ((mWStyle.getStyle() & 1) != 0) {
                    this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    this.setCursor(Cursor.getPredefinedCursor(2));
                }
            }
        } else {
            MWStyle mWStyle = this.fText.getStyleAt(this.posFromPixel(point));
            if ((mWStyle.getStyle() & 1) != 0) {
                this.setCursor(Cursor.getPredefinedCursor(12));
            } else {
                this.setCursor(Cursor.getPredefinedCursor(2));
            }
        }
    }

    private Rectangle getSelectionBounds() {
        Rectangle rectangle = new Rectangle();
        int n = this.pixelYFromLine(this.fText.lineFromPos(this.getSelMin()));
        int n2 = this.pixelYFromLine(this.fText.lineFromPos(this.getSelMax()));
        char c = this.getModel().charAt(this.getSelMax() - 1);
        if ((c == '\n' || c == '\r') && n + this.fText.getFontHeight() == n2) {
            rectangle.x = this.pixelXFromPos(this.getSelMin());
            rectangle.width = this.getBounds().width - rectangle.x;
            rectangle.y = n;
            rectangle.height = this.fText.getFontBaseline();
        } else if (n == n2) {
            rectangle.x = this.pixelXFromPos(this.getSelMin());
            rectangle.width = this.pixelXFromPos(this.getSelMax()) - rectangle.x;
            rectangle.y = n;
            rectangle.height = this.fText.getFontBaseline();
        } else {
            rectangle.x = this.getBounds().x;
            rectangle.width = this.getBounds().width;
            rectangle.y = n;
            rectangle.height = n2 - n + this.fText.getFontBaseline();
        }
        return rectangle;
    }

    public int getTopLine() {
        return this.fTopLine;
    }

    public void setTopLine(int n) {
        this.fAutoScrollTime = System.currentTimeMillis() + 25L;
        this.fText.checkLine(n);
        this.fDeferredScrollPos = -1;
        if (n == this.fTopLine) {
            return;
        }
        int n2 = this.fTopLine;
        this.fTopLine = n;
        this.updateScrollbars();
        this.repaintCanvas();
        if (this.isSomeoneListening()) {
            MWTextViewEvent mWTextViewEvent = MWTextViewEvent.newTopLineChangedEvent(this, n2, this.fTopLine);
            this.notifyListeners(mWTextViewEvent);
        }
    }

    public int getHScrollAmount() {
        return this.fHScrollAmount;
    }

    public void setHScrollAmount(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Can't scroll to negative position");
        }
        if (n == this.fHScrollAmount) {
            return;
        }
        int n2 = this.fHScrollAmount;
        this.fHScrollAmount = n;
        this.updateScrollbars();
        this.repaintCanvas();
        if (this.isSomeoneListening()) {
            MWTextViewEvent mWTextViewEvent = MWTextViewEvent.newHScrollAmountChangedEvent(this, n2, this.fHScrollAmount);
            this.notifyListeners(mWTextViewEvent);
        }
    }

    public int getVScrollStyle() {
        return this.fVScrollStyle;
    }

    public void setVScrollStyle(int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Invalid scrollbar style.");
        }
        if (n == this.fVScrollStyle) {
            return;
        }
        this.fVScrollStyle = n;
        if (this.fVScrollStyle == 2) {
            this.fVScroll = new MWScrollbar(0, 0, 0, 0, 0);
            this.fVScroll.setUnitIncrement(1);
            this.add((Component)this.fVScroll, "Vertical");
            this.fVScrollEventHandler = new VScrollEventHandler();
            this.fVScroll.addAdjustmentListener(this.fVScrollEventHandler);
            this.fVScroll.setEnabled(this.isEnabled());
            int n2 = this.fDeferredScrollPos;
            this.updateScrollbars();
            this.fDeferredScrollPos = n2;
        } else {
            this.fVScroll.removeAdjustmentListener(this.fVScrollEventHandler);
            this.remove(this.fVScroll);
            this.fVScroll = null;
            this.fVScrollEventHandler = null;
        }
        this.invalidate();
        this.getParent().validate();
    }

    public int getHScrollStyle() {
        return this.fHScrollStyle;
    }

    public void setHScrollStyle(int n) {
        if (n < 1 || n > 2) {
            throw new IllegalArgumentException("Invalid scrollbar style.");
        }
        if (n == this.fHScrollStyle) {
            return;
        }
        this.fHScrollStyle = n;
        if (this.fHScrollStyle == 2) {
            this.fHScroll = new MWScrollbar(1, 0, 0, 0, 0);
            this.add((Component)this.fHScroll, "Horizontal");
            this.initHScroll();
        } else {
            this.fHScroll.removeAdjustmentListener(this.fHScrollEventHandler);
            this.remove(this.fHScroll);
            this.fHScroll = null;
            this.fHScrollEventHandler = null;
            this.setHScrollAmount(0);
        }
        this.invalidate();
        this.getParent().validate();
    }

    public MWScrollbar getHScroll() {
        return this.fHScroll;
    }

    public boolean setHScrollLock(boolean bl) {
        boolean bl2 = this.fHScrollLock;
        this.fHScrollLock = bl;
        return bl2;
    }

    public void setRemoteHScroll(MWScrollbar mWScrollbar) {
        this.setHScrollStyle(1);
        if (mWScrollbar != null) {
            this.fHScrollStyle = 2;
            this.fHScroll = mWScrollbar;
            this.initHScroll();
        }
    }

    private void initHScroll() {
        int n = this.fText.getFontWidth();
        if (n <= 0) {
            n = 10;
        }
        this.fHScroll.setUnitIncrement(n);
        this.fHScrollEventHandler = new HScrollEventHandler();
        this.fHScroll.addAdjustmentListener(this.fHScrollEventHandler);
        this.fHScroll.setEnabled(this.isEnabled());
        int n2 = this.fDeferredScrollPos;
        this.updateScrollbars();
        this.fDeferredScrollPos = n2;
    }

    @Override
    public void mouseWheelTurned(int n, int n2) {
        if (PlatformInfo.isWindows() && n2 == 0 && this.fVScroll != null && this.fVScroll.isEnabled()) {
            int n3 = this.getTopLine() + n;
            if (n3 < 0) {
                n3 = 0;
            } else if (n3 > this.fText.getNumLines()) {
                n3 = this.fText.getNumLines();
            }
            this.setTopLine(n3);
        }
    }

    private MWKeyMap keyMap() {
        if (this.fKeyMap == null) {
            return sKeyMap;
        }
        return this.fKeyMap;
    }

    public MWKeyMap getKeyMap() {
        if (this.fKeyMap == null) {
            this.fKeyMap = new MWKeyMap();
        }
        return this.fKeyMap;
    }

    public void setKeyMap(MWKeyMap mWKeyMap) {
        this.fKeyMap = mWKeyMap;
        if (this.fKeyMap == null) {
            this.fKeyMap = sKeyMap;
        }
    }

    public void setKeyBindingScheme(int n) {
        int n2 = this.fKeyMap == null ? sKeyMap.getKeyBindingScheme() : this.fKeyMap.getKeyBindingScheme();
        if (n2 != n) {
            if (this.fKeyMap == null) {
                this.fKeyMap = new MWKeyMap();
            }
            if (n == 2) {
                this.fKeyMap.setEmacsBindings();
            } else if (n == 1) {
                this.fKeyMap.setWindowsBindings();
            } else if (n == 3) {
                this.fKeyMap.setMacintoshBindings();
            }
        }
    }

    public int getKeyBindingScheme() {
        if (this.fKeyMap == null) {
            return sKeyMap.getKeyBindingScheme();
        }
        return this.fKeyMap.getKeyBindingScheme();
    }

    public synchronized void overrideCommand(int n, ActionListener actionListener) {
        if (this.fOverrides == null) {
            this.fOverrides = new IntHashtable();
        }
        this.fOverrides.put(n, (Object)actionListener);
    }

    public synchronized void removeCommandOverride(int n) {
        if (this.fOverrides != null) {
            this.fOverrides.remove(n);
        }
    }

    public synchronized ActionListener getCommandOverride(int n) {
        if (this.fOverrides == null) {
            return null;
        }
        return (ActionListener)this.fOverrides.get(n);
    }

    public MWTextModel getModel() {
        return this.fText;
    }

    public Dimension getTextCanvasSize() {
        return this.fTextCanvas.getSize();
    }

    @Override
    public void processKeyEvent(KeyEvent keyEvent) {
        this.fTextCanvas.processKeyEvent(keyEvent);
    }

    @Override
    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        this.fTextCanvas.processMouseMotionEvent(mouseEvent);
    }

    @Override
    public void requestFocus() {
        this.fTextCanvas.requestFocus();
    }

    @Override
    public boolean isFocusTraversable() {
        return this.isEnabled() && this.fText.isEditable();
    }

    @Override
    public boolean hasFocus() {
        return this.fHasFocus;
    }

    public boolean isActiveView() {
        return this == this.fText.getActiveView();
    }

    public void addKeyFilter(KeyListener keyListener) {
        if (keyListener != null) {
            int n;
            if (this.fKeyFilters == null) {
                this.fKeyFilters = new Vector();
                this.fKeyFilters.addElement(this.fTextCanvasKeyHandler);
            }
            for (n = 0; n < this.fKeyFilters.size(); ++n) {
                this.fTextCanvas.removeKeyListener((KeyListener)this.fKeyFilters.elementAt(n));
            }
            this.fKeyFilters.insertElementAt(keyListener, 0);
            for (n = 0; n < this.fKeyFilters.size(); ++n) {
                this.fTextCanvas.addKeyListener((KeyListener)this.fKeyFilters.elementAt(n));
            }
        }
    }

    public void removeKeyFilter(KeyListener keyListener) {
        if (keyListener != null) {
            if (this.fKeyFilters != null) {
                this.fKeyFilters.removeElement(keyListener);
            }
            this.fTextCanvas.removeKeyListener(keyListener);
        }
    }

    public void setCtrlCKeyHandler(KeyListener keyListener) {
        this.fTextCanvasCtrlCKeyHandler = keyListener;
    }

    public int getGutterWidth() {
        return this.fGutter.getWidth();
    }

    public void setGutterWidth(int n) {
        this.fGutter.setWidth(n);
    }

    @Override
    public boolean isEnabled() {
        return this.fEnabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setEnabled(boolean bl) {
        if (bl != this.isEnabled()) {
            this.beginDeferUpdates();
            try {
                this.fEnabled = bl;
                if (this.fHScroll != null) {
                    this.fHScroll.setEnabled(bl);
                }
                if (this.fVScroll != null) {
                    this.fVScroll.setEnabled(bl);
                }
                this.updateCaret();
                this.updateBackground();
                this.repaintAll();
            }
            finally {
                this.endDeferUpdates();
            }
        }
    }

    public boolean getDimBGWhenNotEditable() {
        return this.fDimBGWhenNotEditable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimBGWhenNotEditable(boolean bl) {
        if (bl != this.fDimBGWhenNotEditable) {
            this.fDimBGWhenNotEditable = bl;
            if (!this.fText.isEditable() && this.isEnabled()) {
                this.beginDeferUpdates();
                try {
                    this.updateBackground();
                    this.repaintAll();
                }
                finally {
                    this.endDeferUpdates();
                }
            }
        }
    }

    public boolean getDimBGWhenDisabled() {
        return this.fDimBGWhenDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimBGWhenDisabled(boolean bl) {
        if (bl != this.fDimBGWhenDisabled) {
            this.fDimBGWhenDisabled = bl;
            if (!this.isEnabled()) {
                this.beginDeferUpdates();
                try {
                    this.updateBackground();
                    this.repaintAll();
                }
                finally {
                    this.endDeferUpdates();
                }
            }
        }
    }

    public boolean getDimFGWhenDisabled() {
        return this.fDimFGWhenDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDimFGWhenDisabled(boolean bl) {
        if (bl != this.fDimFGWhenDisabled) {
            this.fDimFGWhenDisabled = bl;
            if (!this.isEnabled()) {
                this.beginDeferUpdates();
                try {
                    this.repaintAll();
                }
                finally {
                    this.endDeferUpdates();
                }
            }
        }
    }

    public boolean isBeepOn() {
        return this.fBeepOn;
    }

    public void setBeepOn(boolean bl) {
        this.fBeepOn = bl;
    }

    public boolean isBorderBeepOn() {
        return this.fBorderBeepOn;
    }

    public void setBorderBeepOn(boolean bl) {
        this.fBorderBeepOn = bl;
    }

    public void borderBeep() {
        if (this.fBeepOn && this.fBorderBeepOn) {
            long l = System.currentTimeMillis();
            if (l > this.fLastBorderBeep + 600L) {
                this.getToolkit().beep();
            }
            this.fLastBorderBeep = l;
        }
    }

    public void beep() {
        if (this.fBeepOn) {
            this.getToolkit().beep();
        }
    }

    public int getGoalCol() {
        return this.fGoalCol;
    }

    public void setGoalCol(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.fGoalCol = n;
    }

    private void setGoalColFromPos(int n) {
        this.setGoalCol(this.fText.colFromPos(n));
    }

    public Range getSel() {
        return this.fSel;
    }

    public int getSelStart() {
        return this.fSel.getStart();
    }

    public int getSelEnd() {
        return this.fSel.getEnd();
    }

    public int getSelMin() {
        return this.fSel.getMin();
    }

    public int getSelMax() {
        return this.fSel.getMax();
    }

    public boolean isSelEmpty() {
        return this.fSel.isEmpty();
    }

    public String getSelText() {
        return this.fText.getText(this.fSel);
    }

    public void setSel(Range range) {
        this.setSel(range.getStart(), range.getEnd());
    }

    public void setSel(int n) {
        this.setSel(n, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void setSel(int var1_1, int var2_2) {
        var4_3 = this.fText;
        synchronized (var4_3) {
            var3_4 = new Range(var1_1, var2_2);
            this.clampToModel(var3_4);
            var1_1 = var3_4.getStart();
            var2_2 = var3_4.getEnd();
            if (var1_1 != this.getSelStart() || var2_2 != this.getSelEnd()) {
                var5_5 = this.isCaretEnabled();
                this.setCaretEnabled(false);
                try {
                    var9_7 = this.fSel.getStart();
                    var10_8 = this.fSel.getEnd();
                    this.fSel.setValues(var3_4.getStart(), var3_4.getEnd());
                    var3_4.setValues(var9_7, var10_8);
                    var6_9 = var3_4;
                    var7_10 = (Range)var6_9.clone();
                    var8_11 = new Range();
                    this.clampToModel(var7_10);
                    var7_10.intersect(this.fSel, var8_11);
                    if (var8_11.isEmpty()) {
                        this.repaintRange(var7_10);
                        this.repaintRange(this.fSel);
                    } else {
                        var11_12 = Math.min(var7_10.getMin(), this.getSelMin());
                        var12_14 = Math.max(var7_10.getMax(), this.getSelMax());
                        if (var11_12 < var8_11.getMin()) {
                            this.repaintRange(var11_12, var8_11.getMin());
                        }
                        if (var8_11.getMax() < var12_14) {
                            this.repaintRange(var8_11.getMax(), var12_14);
                        }
                    }
                    if (!this.isSomeoneListening()) ** GOTO lbl53
                    if (this.fDragging) {
                        var11_13 = MWTextViewEvent.newSelChangingEvent(this, var6_9, this.fSel);
                    } else if (this.fSelBeforeDrag == null) {
                        var11_13 = MWTextViewEvent.newSelChangedEvent(this, var6_9, this.fSel);
                    } else {
                        var11_13 = MWTextViewEvent.newSelChangedEvent(this, this.fSelBeforeDrag, this.fSel);
                        this.fSelBeforeDrag = null;
                    }
                    this.notifyListeners(var11_13);
                }
                finally {
                    this.setCaretEnabled(var5_5);
                }
            } else if (this.fSelBeforeDrag != null && !this.fDragging) {
                if (this.isSomeoneListening() && (var1_1 != this.fSelBeforeDrag.getStart() || var2_2 != this.fSelBeforeDrag.getEnd())) {
                    var5_6 = MWTextViewEvent.newSelChangedEvent(this, this.fSelBeforeDrag, this.fSel);
                    this.notifyListeners(var5_6);
                }
                this.fSelBeforeDrag = null;
            }
lbl53:
            // 5 sources

            if (this.isActiveView()) {
                this.scrollPosIntoView(var2_2);
            }
        }
    }

    public void setSelectionNotification(boolean bl) {
        this.fDragging = !bl;
    }

    public boolean isSelVisibleWhenNoFocus() {
        return this.fSelVisibleWhenNoFocus;
    }

    public void setSelVisibleWhenNoFocus(boolean bl) {
        if (bl == this.fSelVisibleWhenNoFocus) {
            return;
        }
        this.fSelVisibleWhenNoFocus = bl;
        this.repaintRange(this.fSel);
    }

    public void setSelFocusOverride(int n) {
        this.fSelFocusOverride = (this.fSelFocusOverride & 8) + n;
    }

    private boolean shouldDrawSel() {
        boolean bl = true;
        if (!this.hasFocus()) {
            bl = MWUtils.isParentFrameActive(this);
        }
        return this.isEnabled() && (this.hasFocus() || this.isSelVisibleWhenNoFocus() && !bl || (this.fSelFocusOverride & 1) == 1);
    }

    private void clampSelToModel() {
        Range range = (Range)this.fSel.clone();
        if (this.clampToModel(range)) {
            this.setSel(range);
        }
    }

    private boolean clampToModel(Range range) {
        boolean bl = true;
        boolean bl2 = true;
        int n = this.fText.length();
        if (range.getStart() > n) {
            range.setStart(n);
        } else if (range.getStart() < 0) {
            range.setStart(0);
        } else {
            bl = false;
        }
        if (range.getEnd() > n) {
            range.setEnd(n);
        } else if (range.getEnd() < 0) {
            range.setEnd(0);
        } else {
            bl2 = false;
        }
        return bl || bl2;
    }

    public int numLinesHigh() {
        int n = this.fTextCanvas.getSize().height;
        if (n == 0) {
            return 0;
        }
        return (n - 1) / this.fText.getFontHeight() + 1;
    }

    public int numCompleteLinesHigh() {
        return this.fTextCanvas.getSize().height / this.fText.getFontHeight();
    }

    public int getBottomLine() {
        return Math.min(this.getTopLine() + this.numLinesHigh() - 1, this.fText.getNumLines() - 1);
    }

    public int getBottomCompleteLine() {
        return this.getTopLine() + this.numCompleteLinesHigh() - 1;
    }

    public void scrollLineToTop(int n) {
        this.scrollLineToPercent(n, 0);
    }

    public void scrollLineToCenter(int n) {
        this.scrollLineToPercent(n, 50);
    }

    public void scrollLineToBottom(int n) {
        this.scrollLineToPercent(n, 100);
    }

    public void scrollLineToPercent(int n, int n2) {
        int n3 = (this.numCompleteLinesHigh() - 1) * n2 / 100;
        if (n3 >= 0) {
            int n4 = n - n3;
            n4 = Math.min(n4, this.fText.getNumLines() - this.numCompleteLinesHigh());
            n4 = Math.max(n4, 0);
            this.setTopLine(n4);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scrollPosIntoView(int n) {
        Dimension dimension = this.fTextCanvas.getSize();
        if (n > this.fText.length()) {
            n = this.fText.length();
        }
        if (dimension.width == 0 || dimension.height == 0 || !MWUtils.isAWTEventQueueThread()) {
            this.fDeferredScrollPos = n;
            return;
        }
        this.fDeferredScrollPos = -1;
        this.beginDeferUpdates();
        try {
            int n2;
            int n3 = this.fText.lineFromPos(n);
            if (n3 < this.getTopLine()) {
                n2 = n3;
            } else {
                int n4 = this.getBottomCompleteLine();
                int n5 = this.numCompleteLinesHigh();
                n2 = n3 <= n4 || n5 < 1 ? this.getTopLine() : n3 - n5 + 1;
            }
            this.setTopLine(n2);
            if (!this.fHScrollLock) {
                int n6;
                int n7 = this.pixelXFromPos(n);
                if (n7 > (n6 = dimension.width)) {
                    int n8 = n7 - n6 + n6 / 4;
                    this.setHScrollAmount(this.getHScrollAmount() + n8);
                } else if (n7 < 0) {
                    int n9 = -(-n7 + n6 / 4);
                    this.setHScrollAmount(Math.max(this.getHScrollAmount() + n9, 0));
                }
            }
        }
        finally {
            this.endDeferUpdates();
        }
    }

    public void scrollSelToView(Rectangle rectangle) {
        Rectangle rectangle2 = this.getSelectionBounds();
        if ((rectangle2 = MWUtils.mapFromComponentToScreen(rectangle2, (Component)this)).intersects(rectangle)) {
            int n;
            int n2 = this.fText.lineFromPos(this.getSelMin());
            rectangle = MWUtils.mapFromScreenToComponent(rectangle, (Component)this);
            int n3 = this.fTextCanvas.getSize().height;
            if (n3 - (rectangle.y + rectangle.height) > rectangle2.height) {
                n = rectangle.y + rectangle.height + this.fText.getFontHeight() - 1;
                if (Math.abs(n = n2 - this.lineFromPixelY(n)) > this.fTopLine && rectangle.y > rectangle2.height) {
                    n = n2 - this.lineFromPixelY(rectangle.y - this.fText.getFontHeight() + 1);
                }
            } else if (rectangle.y > rectangle2.height) {
                n = n2 - this.lineFromPixelY(rectangle.y - this.fText.getFontHeight() + 1);
            } else if (n3 - (rectangle.y + rectangle.height) > rectangle.y) {
                n = rectangle.y + rectangle.height + this.fText.getFontHeight() - 1;
                if (Math.abs(n = n2 - this.lineFromPixelY(n)) > this.fTopLine && rectangle.y > rectangle2.height) {
                    n = n2 - this.lineFromPixelY(rectangle.y - this.fText.getFontHeight() + 1);
                }
            } else {
                n = n2 - this.lineFromPixelY(rectangle.y - this.fText.getFontHeight() + 1);
            }
            rectangle = MWUtils.mapFromComponentToScreen(rectangle, (Component)this);
            if ((n = this.fTopLine + n) < 0) {
                n = 0;
            } else if (n > this.fText.getNumLines()) {
                n = this.fText.getNumLines() - 1;
            }
            this.setTopLine(n);
        }
    }

    private int getStyleExtent(int n, int n2, MWTextModel.StyleRun styleRun) {
        while (n < n2) {
            int n3 = this.fText.runIndexFromPos(n);
            styleRun = this.fText.getStyleRunAt(n3, styleRun);
            int n4 = styleRun.getStyle().getStyle();
            if ((n4 & 2) == 0) {
                MWStyle mWStyle = styleRun.getStyle();
                int n5 = Math.max(n, styleRun.getStart());
                int n6 = styleRun.getEnd();
                while (n6 < n2 && (n4 & 0xC0) == ((styleRun = this.fText.getStyleRunAt(n3 = this.fText.runIndexFromPos(n6), styleRun)).getStyle().getStyle() & 0xC2)) {
                    n6 = styleRun.getEnd();
                }
                styleRun.setStyle(mWStyle);
                styleRun.setStart(n5);
                if (n6 > n2) {
                    n6 = n2;
                }
                styleRun.setEnd(n6);
                break;
            }
            n = styleRun.getEnd();
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pixelXFromPos(int n) {
        MWTextModel mWTextModel = this.fText;
        synchronized (mWTextModel) {
            int n2 = this.fText.lineFromPos(n);
            int n3 = this.fText.getLineStart(n2);
            int n4 = 0;
            int n5 = 0;
            MWTextModel.StyleRun styleRun = this.fStyleRunX;
            n3 = this.getStyleExtent(n3, n, styleRun);
            while (n3 < n) {
                this.expandTabs(this.fText.getRawCharBuf(), n3, styleRun.getEnd(), n5, this.fTabBuf);
                n4 += this.tabBufWidth(styleRun.getStyle().getStyle());
                n5 += this.fTabBuf.length();
                n3 = styleRun.getEnd();
                if (n3 >= n) continue;
                n3 = this.getStyleExtent(n3, n, styleRun);
            }
            return n4 - this.fHScrollAmount;
        }
    }

    public int pixelYFromLine(int n) {
        return (n - this.getTopLine()) * this.fText.getFontHeight();
    }

    public Point pixelFromPos(int n) {
        int n2 = this.fText.lineFromPos(n);
        return new Point(this.pixelXFromPos(n), this.pixelYFromLine(n2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int posFromPixelX(int n, int n2) {
        MWTextModel mWTextModel = this.fText;
        synchronized (mWTextModel) {
            MWTextModel.StyleRun styleRun = this.fStyleRunX;
            if ((n2 += this.fHScrollAmount) < 0) {
                return -1;
            }
            int n3 = this.fText.getLineStart(n);
            int n4 = this.fText.getLineEndNoEOL(n);
            n3 = this.getStyleExtent(n3, n4, styleRun);
            int n5 = styleRun.getEnd() - 1;
            int n6 = 0;
            int n7 = 0;
            for (int i = n3; i < n4; ++i) {
                this.expandTabs(this.fText.getRawCharBuf(), i, i + 1, n7, this.fTabBuf);
                n7 += this.fTabBuf.length();
                int n8 = this.tabBufWidth();
                int n9 = n6 + n8;
                if (n6 <= n2 && n2 < n9) {
                    return i;
                }
                n6 = n9;
                if (i != n5) continue;
                n3 = this.getStyleExtent(n5 + 1, n4, styleRun);
                n5 = styleRun.getEnd() - 1;
                i = n3 - 1;
            }
            return -1;
        }
    }

    public int lineFromPixelY(int n) {
        return n / this.fText.getFontHeight() + this.getTopLine();
    }

    public int posFromPixel(Point point) {
        return this.posFromPixel(point.x, point.y);
    }

    private int posFromPixel(int n, int n2) {
        int n3 = -1;
        int n4 = this.lineFromPixelY(n2);
        if (n4 >= 0 && n4 < this.fText.getNumLines()) {
            n3 = this.posFromPixelX(n4, n);
        }
        return n3;
    }

    public int selectionPosFromPixel(Point point) {
        return this.selectionPosFromPixel(point.x, point.y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int selectionPosFromPixel(int n, int n2) {
        MWTextModel mWTextModel = this.fText;
        synchronized (mWTextModel) {
            int n3 = this.lineFromPixelY(n2);
            if (n3 >= this.fText.getNumLines()) {
                if (this.fText.getNumLines() == 1) {
                    return this.fText.getLineEndNoEOL(0);
                }
                return this.fText.length();
            }
            if (n3 < 0) {
                return 0;
            }
            int n4 = this.fText.getLineStart(n3);
            if (n + this.fHScrollAmount < 0) {
                return n4;
            }
            int n5 = this.posFromPixelX(n3, n);
            if (n5 == -1) {
                return this.fText.getLineEndNoEOL(n3);
            }
            int n6 = this.pixelXFromPos(n5);
            int n7 = this.pixelXFromPos(n5 + 1);
            if (n + this.fHScrollAmount > n6 + (n7 -= n6) / 2 - 1) {
                ++n5;
            }
            return n5;
        }
    }

    public int selectionPosFromPoint(Point point) {
        return this.selectionPosFromPoint(point.x, point.y);
    }

    private int selectionPosFromPoint(int n, int n2) {
        int n3;
        int n4;
        int n5 = this.selectionPosFromPixel(n, n2);
        int n6 = this.lineFromPixelY(n2);
        int n7 = this.getSelMin();
        int n8 = this.getSelMax();
        if (n6 >= this.fText.getNumLines()) {
            n6 = -1;
        } else if (n5 == n8 && (n7 > (n4 = (n3 = this.fText.getLineEnd(n6)) - this.fText.getTerminatorLength(n6)) || n8 < n3 || n4 == n3) && this.posFromPixel(n, n2) == -1) {
            n6 = -1;
        }
        if (n5 < n7 || n5 > n8 || n6 < 0) {
            n5 = -n5;
        }
        return n5;
    }

    public int textWidth(char[] cArray, int n, int n2) {
        if (this.fText.isFontMonospaced() || this.fText.getFontMetrics() == null) {
            return this.fText.getFontWidth() * (n2 - n);
        }
        return this.fText.getFontMetrics().charsWidth(cArray, n, n2);
    }

    private int tabBufWidth() {
        return this.textWidth(this.fTabBuf.getRawBuf(), 0, this.fTabBuf.length());
    }

    private int tabBufWidth(int n) {
        int n2 = (n & 0xC0) != 0 ? this.fText.getStyleMetrics(n).charsWidth(this.fTabBuf.getRawBuf(), 0, this.fTabBuf.length()) : this.tabBufWidth();
        return n2;
    }

    public void expandTabs(char[] cArray, int n, int n2, int n3, CharBuffer charBuffer) {
        if (n2 - n < 0) {
            return;
        }
        charBuffer.setSize((n2 - n) * this.getSpacesPerTab(), false);
        int n4 = 0;
        for (int i = n; i < n2; ++i) {
            if (cArray[i] == '\t') {
                int n5 = n3 + n4;
                int n6 = this.nextTabCol(n5) - n5;
                for (int j = 0; j < n6; ++j) {
                    charBuffer.setAt(n4 + j, ' ');
                }
                n4 += n6;
                continue;
            }
            charBuffer.setAt(n4, cArray[i]);
            ++n4;
        }
        charBuffer.setSize(n4, false);
    }

    private int nextTabCol(int n) {
        return this.fText.nextTabCol(n);
    }

    private int getSpacesPerTab() {
        return this.fText.getSpacesPerTab();
    }

    private void setSpacesPerTab(int n) {
        this.fText.setSpacesPerTab(n);
    }

    public void beginDeferUpdates() {
        ++this.fDeferUpdatesCounter;
    }

    public void endDeferUpdates() {
        if (this.fDeferUpdatesCounter <= 0) {
            if (Log.LOGGING) {
                throw new IllegalStateException("WARNING: endDeferUpdates: unbalanced call");
            }
            this.fDeferUpdatesCounter = 0;
        } else {
            --this.fDeferUpdatesCounter;
        }
        if (this.fDeferUpdatesCounter == 0 && this.fRepaintState != 0) {
            if (this.fRepaintState == 1 || this.fRepaintState == 3) {
                this.fTextCanvas.repaint();
            } else {
                this.repaint();
            }
        }
    }

    public boolean isBlackHighlight() {
        return this.fBlackHighlight;
    }

    public void setBlackHighlight(boolean bl) {
        this.fBlackHighlight = bl;
    }

    public void setColorMode(int n) {
        if (n >= 0 && n <= 2 && n != this.fColorMode) {
            this.fColorMode = n;
            this.updateBackground();
        }
    }

    private boolean isSelectionActive() {
        boolean bl = true;
        if (!this.hasFocus() && !PlatformInfo.isXWindows()) {
            bl = MWUtils.isParentFrameActive(this);
        }
        return this.hasFocus() || !this.isSelVisibleWhenNoFocus() || bl;
    }

    protected Color getHighlightBackgroundColor() {
        return Decorations.getColor(4, this.isSelectionActive(), this.getTextBackgroundColor());
    }

    protected Color getHighlightTextColor() {
        return Decorations.getColor(5, this.isSelectionActive(), null);
    }

    protected Color getTextBackgroundColor() {
        Color color = this.fColorMode == 0 ? this.getPlatformColor(13) : (this.fColorMode == 1 ? this.getPlatformColor(0) : this.getBackground());
        return color;
    }

    protected Color getTextColor() {
        Color color = this.fColorMode == 0 ? this.getPlatformColor(14) : (this.fColorMode == 1 ? this.getPlatformColor(12) : this.getForeground());
        return color;
    }

    private void repaintRange(Range range) {
        this.repaintRange(range.getStart(), range.getEnd());
    }

    private void repaintRange(int n, int n2) {
        int n3 = this.fText.lineFromPos(n);
        int n4 = this.fText.lineFromPos(n2);
        this.repaintLines(Math.min(n3, n4), Math.max(n3, n4));
    }

    private void repaintLines(int n, int n2) {
        switch (this.fRepaintState) {
            case 0: {
                this.fLinesToRepaint.setValues(n, n2);
                this.fRepaintState = 1;
                break;
            }
            case 1: {
                this.fLinesToRepaint.union(n, n2, this.fLinesToRepaint);
                break;
            }
        }
        this.repaintIfNotDeferred(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Window window = MWUtils.getTopLevelWindow(this);
        this.fSwingHack = window != null && !(window instanceof MWFrame) && !(window instanceof MWDialog);
    }

    private void repaintCaret(int n) {
        int n2 = this.fText.lineFromPos(n);
        if (n2 < this.getTopLine() || n2 > this.getBottomLine()) {
            return;
        }
        int n3 = this.pixelXFromPos(n);
        if (n3 < 0 || n3 > this.fTextCanvas.getSize().width) {
            return;
        }
        if (this.fRepaintState == 0) {
            this.fLinesToRepaint.setValues(n2, n2);
            this.fRepaintState = 1;
            if (this.fDeferUpdatesCounter == 0 && !this.fRepaintPending) {
                Point point = this.pixelFromPos(n);
                this.fTextCanvas.repaint(point.x, point.y, 1, this.fText.getFontHeight());
            }
        } else {
            this.repaintLines(n2, n2);
        }
    }

    public void repaintAll() {
        this.fRepaintState = 2;
        this.repaintIfNotDeferred();
    }

    private void repaintCanvas() {
        this.fRepaintState = 3;
        this.repaintIfNotDeferred(false);
    }

    private void repaintIfNotDeferred() {
        this.repaintIfNotDeferred(true);
    }

    private void repaintIfNotDeferred(boolean bl) {
        if (this.fDeferUpdatesCounter == 0 && !this.fRepaintPending) {
            this.fRepaintPending = true;
            if (bl) {
                this.repaint();
            } else {
                this.fTextCanvas.repaint();
            }
        }
    }

    @Override
    public void paint(Graphics graphics) {
        if (this.fVScroll != null && this.fVScroll.isShowing() && this.fHScroll != null && this.fHScroll.isShowing()) {
            Rectangle rectangle = this.fVScroll.getBounds();
            Rectangle rectangle2 = this.fHScroll.getBounds();
            graphics.setColor(Decorations.getColor(6));
            graphics.fillRect(rectangle.x, rectangle2.y, rectangle.width, rectangle2.height);
        }
        if (this.fSwingHack && (this.fRepaintState == 1 || this.fRepaintState == 0)) {
            this.fRepaintState = 2;
        }
        super.paint(graphics);
    }

    private void renderLine(Graphics graphics, int n) {
        int n2;
        int n3 = this.fText.getLineStart(n);
        int n4 = this.fText.getLineEnd(n);
        int n5 = n4 - this.fText.getTerminatorLength(n);
        int n6 = this.getSelMin();
        int n7 = this.getSelMax();
        int n8 = Math.max(n3, n6);
        int n9 = Math.min(n5, n7);
        this.fRunInfo.init();
        MWStyle mWStyle = this.fText.getStyleAt(n3);
        if ((mWStyle.getStyle() & 0x200) != 0) {
            if (mWStyle.getBackground() != null) {
                // empty if block
            }
            graphics.setColor(mWStyle.getBackground());
            graphics.fillRect(0, 0, this.fTextCanvas.getSize().width, this.fText.getFontHeight());
        }
        if (n8 >= n9 || !this.shouldDrawSel()) {
            this.drawExpandedChars(graphics, n3, n5, false);
        } else {
            if (n3 < n8) {
                this.drawExpandedChars(graphics, n3, n8, false);
            }
            this.drawExpandedChars(graphics, n8, n9, true);
            if (n9 < n5) {
                this.drawExpandedChars(graphics, n9, n5, false);
            }
        }
        if (this.fMaxLineWidth < this.fRunInfo.startX) {
            this.fMaxLineWidth = this.fRunInfo.startX;
            this.updateScrollbars();
        }
        if (n6 <= n5 && n7 >= n4 && n5 != n4 && this.shouldDrawSel() && (n2 = this.fTextCanvas.getSize().width - (this.fRunInfo.startX - this.fHScrollAmount) + 1) > 0) {
            graphics.setColor(this.getHighlightBackgroundColor());
            graphics.fillRect(this.fRunInfo.startX - this.fHScrollAmount, 0, n2, this.fText.getFontHeight());
        }
        if (n3 <= this.getSelEnd() && this.getSelEnd() <= n5 && this.shouldDrawCaret() && (this.fCaretOn || this.getSelEnd() != this.getSelStart() && this.getSelEnd() == this.getSelMin())) {
            this.drawCaret(graphics, this.pixelXFromPos(this.getSelEnd()), 0);
        } else if (this.fDragInProgress && n3 <= this.fDragPos && this.fDragPos <= n5) {
            this.drawCaret(graphics, this.pixelXFromPos(this.fDragPos), 0);
        }
    }

    private void drawExpandedChars(Graphics graphics, int n, int n2, boolean bl) {
        int n3;
        if (n == n2) {
            return;
        }
        MWTextModel.StyleRun styleRun = new MWTextModel.StyleRun();
        int n4 = this.fText.numRuns();
        for (int i = n3 = this.fText.runIndexFromPos(n); i < n4 - 1; ++i) {
            int n5;
            int n6;
            Color color;
            this.fText.getStyleRunAt(i, styleRun);
            if (styleRun.getStart() >= n2) break;
            int n7 = styleRun.getStyle().getStyle();
            if ((n7 & 2) != 0) continue;
            int n8 = Math.max(styleRun.getStart(), n);
            int n9 = Math.min(styleRun.getEnd(), n2);
            this.expandTabs(this.fText.getRawCharBuf(), n8, n9, this.fRunInfo.startCol, this.fTabBuf);
            int n10 = this.tabBufWidth(n7);
            int n11 = this.fTabBuf.length();
            if (bl) {
                graphics.setColor(this.getHighlightBackgroundColor());
                graphics.fillRect(this.fRunInfo.startX - this.fHScrollAmount, 0, n10, this.fText.getFontHeight());
            } else if (styleRun.getStyle().getBackground() != null) {
                graphics.setColor(styleRun.getStyle().getBackground());
                graphics.fillRect(this.fRunInfo.startX - this.fHScrollAmount, 0, n10, this.fText.getFontHeight());
            }
            if (styleRun.getStyle().isAutoColor()) {
                color = bl ? this.getHighlightTextColor() : (this.isEnabled() || !this.fDimFGWhenDisabled ? this.getTextColor() : this.getPlatformColor(15));
            } else if (bl && this.fBlackHighlight) {
                color = this.getHighlightTextColor();
            } else if (bl && !this.isSelectionActive()) {
                color = this.getHighlightTextColor();
            } else {
                color = styleRun.getStyle().getForeground();
                if (color == null) {
                    color = this.getTextColor();
                }
            }
            if ((n7 & 0xC0) != 0) {
                graphics.setFont(this.fText.getStyleFont(n7));
            }
            graphics.setColor(color);
            graphics.drawChars(this.fTabBuf.getRawBuf(), 0, n11, this.fRunInfo.startX - this.fHScrollAmount, this.fText.getFontBaseline());
            if ((n7 & 0xC0) != 0) {
                graphics.setFont(this.fText.getDefaultFont());
            }
            if ((n7 & 4) != 0) {
                n6 = this.fRunInfo.startX - this.fHScrollAmount;
                n5 = (this.fText.getFontHeight() + 1 >> 1) + 1;
                graphics.drawLine(n6, n5, n6 + n10, n5);
            }
            if ((n7 & 8) != 0) {
                n6 = this.fRunInfo.startX - this.fHScrollAmount;
                n5 = this.fText.getFontBaseline() + 1;
                graphics.drawLine(n6, n5, n6 + n10, n5);
            }
            this.fRunInfo.startCol += n11;
            this.fRunInfo.startX += n10;
        }
    }

    private void drawCaret(Graphics graphics) {
        Point point = this.pixelFromPos(this.getSelEnd());
        this.drawCaret(graphics, point.x, point.y);
    }

    private void drawCaret(Graphics graphics, int n, int n2) {
        if (this.fCaretOn || this.fDragPos != -1) {
            graphics.setColor(this.getTextColor());
        } else {
            graphics.setColor(this.getBackground());
        }
        graphics.drawLine(n, n2, n, n2 + this.fText.getFontHeight() - 1);
    }

    private void updateScrollbars() {
        int n;
        int n2;
        int n3;
        if (this.fVScrollStyle == 2) {
            n3 = this.numCompleteLinesHigh();
            if (n3 < 0) {
                return;
            }
            n2 = Math.max(0, this.fText.getNumLines() - n3);
            if (this.fVScroll.getVisibleAmount() != n3 || this.fVScroll.getMaximum() != n2 || this.fVScroll.getValue() != this.getTopLine()) {
                n = n2 > 0 ? this.getTopLine() : 0;
                this.fVScroll.setValues(n, n3, 0, n2);
                this.fVScroll.setBlockIncrement(Math.max(1, n3 - 1));
                this.setTopLine(n);
            }
        }
        if (this.fHScrollStyle == 2) {
            n3 = this.fTextCanvas.getSize().width;
            if (n3 < 0) {
                return;
            }
            n2 = Math.max(0, this.fMaxLineWidth - n3);
            if (this.fHScroll.getVisibleAmount() != n3 || this.fHScroll.getMaximum() != n2 || this.fHScroll.getValue() != this.fHScrollAmount) {
                n = n2 > 0 ? this.fHScrollAmount : 0;
                this.fHScroll.setValues(n, n3, 0, n2);
                this.fHScroll.setBlockIncrement(Math.max(1, n3 - 1));
                this.setHScrollAmount(n);
            }
        }
    }

    private Color getPlatformColor(int n) {
        return Decorations.getColor(n);
    }

    protected synchronized void updateBackground() {
        if (!this.fText.isEditable() && this.fDimBGWhenNotEditable || !this.isEnabled() && this.fDimBGWhenDisabled) {
            this.setBackground(this.getPlatformColor(6));
        } else {
            this.setBackground(this.getTextBackgroundColor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caretTimerHold() {
        MWTextModel mWTextModel = this.fText;
        synchronized (mWTextModel) {
            if (sCaretTimerOwner == this) {
                sCaretTimer.hold();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caretTimerReset() {
        MWTextModel mWTextModel = this.fText;
        synchronized (mWTextModel) {
            if (sCaretTimerOwner == this) {
                sCaretTimer.reset();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caretTimerStop() {
        MWTextModel mWTextModel = this.fText;
        synchronized (mWTextModel) {
            if (sCaretTimerOwner == this) {
                sCaretTimerOwner = null;
                sCaretTimerListener = null;
                sCaretTimerIdle = PlatformInfo.isBlackdownVM() ? Long.MAX_VALUE : System.currentTimeMillis() + 10000L;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caretTimerStart() {
        MWTextModel mWTextModel = this.fText;
        synchronized (mWTextModel) {
            if (sCaretTimer == null) {
                sCaretTimer = new Timer(CARET_BLINK_DELAY, (ActionListener)new CaretTimerEventHandler(), "MWTextView caret");
                int n = NativeJava.getCaretBlinkRate();
                if (n > 0) {
                    sCaretTimer.start();
                }
            } else {
                int n;
                if (sCaretTimerOwner != null && sCaretTimerOwner != this) {
                    sCaretTimerOwner.setCaretOn(false);
                    MWTextView.sCaretTimerOwner.fLastShouldDrawCaret = false;
                }
                if ((n = sCaretTimer.getDelay()) == 1000000000) {
                    sCaretTimer.setDelay(CARET_BLINK_DELAY);
                    sCaretTimer.interrupt();
                } else {
                    sCaretTimer.reset();
                }
            }
            sCaretTimerOwner = this;
            sCaretTimerListener = this.fCaretTimerListener;
        }
    }

    protected boolean isCaretEnabled() {
        return this.fCaretEnabled;
    }

    public void setCaretEnabled(boolean bl) {
        if (bl == this.fCaretEnabled) {
            return;
        }
        this.fCaretEnabled = bl;
        this.updateCaret();
    }

    protected void updateCaret() {
        boolean bl = this.shouldDrawCaret();
        if (this.fLastShouldDrawCaret == bl) {
            return;
        }
        this.fLastShouldDrawCaret = bl;
        if (bl) {
            this.setCaretOn(true);
            this.caretTimerStart();
        } else {
            if (this.fHasFocus && this.fEnabled) {
                this.caretTimerHold();
            } else {
                this.caretTimerStop();
            }
            this.setCaretOn(false);
        }
    }

    private boolean shouldDrawCaret() {
        if (PlatformInfo.getAppearance() == 0) {
            return this.fHasFocus && this.fEnabled && this.fCaretEnabled && this.getSelStart() == this.getSelEnd() && !this.fDragInProgress;
        }
        return this.fHasFocus && this.fEnabled && this.fCaretEnabled && this.fText.isEditable() && !this.fDragInProgress;
    }

    protected boolean isCaretOn() {
        return this.fCaretOn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setCaretOn(boolean bl) {
        MWTextModel mWTextModel = this.fText;
        synchronized (mWTextModel) {
            if (bl != this.fCaretOn) {
                this.fCaretOn = bl;
                int n = Math.min(this.getSelEnd(), this.fText.length());
                this.repaintCaret(n);
            }
        }
    }

    public void dispatchTextComponentEvent(AWTEvent aWTEvent) {
        this.fTextCanvas.dispatchEvent(aWTEvent);
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        Assert._assert((focusListener != null ? 1 : 0) != 0);
        this.fTextCanvas.addFocusListener(focusListener);
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this.fTextCanvas.removeFocusListener(focusListener);
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        Assert._assert((keyListener != null ? 1 : 0) != 0);
        this.fTextCanvas.addKeyListener(keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        Assert._assert((keyListener != null ? 1 : 0) != 0);
        this.fTextCanvas.removeKeyListener(keyListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        Assert._assert((mouseListener != null ? 1 : 0) != 0);
        this.fTextCanvas.addMouseListener(mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.fTextCanvas.removeMouseListener(mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        Assert._assert((mouseMotionListener != null ? 1 : 0) != 0);
        this.fTextCanvas.addMouseMotionListener(mouseMotionListener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        Assert._assert((mouseMotionListener != null ? 1 : 0) != 0);
        this.fTextCanvas.removeMouseMotionListener(mouseMotionListener);
    }

    public synchronized void addTextViewListener(MWTextViewListener mWTextViewListener) {
        Assert._assert((mWTextViewListener != null ? 1 : 0) != 0);
        this.fListeners.addElement(mWTextViewListener);
    }

    public synchronized boolean removeTextViewListener(MWTextViewListener mWTextViewListener) {
        Assert._assert((mWTextViewListener != null ? 1 : 0) != 0);
        return this.fListeners.removeElement(mWTextViewListener);
    }

    private boolean isSomeoneListening() {
        return !this.fListeners.isEmpty();
    }

    private synchronized void notifyListeners(MWTextViewEvent mWTextViewEvent) {
        Enumeration enumeration = this.fListeners.elements();
        while (enumeration.hasMoreElements()) {
            MWTextViewListener mWTextViewListener = (MWTextViewListener)enumeration.nextElement();
            switch (mWTextViewEvent.getID()) {
                case 1: {
                    mWTextViewListener.selectionChanging(mWTextViewEvent);
                    break;
                }
                case 2: {
                    mWTextViewListener.selectionChanged(mWTextViewEvent);
                    break;
                }
                case 3: {
                    mWTextViewListener.topLineChanged(mWTextViewEvent);
                    break;
                }
                case 4: {
                    mWTextViewListener.hScrollAmountChanged(mWTextViewEvent);
                }
            }
        }
    }

    public void extendSelection(int n) {
        this.setSel(this.getSelStart(), n);
    }

    public void charLeft() {
        int n = this.isSelEmpty() ? this.fText.prevPos(this.getSelStart()) : this.getSelMin();
        if (n == -1) {
            this.borderBeep();
        } else {
            this.setGoalColFromPos(n);
            this.setSel(n);
        }
    }

    public void charLeftExtend() {
        int n = this.fText.prevPos(this.getSelEnd());
        if (n == -1) {
            this.borderBeep();
        } else {
            this.setGoalColFromPos(n);
            this.extendSelection(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void charLeftDelete() {
        try {
            if (this.isSelEmpty()) {
                this.fText.startCommand("Typing");
                int n = this.fText.prevPos(this.getSelEnd());
                if (n == -1) {
                    this.borderBeep();
                } else {
                    this.fText.delete(this.getSelStart(), n);
                }
            } else {
                this.fText.startCommand("Delete");
                this.fText.delete(this.fSel);
            }
        }
        finally {
            this.fText.endCommand();
        }
    }

    public void charRight() {
        int n = this.isSelEmpty() ? this.fText.nextPos(this.getSelStart()) : this.getSelMax();
        if (n == -1) {
            this.borderBeep();
        } else {
            this.setGoalColFromPos(n);
            this.setSel(n);
        }
    }

    public void charRightExtend() {
        int n = this.fText.nextPos(this.getSelEnd());
        if (n == -1) {
            this.borderBeep();
        } else {
            this.setGoalColFromPos(n);
            this.extendSelection(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void charRightDelete() {
        this.fText.startCommand("Delete");
        try {
            if (this.isSelEmpty()) {
                int n = this.fText.nextPos(this.getSelEnd());
                if (n == -1) {
                    this.borderBeep();
                } else {
                    this.fText.delete(this.getSelStart(), n);
                }
            } else {
                this.fText.delete(this.fSel);
            }
        }
        finally {
            this.fText.endCommand();
        }
    }

    public void wordLeft() {
        this.wordLeftHelper(this.getSelMin());
    }

    public void wordLeftExtend() {
        int n = this.getSelStart();
        this.wordLeftHelper(this.getSelEnd());
        this.setSel(n, this.getSelEnd());
    }

    private void wordLeftHelper(int n) {
        if (n == 0) {
            this.borderBeep();
            return;
        }
        int n2 = this.findWordStartLeft(n);
        if (n2 == n) {
            n2 = this.findWordStartLeft(n - 1);
        }
        this.setGoalColFromPos(n2);
        this.setSel(n2);
    }

    protected int findWordStartLeft(int n) {
        boolean bl = n == this.fText.length() ? true : this.isWordBreakChar(this.fText.charAt(n));
        while (n > 0) {
            boolean bl2 = this.isWordBreakChar(this.fText.charAt(n - 1));
            if (bl2 && !bl) {
                return n;
            }
            bl = bl2;
            --n;
        }
        return 0;
    }

    public void wordRight() {
        int n = this.wordRightHelper(this.getSelMax(), false);
        if (n != -1) {
            this.setGoalColFromPos(n);
            this.setSel(n);
        }
    }

    public void wordRightExtend() {
        int n = this.wordRightHelper(this.getSelEnd(), false);
        if (n != -1) {
            this.setGoalColFromPos(n);
            this.setSel(this.getSelStart(), n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wordRightDelete() {
        int n = this.wordRightHelper(this.getSelEnd(), false);
        if (n != -1) {
            this.fText.startCommand("Delete Word");
            try {
                this.fText.delete(this.getSelStart(), n);
            }
            finally {
                this.fText.endCommand();
            }
        }
    }

    public void wordRightEmacs() {
        int n = this.wordRightHelper(this.getSelMax(), true);
        if (n != -1) {
            this.setGoalColFromPos(n);
            this.setSel(n);
        }
    }

    public void wordRightExtendEmacs() {
        int n = this.wordRightHelper(this.getSelEnd(), true);
        if (n != -1) {
            this.setGoalColFromPos(n);
            this.setSel(this.getSelStart(), n);
        }
    }

    private int wordRightHelper(int n, boolean bl) {
        int n2;
        if (n == this.fText.length()) {
            this.borderBeep();
            return -1;
        }
        if (bl) {
            n2 = this.findWordEndRight(n);
            if (n2 == n) {
                n2 = this.findWordEndRight(n + 1);
            }
        } else {
            n2 = this.findWordStartRight(n);
            if (n2 == n) {
                n2 = this.findWordStartRight(n + 1);
            }
        }
        return n2;
    }

    protected int findWordEndRight(int n) {
        boolean bl = n == 0 ? true : this.isWordBreakChar(this.fText.charAt(n - 1));
        int n2 = this.fText.length();
        while (n < n2) {
            boolean bl2 = this.isWordBreakChar(this.fText.charAt(n));
            if (!bl && bl2) {
                return n;
            }
            bl = bl2;
            ++n;
        }
        return n2;
    }

    protected int findWordStartRight(int n) {
        boolean bl = n == 0 ? true : this.isWordBreakChar(this.fText.charAt(n - 1));
        int n2 = this.fText.length();
        while (n < n2) {
            boolean bl2 = this.isWordBreakChar(this.fText.charAt(n));
            if (bl && !bl2) {
                return n;
            }
            bl = bl2;
            ++n;
        }
        return n2;
    }

    public void lineUp() {
        int n = this.lineUpHelper(false);
        if (n != -1) {
            this.setSel(n);
        }
    }

    public void lineUpExtend() {
        int n = this.lineUpHelper(true);
        if (n != -1) {
            this.setSel(this.getSelStart(), n);
        }
    }

    protected int lineUpHelper(boolean bl) {
        int n = this.fText.lineFromPos(this.getSelEnd());
        if (n == 0) {
            int n2;
            if (bl && this.getSelEnd() != 0) {
                n2 = 0;
            } else {
                n2 = -1;
                this.borderBeep();
            }
            return n2;
        }
        int n3 = Math.min(this.fText.getLineLengthNoEOL(n - 1), this.getGoalCol());
        return this.fText.getLineStart(n - 1) + n3;
    }

    public void lineDown() {
        int n = this.lineDownHelper(false);
        if (n != -1) {
            this.setSel(n);
        }
    }

    public void lineDownExtend() {
        int n = this.lineDownHelper(true);
        if (n != -1) {
            this.setSel(this.getSelStart(), n);
        }
    }

    protected int lineDownHelper(boolean bl) {
        int n = this.fText.lineFromPos(this.getSelEnd());
        if (n == this.fText.getNumLines() - 1) {
            int n2;
            if (bl && this.getSelEnd() != this.fText.length()) {
                n2 = this.fText.length();
            } else {
                n2 = -1;
                this.borderBeep();
            }
            return n2;
        }
        int n3 = Math.min(this.fText.getLineLengthNoEOL(n + 1), this.getGoalCol());
        return this.fText.getLineStart(n + 1) + n3;
    }

    public void lineStart() {
        this.setSel(this.lineStartHelper(this.getSelStart()));
    }

    public void lineStartExtend() {
        int n = this.getSelMin() < this.getSelStart() ? this.getSelMin() : this.getSelEnd();
        this.setSel(this.getSelStart(), this.lineStartHelper(n));
    }

    private int lineStartHelper(int n) {
        int n2 = this.fText.lineFromPos(n);
        this.setGoalCol(0);
        return this.fText.getLineStart(n2);
    }

    public void lineEnd() {
        this.setSel(this.lineEndHelper());
    }

    public void lineEndExtend() {
        this.setSel(this.getSelStart(), this.lineEndHelper());
    }

    public int lineEndHelper() {
        int n = this.fText.lineFromPos(this.getSelEnd());
        int n2 = this.fText.getLineEndNoEOL(n);
        this.setGoalCol(n2 - this.fText.getLineStart(n));
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void emacsKillLine() {
        block16: {
            int n;
            int n2 = this.getSelStart();
            int n3 = this.getSelEnd();
            if (n3 == (n = this.lineEndHelper())) {
                n = this.fText.getLineEnd(this.fText.lineFromPos(n));
            }
            if (n > this.fText.length()) {
                this.beep();
                return;
            }
            this.setSel(n3, n);
            this.fText.startCommand("Kill Line");
            try {
                Transferable transferable;
                String string;
                block17: {
                    if (this.isSelEmpty()) break block16;
                    string = "";
                    if (this.fEmacsKillSelStart == n2 && this.fEmacsKillSelEnd == n3) {
                        block18: {
                            transferable = PlatformInfo.isXWindows() ? MWClipboard.getMWClipboard().getXSelectionContents(this) : sClip.getContents(this);
                            if (transferable == null) break block17;
                            if (transferable.getTransferDataFlavors() != null) break block18;
                            return;
                        }
                        if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                            try {
                                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                            }
                            catch (UnsupportedFlavorException unsupportedFlavorException) {
                                unsupportedFlavorException.printStackTrace();
                            }
                            catch (IOException iOException) {
                                iOException.printStackTrace();
                            }
                        }
                    }
                }
                string = string + this.copy(false);
                if (PlatformInfo.isXWindows()) {
                    this.fText.delete(this.fSel);
                    MWClipboard.getMWClipboard().setXSelectionContents(string);
                } else {
                    transferable = new StringSelection(string);
                    sClip.setContents(transferable, null);
                    this.fText.delete(this.fSel);
                    MWClipboardMonitor.dataPlacedOnClipboard();
                }
                this.fEmacsKillSelStart = n2;
                this.fEmacsKillSelEnd = n3;
            }
            finally {
                this.fText.endCommand();
            }
        }
    }

    public void pageUp() {
        this.pageUpHelper(false);
    }

    public void pageUpExtend() {
        this.pageUpHelper(true);
    }

    public void pageUpHelper(boolean bl) {
        int n = this.getTopLine();
        if (this.getSelEnd() == 0 && n == 0) {
            this.borderBeep();
            return;
        }
        int n2 = this.numCompleteLinesHigh() - 1;
        int n3 = this.fText.lineFromPos(this.getSelEnd());
        int n4 = n3 - n2;
        if (n4 < 0) {
            n4 = 0;
            this.setGoalCol(0);
        }
        int n5 = n + (n4 - n3);
        n5 = Math.min(n5, this.fText.getNumLines() - this.numCompleteLinesHigh());
        n5 = Math.max(n5, 0);
        if (!bl) {
            if (n4 > (n2 += n5)) {
                n4 = n2;
            } else if (n4 < n5) {
                n4 = n5;
            }
        }
        int n6 = Math.min(this.fText.getLineLengthNoEOL(n4), this.getGoalCol());
        int n7 = this.fText.getLineStart(n4) + n6;
        if (bl) {
            this.setSel(this.getSelStart(), n7);
        } else {
            this.setSel(n7);
        }
        this.setTopLine(n5);
    }

    public void pageDown() {
        this.pageDownHelper(false);
    }

    public void pageDownExtend() {
        this.pageDownHelper(true);
    }

    private void pageDownHelper(boolean bl) {
        int n;
        int n2 = this.getTopLine();
        if (this.getSelEnd() == this.fText.length() && (n = this.fText.getNumLines() - this.numCompleteLinesHigh()) <= n2) {
            this.borderBeep();
            return;
        }
        int n3 = this.numCompleteLinesHigh() - 1;
        int n4 = this.fText.lineFromPos(this.getSelEnd());
        int n5 = n4 + n3;
        if (n5 >= this.fText.getNumLines()) {
            n5 = this.fText.getNumLines() - 1;
            this.setGoalCol(this.fText.getLineEndNoEOL(n5));
        }
        n = n2 + (n5 - n4);
        n = Math.min(n, this.fText.getNumLines() - this.numCompleteLinesHigh());
        n = Math.max(n, 0);
        if (!bl) {
            if (n5 > (n3 += n)) {
                n5 = n3;
            } else if (n5 < n) {
                n5 = n;
            }
        }
        int n6 = Math.min(this.fText.getLineLengthNoEOL(n5), this.getGoalCol());
        int n7 = this.fText.getLineStart(n5) + n6;
        if (bl) {
            this.setSel(this.getSelStart(), n7);
        } else {
            this.setSel(n7);
        }
        this.setTopLine(n);
    }

    public void bufferStart() {
        this.setGoalCol(0);
        this.setSel(0);
    }

    public void bufferStartExtend() {
        this.setSel(this.getSelStart(), 0);
    }

    public void bufferEnd() {
        int n = this.fText.length();
        this.setGoalColFromPos(n);
        this.setSel(n);
    }

    public void bufferEndExtend() {
        this.setSel(this.getSelStart(), this.fText.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferSelect() {
        this.beginDeferUpdates();
        try {
            this.setSel(0, this.fText.length());
            this.setTopLine(0);
            this.setHScrollAmount(0);
        }
        finally {
            this.endDeferUpdates();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertLineBreak() {
        this.fText.startCommand("Typing");
        try {
            this.fText.replace(this.fSel, this.fText.getTerminator());
        }
        finally {
            this.fText.endCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cut() {
        this.fText.startCommand("Cut");
        try {
            if (!this.isSelEmpty()) {
                if (PlatformInfo.isXWindows()) {
                    String string = this.copy(false);
                    this.fText.delete(this.fSel);
                    MWClipboard.getMWClipboard().setXSelectionContents(string);
                } else {
                    this.copy();
                    this.fText.delete(this.fSel);
                }
            }
        }
        finally {
            this.fText.endCommand();
        }
    }

    public void copy() {
        this.copy(true);
    }

    private String copy(boolean bl) {
        String string = null;
        if (!this.isSelEmpty()) {
            if (this.fText.getTerminator().equals("\n")) {
                string = this.fText.getText(this.fSel);
            } else {
                int n;
                int n2 = this.fText.lineFromPos(this.fSel.getMin());
                if (n2 == (n = this.fText.lineFromPos(this.fSel.getMax()))) {
                    string = this.fText.getText(this.fSel);
                } else {
                    int n3 = this.fSel.getMin();
                    int n4 = this.fSel.getMax();
                    StringBuffer stringBuffer = new StringBuffer(n4 - n3);
                    char[] cArray = this.fText.getRawCharBuf();
                    for (int i = n2; i <= n; ++i) {
                        int n5 = Math.max(this.fText.getLineStart(i), n3);
                        int n6 = Math.min(this.fText.getLineEndNoEOL(i), n4);
                        stringBuffer.append(cArray, n5, n6 - n5);
                        if (n4 <= n6) continue;
                        stringBuffer.append("\n");
                    }
                    string = stringBuffer.toString();
                }
            }
            if (bl) {
                if (PlatformInfo.isXWindows()) {
                    MWClipboard.getMWClipboard().setXSelectionContents(string);
                } else {
                    StringSelection stringSelection = new StringSelection(string);
                    sClip.setContents(stringSelection, null);
                    MWClipboardMonitor.dataPlacedOnClipboard();
                }
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void do_paste(Range range, String string, String string2) {
        try {
            char[] cArray;
            this.fText.startCommand(string2);
            String string3 = this.fText.getTerminator();
            int n = string.indexOf(10);
            String string4 = n != -1 ? (n > 0 && string.charAt(n - 1) == '\r' ? "\r\n" : "\n") : ((n = string.indexOf(13)) != -1 ? "\r" : string3);
            if (string3.equals(string4)) {
                cArray = string.toCharArray();
            } else {
                int n2;
                int n3 = string4.length();
                int n4 = string3.length();
                int n5 = string.length();
                if (n3 != n4) {
                    n2 = 0;
                    n = string.indexOf(string4);
                    while (n != -1) {
                        ++n2;
                        n = string.indexOf(string4, n + n3);
                    }
                    n5 += n2 * (n4 - n3);
                }
                cArray = new char[n5];
                int n6 = 0;
                n5 = string.length();
                for (n2 = 0; n2 < n5; n2 += n3) {
                    n = n2;
                    if ((n2 = string.indexOf(string4, n)) == -1) {
                        n2 = n5;
                    }
                    string.getChars(n, n2, cArray, n6);
                    n6 += n2 - n;
                    if (n2 == n5) continue;
                    string3.getChars(0, n4, cArray, n6);
                    n6 += n4;
                }
            }
            this.fText.replace(range, cArray);
        }
        finally {
            this.fText.endCommand();
        }
    }

    public void paste() {
        Transferable transferable = null;
        transferable = PlatformInfo.isXWindows() ? MWClipboard.getMWClipboard().getXSelectionContents(this) : sClip.getContents(this);
        if (transferable != null) {
            if (transferable.getTransferDataFlavors() == null) {
                return;
            }
            if (transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
                try {
                    String string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    this.do_paste(this.fSel, string, "Paste");
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    unsupportedFlavorException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undo() {
        if (this.fText.canUndo()) {
            this.beginDeferUpdates();
            try {
                this.fText.undo();
            }
            finally {
                this.endDeferUpdates();
            }
        } else {
            this.beep();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redo() {
        if (this.fText.canRedo()) {
            this.beginDeferUpdates();
            try {
                this.fText.redo();
            }
            finally {
                this.endDeferUpdates();
            }
        } else {
            this.beep();
        }
    }

    public void clearSelection() {
        if (this.getSelStart() != this.getSelEnd()) {
            this.setSel(this.getSelEnd());
        }
    }

    private boolean isWholeWord(int n, int n2) {
        char c;
        if (n > 0 && (Character.isLetterOrDigit(c = this.fText.charAt(n - 1)) || c == '_')) {
            return false;
        }
        c = this.fText.charAt(n);
        if (!Character.isLetterOrDigit(c) && c != '_') {
            return false;
        }
        c = this.fText.charAt(n + n2 - 1);
        if (!Character.isLetterOrDigit(c) && c != '_') {
            return false;
        }
        return n + n2 >= this.fText.length() || !Character.isLetterOrDigit(c = this.fText.charAt(n + n2)) && c != '_';
    }

    public boolean findString(String string, int n, boolean bl) {
        int n2;
        boolean bl2;
        boolean bl3 = false;
        boolean bl4 = (n & 8) != 0;
        boolean bl5 = (n & 2) != 0;
        boolean bl6 = bl2 = (n & 4) != 0;
        int n3 = bl4 ? this.getSelStart() - 1 : (this.getSelStart() != this.getSelEnd() && !bl ? this.getSelEnd() : this.getSelStart());
        while (true) {
            n2 = !bl4 ? this.fText.findString(string, n3, (n & 1) != 0) : this.fText.findStringBackwards(string, n3, (n & 1) != 0);
            if (bl2 && n2 != -1 && !this.isWholeWord(n2, string.length())) {
                if (bl4) {
                    n3 = n2 - 1;
                    continue;
                }
                n3 = n2 + string.length();
                continue;
            }
            if (n2 >= 0) {
                if (bl3 && (!bl4 && n2 >= this.getSelStart() || bl4 && n2 < this.getSelEnd())) {
                    n2 = -1;
                }
                if (bl5 || n2 < this.fText.length()) break;
                n2 = -1;
                break;
            }
            if (!bl5 || bl3) break;
            n3 = bl4 ? this.fText.length() - 1 : 0;
            bl3 = true;
        }
        if (n2 != -1) {
            this.setSel(n2, n2 + string.length());
            if (bl3) {
                this.beep();
            }
            return true;
        }
        this.beep();
        return false;
    }

    public int wordStartFromPos(int n) {
        int n2;
        for (n2 = n; n2 > 0 && !this.isWordBreakChar(this.fText.charAt(n2 - 1)); --n2) {
        }
        return n2;
    }

    public int wordEndFromPos(int n) {
        int n2;
        for (n2 = n; n2 < this.fText.length() && !this.isWordBreakChar(this.fText.charAt(n2)); ++n2) {
        }
        return n2;
    }

    public void wordAt(int n, Range range) {
        int n2 = this.wordStartFromPos(n);
        int n3 = this.wordEndFromPos(n2);
        range.setValues(n2, n3);
    }

    public void selectWord(int n) {
        Range range = new Range();
        this.wordAt(n, range);
        this.setSel(range);
        this.setGoalColFromPos(range.getEnd());
    }

    public void selectLine(int n) {
        int n2 = this.fText.getLineStart(n);
        int n3 = this.fText.getLineEnd(n);
        this.setSel(n2, n3);
        this.setGoalColFromPos(n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertChar(char c) {
        this.fText.startCommand("Typing");
        try {
            this.fText.replace(this.fSel, c);
        }
        finally {
            this.fText.endCommand();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceSel(String string) {
        this.fText.startCommand("Replace");
        try {
            int n = this.getSelStart();
            this.fText.replace(this.fSel, string.toCharArray());
            this.setSel(n, n + string.length());
        }
        finally {
            this.fText.endCommand();
        }
    }

    public boolean compareSel(Range range) {
        return this.getSelStart() == range.getStart() && this.getSelEnd() == range.getEnd();
    }

    protected boolean isConstCommand(int n) {
        return n != 2 && n != 5 && n != 34 && n != 32 && n != 30 && n != 31 && n != 35 && n != 36;
    }

    protected boolean isWordBreakChar(char c) {
        return !Character.isLetterOrDigit(c) && c != '_' && (c != '\r' || !this.fText.isCRMode());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startDrag(int n, Point point, int n2, boolean bl) {
        this.fText.checkPos(n);
        if (n2 < 1 || n2 > 3) {
            throw new IllegalArgumentException();
        }
        boolean bl2 = this.isCaretEnabled();
        this.beginDeferUpdates();
        try {
            this.setCaretEnabled(false);
            this.fDragging = true;
            this.fSelBeforeDrag = (Range)this.fSel.clone();
            this.fMouseSelMode = n2;
            this.computeChunkUnderPos(n, point);
            if (bl) {
                int n3 = n < this.getSelStart() ? this.fCurrChunkStart : this.fCurrChunkEnd;
                this.setSel(this.getSelStart(), n3);
                this.fDragAnchor.setValues(this.getSelStart(), this.getSelStart());
            } else {
                this.setSel(this.fCurrChunkStart, this.fCurrChunkEnd);
                this.fDragAnchor.copyFrom(this.fSel);
            }
            this.fDragRect = this.fTextCanvas.getBounds();
            this.fDragRect.y = 0;
            this.fDragRect.x = 0;
            this.fSelInProgress = true;
        }
        finally {
            this.fDragging = false;
            this.setCaretEnabled(bl2);
            this.endDeferUpdates();
        }
    }

    private void clearDrag() {
        this.fSelInProgress = false;
        this.fDragRect = null;
        this.fDragPoint = null;
        this.fDragInProgress = false;
        this.fDragItem = null;
        if (this.fDragGraphics != null) {
            this.fDragGraphics.dispose();
            this.fDragGraphics = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void continueDrag(int n) {
        this.fDragging = true;
        try {
            this.updateDrag(n, null);
        }
        finally {
            this.fDragging = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enterDrag() {
        if (this.fSelInProgress || this.fDragInProgress) {
            MWTextModel mWTextModel = this.fText;
            synchronized (mWTextModel) {
                if (sCaretTimerOwner == this) {
                    sCaretTimer.setDelay(CARET_BLINK_DELAY);
                    sCaretTimer.reset();
                }
            }
            this.fAutoScrollHandler = null;
            this.fCaretTime = -1L;
        }
    }

    public void finishDrag(int n, Point point) {
        this.updateDrag(n, point);
        this.enterDrag();
        this.clearDrag();
        this.setGoalColFromPos(this.getSelEnd());
    }

    private void updateDrag(int n, Point point) {
        this.computeChunkUnderPos(n, point);
        if (n < this.fDragAnchor.getStart() || n == this.fDragAnchor.getStart() && this.fMouseSelMode != 3) {
            this.setSel(this.fDragAnchor.getMax(), this.fCurrChunkStart);
        } else if (n >= this.fDragAnchor.getEnd()) {
            this.setSel(this.fDragAnchor.getMin(), this.fCurrChunkEnd);
        } else if (this.getSelStart() < this.getSelEnd()) {
            this.setSel(this.fCurrChunkStart, this.fCurrChunkEnd);
        } else {
            this.setSel(this.fCurrChunkEnd, this.fCurrChunkStart);
        }
    }

    private void computeChunkUnderPos(int n, Point point) {
        switch (this.fMouseSelMode) {
            case 1: {
                this.fCurrChunkStart = n;
                this.fCurrChunkEnd = n;
                break;
            }
            case 2: {
                int n2 = 0;
                if (point != null) {
                    n2 = this.pixelXFromPos(n);
                    n2 = point.x < n2 ? n - 1 : n;
                    if (n2 == this.getModel().length()) {
                        n2 = this.posFromPixel(point) == -1 ? -1 : --n2;
                    }
                    if (n2 >= 0 && this.isWordBreakChar(this.getModel().charAt(n2)) && !Character.isWhitespace(this.getModel().charAt(n2))) {
                        this.fCurrChunkStart = n2;
                        this.fCurrChunkEnd = n2 + 1;
                    } else {
                        n2 = 0;
                    }
                }
                if (n2 != 0) break;
                this.fCurrChunkStart = this.wordStartFromPos(n);
                this.fCurrChunkEnd = this.wordEndFromPos(this.fCurrChunkStart);
                break;
            }
            case 3: {
                int n3 = this.fText.lineFromPos(n);
                this.fCurrChunkStart = this.fText.getLineStart(n3);
                this.fCurrChunkEnd = this.fText.getLineEnd(n3);
            }
        }
    }

    private void continueDragSL(Point point) {
        int n = this.selectionPosFromPixel(point);
        if (n == -1) {
            return;
        }
        int n2 = this.getHScrollAmount();
        this.continueDrag(n);
        Dimension dimension = this.fTextCanvas.getSize();
        dimension.width -= 2;
        int n3 = this.fText.getLineEndNoEOL(0);
        while (n2 == this.getHScrollAmount()) {
            if (n > 0 && point.x < 0) {
                this.continueDrag(--n);
                continue;
            }
            if (n >= n3 || point.x <= dimension.width) break;
            this.continueDrag(++n);
        }
        if (n2 != this.getHScrollAmount()) {
            int n4;
            if (point.x < 0) {
                n = this.posFromPixelX(0, 0);
                n4 = this.pixelXFromPos(n);
            } else {
                dimension.width += 2;
                n = this.posFromPixelX(0, dimension.width);
                if (n == -1) {
                    n = n3;
                    dimension.width -= dimension.width / 4;
                }
                n4 = this.pixelXFromPos(n) - dimension.width;
            }
            if ((n4 += this.getHScrollAmount()) < 0) {
                n4 = 0;
            }
            this.setHScrollAmount(n4);
            this.continueDrag(n);
        }
    }

    private void transferDrag(DragMessage dragMessage) {
        if (dragMessage.getMessageType() == 1) {
            if (sCaretTimerOwner != this) {
                if (dragMessage.getSource() != this) {
                    if (dragMessage.getSource() instanceof MWTextView) {
                        ((MWTextView)dragMessage.getSource()).fMouseHandler.mouseEntered(dragMessage.getMouseEvent());
                    }
                    this.fMouseHandler.fDefiniteDrag = true;
                } else if (sCaretTimerOwner != this) {
                    this.caretTimerStart();
                }
            }
            if (dragMessage.getSource() != this) {
                this.fDragTransfer = true;
            }
        } else if (dragMessage.getMessageType() == 3) {
            this.fDragTransfer = true;
            this.caretTimerStart();
            this.fMouseHandler.mouseExited(dragMessage.getMouseEvent());
            this.fDragTransfer = false;
        }
    }

    @Override
    public void trackDrag(DragMessage dragMessage) {
        Object object;
        int n;
        int n2;
        int n3;
        if (dragMessage.getMessageType() == 3) {
            n3 = -1;
            n2 = this.fDragPos != -1 ? this.fText.lineFromPos(this.fDragPos) : -1;
            n = this.fDragPos;
            this.transferDrag(dragMessage);
        } else {
            if (dragMessage.getMessageType() == 1) {
                this.fDragGraphics = this.fTextCanvas.getGraphics();
                this.fDragInProgress = true;
                this.fDragPos = -1;
                this.transferDrag(dragMessage);
            }
            this.fDragSource = dragMessage.getSource();
            if (this.fDragSource != this) {
                object = dragMessage.getMouseEvent().getPoint();
                n = this.selectionPosFromPoint(((Point)object).x - this.getGutterWidth(), ((Point)object).y);
            } else {
                n = this.selectionPosFromPoint(dragMessage.getMouseEvent().getPoint());
            }
            if (n <= 0 && (n != 0 || this.fDragSource == this)) {
                n2 = (n = -n) != this.fDragPos && this.fDragPos != -1 ? this.fText.lineFromPos(this.fDragPos) : -1;
                if (n != this.fDragPos && (n != this.getSelMin() || this.getSelMin() == this.getSelMax())) {
                    this.fDragPos = n;
                    n3 = this.fText.lineFromPos(n);
                } else {
                    n3 = -1;
                }
            } else {
                n2 = this.fDragPos != -1 ? (this.fDragSource != this && n == this.fDragPos ? -1 : this.fText.lineFromPos(this.fDragPos)) : -1;
                if (n != this.fDragPos && this.fDragSource != this) {
                    this.fDragPos = n;
                    n3 = this.fText.lineFromPos(n);
                } else {
                    n3 = -1;
                }
            }
        }
        if (this.fRepaintState == 0) {
            object = this.fDragGraphics;
            if (n2 != -1 && n2 != n3) {
                this.fLinesToRepaint.setValues(n2, n2);
                this.fRepaintState = 1;
                this.fDragPos = -1;
                if (object != null) {
                    object = this.fTextCanvas.getGraphics();
                }
                if (object != null) {
                    this.fDragGraphics = object;
                    this.fTextCanvas.paint((Graphics)object);
                }
            }
            if (n3 != -1) {
                this.fLinesToRepaint.setValues(n3, n3);
                this.fRepaintState = 1;
                this.fDragPos = n;
                if (object != null) {
                    object = this.fTextCanvas.getGraphics();
                }
                if (object != null) {
                    this.fDragGraphics = object;
                    this.fTextCanvas.paint((Graphics)object);
                }
            }
            if (object != null && object != this.fDragGraphics) {
                ((Graphics)object).dispose();
            }
        }
    }

    @Override
    public boolean willReceiveDrag(Transferable transferable, MouseEvent mouseEvent, Rectangle rectangle) {
        this.fSelInProgress = false;
        if (this.fAllowDragAndDrop && (transferable.isDataFlavorSupported(DragItem.STRING_FLAVOR) || transferable.isDataFlavorSupported(DragItem.STRINGS_FLAVOR))) {
            this.fDragRect = this.fTextCanvas.getBounds();
            this.fDragRect.y = 0;
            this.fDragRect.x = 0;
            Rectangle rectangle2 = this.fTextCanvas.getBounds();
            rectangle2.x -= this.getGutterWidth();
            rectangle2.width += this.getGutterWidth();
            rectangle.setBounds(rectangle2);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveDrop(Transferable transferable) {
        if (this.fDragPos >= 0) {
            try {
                String string;
                int n = this.fDragPos;
                this.fDragPos = -1;
                if (this.fDragSource == this) {
                    this.fText.startCommand("DragNDrop");
                    if (n >= this.getSelMax()) {
                        n -= this.getSelMax() - this.getSelMin();
                    }
                    this.fText.delete(this.getSelMin(), this.getSelMax());
                }
                this.setSel(n);
                if (transferable.isDataFlavorSupported(DragItem.STRING_FLAVOR)) {
                    string = (String)transferable.getTransferData(DragItem.STRING_FLAVOR);
                } else {
                    StringBuffer stringBuffer = new StringBuffer();
                    String[] stringArray = (String[])transferable.getTransferData(DragItem.STRINGS_FLAVOR);
                    for (int i = 0; i < stringArray.length; ++i) {
                        string = stringArray[i];
                        stringBuffer.append(string);
                        if (string.endsWith("\n") || string.endsWith("\r")) continue;
                        stringBuffer.append("\n");
                    }
                    string = stringBuffer.toString();
                }
                if (string != null) {
                    this.do_paste(new Range(n, n), string, "Drop");
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (this.fDragSource == this) {
                    this.fText.endCommand();
                }
            }
        }
    }

    private boolean HandleAutoScroll() {
        int n;
        if (this.fAutoScrollHandler == null) {
            return false;
        }
        boolean bl = true;
        if (this.fSelInProgress && this.fCaretTime >= 0L) {
            this.fCaretTime += 25L;
            if (this.fCaretTime >= (long)CARET_BLINK_DELAY) {
                this.fCaretTime = 0L;
                bl = false;
            }
        }
        if (System.currentTimeMillis() < this.fAutoScrollTime) {
            return bl;
        }
        this.fAutoScrollTime = System.currentTimeMillis() + 25L;
        boolean bl2 = false;
        int n2 = 0;
        if (this.fDragPoint.y < this.fDragRect.y) {
            if (this.getTopLine() > 0) {
                n2 = this.fDragPoint.y - this.fDragRect.y;
            } else {
                bl2 = true;
            }
        } else if (this.fDragPoint.y >= this.fDragRect.height) {
            if (this.getTopLine() + this.numCompleteLinesHigh() < this.fText.getNumLines()) {
                n2 = this.fDragPoint.y - (this.fDragRect.height - 1);
            } else {
                bl2 = true;
            }
        }
        if (this.fDragPoint.x >= this.fDragRect.width) {
            n = this.fDragPoint.x - (this.fDragRect.width - 1);
        } else if (this.fDragPoint.x < this.getHScrollAmount()) {
            int n3 = n = this.getHScrollAmount() > 0 ? this.fDragPoint.x - this.getHScrollAmount() : 0;
            if (n == 0) {
                bl2 = true;
            }
        } else {
            n = 0;
        }
        if (Math.abs(n) > Math.abs(n2)) {
            if (this.fSelInProgress) {
                if (n != 0) {
                    int n4 = this.getHScrollAmount();
                    n4 = n < 0 ? (n4 > 10 ? n4 - 10 : 0) : this.getHScrollAmount() + this.fTextCanvas.getSize().width + 10;
                    this.fAutoScrollHandler.mouseDragged(new MouseEvent(this.fTextCanvas, 506, System.currentTimeMillis(), 0, n4, this.fDragPoint.y, 0, false));
                }
            } else if (n < 0) {
                int n5 = this.getHScrollAmount();
                n5 = n5 > 10 ? n5 - 10 : 0;
                this.fDragPos = this.selectionPosFromPoint(n5, this.fDragPoint.y);
                if (this.fDragPos < 0) {
                    this.fDragPos = -this.fDragPos;
                }
                this.setHScrollAmount(n5);
            } else if (n > 0) {
                n = this.fTextCanvas.getSize().width;
                int n6 = this.fMaxLineWidth - n;
                if (n6 > this.getHScrollAmount()) {
                    n6 = n6 > this.getHScrollAmount() + 10 ? this.getHScrollAmount() + 10 : n6;
                    this.fDragPos = this.selectionPosFromPoint(n6 + n, this.fDragPoint.y);
                    if (this.fDragPos < 0) {
                        this.fDragPos = -this.fDragPos;
                    }
                    this.setHScrollAmount(n6);
                } else if (n6 == this.getHScrollAmount()) {
                    bl2 = true;
                }
            }
        } else if (this.fSelInProgress) {
            if (n2 != 0) {
                int n7 = n2 < 0 ? this.getTopLine() - 1 : this.getTopLine() + this.numCompleteLinesHigh() + 1;
                n7 = this.pixelYFromLine(n7);
                this.fAutoScrollHandler.mouseDragged(new MouseEvent(this.fTextCanvas, 506, System.currentTimeMillis(), 0, this.fDragPoint.x, n7, 0, false));
            }
        } else if (n2 != 0) {
            int n8;
            if (n2 < 0) {
                n8 = this.getTopLine() - 1;
                this.fDragPos = this.selectionPosFromPoint(this.fDragPoint.x, this.pixelYFromLine(n8));
            } else {
                n8 = this.getTopLine() + 1;
                this.fDragPos = this.selectionPosFromPoint(this.fDragPoint.x, this.pixelYFromLine(n8 + this.numCompleteLinesHigh()));
            }
            if (this.fDragPos < 0) {
                this.fDragPos = -this.fDragPos;
            }
            this.setTopLine(n8);
        }
        if (this.fDragInProgress && bl2 && this.fDragPos != -1) {
            this.fDragPos = -1;
            this.repaintAll();
        }
        return bl;
    }

    private void dispatchCommand(int n, KeyEvent keyEvent) {
        boolean bl = true;
        ActionListener actionListener = this.getCommandOverride(n);
        if (actionListener != null) {
            actionListener.actionPerformed(new ActionEvent(keyEvent, n, null));
            return;
        }
        switch (n) {
            case 0: {
                this.charLeft();
                break;
            }
            case 1: {
                this.charLeftExtend();
                break;
            }
            case 2: {
                this.charLeftDelete();
                break;
            }
            case 3: {
                this.charRight();
                break;
            }
            case 4: {
                this.charRightExtend();
                break;
            }
            case 5: {
                this.charRightDelete();
                break;
            }
            case 6: {
                this.wordLeft();
                break;
            }
            case 7: {
                this.wordLeftExtend();
                break;
            }
            case 8: {
                this.wordRight();
                break;
            }
            case 9: {
                this.wordRightExtend();
                break;
            }
            case 10: {
                this.wordRightDelete();
                break;
            }
            case 11: {
                this.wordRightEmacs();
                break;
            }
            case 12: {
                this.wordRightExtendEmacs();
                break;
            }
            case 13: {
                this.lineUp();
                break;
            }
            case 14: {
                this.lineUpExtend();
                break;
            }
            case 15: {
                this.lineDown();
                break;
            }
            case 16: {
                this.lineDownExtend();
                break;
            }
            case 17: {
                this.lineStart();
                break;
            }
            case 18: {
                this.lineStartExtend();
                break;
            }
            case 19: {
                this.lineEnd();
                break;
            }
            case 20: {
                this.lineEndExtend();
                break;
            }
            case 38: {
                this.emacsKillLine();
                break;
            }
            case 21: {
                this.pageUp();
                break;
            }
            case 22: {
                this.pageUpExtend();
                break;
            }
            case 23: {
                this.pageDown();
                break;
            }
            case 24: {
                this.pageDownExtend();
                break;
            }
            case 25: {
                this.bufferStart();
                break;
            }
            case 26: {
                this.bufferStartExtend();
                break;
            }
            case 27: {
                this.bufferEnd();
                break;
            }
            case 28: {
                this.bufferEndExtend();
                break;
            }
            case 29: {
                this.bufferSelect();
                break;
            }
            case 30: {
                this.insertLineBreak();
                break;
            }
            case 31: {
                this.insertChar(keyEvent.getKeyChar());
                break;
            }
            case 32: {
                this.cut();
                break;
            }
            case 33: {
                this.copy();
                break;
            }
            case 34: {
                this.paste();
                break;
            }
            case 35: {
                this.undo();
                break;
            }
            case 36: {
                this.redo();
                break;
            }
            case 37: {
                bl = false;
                break;
            }
            case 39: {
                this.clearSelection();
                break;
            }
            case 40: {
                this.incrementalSearch(keyEvent.getKeyCode());
                break;
            }
            case 100: {
                this.test();
                break;
            }
            default: {
                Assert._assert((boolean)true, (String)"Unimplemented command");
            }
        }
        if (bl) {
            keyEvent.consume();
        }
    }

    public boolean incrementalSearch(int n) {
        int n2 = n == 83 ? this.getSelMax() : this.getSelMin();
        ISearchPanel iSearchPanel = new ISearchPanel(new BorderLayout(), n, n2);
        Dimension dimension = this.getSize();
        Dimension dimension2 = iSearchPanel.getPreferredSize();
        Dimension dimension3 = this.fTextContainer.getSize();
        ++dimension3.width;
        if (this.keyMap().getCommand(0, 10) != 37 && dimension2.height * 2 < dimension.height && (dimension2.width <= dimension3.width || this.fMiniBufferParent != null && dimension2.width <= dimension3.width + (this.fMiniBufferParent.getSize().width - dimension.width))) {
            iSearchPanel.setFloaterOwner(this);
            this.setSelFocusOverride(1);
            this.fMiniBufferPanel = iSearchPanel;
            n2 = this.fMiniBufferParent == null ? 1 - this.getGutterWidth() : dimension.width - this.fMiniBufferParent.getSize().width - 1;
            iSearchPanel.show(this, n2, dimension.height - dimension2.height);
        }
        return true;
    }

    @Override
    public void floaterAutoCollapsed(Floater floater) {
        if (floater == null) {
            if (this.fMiniBufferPanel != null) {
                this.fMiniBufferPanel.collapse();
            }
        } else {
            this.fMiniBufferPanel = null;
            this.setSelFocusOverride(0);
            this.requestFocus();
        }
    }

    public void setMiniBufferFilter(KeyListener keyListener) {
        this.fMiniBufferKeyFilter = keyListener;
    }

    public void setMiniBufferParent(Container container) {
        this.fMiniBufferParent = container;
    }

    private void test() {
        if (Log.LOGGING) {
            if (i % 2 == 0) {
                MWTextComponent mWTextComponent;
                mWTextComponent.setEditable(!(mWTextComponent = (MWTextComponent)this.getParent()).isEditable());
            } else {
                this.getParent().setEnabled(!this.getParent().isEnabled());
            }
            ++i;
        }
    }

    public void surrogateSetFocusTraversalKeysEnabled(boolean bl) {
        if (PlatformInfo.getVersion() >= 5) {
            try {
                Class<Component> clazz = Component.class;
                Class[] classArray = new Class[]{Boolean.TYPE};
                Method method = clazz.getMethod("setFocusTraversalKeysEnabled", classArray);
                Object[] objectArray = new Object[]{bl ? Boolean.TRUE : Boolean.FALSE};
                method.invoke((Object)this.fTextCanvas, objectArray);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static {
        i = 0;
    }

    private class ISearchPanel
    extends FloaterPanel
    implements KeyListener,
    FocusListener {
        private MWTextView fView;
        private MWTextField fField;
        private MWLabel fLabel;
        private IntBuffer fCmdStack;
        private String fInitialString;
        private int fInitialPos;
        private int fDirection;
        private boolean fFirstTime;
        private boolean fMatchCase;
        private boolean fBeep;
        private int fVisLines;
        private int fWrap;
        private String fForwardStr;
        private String fReverseStr;
        private String fLabelStr;

        public ISearchPanel(LayoutManager layoutManager, int n, int n2) {
            super(layoutManager);
            this.fFirstTime = true;
            this.fDirection = n;
            this.fInitialPos = n2;
            this.fView = MWTextView.this;
            this.fWrap = 0;
            this.fBeep = true;
            this.fForwardStr = " I-search:";
            this.fReverseStr = " I-search backward:";
            FontMetrics fontMetrics = this.getFontMetrics(MWTextView.this.getModel().getDefaultFont());
            int n3 = fontMetrics.stringWidth(this.fReverseStr) + fontMetrics.charWidth('M') * 10;
            if (n3 > this.fView.getSize().width - 16) {
                this.fForwardStr = " I-S:";
                this.fReverseStr = " I-R:";
            }
            MyPanel myPanel = new MyPanel(new BorderLayout());
            this.fLabelStr = n == 82 ? this.fReverseStr : this.fForwardStr;
            this.fLabel = new MWLabel(this.fLabelStr);
            this.fLabel.setFont(MWTextView.this.getModel().getDefaultFont());
            this.fLabel.setVerticalAlignment(3);
            myPanel.add((Component)this.fLabel, "West");
            this.fField = new MWTextField();
            this.fField.setFont(MWTextView.this.getModel().getDefaultFont());
            this.fField.setBevelOn(false);
            myPanel.add((Component)this.fField, "Center");
            this.add(myPanel);
            this.fLabel.setForeground(MWTextView.this.getTextColor());
            this.fLabel.setBackground(MWTextView.this.getTextBackgroundColor());
            this.fField.setForeground(MWTextView.this.getTextColor());
            this.fField.setBackground(MWTextView.this.getTextBackgroundColor());
            this.fField.getView().setColorMode(2);
            this.fField.getView().fMiniBufferPanel = this;
            myPanel.setForeground(MWTextView.this.getTextColor());
            myPanel.setBackground(MWTextView.this.getTextBackgroundColor());
            this.fField.setKeyMap(new MWKeyMap(new Hashtable(5)));
            this.fField.getView().addFocusListener(this);
            this.fField.getModel().suspendUndoNotification();
            this.fField.getView().setCtrlCKeyHandler(this);
            this.fCmdStack = new IntBuffer(32, 32);
            if (MWTextView.this.fSearchString == null) {
                MWTextView.this.fSearchString = "";
            }
            this.fInitialString = MWTextView.this.fSearchString;
        }

        @Override
        public void collapse() {
            if (MWTextView.this.fSearchString.length() == 0) {
                MWTextView.this.fSearchString = this.fInitialString;
            }
            super.collapse();
            if (this.getFloaterOwner() != null) {
                this.getFloaterOwner().floaterAutoCollapsed(this);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            if (!this.isShowing()) {
                this.fView.requestFocus();
                if (!this.fView.hasFocus()) {
                    this.fView.fTextCanvas.dispatchEvent(new FocusEvent(this.fView, 1004));
                }
            }
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            this.collapse();
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension dimension = this.fView.fTextCanvas.getSize();
            Dimension dimension2 = this.fField.getPreferredSize();
            dimension.height = dimension2.height;
            dimension.width += this.fView.getGutterWidth();
            if (MWTextView.this.fMiniBufferParent != null) {
                dimension.width += ((MWTextView)MWTextView.this).fMiniBufferParent.getSize().width - this.fView.getSize().width;
            }
            ++dimension.width;
            return dimension;
        }

        @Override
        public void requestFocus() {
            super.requestFocus();
            QueueEvent.postQueueEvent((QueueEvent)new ForwardEvent(null));
        }

        private void setLabel(String string) {
            if (this.fLabelStr != string) {
                this.fLabelStr = string;
                this.fLabel.setText(string);
                this.fLabel.invalidate();
                this.fLabel.getParent().invalidate();
                this.fLabel.getParent().doLayout();
            }
        }

        private void forwardEvent(KeyEvent keyEvent) {
            QueueEvent.postQueueEvent((QueueEvent)new ForwardEvent(new KeyEvent(this.fView, keyEvent.getID(), keyEvent.getWhen(), keyEvent.getModifiers(), keyEvent.getKeyCode(), keyEvent.getKeyChar())));
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
        }

        @Override
        public void keyReleased(KeyEvent keyEvent) {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n = keyEvent.getModifiers();
            int n2 = keyEvent.getKeyCode();
            if (n2 == 17 || n2 == 157 || n2 == 18 || n2 == 16) {
                keyEvent.consume();
                return;
            }
            if (MWTextView.this.fMiniBufferKeyFilter != null) {
                MWTextView.this.fMiniBufferKeyFilter.keyPressed(keyEvent);
                if (keyEvent.isConsumed()) {
                    n = -1;
                }
            }
            if (n == 0 || n == 1) {
                switch (n2) {
                    case 10: 
                    case 27: {
                        this.collapse();
                        keyEvent.consume();
                        break;
                    }
                    case 8: {
                        keyEvent.consume();
                        this.doSearch(8, -1, false);
                        break;
                    }
                    case 33: 
                    case 34: 
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: 
                    case 127: 
                    case 144: 
                    case 145: 
                    case 155: {
                        this.collapse();
                        this.forwardEvent(keyEvent);
                        break;
                    }
                    default: {
                        ((MWComponent)keyEvent.getSource()).superProcessKeyEvent(keyEvent);
                        if (this.fField.getModel().length() != MWTextView.this.fSearchString.length() || this.fFirstTime) {
                            MWTextView.this.fSearchString = this.fField.getText();
                            if (!this.fMatchCase) {
                                this.fMatchCase = Character.isUpperCase(keyEvent.getKeyChar());
                            }
                            this.doSearch(0, -1, true);
                            break;
                        } else {
                            break;
                        }
                    }
                }
            } else if (n == 2) {
                if (n2 == 83) {
                    keyEvent.consume();
                    if (this.fDirection != 83 && this.fCmdStack.length() > 0 && this.fCmdStack.getAt(this.fCmdStack.length() - 1) == 0) {
                        this.fCmdStack.append(this.fDirection);
                    }
                    this.doSearch(83, -1, true);
                } else if (n2 == 82) {
                    keyEvent.consume();
                    if (this.fDirection != 82 && this.fCmdStack.length() > 0 && this.fCmdStack.getAt(this.fCmdStack.length() - 1) == 0) {
                        this.fCmdStack.append(this.fDirection);
                    }
                    this.doSearch(82, -1, true);
                } else if (n2 == 87) {
                    keyEvent.consume();
                    this.doCtrlW();
                } else if (n2 == 71) {
                    int n3 = this.fView.getSelMax() - this.fView.getSelMin();
                    keyEvent.consume();
                    if (n3 == 0 && this.fCmdStack.length() == 0 || MWTextView.this.fSearchString.length() == n3) {
                        this.fView.beep();
                        this.fView.setSel(this.fInitialPos);
                        this.collapse();
                    } else {
                        this.bsHelper(71);
                    }
                } else {
                    this.collapse();
                    if (n2 != 81) {
                        this.forwardEvent(keyEvent);
                    }
                }
            } else if (n == 8) {
                if (n2 == 89) {
                    keyEvent.consume();
                    this.doYank(keyEvent);
                } else {
                    this.collapse();
                    this.forwardEvent(keyEvent);
                }
            } else {
                this.collapse();
                this.forwardEvent(keyEvent);
            }
        }

        private void doCtrlW() {
            int n = this.fView.getSelMax();
            this.fView.wordRightExtendEmacs();
            int n2 = this.fView.getSelMax();
            if (n2 > n) {
                String string = this.fView.getModel().getText(n, n2);
                if (!this.fMatchCase) {
                    string.toLowerCase();
                }
                this.fField.getModel().insert(this.fField.getModel().length(), string);
                MWTextView.this.fSearchString = this.fField.getText();
                n = this.fDirection == 83 ? this.fView.getSelMin() : this.fView.getSelMax();
                this.fCmdStack.append(-n);
                this.fCmdStack.append(string.length());
                this.fCmdStack.append(87);
            }
        }

        private void doYank(KeyEvent keyEvent) {
            int n = this.fField.getModel().length();
            this.fField.getView().dispatchCommand(34, keyEvent);
            int n2 = this.fField.getModel().length();
            if (n2 > n) {
                MWTextView.this.fSearchString = this.fField.getText();
                if (!this.fMatchCase) {
                    MWTextView.this.fSearchString.toLowerCase();
                    this.fField.setText(MWTextView.this.fSearchString);
                }
                int n3 = this.fDirection == 83 ? this.fView.getSelMin() : this.fView.getSelMax();
                this.fCmdStack.append(-n3);
                this.fCmdStack.append(n2 - n);
                this.fCmdStack.append(87);
                this.doSearch(this.fDirection, -1, false);
            }
        }

        private int bsHelper(int n) {
            int n2;
            if (n == 0) {
                char c = this.fField.getModel().getCharBuffer().getAt(this.fField.getModel().length() - 1);
                this.fField.getView().charLeftDelete();
                MWTextView.this.fSearchString = this.fField.getText();
                if (Character.isUpperCase(c)) {
                    for (n2 = 0; n2 < MWTextView.this.fSearchString.length() && !Character.isUpperCase(MWTextView.this.fSearchString.charAt(n2)); ++n2) {
                    }
                    this.fMatchCase = n2 < MWTextView.this.fSearchString.length();
                }
                int n3 = this.fCmdStack.length() - 1;
                n2 = -this.fCmdStack.getAt(n3);
                this.fCmdStack.delete(n3, n3 + 1);
            } else if (n == 71) {
                int n4 = this.fCmdStack.length() - 1;
                n = this.fCmdStack.getAt(n4);
                this.fBeep = false;
                while (n >= 0 && (n != 0 || MWTextView.this.fSearchString.length() != this.fView.getSelMax() - this.fView.getSelMin())) {
                    this.doSearch(8, -1, false);
                    n4 = this.fCmdStack.length() - 1;
                    n = this.fCmdStack.getAt(n4);
                }
                this.fBeep = true;
                n2 = -1;
            } else {
                int n5 = this.fCmdStack.length() - 1;
                int n6 = this.fCmdStack.getAt(n5);
                this.fCmdStack.delete(n5, n5 + 1);
                n2 = this.fField.getModel().length();
                this.fField.getModel().delete(n2 - n6, n2);
                MWTextView.this.fSearchString = this.fField.getText();
                n5 = this.fCmdStack.length() - 1;
                n2 = -this.fCmdStack.getAt(n5);
                this.fCmdStack.delete(n5, n5 + 1);
            }
            if (MWTextView.this.fSearchString.length() == 0) {
                n2 = -1;
                if (this.fBeep) {
                    this.fView.beep();
                }
                this.fView.setSel(this.fInitialPos);
                this.fMatchCase = false;
            }
            return n2;
        }

        private void hiliteSel(int n, int n2) {
            int n3;
            int n4;
            this.fView.setSel(n, n2);
            if (this.fVisLines <= 0) {
                this.fVisLines = (((MWTextView)this.fView).fTextCanvas.getSize().height - this.getSize().height) / this.fView.getModel().getFontHeight();
                --this.fVisLines;
            }
            if ((n4 = this.fView.getModel().lineFromPos(n2)) > (n3 = this.fView.getTopLine() + this.fVisLines)) {
                this.fView.setTopLine(this.fView.getTopLine() + (n4 - n3));
            }
        }

        private void doSearch(int n, int n2, boolean bl) {
            if (n == 83) {
                int n3;
                if (bl) {
                    this.setLabel(this.fForwardStr);
                }
                if (MWTextView.this.fSearchString.length() == 0) {
                    MWTextView.this.fSearchString = this.fInitialString;
                    if (MWTextView.this.fSearchString.length() == 0) {
                        return;
                    }
                }
                this.fDirection = n;
                if (this.fFirstTime) {
                    this.fField.setText(MWTextView.this.fSearchString);
                }
                int n4 = this.fView.getSelMin();
                int n5 = this.fView.getSelMax();
                if (n2 < 0) {
                    n2 = MWTextView.this.fSearchString.length() == n5 - n4 ? n5 : n4;
                }
                if (n2 >= this.fView.getModel().length() - 1) {
                    n2 = 0;
                }
                if (n2 == 0 && n5 != n4 && n4 != 0 && this.fWrap != 1) {
                    this.fWrap = 1;
                    n3 = -1;
                } else {
                    if (n2 == 0) {
                        this.fWrap = 0;
                    }
                    n3 = this.fView.getModel().findString(MWTextView.this.fSearchString, n2, this.fMatchCase);
                }
                if (n3 == -1 && n2 > 0) {
                    if (this.fWrap != 1) {
                        this.fWrap = 1;
                    } else {
                        this.fWrap = 0;
                        n3 = this.fView.getModel().findString(MWTextView.this.fSearchString, 0, this.fMatchCase);
                    }
                }
                if (n3 != -1) {
                    this.hiliteSel(n3, n3 + MWTextView.this.fSearchString.length());
                    if (bl) {
                        this.fCmdStack.append(-n4);
                    }
                } else if (this.fBeep) {
                    this.fView.beep();
                }
                this.fFirstTime = false;
            } else if (n == 82) {
                int n6;
                if (bl) {
                    this.setLabel(this.fReverseStr);
                }
                if (MWTextView.this.fSearchString.length() == 0) {
                    MWTextView.this.fSearchString = this.fInitialString;
                    if (MWTextView.this.fSearchString.length() == 0) {
                        return;
                    }
                }
                this.fDirection = n;
                if (this.fFirstTime) {
                    this.fField.setText(MWTextView.this.fSearchString);
                }
                int n7 = this.fView.getSelMin();
                int n8 = this.fView.getSelMax();
                if (n2 < 0) {
                    n2 = MWTextView.this.fSearchString.length() == n8 - n7 && MWTextView.this.fSearchString.length() > 0 ? n8 - 2 : n8;
                }
                if (this.fWrap == 0 && n2 == this.fInitialPos) {
                    n2 = this.fInitialPos - 1;
                }
                if (n2 <= 0) {
                    n2 = this.fView.getModel().length() - 1;
                }
                if (n2 == this.fView.getModel().length() - 1 && n8 != n7 && n8 != this.fView.getModel().length() - 1 && this.fWrap != -1) {
                    this.fWrap = -1;
                    n6 = -1;
                } else {
                    if (n2 == this.fView.getModel().length() - 1) {
                        this.fWrap = 0;
                    }
                    n6 = this.fView.getModel().findStringBackwards(MWTextView.this.fSearchString, n2, this.fMatchCase);
                }
                if (n6 == -1 && (n2 < this.fView.getModel().length() - 1 || n2 == this.fView.getModel().length())) {
                    if (this.fWrap != -1) {
                        this.fWrap = -1;
                    } else {
                        this.fWrap = 0;
                        n6 = this.fView.getModel().findStringBackwards(MWTextView.this.fSearchString, this.fView.getModel().length() - 1, this.fMatchCase);
                    }
                }
                if (n6 != -1) {
                    this.hiliteSel(n6, n6 + MWTextView.this.fSearchString.length());
                    if (bl) {
                        this.fCmdStack.append(-n8);
                    }
                } else if (this.fBeep) {
                    this.fView.beep();
                }
                this.fFirstTime = false;
            } else if (n == 8) {
                int n9;
                n = this.fCmdStack.length() - 1;
                if (n >= 0) {
                    n9 = n;
                    n = this.fCmdStack.getAt(n9);
                    this.fCmdStack.delete(n9, n9 + 1);
                } else {
                    if (this.fField.getModel().length() > 0) {
                        this.fField.setText("");
                    }
                    if (this.fBeep) {
                        this.fView.beep();
                    }
                }
                n2 = -1;
                if (n == 0) {
                    n2 = this.bsHelper(0);
                } else if (n == 83) {
                    this.setLabel(this.fForwardStr);
                    this.fDirection = 83;
                } else if (n == 82) {
                    this.setLabel(this.fReverseStr);
                    this.fDirection = 82;
                } else if (n == 87) {
                    n2 = this.bsHelper(87);
                } else if (n < 0) {
                    n2 = -n;
                    n9 = this.fCmdStack.length() - 1;
                    if (n9 >= 0) {
                        n = this.fCmdStack.getAt(n9);
                    }
                }
                if (n2 >= 0) {
                    this.doSearch(this.fDirection, n2, false);
                    if (n == 83 || n == 82) {
                        this.doSearch(8, -1, false);
                    }
                }
            } else if (n == 0) {
                if (bl) {
                    n2 = this.fDirection == 83 ? this.fView.getSelMin() : this.fView.getSelMax();
                    this.fCmdStack.append(-n2);
                    this.fCmdStack.append(0);
                }
                this.fFirstTime = false;
                this.doSearch(this.fDirection, -1, false);
            }
        }

        private class ForwardEvent
        extends QueueEvent {
            KeyEvent fEvent;

            public ForwardEvent(KeyEvent keyEvent) {
                this.fEvent = keyEvent;
            }

            public void dispatch() {
                if (this.fEvent != null) {
                    ISearchPanel.this.fView.processKeyEvent(this.fEvent);
                } else {
                    ISearchPanel.this.fField.requestFocus();
                }
            }
        }

        private class MyPanel
        extends MWPanel {
            public MyPanel(LayoutManager layoutManager) {
                super(layoutManager);
                this.setOpaqueInsets(false);
                this.setInsets(new Insets(2, 2, 2, 2));
            }

            @Override
            public void paint(Graphics graphics) {
                Dimension dimension = this.getSize();
                graphics.setColor(this.getBackground());
                graphics.drawRect(1, 1, dimension.width - 3, dimension.height - 3);
                graphics.setColor(this.getForeground());
                graphics.drawRect(0, 0, dimension.width - 1, dimension.height - 1);
                super.paint(graphics);
            }
        }
    }

    private static class TextContainer
    extends MWContainer {
        private TextContainer() {
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }
    }

    private class TextCanvas
    extends MWComponent {
        private boolean fUseOffscreen = true;

        private TextCanvas() {
        }

        @Override
        public void setSize(int n, int n2) {
            super.setSize(n, n2);
            MWTextView.this.repaintCanvas();
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            super.setBounds(n, n2, n3, n4);
            MWTextView.this.repaintCanvas();
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public void print(Graphics graphics) {
            boolean bl = this.fUseOffscreen;
            this.fUseOffscreen = false;
            this.paint(graphics);
            this.fUseOffscreen = bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void paint(Graphics graphics) {
            Shape shape = null;
            Dimension dimension = this.getSize();
            if (dimension.width == 0 || dimension.height == 0) {
                return;
            }
            MWTextModel mWTextModel = MWTextView.this.fText;
            synchronized (mWTextModel) {
                int n;
                int n2;
                int n3;
                if (MWTextView.this.fDeferredScrollPos != -1) {
                    MWTextView.this.scrollPosIntoView(MWTextView.this.fDeferredScrollPos);
                    MWTextView.this.fDeferredScrollPos = -1;
                }
                if (MWTextView.this.fDeferUpdatesCounter > 0) {
                    if (MWTextView.this.fRepaintState != 3 || !MWTextView.this.fText.isTextEventNotificationSuspended()) {
                        MWTextView.this.fRepaintState = 2;
                    }
                    return;
                }
                if (MWTextView.this.fRepaintState == 0) {
                    MWTextView.this.fRepaintState = 2;
                }
                MWTextView.this.fRepaintPending = false;
                super.paint(graphics);
                int n4 = MWTextView.this.getTopLine();
                int n5 = n3 = MWTextView.this.getBottomLine();
                if (dimension.width < 0) {
                    return;
                }
                if (MWTextView.this.fRepaintState == 1) {
                    n4 = Math.max(n4, MWTextView.this.fLinesToRepaint.getStart());
                    n5 = Math.min(n5, MWTextView.this.fLinesToRepaint.getEnd());
                }
                if (MWTextView.this.fDragTransfer && MWTextView.this.fDragRect != null && MWTextView.this.fRepaintState != 2) {
                    shape = graphics.getClip();
                    graphics.clipRect(((MWTextView)MWTextView.this).fDragRect.x + 3, ((MWTextView)MWTextView.this).fDragRect.y + 3, ((MWTextView)MWTextView.this).fDragRect.width - 6, ((MWTextView)MWTextView.this).fDragRect.height - 6);
                }
                if (this.fUseOffscreen) {
                    if (MWTextView.this.fOffScreenBuffer == null || MWTextView.this.fOffScreenBuffer.getWidth(this) != dimension.width || MWTextView.this.fOffScreenBuffer.getHeight(this) != MWTextView.this.getModel().getFontHeight()) {
                        if (MWTextView.this.fOffScreenBuffer != null) {
                            MWTextView.this.fOffScreenGraphics.dispose();
                            MWTextView.this.fOffScreenBuffer.flush();
                        }
                        MWTextView.this.fOffScreenBuffer = this.createImage(dimension.width, MWTextView.this.getModel().getFontHeight());
                        if (MWTextView.this.fOffScreenBuffer == null) {
                            return;
                        }
                        MWTextView.this.fOffScreenGraphics = MWTextView.this.fOffScreenBuffer.getGraphics();
                    }
                    MWTextView.this.fOffScreenGraphics.setFont(MWTextView.this.getModel().getDefaultFont());
                    for (n2 = n4; n2 <= n5; ++n2) {
                        MWTextView.this.fOffScreenGraphics.setColor(this.getBackground());
                        MWTextView.this.fOffScreenGraphics.fillRect(0, 0, MWTextView.this.fOffScreenBuffer.getWidth(this), MWTextView.this.fOffScreenBuffer.getHeight(this));
                        MWTextView.this.renderLine(MWTextView.this.fOffScreenGraphics, n2);
                        graphics.drawImage(MWTextView.this.fOffScreenBuffer, 0, MWTextView.this.pixelYFromLine(n2), this);
                    }
                } else {
                    n = MWTextView.this.pixelYFromLine(n4);
                    int n6 = MWTextView.this.pixelYFromLine(n5 + 1) - n;
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, n, dimension.width, n6);
                    graphics.setFont(MWTextView.this.getModel().getDefaultFont());
                    for (n2 = n4; n2 <= n5; ++n2) {
                        graphics.setColor(this.getBackground());
                        graphics.translate(0, MWTextView.this.pixelYFromLine(n2));
                        MWTextView.this.renderLine(graphics, n2);
                        graphics.translate(0, -MWTextView.this.pixelYFromLine(n2));
                    }
                }
                if ((n2 = Math.min(MWTextView.this.getModel().getNumLines() - 1, n3)) < MWTextView.this.getTopLine() + MWTextView.this.numLinesHigh() - 1) {
                    n = MWTextView.this.pixelYFromLine(n2 + 1);
                    graphics.setColor(this.getBackground());
                    graphics.fillRect(0, n, dimension.width, dimension.height - n + 1);
                }
                if (MWTextView.this.fDragTransfer && MWTextView.this.fDragRect != null && MWTextView.this.fRepaintState != 2) {
                    graphics.setClip(shape);
                }
                if (MWTextView.this.fRepaintState == 2 && MWTextView.this.fDragInProgress && MWTextView.this.fDragItem != null) {
                    MWTextView.this.fDragItem.paintActiveRect();
                    MWTextView.this.fDragItem.paintDragOutline();
                }
                MWTextView.this.fRepaintState = 0;
                MWTextView.this.fLinesToRepaint.setValues(-1, -1);
            }
        }

        @Override
        public void processKeyEvent(KeyEvent keyEvent) {
            if (MWTextView.this.fTextCanvasCtrlCKeyHandler != null && keyEvent.getID() == 401 && (keyEvent.getKeyCode() == 67 || keyEvent.getKeyCode() == 3 || MWTextView.this.fMiniBufferPanel != null)) {
                MWTextView.this.fTextCanvasCtrlCKeyHandler.keyPressed(keyEvent);
            }
            if (MWTextView.this.fMiniBufferPanel == null) {
                if (keyEvent.isConsumed()) {
                    this.superProcessKeyEvent(keyEvent);
                } else {
                    super.processKeyEvent(keyEvent);
                }
            }
        }

        @Override
        protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    private class Gutter
    extends MWComponent {
        int fWidth = 0;

        public Gutter(int n) {
            this.fWidth = n;
            GutterMouseEventHandler gutterMouseEventHandler = new GutterMouseEventHandler();
            this.addMouseListener(gutterMouseEventHandler);
            this.addMouseMotionListener(gutterMouseEventHandler);
        }

        @Override
        public int getWidth() {
            return this.fWidth;
        }

        public void setWidth(int n) {
            if (n != this.fWidth) {
                this.fWidth = n;
                this.invalidate();
                this.getParent().validate();
            }
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(this.fWidth, this.fWidth);
        }

        @Override
        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        @Override
        public void paint(Graphics graphics) {
            Dimension dimension = this.getSize();
            graphics.setColor(this.getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }

        public class GutterMouseEventHandler
        extends MouseAdapter
        implements MouseMotionListener {
            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (PlatformInfo.isXWindows() && (mouseEvent.getModifiers() & 8) != 0) {
                    KeyEvent keyEvent = new KeyEvent(mouseEvent.getComponent(), 401, 0L, 0, 0, '\u0000');
                    MWTextView.this.dispatchCommand(34, keyEvent);
                } else {
                    MWTextView.this.startDrag(this.lineStartFromEvent(mouseEvent), null, 3, mouseEvent.isShiftDown());
                }
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                if (PlatformInfo.isXWindows() && (mouseEvent.getModifiers() & 8) != 0) {
                    return;
                }
                MWTextView.this.continueDrag(this.lineStartFromEvent(mouseEvent));
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                MWTextView.this.finishDrag(this.lineStartFromEvent(mouseEvent), null);
                MWTextView.this.requestFocus();
                if (PlatformInfo.isXWindows()) {
                    KeyEvent keyEvent = new KeyEvent(mouseEvent.getComponent(), 401, 0L, 0, 0, '\u0000');
                    MWTextView.this.dispatchCommand(33, keyEvent);
                }
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }

            private int lineStartFromEvent(MouseEvent mouseEvent) {
                int n = MWTextView.this.lineFromPixelY(mouseEvent.getPoint().y);
                int n2 = Math.max(Math.min(n, MWTextView.this.fText.getNumLines() - 1), 0);
                return MWTextView.this.fText.getLineStart(n2);
            }
        }
    }

    private class CaretTimerHandler
    implements ActionListener {
        private CaretTimerHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MWTextModel mWTextModel = MWTextView.this.fText;
            synchronized (mWTextModel) {
                try {
                    if (MWTextView.this.HandleAutoScroll()) {
                        return;
                    }
                }
                catch (Exception exception) {
                    return;
                }
                if (MWTextView.this.fDragInProgress) {
                    return;
                }
                Graphics graphics = MWTextView.this.getGraphics();
                if (graphics == null) {
                    MWTextView.this.caretTimerStop();
                } else {
                    MWTextView.this.setCaretOn(!MWTextView.this.isCaretOn());
                    graphics.dispose();
                }
            }
        }
    }

    private class CaretTimerEventHandler
    implements ActionListener {
        private CaretTimerEventHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            CaretTimerHandler caretTimerHandler = sCaretTimerListener;
            if (caretTimerHandler == null) {
                if (System.currentTimeMillis() > sCaretTimerIdle) {
                    sCaretTimerIdle = 0L;
                    sCaretTimer.setDelay(1000000000);
                }
            } else {
                caretTimerHandler.actionPerformed(actionEvent);
            }
        }
    }

    private class FocusEventHandler
    implements FocusListener {
        private FocusEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusGained(FocusEvent focusEvent) {
            MWTextView.this.fHasFocus = true;
            MWTextView.this.fText.viewWasActivated(MWTextView.this);
            MWTextView.this.beginDeferUpdates();
            try {
                MWTextView.this.updateCaret();
                MWTextView.this.repaintAll();
            }
            finally {
                MWTextView.this.endDeferUpdates();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void focusLost(FocusEvent focusEvent) {
            MWTextView.this.fHasFocus = false;
            MWTextView.this.beginDeferUpdates();
            try {
                MWTextView.this.updateCaret();
                MWTextView.this.repaintAll();
            }
            finally {
                MWTextView.this.endDeferUpdates();
            }
        }
    }

    private class ComponentEventHandler
    extends ComponentAdapter {
        private ComponentEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void componentResized(ComponentEvent componentEvent) {
            MWTextView.this.beginDeferUpdates();
            try {
                MWTextView.this.updateScrollbars();
            }
            finally {
                MWTextView.this.endDeferUpdates();
            }
        }
    }

    private class PropertyEventHandler
    implements PropertyChangeListener {
        private PropertyEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getPropertyName() == "Editable") {
                MWTextView.this.beginDeferUpdates();
                try {
                    MWTextView.this.updateBackground();
                    MWTextView.this.repaintAll();
                }
                finally {
                    MWTextView.this.endDeferUpdates();
                }
            }
        }
    }

    private class TextEventHandler
    extends MWTextAdapter {
        private TextEventHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void textDeleted(MWTextEvent mWTextEvent) {
            MWTextView.this.beginDeferUpdates();
            try {
                if (MWTextView.this.isActiveView() && MWTextView.this.fText.isEditable()) {
                    if (mWTextEvent.getMinLine() < MWTextView.this.getTopLine()) {
                        int n = mWTextEvent.getMaxLine() - mWTextEvent.getMinLine();
                        MWTextView.this.setTopLine(Math.max(0, MWTextView.this.getTopLine() - n));
                    }
                    if (!MWTextView.this.fText.isTextEventNotificationSuspended()) {
                        MWTextView.this.setSel(mWTextEvent.getMinPos());
                        MWTextView.this.setGoalColFromPos(MWTextView.this.getSelMin());
                    }
                } else {
                    MWTextView.this.clampSelToModel();
                    if (mWTextEvent.getMinLine() < MWTextView.this.getTopLine()) {
                        int n = mWTextEvent.getMaxLine() - mWTextEvent.getMinLine();
                        MWTextView.this.setTopLine(Math.max(0, MWTextView.this.getTopLine() - n));
                    }
                }
                if (MWTextView.this.fText.length() == 0) {
                    MWTextView.this.fMaxLineWidth = 0;
                }
                MWTextView.this.updateScrollbars();
                int n = mWTextEvent.getMaxLine();
                int n2 = mWTextEvent.getMinLine();
                int n3 = MWTextView.this.fLinesToRepaint.getEnd();
                if (n3 > 0) {
                    int n4 = MWTextView.this.fLinesToRepaint.getStart();
                    if (n < n4) {
                        int n5 = n - n2;
                        MWTextView.this.fLinesToRepaint.setValues(n4 - n5, n3 - n5);
                    } else if (n < n3) {
                        int n6;
                        if (n2 <= n4) {
                            n6 = n4 - n2;
                            MWTextView.this.fLinesToRepaint.setStart(n4 - n6);
                        }
                        n6 = n - n2;
                        MWTextView.this.fLinesToRepaint.setEnd(n3 - n6);
                    } else if (n2 < n3) {
                        MWTextView.this.fLinesToRepaint.setEnd(MWTextView.this.fText.getNumLines() - 1);
                        if (n2 < n4) {
                            MWTextView.this.fLinesToRepaint.setStart(n2);
                        }
                    }
                }
                if (n2 == n) {
                    MWTextView.this.repaintLines(n2, n2);
                } else {
                    MWTextView.this.repaintLines(n2, MWTextView.this.fText.getNumLines() - 1);
                }
            }
            finally {
                MWTextView.this.endDeferUpdates();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void textInserted(MWTextEvent mWTextEvent) {
            MWTextView.this.beginDeferUpdates();
            try {
                if (MWTextView.this.isActiveView() && MWTextView.this.fText.isEditable()) {
                    MWTextView.this.setSel(mWTextEvent.getMaxPos());
                    MWTextView.this.setGoalColFromPos(MWTextView.this.getSelMin());
                    if (MWTextView.this.fSelInProgress && MWTextView.this.fText.isTextEventNotificationSuspended() && mWTextEvent.getMinPos() < MWTextView.this.fDragAnchor.getMin()) {
                        MWTextView.this.fDragAnchor.setValues(MWTextView.this.fDragAnchor.getStart() + mWTextEvent.getLength(), MWTextView.this.fDragAnchor.getEnd() + mWTextEvent.getLength());
                    }
                } else if (mWTextEvent.getMinLine() < MWTextView.this.getTopLine()) {
                    int n = mWTextEvent.getMaxLine() - mWTextEvent.getMinLine();
                    MWTextView.this.setTopLine(MWTextView.this.getTopLine() + n);
                }
                MWTextView.this.updateScrollbars();
                if (mWTextEvent.getMinLine() == mWTextEvent.getMaxLine()) {
                    MWTextView.this.repaintLines(mWTextEvent.getMinLine(), mWTextEvent.getMaxLine());
                } else {
                    MWTextView.this.repaintLines(mWTextEvent.getMinLine(), MWTextView.this.fText.getNumLines() - 1);
                }
            }
            finally {
                MWTextView.this.endDeferUpdates();
            }
        }

        @Override
        public void styleChanged(MWTextEvent mWTextEvent) {
            MWTextView.this.repaintLines(mWTextEvent.getMinLine(), mWTextEvent.getMaxLine());
        }

        @Override
        public void commandStarted(MWTextEvent mWTextEvent) {
            MWTextView.this.beginDeferUpdates();
        }

        @Override
        public void commandEnded(MWTextEvent mWTextEvent) {
            MWTextView.this.endDeferUpdates();
        }
    }

    private class KeyEventHandler
    extends KeyAdapter {
        private KeyEventHandler() {
        }

        @Override
        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.isAltGraphDown()) {
                this.keyPressed(keyEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.isConsumed()) {
                return;
            }
            if (keyEvent.isAltGraphDown() && keyEvent.getID() == 401) {
                return;
            }
            MWTextView.this.beginDeferUpdates();
            try {
                int n = keyEvent.getModifiers();
                int n2 = keyEvent.getKeyCode();
                char c = keyEvent.getKeyChar();
                int n3 = MWTextView.this.keyMap().getCommand(n, n2);
                if (n3 == -1) {
                    int n4 = n & 0xA;
                    if (n4 == 2) {
                        return;
                    }
                    if (n4 == 8 && !PlatformInfo.isMacintosh()) {
                        return;
                    }
                    if (keyEvent.isMetaDown() || n2 == 127 || c == '\uffff' || c == '\uffff' || n2 == 127 || n2 == 27 || c == '\b') {
                        if (n4 == 10) {
                            keyEvent.consume();
                        }
                        return;
                    }
                    keyEvent.consume();
                    n3 = 31;
                }
                if (!MWTextView.this.isEnabled() && n3 != 100) {
                    return;
                }
                if (!MWTextView.this.getModel().isEditable() && !MWTextView.this.isConstCommand(n3)) {
                    return;
                }
                MWTextView.this.dispatchCommand(n3, keyEvent);
            }
            finally {
                MWTextView.this.endDeferUpdates();
            }
        }
    }

    private class MouseEventHandler
    extends MouseAdapter
    implements MouseMotionListener {
        long fDblClickTime;
        int fDblClickX;
        int fDblClickY;
        int fStartPos;
        int fSelMode;
        boolean fShiftDown;
        boolean fPossibleDrag = false;
        boolean fDefiniteDrag = false;
        boolean fContextClicking = false;
        Point fDragStartPoint;

        private MouseEventHandler() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            int n;
            this.fPossibleDrag = false;
            this.fDefiniteDrag = false;
            this.fSelMode = 1;
            if (!MWTextView.this.isEnabled()) {
                return;
            }
            boolean bl = MWTextView.this.hasFocus();
            MWTextView.this.fTextCanvas.requestFocus();
            this.fStartPos = MWTextView.this.selectionPosFromPixel(mouseEvent.getPoint());
            if (this.fStartPos == -1) {
                return;
            }
            int n2 = mouseEvent.getClickCount();
            int n3 = n = PlatformInfo.isMacintosh() ? 2 : 4;
            if ((mouseEvent.getModifiers() & n) != 0 && n2 == 1 && this.fStartPos >= MWTextView.this.getSelMin() && this.fStartPos <= MWTextView.this.getSelMax()) {
                this.fContextClicking = true;
                return;
            }
            this.fContextClicking = false;
            int n4 = n = PlatformInfo.isXWindows() ? 4 : 12;
            if ((mouseEvent.getModifiers() & n) != 0) {
                this.fDefiniteDrag = true;
                return;
            }
            if (!bl && (MWTextView.this.fSelFocusOverride & 8) == 8) {
                this.fDefiniteDrag = true;
                MWTextView.this.bufferSelect();
                return;
            }
            if ((mouseEvent.getModifiers() & 2) == 2) {
                if (PlatformInfo.isMacintosh()) {
                    this.fDefiniteDrag = true;
                    return;
                }
                n2 = 2;
            }
            if (PlatformInfo.isXWindows() && (mouseEvent.getModifiers() & 8) != 0) {
                n2 = 1;
            }
            if (mouseEvent.getModifiers() == 16 && (((MWStyle)(object = MWTextView.this.fText.getStyleAt(MWTextView.this.posFromPixel(mouseEvent.getPoint())))).getStyle() & 1) != 0) {
                this.fDefiniteDrag = true;
                return;
            }
            switch (n2) {
                case 1: {
                    this.fSelMode = 1;
                    break;
                }
                case 2: {
                    this.fSelMode = 2;
                    break;
                }
                case 3: {
                    this.fSelMode = 3;
                    break;
                }
                default: {
                    this.fSelMode = 1;
                }
            }
            this.fShiftDown = mouseEvent.isShiftDown();
            if (PlatformInfo.isXWindows() && (mouseEvent.getModifiers() & 8) != 0) {
                object = new KeyEvent(mouseEvent.getComponent(), 401, 0L, 0, 0, '\u0000');
                MWTextView.this.setSel(this.fStartPos);
                MWTextView.this.dispatchCommand(34, (KeyEvent)object);
                this.fDefiniteDrag = true;
                return;
            }
            boolean bl2 = this.fPossibleDrag = this.fSelMode == 1 && !MWTextView.this.getSel().isEmpty() && this.fStartPos >= MWTextView.this.getSelMin() && this.fStartPos <= MWTextView.this.getSelMax() && MWTextView.this.fAllowDragAndDrop;
            if (this.fPossibleDrag) {
                this.fDragStartPoint = mouseEvent.getPoint();
                MWTextView.this.fDragRect = MWTextView.this.fTextCanvas.getBounds();
            } else {
                MWTextView.this.startDrag(this.fStartPos, mouseEvent.getPoint(), this.fSelMode, this.fShiftDown);
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.fPossibleDrag) {
                MWTextView.this.startDrag(this.fStartPos, mouseEvent.getPoint(), this.fSelMode, this.fShiftDown);
            }
            if (MWTextView.this.fSelInProgress || MWTextView.this.fDragInProgress) {
                MWTextView.this.enterDrag();
                MWTextView.this.clearDrag();
            }
            if (!MWTextView.this.isEnabled() || this.fContextClicking || this.fDefiniteDrag) {
                return;
            }
            int n = MWTextView.this.selectionPosFromPixel(mouseEvent.getPoint());
            if (n == -1) {
                return;
            }
            MWTextView.this.finishDrag(n, mouseEvent.getPoint());
            if (PlatformInfo.isXWindows()) {
                KeyEvent keyEvent = new KeyEvent(mouseEvent.getComponent(), 401, 0L, 0, 0, '\u0000');
                MWTextView.this.dispatchCommand(33, keyEvent);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!MWTextView.this.isEnabled() || this.fContextClicking || this.fDefiniteDrag) {
                return;
            }
            if (MWTextView.this.fAllowDragAndDrop && this.fPossibleDrag) {
                if (Math.abs(this.fDragStartPoint.x - mouseEvent.getX()) > 2 || Math.abs(this.fDragStartPoint.y - mouseEvent.getY()) > 2) {
                    StringSelection stringSelection = new StringSelection(MWTextView.this.getSelText());
                    Rectangle rectangle = MWTextView.this.getSelectionBounds();
                    DragItem dragItem = new DragItem(MWTextView.this, rectangle, this.fDragStartPoint, stringSelection);
                    MWTextView.this.fDragItem = dragItem;
                    dragItem.startDrag();
                    this.fPossibleDrag = false;
                    this.fDefiniteDrag = true;
                }
                return;
            }
            if (MWTextView.this.fText.getNumLines() == 1) {
                MWTextView.this.continueDragSL(mouseEvent.getPoint());
            } else {
                int n = MWTextView.this.selectionPosFromPixel(mouseEvent.getPoint());
                if (n == -1) {
                    return;
                }
                MWTextView.this.continueDrag(n);
            }
            if (MWTextView.this.fDragPoint != null) {
                ((MWTextView)MWTextView.this).fDragPoint.x = mouseEvent.getPoint().x;
                ((MWTextView)MWTextView.this).fDragPoint.y = mouseEvent.getPoint().y;
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            MWTextView.this.handleCursor(mouseEvent.getPoint());
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            MWTextView.this.enterDrag();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            if (MWTextView.this.fSelInProgress || MWTextView.this.fDragInProgress) {
                if (!MWTextView.this.hasFocus() && !MWTextView.this.fDragTransfer) {
                    this.mouseReleased(mouseEvent);
                    return;
                }
                if (MWTextView.this.fDragPoint == null) {
                    MWTextView.this.fDragPoint = new Point();
                }
                ((MWTextView)MWTextView.this).fDragPoint.x = mouseEvent.getPoint().x;
                ((MWTextView)MWTextView.this).fDragPoint.y = mouseEvent.getPoint().y;
                MWTextView.this.fAutoScrollHandler = this;
                MWTextView.this.fAutoScrollTime = System.currentTimeMillis() + 25L;
                MWTextModel mWTextModel = MWTextView.this.fText;
                synchronized (mWTextModel) {
                    if (sCaretTimerOwner == MWTextView.this) {
                        sCaretTimer.setDelay(25);
                        sCaretTimer.reset();
                    }
                }
                MWTextView.this.fCaretTime = 0L;
            }
        }
    }

    private static class RunInfo {
        public int startX;
        public int startCol;

        public RunInfo() {
            this.init();
        }

        public void init() {
            this.startX = 0;
            this.startCol = 0;
        }
    }

    private class HScrollEventHandler
    implements AdjustmentListener {
        private HScrollEventHandler() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            MWTextView.this.fRepaintPending = false;
            MWTextView.this.setHScrollAmount(MWTextView.this.fHScroll.getValue());
        }
    }

    private class VScrollEventHandler
    implements AdjustmentListener {
        private VScrollEventHandler() {
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            MWTextView.this.fRepaintPending = false;
            MWTextView.this.setTopLine(MWTextView.this.fVScroll.getValue());
        }
    }
}

