/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.webservices.clients.cloudconsole;

import com.mathworks.webservices.client.core.ClientConfiguration;
import com.mathworks.webservices.client.core.MathWorksWebServiceClient;
import com.mathworks.webservices.client.core.http.HttpMethodName;
import com.mathworks.webservices.client.core.http.HttpRequest;
import com.mathworks.webservices.client.core.http.MathWorksHttpClient;
import com.mathworks.webservices.client.core.http.ResponseHandler;
import com.mathworks.webservices.client.core.xml.JaxbResponseHandler;
import com.mathworks.webservices.clients.cloudconsole.ClusterDetailsRequest;
import com.mathworks.webservices.clients.cloudconsole.ClusterDetailsResponse;
import com.mathworks.webservices.clients.cloudconsole.DiscoverClustersRequest;
import com.mathworks.webservices.clients.cloudconsole.DiscoverClustersResponse;

public class CloudConsoleClient
extends MathWorksWebServiceClient {
    private static final String SERIALIZE_PACKAGE = "com.mathworks.webservices.clients.cloudconsole";

    public CloudConsoleClient(String endpoint) {
        this(endpoint, new MathWorksHttpClient());
    }

    public CloudConsoleClient(String endpoint, ClientConfiguration config) {
        this(endpoint, new MathWorksHttpClient(config));
    }

    public CloudConsoleClient(String endpoint, MathWorksHttpClient client) {
        super(client, (ResponseHandler)new JaxbResponseHandler(SERIALIZE_PACKAGE));
        this.setEndpoint(endpoint);
    }

    public DiscoverClustersResponse discoverMyCloudClusters(DiscoverClustersRequest request) {
        String pathToService = "/cluster/list";
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.GET, this.endpoint, "/cluster/list");
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        return (DiscoverClustersResponse)this.executeRequest(httpRequest);
    }

    public ClusterDetailsResponse getClusterDetails(ClusterDetailsRequest request) {
        String pathToService = "/cluster/" + request.getClusterId();
        HttpRequest httpRequest = new HttpRequest(HttpMethodName.GET, this.endpoint, pathToService);
        httpRequest.addHeader("x-mw-authentication", request.getToken());
        httpRequest.setLocale(request.getLocale());
        httpRequest.setClientString(request.getClientString());
        return (ClusterDetailsResponse)this.executeRequest(httpRequest);
    }
}

