/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.landlord;

import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LocalLandlord;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.jini.core.lease.LeaseException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.id.Uuid;

public class LandlordUtil {
    public static Landlord.RenewResults renewAll(LocalLandlord localLandlord, Uuid[] uuidArray, long[] lArray) {
        int n = uuidArray.length;
        long[] lArray2 = new long[n];
        ArrayList<LeaseException> arrayList = new ArrayList<LeaseException>(n);
        for (int i = 0; i < n; ++i) {
            try {
                lArray2[i] = localLandlord.renew(uuidArray[i], lArray[i]);
                continue;
            }
            catch (LeaseException leaseException) {
                lArray2[i] = -1L;
                arrayList.add(leaseException);
            }
        }
        if (arrayList.size() == 0) {
            return new Landlord.RenewResults(lArray2);
        }
        Exception[] exceptionArray = new Exception[arrayList.size()];
        return new Landlord.RenewResults(lArray2, arrayList.toArray(exceptionArray));
    }

    public static Map cancelAll(LocalLandlord localLandlord, Uuid[] uuidArray) {
        int n = uuidArray.length;
        HashMap<Uuid, UnknownLeaseException> hashMap = null;
        for (int i = 0; i < n; ++i) {
            try {
                localLandlord.cancel(uuidArray[i]);
                continue;
            }
            catch (UnknownLeaseException unknownLeaseException) {
                if (hashMap == null) {
                    hashMap = new HashMap<Uuid, UnknownLeaseException>();
                }
                hashMap.put(uuidArray[i], unknownLeaseException);
            }
        }
        return hashMap;
    }
}

