/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.fatalexit;

import com.mathworks.fatalexit.ComponentName;
import com.mathworks.fatalexit.ReportSegvIntf;
import com.mathworks.fatalexit.ResourceBundleIntf;
import com.mathworks.fatalexit.SendReportPanel;
import com.mathworks.mlwebservices.segv.V1.ws.ReportSegv;
import com.mathworks.mlwebservices.segv.V1.ws.ReportSegvListener;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.mwswing.plaf.PlafUtils;
import com.mathworks.services.Prefs;
import com.mathworks.util.PlatformInfo;
import java.awt.AWTError;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public class FatalExitFrame
extends JDialog
implements ReportSegvListener {
    private static final String MATLAB_ERROR_LOG_NEVER_REPORT_PREF = "MatlabErrorLogNeverReportWSVO";
    private static final String EOL = System.getProperty("line.separator");
    private static final int PREFERRED_WIDTH = 480;
    private static final int SPACING_STANDARD = 10;
    private static Border EMPTY_BORDER = BorderFactory.createEmptyBorder(10, 10, 10, 10);
    private static String ATTEMPT_TO_CONTINUE;
    private static String CLICK_CLOSE_TO_QUIT_MATLAB;
    private static String CLICK_DETAILS_FOR_ERROR_INFORMATION;
    private static String CLICK_ATTEMPT_TO_CONTINUE;
    private static String CLOSE;
    private static String COULD_NOT_FIND_DETAILS_FILE;
    private static String COULD_NOT_READ_DETAILS_FILE;
    private static String DETAILS_WHEN_CLOSED;
    private static String DETAILS_WHEN_OPEN;
    private static String MATLAB_CRASH_FILE;
    private static String MATLAB_HAS_ENCOUNTERED_A_FATAL_ERROR;
    private static String WINDOW_TITLE;
    private static String YOUR_DATA_MAY_HAVE_BEEN_LOST;
    private static String CHECK_BOX_TO_NEVER_SEND;
    private static String CLICK_TO_SEND;
    private static String SEND;
    private static String NEVER_SEND;
    private static boolean IS_JAPANESE;
    private static int CONTINUE_EXIT_CODE;
    private final String fFileName;
    private final boolean fShowAttemptToContinueButton;
    private boolean fDetailsButtonClosed;
    private JComponent fDetailsComponent;
    private JSeparator fSeparator;
    private JButton fSendButton;
    private Checkbox fNeverSendButton;
    private JButton fCloseButton;
    private JButton fDetailsButton;
    private JButton fAttemptToContinueButton;
    private final boolean fNeverSendEmail = Prefs.getBooleanPref((String)"MatlabErrorLogNeverReportWSVO", (boolean)false);
    private static String segvWSOverrideURL;
    private static ResourceBundle bundle;
    private final SendReportPanel sendReportPanel;

    public SendReportPanel getSendReportPanel() {
        return this.sendReportPanel;
    }

    public FatalExitFrame(String string, boolean bl) {
        this.setTitle(WINDOW_TITLE);
        this.setName(ComponentName.FATAL_EXIT_FRAME.toString());
        this.fFileName = string;
        this.fShowAttemptToContinueButton = bl;
        URL uRL = FatalExitFrame.class.getResource("/com/mathworks/fatalexit/resources/membrane_48.png");
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.setIconImage(imageIcon.getImage());
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                FatalExitFrame.this.closeAndEndGracefully();
            }
        });
        this.initComponents();
        this.configureKeyStrokes();
        this.getRootPane().setDefaultButton(this.fCloseButton);
        this.pack();
        this.setLocationRelativeTo(null);
        this.sendReportPanel = new SendReportPanel(this, this, new ResourceBundleIntf(){

            @Override
            public String getString(String string) {
                return bundle.getString(string);
            }
        }, new ReportSegvIntf(){

            @Override
            public void reportFile(ReportSegvListener reportSegvListener, String string, String string2, String string3, String string4) {
                ReportSegv.reportFile((ReportSegvListener)reportSegvListener, (String)string, (String)string2, (String)string3, (String)string4);
            }
        }, this.fFileName, segvWSOverrideURL);
    }

    private void exit(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.dispose();
            System.exit(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FatalExitFrame.this.exit(n);
                }
            });
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                FatalExitFrame.this.setAlwaysOnTop(true);
                FatalExitFrame.this.toFront();
            }
        });
    }

    private void initComponents() {
        this.fSeparator = this.createSeparator();
        this.fDetailsComponent = this.createDetailsComponent();
        this.getContentPane().add(this.createContentPanel());
        this.setResizable(false);
    }

    private JComponent createContentPanel() {
        Box box = Box.createVerticalBox();
        box.add(this.createIconsAndLabelComponent());
        box.add(this.fDetailsComponent);
        box.setBorder(EMPTY_BORDER);
        return box;
    }

    private JPanel createIconsAndLabelComponent() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.setBorder(EMPTY_BORDER);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        jPanel.add((Component)this.createErrorIconLabel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        jPanel.add((Component)this.createLabelPanel(), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        jPanel.add((Component)this.createButtonBar(), gridBagConstraints);
        return jPanel;
    }

    private void addLabelToBox(Box box, String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setFont(jLabel.getFont().deriveFont(0));
        box.add(jLabel);
        box.add(Box.createVerticalStrut(10));
    }

    private Box createLabelPanel() {
        Box box = Box.createVerticalBox();
        this.addLabelToBox(box, MATLAB_HAS_ENCOUNTERED_A_FATAL_ERROR);
        this.addLabelToBox(box, YOUR_DATA_MAY_HAVE_BEEN_LOST);
        if (!this.fNeverSendEmail) {
            this.addLabelToBox(box, CHECK_BOX_TO_NEVER_SEND);
            this.addLabelToBox(box, CLICK_TO_SEND);
        }
        this.addLabelToBox(box, CLICK_CLOSE_TO_QUIT_MATLAB);
        if (this.fShowAttemptToContinueButton) {
            this.addLabelToBox(box, CLICK_ATTEMPT_TO_CONTINUE);
        }
        this.addLabelToBox(box, CLICK_DETAILS_FOR_ERROR_INFORMATION);
        box.setBackground(Color.BLUE);
        return box;
    }

    private Box createButtonBar() {
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FatalExitFrame.this.closeAndEndGracefully();
            }
        };
        this.fDetailsButton = new JButton();
        this.fDetailsButtonClosed = true;
        this.fDetailsButton.addActionListener(this.detailsButtonActionListener());
        Box box = Box.createHorizontalBox();
        box.setAlignmentX(1.0f);
        box.add(Box.createGlue());
        if (!this.fNeverSendEmail) {
            this.fNeverSendButton = new Checkbox(NEVER_SEND, this.fNeverSendEmail);
            this.fNeverSendButton.setName(ComponentName.NEVER_SEND_CHECKBOX.toString());
            this.fNeverSendButton.setMaximumSize(new Dimension(10, 20));
            this.fNeverSendButton.addItemListener(this.neverSendActionListener());
            box.add(this.fNeverSendButton);
            box.add(Box.createHorizontalStrut(10));
            this.fSendButton = new JButton();
            this.fSendButton.addActionListener(this.sendEmailActionListener());
            this.setTextAndMnemonicAndName(SEND, this.fSendButton, ComponentName.SEND_BUTTON);
            box.add(this.fSendButton);
            box.add(Box.createHorizontalStrut(10));
        }
        this.fCloseButton = new JButton(abstractAction);
        this.setTextAndMnemonicAndName(CLOSE, this.fCloseButton, ComponentName.END_NOW_BUTTON);
        box.add(this.fCloseButton);
        box.add(Box.createHorizontalStrut(10));
        if (this.fShowAttemptToContinueButton) {
            AbstractAction abstractAction2 = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    FatalExitFrame.this.closeAndAttemptToContinue();
                }
            };
            this.fAttemptToContinueButton = new JButton(abstractAction2);
            this.setTextAndMnemonicAndName(ATTEMPT_TO_CONTINUE, this.fAttemptToContinueButton, ComponentName.ATTEMPT_TO_CONTINUE);
            box.add(this.fAttemptToContinueButton);
            box.add(Box.createHorizontalStrut(10));
        }
        this.setTextAndMnemonicAndName(DETAILS_WHEN_CLOSED, this.fDetailsButton, ComponentName.DETAILS_BUTTON);
        box.add(this.fDetailsButton);
        return box;
    }

    private ItemListener neverSendActionListener() {
        return new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                boolean bl = FatalExitFrame.this.fNeverSendButton.getState();
                Prefs.setBooleanPref((String)FatalExitFrame.MATLAB_ERROR_LOG_NEVER_REPORT_PREF, (boolean)bl);
                FatalExitFrame.this.fSendButton.setEnabled(!bl);
            }
        };
    }

    private ActionListener detailsButtonActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FatalExitFrame.this.fDetailsButtonClosed = !FatalExitFrame.this.fDetailsButtonClosed;
                FatalExitFrame.this.setTextAndMnemonicAndName(FatalExitFrame.this.fDetailsButtonClosed ? DETAILS_WHEN_CLOSED : DETAILS_WHEN_OPEN, FatalExitFrame.this.fDetailsButton, ComponentName.DETAILS_BUTTON);
                FatalExitFrame.this.fDetailsComponent.setVisible(!FatalExitFrame.this.fDetailsButtonClosed);
                FatalExitFrame.this.fSeparator.setVisible(FatalExitFrame.this.fDetailsButtonClosed);
                FatalExitFrame.this.pack();
            }
        };
    }

    private ActionListener sendEmailActionListener() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FatalExitFrame.this.sendReportPanel.show();
            }
        };
    }

    private void closeAndEndGracefully() {
        this.exit(0);
    }

    private void closeAndAttemptToContinue() {
        this.exit(CONTINUE_EXIT_CODE);
    }

    private JSeparator createSeparator() {
        JSeparator jSeparator = new JSeparator();
        jSeparator.setPreferredSize(new Dimension(480, 0));
        return jSeparator;
    }

    private void configureKeyStrokes() {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FatalExitFrame.this.closeAndEndGracefully();
            }
        };
        InputMap inputMap = this.getRootPane().getInputMap(2);
        inputMap.put(keyStroke, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", abstractAction);
    }

    private JComponent createDetailsComponent() {
        String string = FatalExitFrame.readCrashFile(this.fFileName);
        JTextArea jTextArea = new JTextArea(string, 20, 80);
        jTextArea.setName(ComponentName.DETAILS_TEXT_AREA.toString());
        jTextArea.setEditable(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jScrollPane.setVisible(false);
        jScrollPane.setPreferredSize(new Dimension(480, jScrollPane.getPreferredSize().height));
        Border border = BorderFactory.createEmptyBorder(10, 0, 0, 0);
        Border border2 = BorderFactory.createLoweredBevelBorder();
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(border, border2));
        return jScrollPane;
    }

    private JLabel createErrorIconLabel() {
        Icon icon;
        try {
            icon = new ImageIcon(FatalExitFrame.class.getResource("/com/mathworks/fatalexit/resources/dialog_error_48.png"));
        }
        catch (Throwable throwable) {
            icon = UIManager.getIcon("error_icon");
        }
        return new JLabel(icon);
    }

    private void setTextAndMnemonicAndName(String string, JButton jButton, ComponentName componentName) {
        jButton.setText(MJUtilities.exciseMnemonic((String)string));
        jButton.setName(componentName.toString());
        MJUtilities.setMnemonicFromText((AbstractButton)jButton, (String)string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readCrashFile(String string) {
        BufferedReader bufferedReader = null;
        String string2 = MessageFormat.format(MATLAB_CRASH_FILE, string) + ":" + EOL + EOL;
        try {
            String string3;
            FileReader fileReader = new FileReader(string);
            bufferedReader = new BufferedReader(fileReader);
            while ((string3 = bufferedReader.readLine()) != null) {
                string2 = string2 + string3 + EOL;
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            String string4 = MessageFormat.format(COULD_NOT_FIND_DETAILS_FILE, string);
            return string4;
        }
        catch (IOException iOException) {
            String string5 = MessageFormat.format(COULD_NOT_READ_DETAILS_FILE, string, iOException.toString());
            return string5;
        }
        finally {
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return string2;
    }

    private static void i18nSetup() {
        IS_JAPANESE = Locale.getDefault().getLanguage().equals(Locale.JAPANESE.getLanguage());
        if (IS_JAPANESE && !PlatformInfo.isMacintosh()) {
            Locale.setDefault(Locale.ENGLISH);
            IS_JAPANESE = false;
        }
        try {
            ATTEMPT_TO_CONTINUE = bundle.getString("button.AttemptToContinue");
            DETAILS_WHEN_CLOSED = bundle.getString("button.DetailsWhenClosed");
            DETAILS_WHEN_OPEN = bundle.getString("button.DetailsWhenOpen");
            CLOSE = bundle.getString("button.Close");
            CLICK_ATTEMPT_TO_CONTINUE = bundle.getString("label.ClickAttemptToContinue");
            CLICK_CLOSE_TO_QUIT_MATLAB = bundle.getString("label.ClickCloseToQuitMATLAB");
            CLICK_DETAILS_FOR_ERROR_INFORMATION = bundle.getString("label.ClickDetailsForErrorInformation");
            MATLAB_CRASH_FILE = bundle.getString("label.MATLABCrashFile");
            MATLAB_HAS_ENCOUNTERED_A_FATAL_ERROR = bundle.getString("label.MATLABHasEncounteredAFatalError");
            WINDOW_TITLE = bundle.getString("window.title");
            COULD_NOT_FIND_DETAILS_FILE = bundle.getString("error.CouldNotFindDetailsFile");
            COULD_NOT_READ_DETAILS_FILE = bundle.getString("error.CouldNotReadDetailsFile");
            bundle.getString("error.SettingSystemLookAndFeel");
            YOUR_DATA_MAY_HAVE_BEEN_LOST = bundle.getString("label.YourDataMayHaveBeenLost");
            CLICK_TO_SEND = bundle.getString("label.ClickToSend");
            CHECK_BOX_TO_NEVER_SEND = bundle.getString("label.CheckBoxToNeverSend");
            SEND = bundle.getString("button.SendButton");
            NEVER_SEND = bundle.getString("button.NeverSend");
        }
        catch (Throwable throwable) {
            System.err.println("Error getting internationalized resources:" + throwable);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void loadAssistiveTechnologies() {
        try {
            if (!PlatformInfo.isWindows()) {
                return;
            }
            final Properties properties = new Properties();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    Object object;
                    try {
                        object = new File("accessibility.properties");
                        FileInputStream fileInputStream = new FileInputStream((File)object);
                        properties.load(fileInputStream);
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    object = System.getProperty("javax.accessibility.screen_magnifier_present");
                    if (object == null && (object = properties.getProperty("screen_magnifier_present", null)) != null) {
                        System.setProperty("javax.accessibility.screen_magnifier_present", (String)object);
                    }
                    return null;
                }
            });
            String string = properties.getProperty("assistive_technologies", null);
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            if (string == null) return;
            StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                try {
                    Class<?> clazz = classLoader != null ? classLoader.loadClass(string2) : Class.forName(string2);
                    clazz.newInstance();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new AWTError("Assistive Technology not found: " + string2);
                }
                catch (InstantiationException instantiationException) {
                    throw new AWTError("Could not instantiate Assistive Technology: " + string2);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throw new AWTError("Could not access Assistive Technology: " + string2);
                }
                catch (Exception exception) {
                    throw new AWTError("Error trying to install Assistive Technology: " + string2 + " " + exception);
                    return;
                }
            }
        }
        catch (Throwable throwable) {
            System.out.println("Exception loading assistive technologies:" + throwable);
        }
    }

    private static void doMatlabLikeSetup() {
        FatalExitFrame.i18nSetup();
        PlafUtils.setLookAndFeel();
        FatalExitFrame.loadAssistiveTechnologies();
    }

    public static void main(final String[] stringArray) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                if (stringArray.length < 1) {
                    System.out.println("Usage: com.mathworks.fatalexit.FatalExitFrame crashFilePath <-lucky> <-testing> <-segvURL url>");
                    System.out.println("\t-lucky: adds the Attempt to Continue button.\n\t-segvURL: provide an override URL for the segv service. Used for testing.\n");
                    return;
                }
                String string = stringArray[0];
                for (int i = 1; i < stringArray.length; ++i) {
                    String string2 = stringArray[i];
                    if ("-segvURL".equalsIgnoreCase(string2)) {
                        if (++i >= stringArray.length) continue;
                        segvWSOverrideURL = stringArray[i];
                        continue;
                    }
                    if (!"-lucky".equalsIgnoreCase(string2)) continue;
                    bl = true;
                }
                FatalExitFrame.doMatlabLikeSetup();
                FatalExitFrame fatalExitFrame = new FatalExitFrame(string, bl);
                fatalExitFrame.setVisible(true);
            }
        });
    }

    public void segvFailedToReport() {
        this.closeAndEndGracefully();
    }

    public void segvReported() {
        this.closeAndEndGracefully();
    }

    static {
        CONTINUE_EXIT_CODE = 199;
        segvWSOverrideURL = null;
        bundle = ResourceBundle.getBundle("com.mathworks.fatalexit.resources.RES_FatalExitFrame");
    }
}

