/*
 * Decompiled with CFR 0.152.
 */
package ice.net;

import ice.debug.Debug;
import ice.net.Cookie;
import ice.net.CookieManagerSettings;
import ice.net.HttpSession;
import ice.net.HttpURLConnection;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class CookieManager
extends VetoableChangeSupport {
    private Vector OEAB = new Vector();
    boolean enabled = true;
    private int addCookie = 4096;
    private int addElement = 1024;
    private int addVetoableChangeListener = -1;
    private int after = 100000;
    private boolean append;
    private boolean before;

    public CookieManager() {
        this(new CookieManagerSettings());
    }

    public CookieManager(CookieManagerSettings cookieManagerSettings) {
        super("Dummy");
        this.append = cookieManagerSettings.isCookieExpirationBufferEnabled();
        this.before = cookieManagerSettings.shouldPersistPrivateCookies();
    }

    public CookieManager(HttpSession httpSession) {
        super("Dummy");
        this.append = httpSession.ieCookieExpiresForgive;
    }

    public boolean isCookieExpirationBufferEnabled() {
        return this.append;
    }

    public boolean shouldPersistPrivateCookies() {
        return this.before;
    }

    public int getMaxTotalCookieSize() {
        return this.after;
    }

    public void setMaxTotalCookieSize(int n) {
        this.after = n;
    }

    public void setMaxCookieSize(int n) {
        this.addCookie = n;
    }

    public int getMaxCookieSize() {
        return this.addCookie;
    }

    public void setMaxNumberOfCookies(int n) {
        this.addElement = n;
    }

    public int getMaxNumberOfCookies() {
        return this.addElement;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public Enumeration elements() {
        return this.OEAB.elements();
    }

    public Cookie[] getAllCookies() {
        int n = this.OEAB.size();
        if (n == 0) {
            return null;
        }
        Cookie[] cookieArray = new Cookie[n];
        int n2 = 0;
        while (n2 < n) {
            cookieArray[n2] = (Cookie)this.OEAB.elementAt(n2);
            ++n2;
        }
        return cookieArray;
    }

    protected boolean extractAllCookies(URL uRL, URLConnection uRLConnection) {
        if (!this.enabled) {
            return false;
        }
        boolean bl = false;
        String[] stringArray = ((HttpURLConnection)uRLConnection).getResponse().getFieldValues("Set-Cookie");
        int n = 0;
        while (n < stringArray.length) {
            Cookie cookie;
            if (stringArray[n].length() > this.addCookie) {
                return false;
            }
            boolean bl2 = this.addVetoableChangeListener(uRLConnection);
            if (this.OEAB.size() >= this.addElement) {
                cookie = (Cookie)this.OEAB.elementAt(0);
                this.addVetoableChangeListener -= cookie.size();
                this.OEAB.removeElementAt(0);
            }
            if ((cookie = Cookie.parseFromString(uRL, stringArray[n])) != null) {
                cookie.setPrivate(bl2);
                this.addCookie(cookie);
                bl = true;
            }
            ++n;
        }
        return bl;
    }

    public synchronized void removeAllCookies() {
        this.OEAB.removeAllElements();
        this.addVetoableChangeListener = 0;
    }

    public synchronized void removeAllSessionCookies() {
        int n = 0;
        int n2 = this.OEAB.size();
        while (n != n2) {
            Cookie cookie = (Cookie)this.OEAB.elementAt(n);
            if (cookie.isSessionCookie()) {
                this.addVetoableChangeListener -= cookie.size();
                this.OEAB.removeElementAt(n);
                --n;
            }
            ++n;
        }
    }

    public synchronized void removeAllExpiredCookies() {
        int n = 0;
        int n2 = this.OEAB.size();
        while (n != n2) {
            Cookie cookie = (Cookie)this.OEAB.elementAt(n);
            if (cookie.isExpired()) {
                this.addVetoableChangeListener -= cookie.size();
                this.OEAB.removeElementAt(n);
                --n;
            }
            ++n;
        }
    }

    public synchronized void addCookie(Cookie cookie) {
        boolean bl;
        int n = this.OEAB.size();
        int n2 = 0;
        while (n2 < n) {
            Cookie cookie2 = (Cookie)this.OEAB.elementAt(n2);
            bl = false;
            boolean bl2 = false;
            if (cookie2.getDomain().indexOf(cookie.getDomain()) != -1 || cookie2.getDomain().equals(cookie.getDomain())) {
                bl = true;
            }
            if (cookie.path == null) {
                bl2 = true;
            } else if (cookie.path.equals(cookie2.path) || cookie2.path.indexOf(cookie.path) != -1) {
                bl2 = true;
            }
            if (bl && bl2 && cookie.name.equals(cookie2.name)) {
                if (this.OEAB(cookie2, cookie)) {
                    if (cookie2.isPrivate()) {
                        cookie.setPrivate(true);
                    }
                    this.addVetoableChangeListener -= cookie2.size();
                    this.addVetoableChangeListener += cookie.size();
                    this.OEAB.setElementAt(cookie, n2);
                }
                return;
            }
            ++n2;
        }
        if (this.OEAB(null, cookie)) {
            boolean bl3 = false;
            bl = false;
            if (this.OEAB.size() > this.addElement) {
                bl3 = true;
            }
            if (cookie.size() > this.addCookie) {
                bl = true;
            }
            if (this.addVetoableChangeListener + cookie.size() > this.after) {
                bl3 = true;
            }
            if (bl) {
                return;
            }
            if (bl3) {
                if (this.addVetoableChangeListener < 0) {
                    return;
                }
                if (this.OEAB.size() != 0) {
                    Cookie cookie3 = (Cookie)this.OEAB.elementAt(0);
                    this.addVetoableChangeListener -= cookie3.size();
                    this.addVetoableChangeListener += cookie.size();
                    this.OEAB.setElementAt(cookie, 0);
                    return;
                }
            }
            if (this.addVetoableChangeListener < 0) {
                this.addVetoableChangeListener = 0;
            }
            this.addVetoableChangeListener += cookie.size();
            this.OEAB.addElement(cookie);
        }
    }

    private boolean OEAB(Cookie cookie, Cookie cookie2) {
        try {
            this.fireVetoableChange("Cookie", cookie, cookie2);
        }
        catch (PropertyVetoException propertyVetoException) {
            return false;
        }
        return true;
    }

    protected void applyAllCookies(URL uRL, URLConnection uRLConnection) {
        String string = this.getCookieStr(uRL);
        if (string != null && string.length() != 0) {
            if (((HttpURLConnection)uRLConnection).isConnected()) {
                ((HttpURLConnection)uRLConnection).disconnect();
            }
            uRLConnection.setRequestProperty("Cookie", string);
        }
    }

    String getCookieStr(URL uRL) {
        if (!this.enabled) {
            return null;
        }
        String string = uRL.getHost();
        if (string == null) {
            return null;
        }
        String string2 = uRL.getProtocol();
        if (!string2.equals("http") && !string2.equals("https")) {
            return null;
        }
        int n = this.OEAB.size();
        if (n == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        Date date = new Date();
        boolean bl = false;
        int n2 = 0;
        while (n2 != n) {
            Cookie cookie = (Cookie)this.OEAB.elementAt(n2);
            boolean bl2 = false;
            if (cookie.expires == null || !cookie.expires.before(date)) {
                bl2 = true;
            }
            if (this.append && !bl2) {
                Date date2 = new Date(date.getTime() - 0x6DDD00L);
                if (cookie.expires == null || !cookie.expires.before(date2)) {
                    bl2 = true;
                }
            }
            if (bl2 && this.addCookie(string, cookie.domain) && this.addElement(uRL, cookie)) {
                cookie.use();
                if (bl) {
                    stringBuffer.append("; ");
                } else {
                    bl = true;
                }
                stringBuffer.append(cookie.name);
                stringBuffer.append('=');
                stringBuffer.append(cookie.value);
            }
            ++n2;
        }
        return stringBuffer.toString();
    }

    private boolean addCookie(String string, String string2) {
        boolean bl = false;
        int n = string2.length();
        if (n != 0) {
            int n2;
            if ('.' == string2.charAt(0)) {
                if (n >= 2 && !(bl = string.endsWith(string2)) && string.length() == n - 1) {
                    bl = string2.endsWith(string);
                }
            } else if (string.endsWith(string2) && ((n2 = string.length()) == n || '.' == string.charAt(n2 - n - 1))) {
                bl = true;
            }
        }
        return bl;
    }

    private boolean addElement(URL uRL, Cookie cookie) {
        String string = cookie.getPath();
        String string2 = uRL.getFile();
        if (string == null) {
            return true;
        }
        if (string.equals("/")) {
            return true;
        }
        if (string.charAt(0) != '/') {
            string = "/" + string;
        }
        int n = 0;
        while (n < string.length()) {
            if (n == string2.length()) {
                return string.charAt(n + 1) == '/' && string.length() == string2.length() + 1;
            }
            if (string.charAt(n) != string2.charAt(n)) {
                return false;
            }
            ++n;
        }
        if (string.endsWith("/")) {
            return true;
        }
        if (string.length() != string2.length() && string2.charAt(string.length()) == '/') {
            return true;
        }
        return string.length() == string2.length();
    }

    public synchronized void writeCookies(ObjectOutput objectOutput) {
        if (!this.enabled) {
            return;
        }
        try {
            Vector<Cookie> vector = new Vector<Cookie>();
            int n = this.OEAB.size();
            int n2 = 0;
            while (n2 < n) {
                Cookie cookie = (Cookie)this.OEAB.elementAt(n2);
                if ((this.before || !cookie.isPrivate()) && cookie.expires != null && cookie.expires.after(new Date())) {
                    vector.addElement(cookie);
                }
                ++n2;
            }
            objectOutput.writeObject(vector);
        }
        catch (IOException iOException) {
            Debug.ex((Throwable)iOException);
        }
        catch (Exception exception) {
            Debug.ex((Throwable)exception);
        }
    }

    public synchronized void readCookies(ObjectInput objectInput) {
        block5: {
            if (!this.enabled) {
                return;
            }
            try {
                Vector vector = (Vector)objectInput.readObject();
                int n = 0;
                while (n < vector.size()) {
                    this.addCookie((Cookie)vector.elementAt(n));
                    ++n;
                }
            }
            catch (Exception exception) {
                if (Debug.ex) {
                    Debug.ex((Throwable)exception);
                }
                if (!Debug.trace) break block5;
                Debug.trace((String)("Error loading cookies: " + exception));
            }
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        super.addVetoableChangeListener(vetoableChangeListener);
    }

    private boolean addVetoableChangeListener(URLConnection uRLConnection) {
        String string = uRLConnection.getHeaderField("Cache-Control");
        return "private".equals(string) || "no-cache".equals(string);
    }
}

