% General purpose commands.
% MATLAB Version 8.0 (R2012b) 20-Jul-2012 
%
% General information.
%   syntax        - Help on MATLAB command syntax.
%   demo          - Run demonstrations.
%   ver           - MATLAB, Simulink and toolbox version information.
%   version       - MATLAB version information.
%   verLessThan   - Compare version of toolbox to specified version string.
%   logo          - Plot the L-shaped membrane logo with MATLAB lighting.
%   membrane      - Generates the MATLAB logo.
%   bench         - MATLAB Benchmark.
% 
% Managing the workspace.
%   who           - List current variables.
%   whos          - List current variables, long form. 
%   clear         - Clear variables and functions from memory.
%   onCleanup     - Specify cleanup work to be done on function completion.
%   pack          - Consolidate workspace memory.
%   load          - Load workspace variables from disk.
%   save          - Save workspace variables to disk. 
%   saveas        - Save Figure or model to desired output format.
%   memory        - Help for memory limitations.
%   recycle       - Set option to move deleted files to recycle folder.
%   quit          - Quit MATLAB session.
%   exit          - Exit from MATLAB.
%
% Managing commands and functions.
%   what          - List MATLAB-specific files in directory.
%   type          - Display MATLAB program file.
%   open          - Open files by extension.
%   which         - Locate functions and files.
%   pcode         - Create pre-parsed pseudo-code file (P-file).
%   mex           - Compile MEX-function. 
%   inmem         - List functions in memory. 
%   namelengthmax - Maximum length of MATLAB function or variable name.
%
% Managing the search path.
%   path          - Get/set search path.
%   addpath       - Add directory to search path.
%   rmpath        - Remove directory from search path.
%   rehash        - Refresh function and file system caches.
%   import        - Import packages into the current scope.
%   finfo         - Identify file type against standard file handlers on path.
%   genpath       - Generate recursive toolbox path.
%   savepath      - Save the current MATLAB path in the pathdef.m file.
%
% Managing the java search path.
%   javaaddpath   - Add directories to the dynamic java path.
%   javaclasspath - Get and set java path.
%   javarmpath    - Remove directory from dynamic java path.
%
% Controlling the command window.
%   echo          - Display statements during function execution.
%   more          - Control paged output in command window.
%   diary         - Save text of MATLAB session.
%   format        - Set output format.
%   beep          - Produce beep sound.
%   desktop       - Start and query the MATLAB Desktop.
%   preferences   - Bring up MATLAB user settable preferences dialog.
%
% Operating system commands.
%   cd            - Change current working directory.
%   copyfile      - Copy file or directory.
%   movefile      - Move file or directory.
%   delete        - Delete file or graphics object.
%   pwd           - Show (print) current working directory.
%   dir           - List directory.
%   ls            - List directory.
%   fileattrib    - Set or get attributes of files and directories.
%   isdir         - True if argument is a directory.
%   mkdir         - Make new directory.
%   rmdir         - Remove directory.
%   getenv        - Get environment variable.
%   !             - Execute operating system command (see PUNCT).
%   dos           - Execute DOS command and return result.
%   unix          - Execute UNIX command and return result.
%   system        - Execute system command and return result.
%   perl          - Execute Perl command and return the result.
%   computer      - Computer type.
%   isunix        - True for the UNIX version of MATLAB.
%   ispc          - True for the PC (Windows) version of MATLAB.
%
% Debugging.
%   debug         - List debugging commands.
%
% Tools to locate dependent functions of a program file.
%   depfun        - Locate dependent functions of program file.
%   depdir        - Locate dependent directories of program file.
%
% Loading and calling shared libraries.
%   calllib          - Call a function in an external library.
%   libpointer       - Creates a pointer object for use with external libraries.
%   libstruct        - Creates a structure pointer for use with external libraries.
%   libisloaded      - True if the specified shared library is loaded.
%   loadlibrary      - Load a shared library into MATLAB. 
%   libfunctions     - Return information on functions in an external library.
%   libfunctionsview - View the functions in an external library.
%   unloadlibrary    - Unload a shared library loaded with LOADLIBRARY.
%   java             - Using Java from within MATLAB.
%   usejava          - True if the specified Java feature is supported in MATLAB.
%
% See also LANG, DATATYPES, IOFUN, GRAPHICS, OPS, STRFUN, TIMEFUN, 
% MATFUN, DEMOS, GRAPHICS, DATAFUN, UITOOLS, DOC, PUNCT, ARITH.

% Controlling multithreading setting.
%   maxNumCompThreads - Controls the maximum number of computational threads.

%   Copyright 1984-2012 The MathWorks, Inc. 
%   Generated from Contents.m_template revision 1.1.6.13  $Date: 2010/06/15 01:38:28 $

