/*
 * Decompiled with CFR 0.152.
 */
package com.mathworks.widgets.debug;

import com.mathworks.matlab.api.editor.actions.DebuggerActions;
import com.mathworks.mwswing.ExtendedAction;
import com.mathworks.mwswing.MJAbstractAction;
import com.mathworks.mwswing.MJUtilities;
import com.mathworks.services.binding.MatlabKeyBindings;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import java.util.Stack;
import javax.swing.Action;
import javax.swing.event.EventListenerList;

public class DebuggerManager
implements DebuggerActions {
    private static final Stack<DebuggerActions> DEBUGGERS = new Stack();
    private static final DebuggerManager INSTANCE = new DebuggerManager();
    public static EventListenerList EVENT_LISTENERS = new EventListenerList();

    public static DebuggerManager getInstance() {
        return INSTANCE;
    }

    public static void addDebuggerToTop(DebuggerActions debuggerActions) {
        DEBUGGERS.push(debuggerActions);
        DebuggerManager.fireStateUpdate(DebuggerTransition.ENTERED, debuggerActions.getClass());
    }

    public static void removeTopDebugger(Class<? extends DebuggerActions> clazz) {
        if (DEBUGGERS.size() == 1) {
            throw new IllegalStateException("No debugger on stack");
        }
        DebuggerActions debuggerActions = DEBUGGERS.pop();
        assert (clazz.equals(debuggerActions.getClass())) : "unexpected debugger removed";
        DebuggerManager.fireStateUpdate(DebuggerTransition.EXITED, debuggerActions.getClass());
    }

    public static Class<? extends DebuggerActions> classOfActiveDebugger() {
        return DebuggerManager.getActiveDebugger().getClass();
    }

    private DebuggerManager() {
        DEBUGGERS.push(new IdleMatlabDebugger());
    }

    private static DebuggerActions getActiveDebugger() {
        return DEBUGGERS.peek();
    }

    public static void addDebugManagerStateListener(DebuggerManagerStateListener debuggerManagerStateListener) {
        EVENT_LISTENERS.add(DebuggerManagerStateListener.class, debuggerManagerStateListener);
    }

    public static void removeDebugManagerStateListener(DebuggerManagerStateListener debuggerManagerStateListener) {
        EVENT_LISTENERS.remove(DebuggerManagerStateListener.class, debuggerManagerStateListener);
    }

    public static void fireStateUpdate(DebuggerTransition debuggerTransition, Class<? extends DebuggerActions> clazz) {
        DebuggerManagerStateListener[] debuggerManagerStateListenerArray;
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                for (DebuggerShellActions debuggerShellActions : DebuggerShellActions.values()) {
                    debuggerShellActions.reevaluateEnablement();
                }
            }
        });
        for (DebuggerManagerStateListener debuggerManagerStateListener : debuggerManagerStateListenerArray = (DebuggerManagerStateListener[])EVENT_LISTENERS.getListeners(DebuggerManagerStateListener.class)) {
            debuggerManagerStateListener.stateUpdated(debuggerTransition, clazz);
        }
    }

    public boolean supportsStackComboBox() {
        return DebuggerManager.getActiveDebugger().supportsStackComboBox();
    }

    public boolean supportsConditionalBreakpoints() {
        return DebuggerManager.getActiveDebugger().supportsConditionalBreakpoints();
    }

    public boolean supportsDisabledBreakpoints() {
        return DebuggerManager.getActiveDebugger().supportsDisabledBreakpoints();
    }

    public boolean isDummy() {
        return DebuggerManager.getActiveDebugger().isDummy();
    }

    public Action getStepActionNoEcho() {
        return DebuggerShellActions.STEP_NO_ECHO.getAction();
    }

    public Action getStepAction() {
        return DebuggerShellActions.STEP.getAction();
    }

    public Action getStepInActionNoEcho() {
        return DebuggerShellActions.STEP_IN_NO_ECHO.getAction();
    }

    public Action getStepInAction() {
        return DebuggerShellActions.STEP_IN.getAction();
    }

    public Action getStepOutActionNoEcho() {
        return DebuggerShellActions.STEP_OUT_NO_ECHO.getAction();
    }

    public Action getStepOutAction() {
        return DebuggerShellActions.STEP_OUT.getAction();
    }

    public Action getContinueActionNoEcho() {
        return DebuggerShellActions.CONTINUE_NO_ECHO.getAction();
    }

    public Action getContinueAction() {
        return DebuggerShellActions.CONTINUE.getAction();
    }

    public Action getExitDebugAction() {
        return DebuggerShellActions.EXIT_DEBUG.getAction();
    }

    private static Action createDummyAction() {
        return new MJAbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
            }

            public boolean isEnabled() {
                return false;
            }
        };
    }

    public static boolean isDebugging() {
        return !DebuggerManager.getActiveDebugger().isDummy();
    }

    public static void flushDebuggerManagerStateListeners() {
        MJUtilities.runOnEventDispatchThread((Runnable)new Runnable(){

            @Override
            public void run() {
                EVENT_LISTENERS = new EventListenerList();
            }
        });
    }

    public static interface DebuggerManagerStateListener
    extends EventListener {
        public void stateUpdated(DebuggerTransition var1, Class<? extends DebuggerActions> var2);
    }

    public static enum DebuggerTransition {
        ENTERED,
        EXITED;

    }

    public static class IdleMatlabDebugger
    implements DebuggerActions {
        public boolean supportsStackComboBox() {
            return true;
        }

        public boolean supportsConditionalBreakpoints() {
            return true;
        }

        public boolean supportsDisabledBreakpoints() {
            return true;
        }

        public boolean isDummy() {
            return true;
        }

        public Action getStepActionNoEcho() {
            return DebuggerManager.createDummyAction();
        }

        public Action getStepAction() {
            return DebuggerManager.createDummyAction();
        }

        public Action getStepInActionNoEcho() {
            return DebuggerManager.createDummyAction();
        }

        public Action getStepInAction() {
            return DebuggerManager.createDummyAction();
        }

        public Action getStepOutActionNoEcho() {
            return DebuggerManager.createDummyAction();
        }

        public Action getStepOutAction() {
            return DebuggerManager.createDummyAction();
        }

        public Action getContinueActionNoEcho() {
            return DebuggerManager.createDummyAction();
        }

        public Action getContinueAction() {
            return DebuggerManager.createDummyAction();
        }

        public Action getExitDebugAction() {
            return DebuggerManager.createDummyAction();
        }
    }

    private static abstract class ActionShell
    extends MJAbstractAction {
        private ActionShell(String string) {
            this.setEnabled(false);
            MatlabKeyBindings.getManager().addKeyBindingAndActionInfo("MATLABDesktop", string, (ExtendedAction)this);
        }

        protected abstract Action getAction();

        public void actionPerformed(ActionEvent actionEvent) {
            this.getAction().actionPerformed(actionEvent);
        }

        private void reevaluateEnablement() {
            this.setEnabled(this.getAction().isEnabled());
        }
    }

    private static enum DebuggerShellActions {
        STEP(new ActionShell("debug-step"){

            @Override
            protected Action getAction() {
                return DebuggerManager.getActiveDebugger().getStepAction();
            }
        }),
        STEP_NO_ECHO(new ActionShell("debug-step"){

            @Override
            protected Action getAction() {
                return DebuggerManager.getActiveDebugger().getStepActionNoEcho();
            }
        }),
        STEP_IN(new ActionShell("debug-step-in"){

            @Override
            protected Action getAction() {
                return DebuggerManager.getActiveDebugger().getStepInAction();
            }
        }),
        STEP_IN_NO_ECHO(new ActionShell("debug-step-in"){

            @Override
            protected Action getAction() {
                return DebuggerManager.getActiveDebugger().getStepInActionNoEcho();
            }
        }),
        STEP_OUT(new ActionShell("debug-step-out"){

            @Override
            protected Action getAction() {
                return DebuggerManager.getActiveDebugger().getStepOutAction();
            }
        }),
        STEP_OUT_NO_ECHO(new ActionShell("debug-step-out"){

            @Override
            protected Action getAction() {
                return DebuggerManager.getActiveDebugger().getStepOutActionNoEcho();
            }
        }),
        CONTINUE(new ActionShell("debug-continue"){

            @Override
            protected Action getAction() {
                return DebuggerManager.getActiveDebugger().getContinueAction();
            }
        }),
        CONTINUE_NO_ECHO(new ActionShell("debug-continue"){

            @Override
            protected Action getAction() {
                return DebuggerManager.getActiveDebugger().getContinueActionNoEcho();
            }
        }),
        EXIT_DEBUG(new ActionShell("exit-debug"){

            @Override
            protected Action getAction() {
                return DebuggerManager.getActiveDebugger().getExitDebugAction();
            }
        });

        private final MJAbstractAction iAction;

        private void reevaluateEnablement() {
            ((ActionShell)this.getAction()).reevaluateEnablement();
        }

        MJAbstractAction getAction() {
            return this.iAction;
        }

        private DebuggerShellActions(MJAbstractAction mJAbstractAction) {
            this.iAction = mJAbstractAction;
        }
    }
}

